/*
 * Decompiled with CFR 0.152.
 */
package helpers;

import com.google.common.base.Throwables;
import helpers.ManagedFileResource;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class TemporaryFileResource
implements ManagedFileResource {
    private final File tempFile;
    private final byte[] content;

    public File getTempFile() {
        return this.tempFile;
    }

    public String getPath() {
        return this.tempFile.getAbsolutePath();
    }

    public TemporaryFileResource(File tempFile, byte[] content) {
        this.tempFile = tempFile;
        this.content = content;
    }

    @Override
    public void create() {
        try {
            FileUtils.writeByteArrayToFile((File)this.tempFile, (byte[])this.content);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void delete() {
        this.tempFile.delete();
    }
}

