/*
 * Decompiled with CFR 0.152.
 */
package keystore;

import com.google.common.base.Throwables;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;

class X509CertificateFactory {
    X509CertificateFactory() {
    }

    public X509Certificate createCertificate(String partialCert) {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            String fullCert = partialCert.contains("-----BEGIN CERTIFICATE-----") ? partialCert : MessageFormat.format("-----BEGIN CERTIFICATE-----\n{0}\n-----END CERTIFICATE-----", partialCert.trim());
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(fullCert.getBytes(StandardCharsets.UTF_8));
            return (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
        }
        catch (CertificateException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

