/*
 * Decompiled with CFR 0.152.
 */
package httpstub;

import com.google.common.collect.ImmutableMultimap;
import httpstub.ReceivedRequest;
import java.util.Map;
import javax.annotation.Nullable;

public class ExpectedRequest {
    private final String path;
    private final String method;
    private ImmutableMultimap<String, String> headers;
    private String body;

    public ExpectedRequest(@Nullable String path, @Nullable String method, @Nullable ImmutableMultimap<String, String> headers, @Nullable String body) {
        this.path = path;
        this.method = method;
        this.headers = headers;
        this.body = body;
    }

    public boolean applies(ReceivedRequest baseRequest) {
        if (this.path != null && !baseRequest.getPath().equals(this.path)) {
            return false;
        }
        if (this.method != null && !baseRequest.getMethod().equals(this.method)) {
            return false;
        }
        if (this.headers != null && this.notAllHeadersFound(baseRequest.getHeaders())) {
            return false;
        }
        return this.body == null || baseRequest.getEntity().equals(this.body);
    }

    private boolean notAllHeadersFound(ImmutableMultimap<String, String> headers) {
        return !this.headers.entries().stream().allMatch(headerEntry -> this.isHeaderInRequest(headers, (Map.Entry<String, String>)headerEntry));
    }

    private boolean isHeaderInRequest(ImmutableMultimap<String, String> receivedHeaders, Map.Entry<String, String> expectedEntry) {
        return receivedHeaders.containsEntry((Object)expectedEntry.getKey(), (Object)expectedEntry.getValue());
    }
}

