/*
 * Decompiled with CFR 0.152.
 */
package uk.emarte.regurgitator.extensions;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import uk.emarte.regurgitator.core.Log;
import uk.emarte.regurgitator.core.RegurgitatorException;
import uk.emarte.regurgitator.core.XmlConfigUtil;
import uk.emarte.regurgitator.extensions.NamespaceLoader;

class XmlNamespaceLoader
extends NamespaceLoader {
    private static final Log log = Log.getLog(XmlNamespaceLoader.class);

    XmlNamespaceLoader() {
    }

    static Map<String, String> loadNamespaces(Element element, String attribute) throws RegurgitatorException {
        if (element != null && attribute != null) {
            throw new RegurgitatorException("namespaces cannot be specified twice");
        }
        if (element == null && attribute == null) {
            throw new RegurgitatorException("namespaces not specified");
        }
        return element != null ? XmlNamespaceLoader.loadNamespaces(element) : XmlNamespaceLoader.loadNamespaces((String)attribute, (Log)log);
    }

    private static Map<String, String> loadNamespaces(Element element) {
        HashMap<String, String> namespaceMap = new HashMap<String, String>();
        List namespaces = XmlConfigUtil.getChildElements((Element)element, (String)"namespace");
        for (Element namespace : namespaces) {
            String prefix = XmlConfigUtil.loadOptionalStr((Element)namespace, (String)"prefix");
            String uri = XmlConfigUtil.loadOptionalStr((Element)namespace, (String)"uri");
            namespaceMap.put(prefix, uri);
            log.debug("Loaded namespace '{}={}'", new Object[]{prefix, uri});
        }
        log.debug("Loaded {} namespaces", new Object[]{namespaceMap.size()});
        return namespaceMap;
    }
}

