/*
 * Decompiled with CFR 0.152.
 */
package uk.emarte.regurgitator.extensions;

import java.util.Set;
import org.w3c.dom.Element;
import uk.emarte.regurgitator.core.Log;
import uk.emarte.regurgitator.core.RegurgitatorException;
import uk.emarte.regurgitator.core.ValueProcessor;
import uk.emarte.regurgitator.core.XmlConfigUtil;
import uk.emarte.regurgitator.core.XmlLoader;
import uk.emarte.regurgitator.extensions.FreemarkerProcessorLoader;

public class FreemarkerProcessorXmlLoader
extends FreemarkerProcessorLoader
implements XmlLoader<ValueProcessor> {
    private static final Log log = Log.getLog(FreemarkerProcessorXmlLoader.class);

    public ValueProcessor load(Element element, Set<Object> allIds) throws RegurgitatorException {
        String valueAttr = XmlConfigUtil.loadOptionalStr((Element)element, (String)"value");
        String valueText = element.getTextContent();
        if (this.valid(valueAttr) && this.valid(valueText)) {
            throw new RegurgitatorException("Value cannot be defined in text and attribute");
        }
        String value = this.valid(valueAttr) ? valueAttr : (this.valid(valueText) ? valueText : null);
        String file = XmlConfigUtil.loadOptionalStr((Element)element, (String)"file");
        return this.buildFreemarkerValueProcessor(value, file, log);
    }

    private boolean valid(String text) {
        return text != null && text.length() > 0;
    }
}

