/*
 * Decompiled with CFR 0.152.
 */
package uk.emarte.regurgitator.extensions;

import java.util.Set;
import org.w3c.dom.Element;
import uk.emarte.regurgitator.core.Log;
import uk.emarte.regurgitator.core.RegurgitatorException;
import uk.emarte.regurgitator.core.ValueBuilder;
import uk.emarte.regurgitator.core.XmlConfigUtil;
import uk.emarte.regurgitator.core.XmlLoader;
import uk.emarte.regurgitator.extensions.FreemarkerBuilderLoader;

public class FreemarkerBuilderXmlLoader
extends FreemarkerBuilderLoader
implements XmlLoader<ValueBuilder> {
    private static final Log log = Log.getLog(FreemarkerBuilderXmlLoader.class);

    public ValueBuilder load(Element element, Set<Object> allIds) throws RegurgitatorException {
        String source = XmlConfigUtil.loadOptionalStr((Element)element, (String)"source");
        String valueAttr = XmlConfigUtil.loadOptionalStr((Element)element, (String)"value");
        String valueText = element.getTextContent();
        if (this.valid(valueAttr) && this.valid(valueText)) {
            throw new RegurgitatorException("Value cannot be defined in text and attribute");
        }
        String value = this.valid(valueAttr) ? valueAttr : (this.valid(valueText) ? valueText : null);
        String file = XmlConfigUtil.loadOptionalStr((Element)element, (String)"file");
        return this.buildFreemarkerValueBuilder(source, value, file, XmlConfigUtil.loadOptionalBool((Element)element, (String)"all-contexts"), log);
    }

    private boolean valid(String text) {
        return text != null && text.length() > 0;
    }
}

