/*
 * Decompiled with CFR 0.152.
 */
package uk.co.samuelwall.materialtaptargetprompt.extras.sequence;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import uk.co.samuelwall.materialtaptargetprompt.MaterialTapTargetPrompt;
import uk.co.samuelwall.materialtaptargetprompt.MaterialTapTargetSequence;
import uk.co.samuelwall.materialtaptargetprompt.extras.sequence.SequenceState;

public class SequenceItem
implements MaterialTapTargetPrompt.PromptStateChangeListener {
    @NonNull
    private final SequenceState sequenceState;
    @NonNull
    final List<Integer> stateChangers = new ArrayList<Integer>();
    @Nullable
    private MaterialTapTargetSequence.SequenceCompleteListener sequenceListener;

    public SequenceItem(@NonNull SequenceState state) {
        this.sequenceState = state;
    }

    public void addStateChanger(int state) {
        this.stateChangers.add(state);
    }

    public void removeStateChanger(int state) {
        this.stateChangers.remove((Object)state);
    }

    public void clearStateChangers() {
        this.stateChangers.clear();
    }

    public void setSequenceListener(@Nullable MaterialTapTargetSequence.SequenceCompleteListener listener) {
        this.sequenceListener = listener;
    }

    @NonNull
    public SequenceState getState() {
        return this.sequenceState;
    }

    public void show() {
        MaterialTapTargetPrompt prompt = this.sequenceState.getPrompt();
        if (prompt != null) {
            this.show(prompt);
        } else {
            this.onItemComplete();
        }
    }

    public void finish() {
        MaterialTapTargetPrompt prompt = this.sequenceState.getPrompt();
        if (prompt != null) {
            prompt.finish();
        }
    }

    public void dismiss() {
        MaterialTapTargetPrompt prompt = this.sequenceState.getPrompt();
        if (prompt != null) {
            prompt.dismiss();
        }
    }

    protected void show(@NonNull MaterialTapTargetPrompt prompt) {
        prompt.show();
    }

    @Override
    public void onPromptStateChanged(@NonNull MaterialTapTargetPrompt prompt, int state) {
        if (this.stateChangers.contains(state)) {
            this.onItemComplete();
        }
    }

    protected void onItemComplete() {
        if (this.sequenceListener != null) {
            this.sequenceListener.onSequenceComplete();
        }
    }
}

