/*
 * Decompiled with CFR 0.152.
 */
package uk.co.samuelwall.materialtaptargetprompt.extras.focals;

import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.RectF;
import android.support.annotation.ColorInt;
import android.support.annotation.Dimension;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import uk.co.samuelwall.materialtaptargetprompt.extras.PromptFocal;
import uk.co.samuelwall.materialtaptargetprompt.extras.PromptOptions;
import uk.co.samuelwall.materialtaptargetprompt.extras.PromptUtils;

public class RectanglePromptFocal
extends PromptFocal {
    Paint mPaint = new Paint();
    int mRippleAlpha;
    RectF mBounds;
    RectF mBaseBounds;
    PointF mBaseBoundsCentre;
    RectF mRippleBounds;
    int mBaseAlpha;
    float mPadding;
    Path mPath;
    private float mRx;
    private float mRy;
    @Nullable
    private PointF mSize;

    public RectanglePromptFocal() {
        this.mPaint.setAntiAlias(true);
        this.mBounds = new RectF();
        this.mBaseBounds = new RectF();
        this.mBaseBoundsCentre = new PointF();
        this.mRippleBounds = new RectF();
        float density = Resources.getSystem().getDisplayMetrics().density;
        this.mRx = this.mRy = 2.0f * density;
        this.mPadding = 8.0f * density;
    }

    @NonNull
    public RectanglePromptFocal setCornerRadius(float rx, float ry) {
        this.mRx = rx;
        this.mRy = ry;
        return this;
    }

    @NonNull
    public RectanglePromptFocal setTargetPadding(@Dimension float padding) {
        this.mPadding = padding;
        return this;
    }

    @NonNull
    public RectanglePromptFocal setSize(@Nullable PointF size) {
        if (size == null) {
            this.mSize = null;
        } else {
            this.mSize = new PointF();
            this.mSize.x = size.x;
            this.mSize.y = size.y;
        }
        return this;
    }

    @Override
    @NonNull
    public RectF getBounds() {
        return this.mBaseBounds;
    }

    @Override
    @NonNull
    public Path getPath() {
        return this.mPath;
    }

    @Override
    public void setColour(@ColorInt int colour) {
        this.mPaint.setColor(colour);
        this.mBaseAlpha = Color.alpha((int)colour);
        this.mPaint.setAlpha(this.mBaseAlpha);
    }

    @Override
    public void prepare(@NonNull PromptOptions options, @NonNull View target, int[] promptViewPosition) {
        int[] targetPosition = new int[2];
        target.getLocationInWindow(targetPosition);
        float left = targetPosition[0] - promptViewPosition[0];
        float top = targetPosition[1] - promptViewPosition[1];
        int width = target.getWidth();
        int height = target.getHeight();
        if (this.mSize == null) {
            this.mBaseBounds.left = left - this.mPadding;
            this.mBaseBounds.top = top - this.mPadding;
            this.mBaseBounds.right = left + (float)width + this.mPadding;
            this.mBaseBounds.bottom = top + (float)height + this.mPadding;
            this.mBaseBoundsCentre.x = left + (float)(width / 2);
            this.mBaseBoundsCentre.y = top + (float)(height / 2);
        } else {
            this.prepare(options, left + (float)(width / 2), top + (float)(height / 2));
        }
    }

    @Override
    public void prepare(@NonNull PromptOptions options, float targetX, float targetY) {
        if (this.mSize == null) {
            throw new UnsupportedOperationException("RectanglePromptFocal size must be set using setSize(PointF)");
        }
        float halfWidth = this.mSize.x / 2.0f;
        float halfHeight = this.mSize.y / 2.0f;
        this.mBaseBounds.left = targetX - halfWidth - this.mPadding;
        this.mBaseBounds.top = targetY - halfHeight - this.mPadding;
        this.mBaseBounds.right = targetX + halfWidth + this.mPadding;
        this.mBaseBounds.bottom = targetY + halfHeight + this.mPadding;
        this.mBaseBoundsCentre.x = targetX;
        this.mBaseBoundsCentre.y = targetY;
    }

    @Override
    public void update(@NonNull PromptOptions options, float revealModifier, float alphaModifier) {
        PromptUtils.scale(this.mBaseBoundsCentre, this.mBaseBounds, this.mBounds, revealModifier, true);
        this.mPath = new Path();
        this.mPath.addRoundRect(this.mBounds, this.mRx, this.mRy, Path.Direction.CW);
    }

    @Override
    public void updateRipple(float revealModifier, float alphaModifier) {
        PromptUtils.scale(this.mBaseBoundsCentre, this.mBaseBounds, this.mRippleBounds, revealModifier, true);
        this.mRippleAlpha = (int)((float)this.mBaseRippleAlpha * alphaModifier);
    }

    @Override
    public void draw(@NonNull Canvas canvas) {
        if (this.mDrawRipple) {
            int oldAlpha = this.mPaint.getAlpha();
            int oldColor = this.mPaint.getColor();
            if (oldColor == 0) {
                this.mPaint.setColor(-1);
            }
            this.mPaint.setAlpha(this.mRippleAlpha);
            canvas.drawRoundRect(this.mRippleBounds, this.mRx, this.mRy, this.mPaint);
            this.mPaint.setColor(oldColor);
            this.mPaint.setAlpha(oldAlpha);
        }
        canvas.drawPath(this.getPath(), this.mPaint);
    }

    @Override
    public boolean contains(float x, float y) {
        return this.mBounds.contains(x, y);
    }
}

