/*
 * Decompiled with CFR 0.152.
 */
package uk.co.samuelwall.materialtaptargetprompt.extras.focals;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.RectF;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.view.View;
import uk.co.samuelwall.materialtaptargetprompt.extras.PromptFocal;
import uk.co.samuelwall.materialtaptargetprompt.extras.PromptOptions;
import uk.co.samuelwall.materialtaptargetprompt.extras.PromptUtils;

public class CirclePromptFocal
extends PromptFocal {
    Paint mPaint = new Paint();
    int mRippleAlpha;
    float mRadius;
    float mBaseRadius;
    float mRippleRadius;
    int mBaseAlpha;
    PointF mPosition;
    RectF mBounds;
    Path mPath;

    public CirclePromptFocal() {
        this.mPaint.setAntiAlias(true);
        this.mPosition = new PointF();
        this.mBounds = new RectF();
    }

    @NonNull
    public CirclePromptFocal setRadius(float radius) {
        this.mBaseRadius = radius;
        return this;
    }

    @Override
    @NonNull
    public RectF getBounds() {
        return this.mBounds;
    }

    @Override
    @NonNull
    public Path getPath() {
        return this.mPath;
    }

    @Override
    @NonNull
    public PointF calculateAngleEdgePoint(float angle, float padding) {
        float focalRadius = this.mBounds.width() + padding;
        float x = this.calculateX(angle, focalRadius, this.mBounds.centerX());
        float y = this.calculateY(angle, focalRadius, this.mBounds.centerY());
        return new PointF(x, y);
    }

    private float calculateX(float angle, float radius, float centreX) {
        return centreX + radius * (float)Math.cos(Math.toRadians(angle));
    }

    private float calculateY(float angle, float radius, float centreY) {
        return centreY + radius * (float)Math.sin(Math.toRadians(angle));
    }

    @Override
    public void setColour(@ColorInt int colour) {
        this.mPaint.setColor(colour);
        this.mBaseAlpha = Color.alpha((int)colour);
        this.mPaint.setAlpha(this.mBaseAlpha);
    }

    @Override
    public void prepare(@NonNull PromptOptions options, @NonNull View target, int[] promptViewPosition) {
        int[] targetPosition = new int[2];
        target.getLocationInWindow(targetPosition);
        this.prepare(options, targetPosition[0] - promptViewPosition[0] + target.getWidth() / 2, targetPosition[1] - promptViewPosition[1] + target.getHeight() / 2);
    }

    @Override
    public void prepare(@NonNull PromptOptions options, float targetX, float targetY) {
        this.mPosition.x = targetX;
        this.mPosition.y = targetY;
        this.mBounds.left = targetX - this.mBaseRadius;
        this.mBounds.top = targetY - this.mBaseRadius;
        this.mBounds.right = targetX + this.mBaseRadius;
        this.mBounds.bottom = targetY + this.mBaseRadius;
    }

    @Override
    public void update(@NonNull PromptOptions options, float revealModifier, float alphaModifier) {
        this.mPaint.setAlpha((int)((float)this.mBaseAlpha * alphaModifier));
        this.mRadius = this.mBaseRadius * revealModifier;
        this.mPath = new Path();
        this.mPath.addCircle(this.mPosition.x, this.mPosition.y, this.mRadius, Path.Direction.CW);
    }

    @Override
    public void updateRipple(float revealModifier, float alphaModifier) {
        this.mRippleRadius = this.mBaseRadius * revealModifier;
        this.mRippleAlpha = (int)((float)this.mBaseRippleAlpha * alphaModifier);
    }

    @Override
    public void draw(@NonNull Canvas canvas) {
        if (this.mDrawRipple) {
            int oldAlpha = this.mPaint.getAlpha();
            int oldColor = this.mPaint.getColor();
            if (oldColor == 0) {
                this.mPaint.setColor(-1);
            }
            this.mPaint.setAlpha(this.mRippleAlpha);
            canvas.drawCircle(this.mPosition.x, this.mPosition.y, this.mRippleRadius, this.mPaint);
            this.mPaint.setColor(oldColor);
            this.mPaint.setAlpha(oldAlpha);
        }
        canvas.drawPath(this.getPath(), this.mPaint);
    }

    @Override
    public boolean contains(float x, float y) {
        return PromptUtils.isPointInCircle(x, y, this.mPosition, this.mRadius);
    }
}

