/*
 * Decompiled with CFR 0.152.
 */
package uk.co.samuelwall.materialtaptargetprompt.extras.backgrounds;

import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import uk.co.samuelwall.materialtaptargetprompt.extras.PromptBackground;
import uk.co.samuelwall.materialtaptargetprompt.extras.PromptOptions;
import uk.co.samuelwall.materialtaptargetprompt.extras.PromptUtils;

public class RectanglePromptBackground
extends PromptBackground {
    RectF mBounds;
    RectF mBaseBounds;
    Paint mPaint = new Paint();
    int mBaseColourAlpha;
    float mRx;
    float mRy;
    PointF mFocalCentre;

    public RectanglePromptBackground() {
        this.mPaint.setAntiAlias(true);
        this.mBounds = new RectF();
        this.mBaseBounds = new RectF();
        this.mFocalCentre = new PointF();
        float density = Resources.getSystem().getDisplayMetrics().density;
        this.mRx = this.mRy = 2.0f * density;
    }

    @NonNull
    public RectanglePromptBackground setCornerRadius(float rx, float ry) {
        this.mRx = rx;
        this.mRy = ry;
        return this;
    }

    @Override
    public void setColour(@ColorInt int colour) {
        this.mPaint.setColor(colour);
        this.mBaseColourAlpha = Color.alpha((int)colour);
        this.mPaint.setAlpha(this.mBaseColourAlpha);
    }

    @Override
    public void prepare(@NonNull PromptOptions options, boolean clipToBounds, @NonNull Rect clipBounds) {
        float y2;
        float y1;
        RectF focalBounds = options.getPromptFocal().getBounds();
        RectF textBounds = options.getPromptText().getBounds();
        float textPadding = options.getTextPadding();
        if (textBounds.top < focalBounds.top) {
            y1 = textBounds.top - textPadding;
            y2 = focalBounds.bottom + textPadding;
        } else {
            y1 = focalBounds.top - textPadding;
            y2 = textBounds.bottom + textPadding;
        }
        float x1 = Math.min(textBounds.left - textPadding, focalBounds.left - textPadding);
        float x2 = Math.max(textBounds.right + textPadding, focalBounds.right + textPadding);
        this.mBaseBounds.set(x1, y1, x2, y2);
        this.mFocalCentre.x = focalBounds.centerX();
        this.mFocalCentre.y = focalBounds.centerY();
    }

    @Override
    public void update(@NonNull PromptOptions prompt, float revealModifier, float alphaModifier) {
        this.mPaint.setAlpha((int)((float)this.mBaseColourAlpha * alphaModifier));
        PromptUtils.scale(this.mFocalCentre, this.mBaseBounds, this.mBounds, revealModifier, false);
    }

    @Override
    public void draw(@NonNull Canvas canvas) {
        canvas.drawRoundRect(this.mBounds, this.mRx, this.mRy, this.mPaint);
    }

    @Override
    public boolean contains(float x, float y) {
        return this.mBounds.contains(x, y);
    }
}

