/*
 * Decompiled with CFR 0.152.
 */
package uk.co.samuelwall.materialtaptargetprompt.extras.backgrounds;

import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.util.DisplayMetrics;
import uk.co.samuelwall.materialtaptargetprompt.extras.PromptBackground;
import uk.co.samuelwall.materialtaptargetprompt.extras.PromptOptions;
import uk.co.samuelwall.materialtaptargetprompt.extras.PromptUtils;

public class FullscreenPromptBackground
extends PromptBackground {
    RectF mBounds;
    RectF mBaseBounds;
    Paint mPaint = new Paint();
    int mBaseColourAlpha;
    float mRx;
    float mRy;
    PointF mFocalCentre;

    public FullscreenPromptBackground() {
        this.mPaint.setAntiAlias(true);
        this.mBounds = new RectF();
        this.mBaseBounds = new RectF();
        this.mFocalCentre = new PointF();
        this.mRy = 0.0f;
        this.mRx = 0.0f;
    }

    @NonNull
    public FullscreenPromptBackground setCornerRadius(float rx, float ry) {
        this.mRx = rx;
        this.mRy = ry;
        return this;
    }

    @Override
    public void setColour(@ColorInt int colour) {
        this.mPaint.setColor(colour);
        this.mBaseColourAlpha = Color.alpha((int)colour);
        this.mPaint.setAlpha(this.mBaseColourAlpha);
    }

    @Override
    public void prepare(@NonNull PromptOptions options, boolean clipToBounds, @NonNull Rect clipBounds) {
        RectF focalBounds = options.getPromptFocal().getBounds();
        DisplayMetrics metrics = this.getDisplayMetrics();
        this.mBaseBounds.set(0.0f, 0.0f, (float)metrics.widthPixels, (float)metrics.heightPixels);
        this.mFocalCentre.x = focalBounds.centerX();
        this.mFocalCentre.y = focalBounds.centerY();
    }

    @NonNull
    protected DisplayMetrics getDisplayMetrics() {
        return Resources.getSystem().getDisplayMetrics();
    }

    @Override
    public void update(@NonNull PromptOptions prompt, float revealModifier, float alphaModifier) {
        this.mPaint.setAlpha((int)((float)this.mBaseColourAlpha * alphaModifier));
        PromptUtils.scale(this.mFocalCentre, this.mBaseBounds, this.mBounds, revealModifier, false);
    }

    @Override
    public void draw(@NonNull Canvas canvas) {
        canvas.drawRect(this.mBounds, this.mPaint);
    }

    @Override
    public boolean contains(float x, float y) {
        return this.mBounds.contains(x, y);
    }
}

