/*
 * Decompiled with CFR 0.152.
 */
package uk.co.samuelwall.materialtaptargetprompt.extras.backgrounds;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.support.annotation.ColorInt;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import uk.co.samuelwall.materialtaptargetprompt.extras.PromptBackground;
import uk.co.samuelwall.materialtaptargetprompt.extras.PromptOptions;
import uk.co.samuelwall.materialtaptargetprompt.extras.PromptText;
import uk.co.samuelwall.materialtaptargetprompt.extras.PromptUtils;

public class CirclePromptBackground
extends PromptBackground {
    PointF mPosition;
    float mRadius;
    PointF mBasePosition;
    float mBaseRadius;
    Paint mPaint = new Paint();
    @IntRange(from=0L, to=255L)
    int mBaseColourAlpha;

    public CirclePromptBackground() {
        this.mPaint.setAntiAlias(true);
        this.mPosition = new PointF();
        this.mBasePosition = new PointF();
    }

    @Override
    public void setColour(@ColorInt int colour) {
        this.mPaint.setColor(colour);
        this.mBaseColourAlpha = Color.alpha((int)colour);
        this.mPaint.setAlpha(this.mBaseColourAlpha);
    }

    @Override
    public void prepare(@NonNull PromptOptions options, boolean clipToBounds, @NonNull Rect clipBounds) {
        PromptText promptText = options.getPromptText();
        RectF focalBounds = options.getPromptFocal().getBounds();
        float focalCentreX = focalBounds.centerX();
        float focalCentreY = focalBounds.centerY();
        float focalPadding = options.getFocalPadding();
        RectF textBounds = promptText.getBounds();
        float textPadding = options.getTextPadding();
        RectF clipBoundsInset88dp = new RectF(clipBounds);
        float inset88dp = 88.0f * options.getResourceFinder().getResources().getDisplayMetrics().density;
        clipBoundsInset88dp.inset(inset88dp, inset88dp);
        if (focalCentreX > clipBoundsInset88dp.left && focalCentreX < clipBoundsInset88dp.right || focalCentreY > clipBoundsInset88dp.top && focalCentreY < clipBoundsInset88dp.bottom) {
            float textWidth = textBounds.width();
            float distanceX = focalCentreX - textBounds.left + textWidth / 2.0f;
            float percentageOffset = 100.0f / textWidth * distanceX;
            float angle = 90.0f * (percentageOffset / 100.0f);
            angle = textBounds.top < focalBounds.top ? 180.0f - angle : 180.0f + angle;
            PointF furthestPoint = options.getPromptFocal().calculateAngleEdgePoint(angle, focalPadding);
            float x1 = furthestPoint.x;
            float y1 = furthestPoint.y;
            float x2 = textBounds.left - textPadding;
            float y2 = textBounds.top < focalBounds.top ? textBounds.top : textBounds.bottom;
            float y3 = y2;
            float x3 = textBounds.right + textPadding;
            if (focalBounds.right > x3) {
                x3 = focalBounds.right + focalPadding;
            }
            double offset = Math.pow(x2, 2.0) + Math.pow(y2, 2.0);
            double bc = (Math.pow(x1, 2.0) + Math.pow(y1, 2.0) - offset) / 2.0;
            double cd = (offset - Math.pow(x3, 2.0) - Math.pow(y3, 2.0)) / 2.0;
            double det = (x1 - x2) * (y2 - y3) - (x2 - x3) * (y1 - y2);
            double idet = 1.0 / det;
            this.mBasePosition.set((float)((bc * (double)(y2 - y3) - cd * (double)(y1 - y2)) * idet), (float)((cd * (double)(x1 - x2) - bc * (double)(x2 - x3)) * idet));
            this.mBaseRadius = (float)Math.sqrt(Math.pow(x2 - this.mBasePosition.x, 2.0) + Math.pow(y2 - this.mBasePosition.y, 2.0));
        } else {
            this.mBasePosition.set(focalCentreX, focalCentreY);
            float length = Math.max(Math.abs(textBounds.right - focalCentreX), Math.abs(textBounds.left - focalCentreX)) + textPadding;
            float height = focalBounds.height() / 2.0f + focalPadding + textBounds.height();
            this.mBaseRadius = (float)Math.sqrt(Math.pow(length, 2.0) + Math.pow(height, 2.0));
        }
        this.mPosition.set(this.mBasePosition);
    }

    @Override
    public void update(@NonNull PromptOptions options, float revealModifier, float alphaModifier) {
        RectF focalBounds = options.getPromptFocal().getBounds();
        float focalCentreX = focalBounds.centerX();
        float focalCentreY = focalBounds.centerY();
        this.mRadius = this.mBaseRadius * revealModifier;
        this.mPaint.setAlpha((int)((float)this.mBaseColourAlpha * alphaModifier));
        this.mPosition.set(focalCentreX + (this.mBasePosition.x - focalCentreX) * revealModifier, focalCentreY + (this.mBasePosition.y - focalCentreY) * revealModifier);
    }

    @Override
    public void draw(@NonNull Canvas canvas) {
        canvas.drawCircle(this.mPosition.x, this.mPosition.y, this.mRadius, this.mPaint);
    }

    @Override
    public boolean contains(float x, float y) {
        return PromptUtils.isPointInCircle(x, y, this.mPosition, this.mRadius);
    }
}

