/*
 * Decompiled with CFR 0.152.
 */
package uk.co.samuelwall.materialtaptargetprompt.extras;

import android.annotation.SuppressLint;
import android.content.res.Resources;
import android.graphics.PointF;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.Layout;
import android.text.SpannableStringBuilder;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.view.Gravity;
import java.text.Bidi;
import uk.co.samuelwall.materialtaptargetprompt.extras.AlphaSpan;

public class PromptUtils {
    private PromptUtils() {
    }

    public static boolean isPointInCircle(float x, float y, @NonNull PointF circleCentre, float radius) {
        return Math.pow(x - circleCentre.x, 2.0) + Math.pow(y - circleCentre.y, 2.0) < Math.pow(radius, 2.0);
    }

    public static void setTypeface(@NonNull TextPaint textPaint, @Nullable Typeface typeface, int style) {
        if (style > 0) {
            typeface = typeface == null ? Typeface.defaultFromStyle((int)style) : Typeface.create((Typeface)typeface, (int)style);
            textPaint.setTypeface(typeface);
            int typefaceStyle = typeface != null ? typeface.getStyle() : 0;
            int need = style & ~typefaceStyle;
            textPaint.setFakeBoldText((need & 1) != 0);
            textPaint.setTextSkewX((need & 2) != 0 ? -0.25f : 0.0f);
        } else if (typeface != null) {
            textPaint.setTypeface(typeface);
        } else {
            textPaint.setTypeface(Typeface.defaultFromStyle((int)style));
        }
    }

    @NonNull
    public static Typeface setTypefaceFromAttrs(@Nullable String familyName, int typefaceIndex, int styleIndex) {
        Typeface tf = null;
        if (familyName != null && (tf = Typeface.create((String)familyName, (int)styleIndex)) != null) {
            return tf;
        }
        switch (typefaceIndex) {
            case 1: {
                tf = Typeface.SANS_SERIF;
                break;
            }
            case 2: {
                tf = Typeface.SERIF;
                break;
            }
            case 3: {
                tf = Typeface.MONOSPACE;
            }
        }
        return Typeface.create((Typeface)tf, (int)styleIndex);
    }

    @Nullable
    public static PorterDuff.Mode parseTintMode(int value, @Nullable PorterDuff.Mode defaultMode) {
        switch (value) {
            case 3: {
                return PorterDuff.Mode.SRC_OVER;
            }
            case 5: {
                return PorterDuff.Mode.SRC_IN;
            }
            case 9: {
                return PorterDuff.Mode.SRC_ATOP;
            }
            case 14: {
                return PorterDuff.Mode.MULTIPLY;
            }
            case 15: {
                return PorterDuff.Mode.SCREEN;
            }
            case 16: {
                return PorterDuff.Mode.valueOf((String)"ADD");
            }
        }
        return defaultMode;
    }

    @SuppressLint(value={"RtlHardcoded"})
    @NonNull
    public static Layout.Alignment getTextAlignment(@NonNull Resources resources, int gravity, @Nullable CharSequence text) {
        Layout.Alignment alignment;
        int absoluteGravity;
        if (Build.VERSION.SDK_INT >= 17) {
            int realGravity = gravity;
            int layoutDirection = resources.getConfiguration().getLayoutDirection();
            if (text != null && layoutDirection == 1 && new Bidi(text.toString(), -2).isRightToLeft()) {
                if (gravity == 0x800003) {
                    realGravity = 0x800005;
                } else if (gravity == 0x800005) {
                    realGravity = 0x800003;
                }
            }
            absoluteGravity = Gravity.getAbsoluteGravity((int)realGravity, (int)layoutDirection);
        } else {
            absoluteGravity = (gravity & 0x800003) == 0x800003 ? 3 : ((gravity & 0x800005) == 0x800005 ? 5 : gravity & 7);
        }
        switch (absoluteGravity) {
            case 5: {
                alignment = Layout.Alignment.ALIGN_OPPOSITE;
                break;
            }
            case 1: {
                alignment = Layout.Alignment.ALIGN_CENTER;
                break;
            }
            default: {
                alignment = Layout.Alignment.ALIGN_NORMAL;
            }
        }
        return alignment;
    }

    @NonNull
    public static StaticLayout createStaticTextLayout(@NonNull CharSequence text, @NonNull TextPaint paint, int maxTextWidth, @NonNull Layout.Alignment textAlignment, float alphaModifier) {
        StaticLayout layout;
        SpannableStringBuilder wrappedText = new SpannableStringBuilder(text);
        wrappedText.setSpan((Object)new AlphaSpan(alphaModifier), 0, wrappedText.length(), 18);
        if (Build.VERSION.SDK_INT >= 23) {
            StaticLayout.Builder builder = StaticLayout.Builder.obtain((CharSequence)wrappedText, (int)0, (int)text.length(), (TextPaint)paint, (int)maxTextWidth);
            builder.setAlignment(textAlignment);
            layout = builder.build();
        } else {
            layout = new StaticLayout((CharSequence)wrappedText, paint, maxTextWidth, textAlignment, 1.0f, 0.0f, false);
        }
        return layout;
    }

    public static void scale(@NonNull PointF origin, @NonNull RectF base, @NonNull RectF out, float scale, boolean even) {
        if (scale == 1.0f) {
            out.set(base);
            return;
        }
        float horizontalFromCentre = base.centerX() - base.left;
        float verticalFromCentre = base.centerY() - base.top;
        if (even && scale > 1.0f) {
            float minChange = Math.min(horizontalFromCentre * scale - horizontalFromCentre, verticalFromCentre * scale - verticalFromCentre);
            out.left = base.left - minChange;
            out.top = base.top - minChange;
            out.right = base.right + minChange;
            out.bottom = base.bottom + minChange;
        } else {
            out.left = origin.x - horizontalFromCentre * scale * ((origin.x - base.left) / horizontalFromCentre);
            out.top = origin.y - verticalFromCentre * scale * ((origin.y - base.top) / verticalFromCentre);
            out.right = origin.x + horizontalFromCentre * scale * ((base.right - origin.x) / horizontalFromCentre);
            out.bottom = origin.y + verticalFromCentre * scale * ((base.bottom - origin.y) / verticalFromCentre);
        }
    }

    public static boolean isRtlText(@Nullable Layout layout, @NonNull Resources resources) {
        boolean result = false;
        if (layout != null) {
            result = layout.getAlignment() == Layout.Alignment.ALIGN_OPPOSITE;
            boolean textIsRtl = layout.isRtlCharAt(0);
            boolean bl = result = (!result || !textIsRtl) && (result || textIsRtl) || textIsRtl;
            if (!result && layout.getAlignment() == Layout.Alignment.ALIGN_NORMAL && Build.VERSION.SDK_INT >= 17) {
                result = resources.getConfiguration().getLayoutDirection() == 1;
            } else if (layout.getAlignment() == Layout.Alignment.ALIGN_OPPOSITE && textIsRtl) {
                result = false;
            }
        }
        return result;
    }

    public static float calculateMaxWidth(float maxTextWidth, @Nullable Rect clipBounds, int parentWidth, float textPadding) {
        return Math.max(80.0f, Math.min(maxTextWidth, (float)(clipBounds != null ? clipBounds.right - clipBounds.left : parentWidth) - textPadding * 2.0f));
    }

    public static float calculateMaxTextWidth(@Nullable Layout textLayout) {
        float maxTextWidth = 0.0f;
        if (textLayout != null) {
            int count = textLayout.getLineCount();
            for (int i = 0; i < count; ++i) {
                maxTextWidth = Math.max(maxTextWidth, textLayout.getLineWidth(i));
            }
        }
        return maxTextWidth;
    }

    public static boolean containsInset(@NonNull Rect bounds, int inset, int x, int y) {
        return x > bounds.left + inset && x < bounds.right - inset && y > bounds.top + inset && y < bounds.bottom - inset;
    }

    @Deprecated
    public static boolean isVersionAfterJellyBeanMR1() {
        return Build.VERSION.SDK_INT >= 17;
    }
}

