/*
 * Decompiled with CFR 0.152.
 */
package uk.co.samuelwall.materialtaptargetprompt.extras;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Rect;
import android.graphics.RectF;
import android.support.annotation.NonNull;
import android.text.Layout;
import android.text.TextPaint;
import uk.co.samuelwall.materialtaptargetprompt.extras.PromptOptions;
import uk.co.samuelwall.materialtaptargetprompt.extras.PromptUIElement;
import uk.co.samuelwall.materialtaptargetprompt.extras.PromptUtils;

public class PromptText
implements PromptUIElement {
    RectF mTextBounds = new RectF();
    float mPrimaryTextLeft;
    float mPrimaryTextLeftChange;
    float mPrimaryTextTop;
    float mSecondaryTextLeft;
    float mSecondaryTextLeftChange;
    float mSecondaryTextOffsetTop;
    Layout mPrimaryTextLayout;
    Layout mSecondaryTextLayout;
    TextPaint mPaintPrimaryText;
    TextPaint mPaintSecondaryText;
    Layout.Alignment mPrimaryTextAlignment;
    Layout.Alignment mSecondaryTextAlignment;
    boolean mClipToBounds;
    Rect mClipBounds;

    @NonNull
    public RectF getBounds() {
        return this.mTextBounds;
    }

    public void prepare(@NonNull PromptOptions options, boolean clipToBounds, @NonNull Rect clipBounds) {
        float textHeight;
        CharSequence secondaryText;
        this.mClipToBounds = clipToBounds;
        this.mClipBounds = clipBounds;
        CharSequence primaryText = options.getPrimaryText();
        if (primaryText != null) {
            this.mPaintPrimaryText = new TextPaint();
            int primaryTextColour = options.getPrimaryTextColour();
            this.mPaintPrimaryText.setColor(primaryTextColour);
            this.mPaintPrimaryText.setAlpha(Color.alpha((int)primaryTextColour));
            this.mPaintPrimaryText.setAntiAlias(true);
            this.mPaintPrimaryText.setTextSize(options.getPrimaryTextSize());
            PromptUtils.setTypeface(this.mPaintPrimaryText, options.getPrimaryTextTypeface(), options.getPrimaryTextTypefaceStyle());
            this.mPrimaryTextAlignment = PromptUtils.getTextAlignment(options.getResourceFinder().getResources(), options.getPrimaryTextGravity(), primaryText);
        }
        if ((secondaryText = options.getSecondaryText()) != null) {
            this.mPaintSecondaryText = new TextPaint();
            int secondaryTextColour = options.getSecondaryTextColour();
            this.mPaintSecondaryText.setColor(secondaryTextColour);
            this.mPaintSecondaryText.setAlpha(Color.alpha((int)secondaryTextColour));
            this.mPaintSecondaryText.setAntiAlias(true);
            this.mPaintSecondaryText.setTextSize(options.getSecondaryTextSize());
            PromptUtils.setTypeface(this.mPaintSecondaryText, options.getSecondaryTextTypeface(), options.getSecondaryTextTypefaceStyle());
            this.mSecondaryTextAlignment = PromptUtils.getTextAlignment(options.getResourceFinder().getResources(), options.getSecondaryTextGravity(), secondaryText);
        }
        RectF focalBounds = options.getPromptFocal().getBounds();
        float focalCentreX = focalBounds.centerX();
        float focalCentreY = focalBounds.centerY();
        boolean verticalTextPositionAbove = focalCentreY > (float)clipBounds.centerY();
        boolean horizontalTextPositionLeft = focalCentreX > (float)clipBounds.centerX();
        float maxWidth = PromptUtils.calculateMaxWidth(options.getMaxTextWidth(), (Rect)(clipToBounds ? clipBounds : null), options.getResourceFinder().getPromptParentView().getWidth(), options.getTextPadding());
        this.createTextLayout(options, maxWidth, 1.0f);
        float primaryTextWidth = PromptUtils.calculateMaxTextWidth(this.mPrimaryTextLayout);
        float secondaryTextWidth = PromptUtils.calculateMaxTextWidth(this.mSecondaryTextLayout);
        float textWidth = Math.max(primaryTextWidth, secondaryTextWidth);
        float focalPadding = options.getFocalPadding();
        float textPadding = options.getTextPadding();
        if (PromptUtils.containsInset(clipBounds, (int)(88.0f * options.getResourceFinder().getResources().getDisplayMetrics().density), (int)focalCentreX, (int)focalCentreY)) {
            this.mPrimaryTextLeft = clipBounds.left;
            float width = Math.min(textWidth, maxWidth);
            this.mPrimaryTextLeft = horizontalTextPositionLeft ? focalCentreX - width + focalPadding : focalCentreX - width - focalPadding;
            if (this.mPrimaryTextLeft < (float)clipBounds.left + textPadding) {
                this.mPrimaryTextLeft = (float)clipBounds.left + textPadding;
            }
            if (this.mPrimaryTextLeft + width > (float)clipBounds.right - textPadding) {
                this.mPrimaryTextLeft = (float)clipBounds.right - textPadding - width;
            }
        } else {
            this.mPrimaryTextLeft = horizontalTextPositionLeft ? (float)(clipToBounds ? clipBounds.right : options.getResourceFinder().getPromptParentView().getRight()) - textPadding - textWidth : (float)(clipToBounds ? clipBounds.left : options.getResourceFinder().getPromptParentView().getLeft()) + textPadding;
        }
        if (verticalTextPositionAbove) {
            this.mPrimaryTextTop = focalBounds.top - focalPadding;
            if (this.mPrimaryTextLayout != null) {
                this.mPrimaryTextTop -= (float)this.mPrimaryTextLayout.getHeight();
            }
        } else {
            this.mPrimaryTextTop = focalBounds.bottom + focalPadding;
        }
        float primaryTextHeight = 0.0f;
        if (this.mPrimaryTextLayout != null) {
            primaryTextHeight = this.mPrimaryTextLayout.getHeight();
        }
        if (this.mSecondaryTextLayout != null) {
            textHeight = this.mSecondaryTextLayout.getHeight();
            if (verticalTextPositionAbove) {
                this.mPrimaryTextTop -= textHeight;
                if (this.mPrimaryTextLayout != null) {
                    this.mPrimaryTextTop -= options.getTextSeparation();
                }
            }
            if (this.mPrimaryTextLayout != null) {
                this.mSecondaryTextOffsetTop = primaryTextHeight + options.getTextSeparation();
            }
            textHeight += this.mSecondaryTextOffsetTop;
        } else {
            textHeight = primaryTextHeight;
        }
        this.mSecondaryTextLeft = this.mPrimaryTextLeft;
        this.mPrimaryTextLeftChange = 0.0f;
        this.mSecondaryTextLeftChange = 0.0f;
        float change = maxWidth - textWidth;
        if (PromptUtils.isRtlText(this.mPrimaryTextLayout, options.getResourceFinder().getResources())) {
            this.mPrimaryTextLeftChange = change;
        }
        if (PromptUtils.isRtlText(this.mSecondaryTextLayout, options.getResourceFinder().getResources())) {
            this.mSecondaryTextLeftChange = change;
        }
        this.mTextBounds.left = this.mPrimaryTextLeft;
        this.mTextBounds.top = this.mPrimaryTextTop;
        this.mTextBounds.right = this.mTextBounds.left + textWidth;
        this.mTextBounds.bottom = this.mTextBounds.top + textHeight;
    }

    void createTextLayout(@NonNull PromptOptions options, float maxWidth, float alphaModifier) {
        this.mPrimaryTextLayout = options.getPrimaryText() != null ? PromptUtils.createStaticTextLayout(options.getPrimaryText(), this.mPaintPrimaryText, (int)maxWidth, this.mPrimaryTextAlignment, alphaModifier) : null;
        this.mSecondaryTextLayout = options.getSecondaryText() != null ? PromptUtils.createStaticTextLayout(options.getSecondaryText(), this.mPaintSecondaryText, (int)maxWidth, this.mSecondaryTextAlignment, alphaModifier) : null;
    }

    @Override
    public void update(@NonNull PromptOptions options, float revealModifier, float alphaModifier) {
        float maxWidth = PromptUtils.calculateMaxWidth(options.getMaxTextWidth(), this.mClipToBounds ? this.mClipBounds : null, options.getResourceFinder().getPromptParentView().getWidth(), options.getTextPadding());
        this.createTextLayout(options, maxWidth, alphaModifier);
    }

    @Override
    public void draw(@NonNull Canvas canvas) {
        canvas.translate(this.mPrimaryTextLeft - this.mPrimaryTextLeftChange, this.mPrimaryTextTop);
        if (this.mPrimaryTextLayout != null) {
            this.mPrimaryTextLayout.draw(canvas);
        }
        if (this.mSecondaryTextLayout != null) {
            canvas.translate(-(this.mPrimaryTextLeft - this.mPrimaryTextLeftChange) + this.mSecondaryTextLeft - this.mSecondaryTextLeftChange, this.mSecondaryTextOffsetTop);
            this.mSecondaryTextLayout.draw(canvas);
        }
    }

    @Override
    public boolean contains(float x, float y) {
        return this.mTextBounds.contains(x, y);
    }
}

