/*
 * Decompiled with CFR 0.152.
 */
package uk.co.samuelwall.materialtaptargetprompt.extras;

import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.PointF;
import android.graphics.PorterDuff;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.DimenRes;
import android.support.annotation.Dimension;
import android.support.annotation.DrawableRes;
import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.annotation.StyleRes;
import android.util.TypedValue;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Interpolator;
import uk.co.samuelwall.materialtaptargetprompt.MaterialTapTargetPrompt;
import uk.co.samuelwall.materialtaptargetprompt.R;
import uk.co.samuelwall.materialtaptargetprompt.ResourceFinder;
import uk.co.samuelwall.materialtaptargetprompt.extras.PromptBackground;
import uk.co.samuelwall.materialtaptargetprompt.extras.PromptFocal;
import uk.co.samuelwall.materialtaptargetprompt.extras.PromptText;
import uk.co.samuelwall.materialtaptargetprompt.extras.PromptUtils;
import uk.co.samuelwall.materialtaptargetprompt.extras.backgrounds.CirclePromptBackground;
import uk.co.samuelwall.materialtaptargetprompt.extras.focals.CirclePromptFocal;

public class PromptOptions<T extends PromptOptions> {
    private ResourceFinder mResourceFinder;
    private boolean mTargetSet;
    @Nullable
    private View mTargetView;
    @Nullable
    private PointF mTargetPosition;
    @Nullable
    private CharSequence mPrimaryText;
    @Nullable
    private CharSequence mSecondaryText;
    @ColorInt
    private int mPrimaryTextColour = -1;
    @ColorInt
    private int mSecondaryTextColour = Color.argb((int)179, (int)255, (int)255, (int)255);
    @ColorInt
    private int mBackgroundColour = Color.argb((int)244, (int)63, (int)81, (int)181);
    @ColorInt
    private int mFocalColour = -1;
    private float mFocalRadius;
    private float mPrimaryTextSize;
    private float mSecondaryTextSize;
    private float mMaxTextWidth;
    private float mTextPadding;
    private float mFocalPadding;
    @Nullable
    private Interpolator mAnimationInterpolator;
    @Nullable
    private Drawable mIconDrawable;
    private boolean mBackButtonDismissEnabled = true;
    @Nullable
    private MaterialTapTargetPrompt.PromptStateChangeListener mPromptStateChangeListener;
    @Nullable
    private MaterialTapTargetPrompt.PromptStateChangeListener mSequencePromptStateChangeListener;
    private boolean mCaptureTouchEventOnFocal;
    private float mTextSeparation;
    private boolean mAutoDismiss = true;
    private boolean mAutoFinish = true;
    private boolean mCaptureTouchEventOutsidePrompt;
    @Nullable
    private Typeface mPrimaryTextTypeface;
    @Nullable
    private Typeface mSecondaryTextTypeface;
    @Nullable
    private String mContentDescription;
    private int mPrimaryTextTypefaceStyle;
    private int mSecondaryTextTypefaceStyle;
    @Nullable
    private ColorStateList mIconDrawableTintList = null;
    @Nullable
    private PorterDuff.Mode mIconDrawableTintMode = PorterDuff.Mode.MULTIPLY;
    private boolean mHasIconDrawableTint;
    private int mIconDrawableColourFilter;
    @Nullable
    private View mTargetRenderView;
    private boolean mIdleAnimationEnabled = true;
    private int mPrimaryTextGravity = 0x800003;
    private int mSecondaryTextGravity = 0x800003;
    @Nullable
    private View mClipToView;
    @NonNull
    private PromptBackground mPromptBackground = new CirclePromptBackground();
    @NonNull
    private PromptFocal mPromptFocal = new CirclePromptFocal();
    @NonNull
    private PromptText mPromptText = new PromptText();

    public PromptOptions(@NonNull ResourceFinder resourceFinder) {
        this.mResourceFinder = resourceFinder;
        float density = this.mResourceFinder.getResources().getDisplayMetrics().density;
        this.mFocalRadius = density * 44.0f;
        this.mPrimaryTextSize = density * 22.0f;
        this.mSecondaryTextSize = density * 18.0f;
        this.mMaxTextWidth = density * 400.0f;
        this.mTextPadding = density * 40.0f;
        this.mFocalPadding = density * 20.0f;
        this.mTextSeparation = density * 16.0f;
    }

    public void load(@StyleRes int themeResId) {
        View contentView;
        if (themeResId == 0) {
            TypedValue outValue = new TypedValue();
            this.mResourceFinder.getTheme().resolveAttribute(R.attr.MaterialTapTargetPromptTheme, outValue, true);
            themeResId = outValue.resourceId;
        }
        TypedArray a = this.mResourceFinder.obtainStyledAttributes(themeResId, R.styleable.PromptView);
        this.mPrimaryTextColour = a.getColor(R.styleable.PromptView_mttp_primaryTextColour, this.mPrimaryTextColour);
        this.mSecondaryTextColour = a.getColor(R.styleable.PromptView_mttp_secondaryTextColour, this.mSecondaryTextColour);
        this.mPrimaryText = a.getString(R.styleable.PromptView_mttp_primaryText);
        this.mSecondaryText = a.getString(R.styleable.PromptView_mttp_secondaryText);
        this.mBackgroundColour = a.getColor(R.styleable.PromptView_mttp_backgroundColour, this.mBackgroundColour);
        this.mFocalColour = a.getColor(R.styleable.PromptView_mttp_focalColour, this.mFocalColour);
        this.mFocalRadius = a.getDimension(R.styleable.PromptView_mttp_focalRadius, this.mFocalRadius);
        this.mPrimaryTextSize = a.getDimension(R.styleable.PromptView_mttp_primaryTextSize, this.mPrimaryTextSize);
        this.mSecondaryTextSize = a.getDimension(R.styleable.PromptView_mttp_secondaryTextSize, this.mSecondaryTextSize);
        this.mMaxTextWidth = a.getDimension(R.styleable.PromptView_mttp_maxTextWidth, this.mMaxTextWidth);
        this.mTextPadding = a.getDimension(R.styleable.PromptView_mttp_textPadding, this.mTextPadding);
        this.mFocalPadding = a.getDimension(R.styleable.PromptView_mttp_focalToTextPadding, this.mFocalPadding);
        this.mTextSeparation = a.getDimension(R.styleable.PromptView_mttp_textSeparation, this.mTextSeparation);
        this.mAutoDismiss = a.getBoolean(R.styleable.PromptView_mttp_autoDismiss, this.mAutoDismiss);
        this.mAutoFinish = a.getBoolean(R.styleable.PromptView_mttp_autoFinish, this.mAutoFinish);
        this.mCaptureTouchEventOutsidePrompt = a.getBoolean(R.styleable.PromptView_mttp_captureTouchEventOutsidePrompt, this.mCaptureTouchEventOutsidePrompt);
        this.mCaptureTouchEventOnFocal = a.getBoolean(R.styleable.PromptView_mttp_captureTouchEventOnFocal, this.mCaptureTouchEventOnFocal);
        this.mPrimaryTextTypefaceStyle = a.getInt(R.styleable.PromptView_mttp_primaryTextStyle, this.mPrimaryTextTypefaceStyle);
        this.mSecondaryTextTypefaceStyle = a.getInt(R.styleable.PromptView_mttp_secondaryTextStyle, this.mSecondaryTextTypefaceStyle);
        this.mPrimaryTextTypeface = PromptUtils.setTypefaceFromAttrs(a.getString(R.styleable.PromptView_mttp_primaryTextFontFamily), a.getInt(R.styleable.PromptView_mttp_primaryTextTypeface, 0), this.mPrimaryTextTypefaceStyle);
        this.mSecondaryTextTypeface = PromptUtils.setTypefaceFromAttrs(a.getString(R.styleable.PromptView_mttp_secondaryTextFontFamily), a.getInt(R.styleable.PromptView_mttp_secondaryTextTypeface, 0), this.mSecondaryTextTypefaceStyle);
        this.mContentDescription = a.getString(R.styleable.PromptView_mttp_contentDescription);
        this.mIconDrawableColourFilter = a.getColor(R.styleable.PromptView_mttp_iconColourFilter, this.mBackgroundColour);
        this.mIconDrawableTintList = a.getColorStateList(R.styleable.PromptView_mttp_iconTint);
        this.mIconDrawableTintMode = PromptUtils.parseTintMode(a.getInt(R.styleable.PromptView_mttp_iconTintMode, -1), this.mIconDrawableTintMode);
        this.mHasIconDrawableTint = true;
        int targetId = a.getResourceId(R.styleable.PromptView_mttp_target, 0);
        a.recycle();
        if (targetId != 0) {
            this.mTargetView = this.mResourceFinder.findViewById(targetId);
            if (this.mTargetView != null) {
                this.mTargetSet = true;
            }
        }
        if ((contentView = this.mResourceFinder.findViewById(0x1020002)) != null) {
            this.mClipToView = (View)contentView.getParent();
        }
    }

    @NonNull
    public ResourceFinder getResourceFinder() {
        return this.mResourceFinder;
    }

    @NonNull
    public T setTarget(@Nullable View target) {
        this.mTargetView = target;
        this.mTargetPosition = null;
        this.mTargetSet = this.mTargetView != null;
        return (T)this;
    }

    @NonNull
    public T setTarget(@IdRes int target) {
        this.mTargetView = this.mResourceFinder.findViewById(target);
        this.mTargetPosition = null;
        this.mTargetSet = this.mTargetView != null;
        return (T)this;
    }

    @Nullable
    public View getTargetView() {
        return this.mTargetView;
    }

    @NonNull
    public T setTarget(float left, float top) {
        this.mTargetView = null;
        this.mTargetPosition = new PointF(left, top);
        this.mTargetSet = true;
        return (T)this;
    }

    @Nullable
    public PointF getTargetPosition() {
        return this.mTargetPosition;
    }

    @NonNull
    public T setTargetRenderView(@Nullable View view) {
        this.mTargetRenderView = view;
        return (T)this;
    }

    @Nullable
    public View getTargetRenderView() {
        return this.mTargetRenderView;
    }

    public boolean isTargetSet() {
        return this.mTargetSet;
    }

    @NonNull
    public T setPrimaryText(@StringRes int resId) {
        this.mPrimaryText = this.mResourceFinder.getString(resId);
        return (T)this;
    }

    @NonNull
    public T setPrimaryText(@Nullable String text) {
        this.mPrimaryText = text;
        return (T)this;
    }

    @NonNull
    public T setPrimaryText(@Nullable CharSequence text) {
        this.mPrimaryText = text;
        return (T)this;
    }

    @Nullable
    public CharSequence getPrimaryText() {
        return this.mPrimaryText;
    }

    @NonNull
    public T setPrimaryTextSize(@Dimension float size) {
        this.mPrimaryTextSize = size;
        return (T)this;
    }

    @NonNull
    public T setPrimaryTextSize(@DimenRes int resId) {
        this.mPrimaryTextSize = this.mResourceFinder.getResources().getDimension(resId);
        return (T)this;
    }

    @Dimension
    public float getPrimaryTextSize() {
        return this.mPrimaryTextSize;
    }

    @NonNull
    public T setPrimaryTextColour(@ColorInt int colour) {
        this.mPrimaryTextColour = colour;
        return (T)this;
    }

    @ColorInt
    public int getPrimaryTextColour() {
        return this.mPrimaryTextColour;
    }

    @NonNull
    public T setPrimaryTextTypeface(@Nullable Typeface typeface) {
        return this.setPrimaryTextTypeface(typeface, 0);
    }

    @NonNull
    public T setPrimaryTextTypeface(@Nullable Typeface typeface, int style) {
        this.mPrimaryTextTypeface = typeface;
        this.mPrimaryTextTypefaceStyle = style;
        return (T)this;
    }

    @Nullable
    public Typeface getPrimaryTextTypeface() {
        return this.mPrimaryTextTypeface;
    }

    public int getPrimaryTextTypefaceStyle() {
        return this.mPrimaryTextTypefaceStyle;
    }

    @NonNull
    public T setSecondaryText(@StringRes int resId) {
        this.mSecondaryText = this.mResourceFinder.getString(resId);
        return (T)this;
    }

    @NonNull
    public T setSecondaryText(@Nullable String text) {
        this.mSecondaryText = text;
        return (T)this;
    }

    @NonNull
    public T setSecondaryText(@Nullable CharSequence text) {
        this.mSecondaryText = text;
        return (T)this;
    }

    @Nullable
    public CharSequence getSecondaryText() {
        return this.mSecondaryText;
    }

    @NonNull
    public T setSecondaryTextSize(@DimenRes int resId) {
        this.mSecondaryTextSize = this.mResourceFinder.getResources().getDimension(resId);
        return (T)this;
    }

    @NonNull
    public T setSecondaryTextSize(@Dimension float size) {
        this.mSecondaryTextSize = size;
        return (T)this;
    }

    @Dimension
    public float getSecondaryTextSize() {
        return this.mSecondaryTextSize;
    }

    @NonNull
    public T setSecondaryTextColour(@ColorInt int colour) {
        this.mSecondaryTextColour = colour;
        return (T)this;
    }

    public int getSecondaryTextColour() {
        return this.mSecondaryTextColour;
    }

    @NonNull
    public T setSecondaryTextTypeface(@Nullable Typeface typeface) {
        return this.setSecondaryTextTypeface(typeface, 0);
    }

    @NonNull
    public T setSecondaryTextTypeface(@Nullable Typeface typeface, int style) {
        this.mSecondaryTextTypeface = typeface;
        this.mSecondaryTextTypefaceStyle = style;
        return (T)this;
    }

    @Nullable
    public Typeface getSecondaryTextTypeface() {
        return this.mSecondaryTextTypeface;
    }

    public int getSecondaryTextTypefaceStyle() {
        return this.mSecondaryTextTypefaceStyle;
    }

    @NonNull
    public T setContentDescription(@StringRes int resId) {
        this.mContentDescription = this.mResourceFinder.getString(resId);
        return (T)this;
    }

    @NonNull
    public T setContentDescription(@Nullable String text) {
        this.mContentDescription = text;
        return (T)this;
    }

    @Nullable
    public String getContentDescription() {
        if (this.mContentDescription != null) {
            return this.mContentDescription;
        }
        return String.format("%s. %s", this.mPrimaryText, this.mSecondaryText);
    }

    @NonNull
    public T setTextPadding(@DimenRes int resId) {
        this.mTextPadding = this.mResourceFinder.getResources().getDimension(resId);
        return (T)this;
    }

    @NonNull
    public T setTextPadding(@Dimension float padding) {
        this.mTextPadding = padding;
        return (T)this;
    }

    @Dimension
    public float getTextPadding() {
        return this.mTextPadding;
    }

    @NonNull
    public T setTextSeparation(@DimenRes int resId) {
        this.mTextSeparation = this.mResourceFinder.getResources().getDimension(resId);
        return (T)this;
    }

    @NonNull
    public T setTextSeparation(@Dimension float separation) {
        this.mTextSeparation = separation;
        return (T)this;
    }

    @Dimension
    public float getTextSeparation() {
        return this.mTextSeparation;
    }

    @NonNull
    public T setFocalPadding(@DimenRes int resId) {
        this.mFocalPadding = this.mResourceFinder.getResources().getDimension(resId);
        return (T)this;
    }

    @NonNull
    public T setFocalPadding(@Dimension float padding) {
        this.mFocalPadding = padding;
        return (T)this;
    }

    @Dimension
    public float getFocalPadding() {
        return this.mFocalPadding;
    }

    @NonNull
    public T setAnimationInterpolator(@Nullable Interpolator interpolator) {
        this.mAnimationInterpolator = interpolator;
        return (T)this;
    }

    @Nullable
    public Interpolator getAnimationInterpolator() {
        return this.mAnimationInterpolator;
    }

    @NonNull
    public T setIdleAnimationEnabled(boolean enabled) {
        this.mIdleAnimationEnabled = enabled;
        return (T)this;
    }

    public boolean getIdleAnimationEnabled() {
        return this.mIdleAnimationEnabled;
    }

    @NonNull
    public T setIcon(@DrawableRes int resId) {
        this.mIconDrawable = this.mResourceFinder.getDrawable(resId);
        return (T)this;
    }

    @NonNull
    public T setIconDrawable(@Nullable Drawable drawable) {
        this.mIconDrawable = drawable;
        return (T)this;
    }

    @Nullable
    public Drawable getIconDrawable() {
        return this.mIconDrawable;
    }

    @NonNull
    public T setIconDrawableTintList(@Nullable ColorStateList tint) {
        this.mIconDrawableTintList = tint;
        this.mHasIconDrawableTint = tint != null;
        return (T)this;
    }

    @NonNull
    public T setIconDrawableTintMode(@Nullable PorterDuff.Mode tintMode) {
        this.mIconDrawableTintMode = tintMode;
        if (tintMode == null) {
            this.mIconDrawableTintList = null;
            this.mHasIconDrawableTint = false;
        }
        return (T)this;
    }

    @NonNull
    public T setIconDrawableColourFilter(@ColorInt int colour) {
        this.mIconDrawableColourFilter = colour;
        this.mIconDrawableTintList = null;
        this.mHasIconDrawableTint = true;
        return (T)this;
    }

    @NonNull
    public T setPromptStateChangeListener(@Nullable MaterialTapTargetPrompt.PromptStateChangeListener listener) {
        this.mPromptStateChangeListener = listener;
        return (T)this;
    }

    public void setSequenceListener(@Nullable MaterialTapTargetPrompt.PromptStateChangeListener listener) {
        this.mSequencePromptStateChangeListener = listener;
    }

    public void onPromptStateChanged(@NonNull MaterialTapTargetPrompt prompt, int state) {
        if (this.mPromptStateChangeListener != null) {
            this.mPromptStateChangeListener.onPromptStateChanged(prompt, state);
        }
    }

    public void onExtraPromptStateChanged(@NonNull MaterialTapTargetPrompt prompt, int state) {
        if (this.mSequencePromptStateChangeListener != null) {
            this.mSequencePromptStateChangeListener.onPromptStateChanged(prompt, state);
        }
    }

    @NonNull
    public T setCaptureTouchEventOnFocal(boolean captureTouchEvent) {
        this.mCaptureTouchEventOnFocal = captureTouchEvent;
        return (T)this;
    }

    public boolean getCaptureTouchEventOnFocal() {
        return this.mCaptureTouchEventOnFocal;
    }

    @NonNull
    public T setMaxTextWidth(@DimenRes int resId) {
        this.mMaxTextWidth = this.mResourceFinder.getResources().getDimension(resId);
        return (T)this;
    }

    @NonNull
    public T setMaxTextWidth(@Dimension float width) {
        this.mMaxTextWidth = width;
        return (T)this;
    }

    @Dimension
    public float getMaxTextWidth() {
        return this.mMaxTextWidth;
    }

    @NonNull
    public T setBackgroundColour(@ColorInt int colour) {
        this.mBackgroundColour = colour;
        return (T)this;
    }

    @ColorInt
    public int getBackgroundColour() {
        return this.mBackgroundColour;
    }

    @NonNull
    public T setFocalColour(@ColorInt int colour) {
        this.mFocalColour = colour;
        return (T)this;
    }

    @ColorInt
    public int getFocalColour() {
        return this.mFocalColour;
    }

    @NonNull
    public T setFocalRadius(@DimenRes int resId) {
        this.mFocalRadius = this.mResourceFinder.getResources().getDimension(resId);
        return (T)this;
    }

    @NonNull
    public T setFocalRadius(@Dimension float radius) {
        this.mFocalRadius = radius;
        return (T)this;
    }

    @Dimension
    public float getFocalRadius() {
        return this.mFocalRadius;
    }

    @NonNull
    public T setAutoDismiss(boolean autoDismiss) {
        this.mAutoDismiss = autoDismiss;
        return (T)this;
    }

    public boolean getAutoDismiss() {
        return this.mAutoDismiss;
    }

    @NonNull
    public T setAutoFinish(boolean autoFinish) {
        this.mAutoFinish = autoFinish;
        return (T)this;
    }

    public boolean getAutoFinish() {
        return this.mAutoFinish;
    }

    @NonNull
    public T setCaptureTouchEventOutsidePrompt(boolean captureTouchEventOutsidePrompt) {
        this.mCaptureTouchEventOutsidePrompt = captureTouchEventOutsidePrompt;
        return (T)this;
    }

    public boolean getCaptureTouchEventOutsidePrompt() {
        return this.mCaptureTouchEventOutsidePrompt;
    }

    @NonNull
    public T setTextGravity(int gravity) {
        this.mPrimaryTextGravity = gravity;
        this.mSecondaryTextGravity = gravity;
        return (T)this;
    }

    @NonNull
    public T setPrimaryTextGravity(int gravity) {
        this.mPrimaryTextGravity = gravity;
        return (T)this;
    }

    public int getPrimaryTextGravity() {
        return this.mPrimaryTextGravity;
    }

    @NonNull
    public T setSecondaryTextGravity(int gravity) {
        this.mSecondaryTextGravity = gravity;
        return (T)this;
    }

    public int getSecondaryTextGravity() {
        return this.mSecondaryTextGravity;
    }

    @NonNull
    public T setClipToView(@Nullable View view) {
        this.mClipToView = view;
        return (T)this;
    }

    @Nullable
    public View getClipToView() {
        return this.mClipToView;
    }

    @NonNull
    public T setBackButtonDismissEnabled(boolean enabled) {
        this.mBackButtonDismissEnabled = enabled;
        return (T)this;
    }

    public boolean getBackButtonDismissEnabled() {
        return this.mBackButtonDismissEnabled;
    }

    @NonNull
    public T setPromptBackground(@NonNull PromptBackground promptBackground) {
        this.mPromptBackground = promptBackground;
        return (T)this;
    }

    @NonNull
    public PromptBackground getPromptBackground() {
        return this.mPromptBackground;
    }

    @NonNull
    public T setPromptFocal(@NonNull PromptFocal promptFocal) {
        this.mPromptFocal = promptFocal;
        return (T)this;
    }

    @NonNull
    public PromptFocal getPromptFocal() {
        return this.mPromptFocal;
    }

    @NonNull
    public T setPromptText(@NonNull PromptText promptText) {
        this.mPromptText = promptText;
        return (T)this;
    }

    @NonNull
    public PromptText getPromptText() {
        return this.mPromptText;
    }

    @Nullable
    public MaterialTapTargetPrompt create() {
        if (!this.mTargetSet || this.mPrimaryText == null && this.mSecondaryText == null) {
            return null;
        }
        MaterialTapTargetPrompt mPrompt = MaterialTapTargetPrompt.createDefault(this);
        if (this.mAnimationInterpolator == null) {
            this.mAnimationInterpolator = new AccelerateDecelerateInterpolator();
        }
        if (this.mIconDrawable != null) {
            this.mIconDrawable.mutate();
            this.mIconDrawable.setBounds(0, 0, this.mIconDrawable.getIntrinsicWidth(), this.mIconDrawable.getIntrinsicHeight());
            if (this.mHasIconDrawableTint) {
                if (this.mIconDrawableTintList != null) {
                    if (Build.VERSION.SDK_INT >= 21) {
                        this.mIconDrawable.setTintList(this.mIconDrawableTintList);
                    }
                } else {
                    this.mIconDrawable.setColorFilter(this.mIconDrawableColourFilter, this.mIconDrawableTintMode);
                    this.mIconDrawable.setAlpha(Color.alpha((int)this.mIconDrawableColourFilter));
                }
            }
        }
        this.mPromptBackground.setColour(this.getBackgroundColour());
        this.mPromptFocal.setColour(this.getFocalColour());
        this.mPromptFocal.setRippleAlpha(150);
        this.mPromptFocal.setDrawRipple(this.getIdleAnimationEnabled());
        if (this.mPromptFocal instanceof CirclePromptFocal) {
            ((CirclePromptFocal)this.mPromptFocal).setRadius(this.getFocalRadius());
        }
        return mPrompt;
    }

    @Nullable
    public MaterialTapTargetPrompt show() {
        MaterialTapTargetPrompt mPrompt = this.create();
        if (mPrompt != null) {
            mPrompt.show();
        }
        return mPrompt;
    }

    @Nullable
    public MaterialTapTargetPrompt showFor(long milliseconds) {
        MaterialTapTargetPrompt mPrompt = this.create();
        if (mPrompt != null) {
            mPrompt.showFor(milliseconds);
        }
        return mPrompt;
    }
}

