/*
 * Decompiled with CFR 0.152.
 */
package uk.co.samuelwall.materialtaptargetprompt.extras;

import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.RectF;
import android.support.annotation.ColorInt;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.view.View;
import uk.co.samuelwall.materialtaptargetprompt.extras.PromptOptions;
import uk.co.samuelwall.materialtaptargetprompt.extras.PromptUIElement;

public abstract class PromptFocal
implements PromptUIElement {
    protected boolean mDrawRipple;
    protected int mBaseRippleAlpha;

    public void setDrawRipple(boolean drawRipple) {
        this.mDrawRipple = drawRipple;
    }

    public void setRippleAlpha(@IntRange(from=0L, to=255L) int rippleAlpha) {
        this.mBaseRippleAlpha = rippleAlpha;
    }

    public Path getPath() {
        return null;
    }

    @NonNull
    public PointF calculateAngleEdgePoint(float angle, float padding) {
        RectF bounds = this.getBounds();
        float angleRadians = (float)Math.toRadians(angle);
        float sin = (float)Math.sin(angleRadians);
        float cos = (float)Math.cos(angleRadians);
        float dx1 = (bounds.width() + padding) / (float)(cos > 0.0f ? 2 : -2);
        float dy1 = (bounds.height() + padding) / (float)(sin > 0.0f ? 2 : -2);
        return new PointF(bounds.centerX() + dx1, bounds.centerY() + dy1);
    }

    public abstract void setColour(@ColorInt int var1);

    @NonNull
    public abstract RectF getBounds();

    public abstract void prepare(@NonNull PromptOptions var1, @NonNull View var2, int[] var3);

    public abstract void prepare(@NonNull PromptOptions var1, float var2, float var3);

    public abstract void updateRipple(@FloatRange(from=0.0, to=2.0) float var1, @FloatRange(from=0.0, to=1.0) float var2);
}

