/*
 * Decompiled with CFR 0.152.
 */
package uk.co.samuelwall.materialtaptargetprompt;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import uk.co.samuelwall.materialtaptargetprompt.MaterialTapTargetPrompt;
import uk.co.samuelwall.materialtaptargetprompt.extras.PromptOptions;
import uk.co.samuelwall.materialtaptargetprompt.extras.sequence.SequenceItem;
import uk.co.samuelwall.materialtaptargetprompt.extras.sequence.SequenceItemShowFor;
import uk.co.samuelwall.materialtaptargetprompt.extras.sequence.SequenceState;
import uk.co.samuelwall.materialtaptargetprompt.extras.sequence.SequenceStatePromptOptions;

public class MaterialTapTargetSequence {
    @NonNull
    private final List<SequenceItem> items = new ArrayList<SequenceItem>();
    int nextPromptIndex = -1;
    @NonNull
    SequenceCompleteListener itemListener = new SequenceCompleteListener(){

        @Override
        public void onSequenceComplete() {
            SequenceItem currentItem = (SequenceItem)MaterialTapTargetSequence.this.items.get(MaterialTapTargetSequence.this.nextPromptIndex);
            currentItem.setSequenceListener(null);
            MaterialTapTargetPrompt prompt = currentItem.getState().getPrompt();
            if (prompt != null) {
                prompt.mView.mPromptOptions.setSequenceListener(null);
            }
            ++MaterialTapTargetSequence.this.nextPromptIndex;
            if (MaterialTapTargetSequence.this.items.size() > MaterialTapTargetSequence.this.nextPromptIndex) {
                MaterialTapTargetSequence.this.show(MaterialTapTargetSequence.this.nextPromptIndex);
            } else if (MaterialTapTargetSequence.this.mOnCompleteListener != null) {
                MaterialTapTargetSequence.this.mOnCompleteListener.onSequenceComplete();
                MaterialTapTargetSequence.this.nextPromptIndex = -1;
            }
        }
    };
    @Nullable
    private SequenceCompleteListener mOnCompleteListener;

    @NonNull
    public MaterialTapTargetSequence setSequenceCompleteListener(@Nullable SequenceCompleteListener listener) {
        this.mOnCompleteListener = listener;
        return this;
    }

    @NonNull
    public MaterialTapTargetSequence addPrompt(@Nullable MaterialTapTargetPrompt prompt) {
        this.addItem(new SequenceItem(new SequenceState(prompt)));
        return this;
    }

    @NonNull
    public MaterialTapTargetSequence addPrompt(@Nullable MaterialTapTargetPrompt prompt, long milliseconds) {
        this.addItem(new SequenceItemShowFor(new SequenceState(prompt), milliseconds));
        return this;
    }

    @NonNull
    public MaterialTapTargetSequence addPrompt(@NonNull PromptOptions promptOptions) {
        this.addItem(new SequenceItem(new SequenceStatePromptOptions(promptOptions)));
        return this;
    }

    @NonNull
    public MaterialTapTargetSequence addPrompt(@NonNull PromptOptions promptOptions, long milliseconds) {
        this.addItem(new SequenceItemShowFor(new SequenceStatePromptOptions(promptOptions), milliseconds));
        return this;
    }

    @NonNull
    public MaterialTapTargetSequence addPrompt(@NonNull SequenceItem item) {
        this.items.add(item);
        return this;
    }

    private void addItem(@NonNull SequenceItem sequenceItem) {
        sequenceItem.addStateChanger(4);
        sequenceItem.addStateChanger(6);
        this.items.add(sequenceItem);
    }

    public int size() {
        return this.items.size();
    }

    @NonNull
    public SequenceItem get(int index) {
        return this.items.get(index);
    }

    @NonNull
    public MaterialTapTargetSequence show() {
        this.nextPromptIndex = 0;
        if (!this.items.isEmpty()) {
            this.show(0);
        } else if (this.mOnCompleteListener != null) {
            this.mOnCompleteListener.onSequenceComplete();
        }
        return this;
    }

    private void show(int index) {
        SequenceItem sequenceItem = this.items.get(index);
        sequenceItem.setSequenceListener(this.itemListener);
        MaterialTapTargetPrompt prompt = sequenceItem.getState().getPrompt();
        if (prompt != null) {
            prompt.mView.mPromptOptions.setSequenceListener(sequenceItem);
        }
        sequenceItem.show();
    }

    @NonNull
    public MaterialTapTargetSequence finish() {
        if (this.nextPromptIndex > -1 && this.nextPromptIndex < this.items.size()) {
            SequenceItem sequenceItem = this.items.get(this.nextPromptIndex);
            sequenceItem.setSequenceListener(null);
            MaterialTapTargetPrompt prompt = sequenceItem.getState().getPrompt();
            if (prompt != null) {
                prompt.mView.mPromptOptions.setSequenceListener(null);
            }
            sequenceItem.finish();
        }
        return this;
    }

    @NonNull
    public MaterialTapTargetSequence dismiss() {
        if (this.nextPromptIndex > -1 && this.nextPromptIndex < this.items.size()) {
            SequenceItem sequenceItem = this.items.get(this.nextPromptIndex);
            sequenceItem.setSequenceListener(null);
            MaterialTapTargetPrompt prompt = sequenceItem.getState().getPrompt();
            if (prompt != null) {
                prompt.mView.mPromptOptions.setSequenceListener(null);
            }
            sequenceItem.dismiss();
        }
        return this;
    }

    @NonNull
    public MaterialTapTargetSequence showFromIndex(int index) {
        this.dismiss();
        this.nextPromptIndex = index;
        this.show(index);
        return this;
    }

    public static interface SequenceCompleteListener {
        public void onSequenceComplete();
    }
}

