/*
 * Decompiled with CFR 0.152.
 */
package uk.co.samuelwall.materialtaptargetprompt;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.app.Activity;
import android.app.Dialog;
import android.app.Fragment;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.DialogFragment;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.AccessibilityNodeInfo;
import uk.co.samuelwall.materialtaptargetprompt.ActivityResourceFinder;
import uk.co.samuelwall.materialtaptargetprompt.DialogResourceFinder;
import uk.co.samuelwall.materialtaptargetprompt.R;
import uk.co.samuelwall.materialtaptargetprompt.ResourceFinder;
import uk.co.samuelwall.materialtaptargetprompt.SupportFragmentResourceFinder;
import uk.co.samuelwall.materialtaptargetprompt.extras.PromptOptions;

public class MaterialTapTargetPrompt {
    public static final int STATE_NOT_SHOWN = 0;
    public static final int STATE_REVEALING = 1;
    public static final int STATE_REVEALED = 2;
    public static final int STATE_FOCAL_PRESSED = 3;
    public static final int STATE_FINISHED = 4;
    public static final int STATE_DISMISSING = 5;
    public static final int STATE_DISMISSED = 6;
    public static final int STATE_FINISHING = 7;
    public static final int STATE_NON_FOCAL_PRESSED = 8;
    public static final int STATE_SHOW_FOR_TIMEOUT = 9;
    public static final int STATE_BACK_BUTTON_PRESSED = 10;
    PromptView mView;
    @Nullable
    ValueAnimator mAnimationCurrent;
    @Nullable
    ValueAnimator mAnimationFocalBreathing;
    @Nullable
    ValueAnimator mAnimationFocalRipple;
    float mFocalRippleProgress;
    int mState;
    final float mStatusBarHeight;
    final Runnable mTimeoutRunnable = new Runnable(){

        @Override
        public void run() {
            MaterialTapTargetPrompt.this.onPromptStateChanged(9);
            MaterialTapTargetPrompt.this.dismiss();
        }
    };
    @Nullable
    final ViewTreeObserver.OnGlobalLayoutListener mGlobalLayoutListener;

    MaterialTapTargetPrompt(PromptOptions promptOptions) {
        ResourceFinder resourceFinder = promptOptions.getResourceFinder();
        this.mView = new PromptView(resourceFinder.getContext());
        this.mView.mPrompt = this;
        this.mView.mPromptOptions = promptOptions;
        this.mView.mPromptTouchedListener = new PromptView.PromptTouchedListener(){

            @Override
            public void onFocalPressed() {
                if (!MaterialTapTargetPrompt.this.isDismissing()) {
                    MaterialTapTargetPrompt.this.onPromptStateChanged(3);
                    if (MaterialTapTargetPrompt.this.mView.mPromptOptions.getAutoFinish()) {
                        MaterialTapTargetPrompt.this.finish();
                    }
                }
            }

            @Override
            public void onNonFocalPressed() {
                if (!MaterialTapTargetPrompt.this.isDismissing()) {
                    MaterialTapTargetPrompt.this.onPromptStateChanged(8);
                    if (MaterialTapTargetPrompt.this.mView.mPromptOptions.getAutoDismiss()) {
                        MaterialTapTargetPrompt.this.dismiss();
                    }
                }
            }

            @Override
            public void onBackButtonPressed() {
                if (!MaterialTapTargetPrompt.this.isDismissing()) {
                    MaterialTapTargetPrompt.this.onPromptStateChanged(10);
                    MaterialTapTargetPrompt.this.onPromptStateChanged(8);
                    if (MaterialTapTargetPrompt.this.mView.mPromptOptions.getAutoDismiss()) {
                        MaterialTapTargetPrompt.this.dismiss();
                    }
                }
            }
        };
        Rect rect = new Rect();
        resourceFinder.getPromptParentView().getWindowVisibleDisplayFrame(rect);
        this.mStatusBarHeight = rect.top;
        this.mGlobalLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                View targetView = MaterialTapTargetPrompt.this.mView.mPromptOptions.getTargetView();
                if (targetView != null) {
                    boolean isTargetAttachedToWindow;
                    if (Build.VERSION.SDK_INT >= 19) {
                        isTargetAttachedToWindow = targetView.isAttachedToWindow();
                    } else {
                        boolean bl = isTargetAttachedToWindow = targetView.getWindowToken() != null;
                    }
                    if (!isTargetAttachedToWindow) {
                        return;
                    }
                }
                MaterialTapTargetPrompt.this.prepare();
                if (MaterialTapTargetPrompt.this.mAnimationCurrent == null) {
                    MaterialTapTargetPrompt.this.updateAnimation(1.0f, 1.0f);
                }
            }
        };
    }

    public void show() {
        if (this.isStarting()) {
            return;
        }
        ViewGroup parent = this.mView.mPromptOptions.getResourceFinder().getPromptParentView();
        if (this.isDismissing() || parent.findViewById(R.id.material_target_prompt_view) != null) {
            this.cleanUpPrompt(this.mState);
        }
        parent.addView((View)this.mView);
        this.addGlobalLayoutListener();
        this.onPromptStateChanged(1);
        this.prepare();
        this.startRevealAnimation();
    }

    public void showFor(long millis) {
        this.mView.postDelayed(this.mTimeoutRunnable, millis);
        this.show();
    }

    public void cancelShowForTimer() {
        this.mView.removeCallbacks(this.mTimeoutRunnable);
    }

    public int getState() {
        return this.mState;
    }

    boolean isStarting() {
        return this.mState == 1 || this.mState == 2;
    }

    boolean isDismissing() {
        return this.mState == 5 || this.mState == 7;
    }

    boolean isDismissed() {
        return this.mState == 6 || this.mState == 4;
    }

    boolean isComplete() {
        return this.mState == 0 || this.isDismissing() || this.isDismissed();
    }

    void addGlobalLayoutListener() {
        ViewTreeObserver viewTreeObserver = ((ViewGroup)this.mView.getParent()).getViewTreeObserver();
        if (viewTreeObserver.isAlive()) {
            viewTreeObserver.addOnGlobalLayoutListener(this.mGlobalLayoutListener);
        }
    }

    void removeGlobalLayoutListener() {
        ViewGroup parent = (ViewGroup)this.mView.getParent();
        if (parent == null) {
            return;
        }
        ViewTreeObserver viewTreeObserver = ((ViewGroup)this.mView.getParent()).getViewTreeObserver();
        if (viewTreeObserver.isAlive()) {
            if (Build.VERSION.SDK_INT >= 16) {
                viewTreeObserver.removeOnGlobalLayoutListener(this.mGlobalLayoutListener);
            } else {
                viewTreeObserver.removeGlobalOnLayoutListener(this.mGlobalLayoutListener);
            }
        }
    }

    public void finish() {
        if (this.isComplete()) {
            return;
        }
        this.cancelShowForTimer();
        this.cleanUpAnimation();
        this.mAnimationCurrent = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.0f});
        this.mAnimationCurrent.setDuration(225L);
        this.mAnimationCurrent.setInterpolator((TimeInterpolator)this.mView.mPromptOptions.getAnimationInterpolator());
        this.mAnimationCurrent.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(@NonNull ValueAnimator animation) {
                float value = ((Float)animation.getAnimatedValue()).floatValue();
                MaterialTapTargetPrompt.this.updateAnimation(1.0f + (1.0f - value) / 4.0f, value);
            }
        });
        this.mAnimationCurrent.addListener((Animator.AnimatorListener)new AnimatorListener(){

            @Override
            public void onAnimationEnd(Animator animation) {
                MaterialTapTargetPrompt.this.cleanUpPrompt(4);
                MaterialTapTargetPrompt.this.mView.sendAccessibilityEvent(32);
            }
        });
        this.onPromptStateChanged(7);
        this.mAnimationCurrent.start();
    }

    public void dismiss() {
        if (this.isComplete()) {
            return;
        }
        this.cancelShowForTimer();
        this.cleanUpAnimation();
        this.mAnimationCurrent = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.0f});
        this.mAnimationCurrent.setDuration(225L);
        this.mAnimationCurrent.setInterpolator((TimeInterpolator)this.mView.mPromptOptions.getAnimationInterpolator());
        this.mAnimationCurrent.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(@NonNull ValueAnimator animation) {
                float value = ((Float)animation.getAnimatedValue()).floatValue();
                MaterialTapTargetPrompt.this.updateAnimation(value, value);
            }
        });
        this.mAnimationCurrent.addListener((Animator.AnimatorListener)new AnimatorListener(){

            @Override
            public void onAnimationEnd(Animator animation) {
                MaterialTapTargetPrompt.this.cleanUpPrompt(6);
                MaterialTapTargetPrompt.this.mView.sendAccessibilityEvent(32);
            }
        });
        this.onPromptStateChanged(5);
        this.mAnimationCurrent.start();
    }

    void cleanUpPrompt(int state) {
        this.cleanUpAnimation();
        this.removeGlobalLayoutListener();
        ViewGroup parent = (ViewGroup)this.mView.getParent();
        if (parent != null) {
            parent.removeView((View)this.mView);
        }
        if (this.isDismissing()) {
            this.onPromptStateChanged(state);
        }
    }

    void cleanUpAnimation() {
        if (this.mAnimationCurrent != null) {
            this.mAnimationCurrent.removeAllUpdateListeners();
            this.mAnimationCurrent.removeAllListeners();
            this.mAnimationCurrent.cancel();
            this.mAnimationCurrent = null;
        }
        if (this.mAnimationFocalRipple != null) {
            this.mAnimationFocalRipple.removeAllUpdateListeners();
            this.mAnimationFocalRipple.cancel();
            this.mAnimationFocalRipple = null;
        }
        if (this.mAnimationFocalBreathing != null) {
            this.mAnimationFocalBreathing.removeAllUpdateListeners();
            this.mAnimationFocalBreathing.cancel();
            this.mAnimationFocalBreathing = null;
        }
    }

    void startRevealAnimation() {
        this.updateAnimation(0.0f, 0.0f);
        this.cleanUpAnimation();
        this.mAnimationCurrent = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        this.mAnimationCurrent.setInterpolator((TimeInterpolator)this.mView.mPromptOptions.getAnimationInterpolator());
        this.mAnimationCurrent.setDuration(225L);
        this.mAnimationCurrent.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(@NonNull ValueAnimator animation) {
                float value = ((Float)animation.getAnimatedValue()).floatValue();
                MaterialTapTargetPrompt.this.updateAnimation(value, value);
            }
        });
        this.mAnimationCurrent.addListener((Animator.AnimatorListener)new AnimatorListener(){

            @Override
            public void onAnimationEnd(@NonNull Animator animation) {
                animation.removeAllListeners();
                MaterialTapTargetPrompt.this.updateAnimation(1.0f, 1.0f);
                MaterialTapTargetPrompt.this.cleanUpAnimation();
                if (MaterialTapTargetPrompt.this.mView.mPromptOptions.getIdleAnimationEnabled()) {
                    MaterialTapTargetPrompt.this.startIdleAnimations();
                }
                MaterialTapTargetPrompt.this.onPromptStateChanged(2);
                MaterialTapTargetPrompt.this.mView.requestFocus();
                MaterialTapTargetPrompt.this.mView.sendAccessibilityEvent(8);
            }
        });
        this.mAnimationCurrent.start();
    }

    void startIdleAnimations() {
        this.cleanUpAnimation();
        this.mAnimationFocalBreathing = ValueAnimator.ofFloat((float[])new float[]{1.0f, 1.1f, 1.0f});
        this.mAnimationFocalBreathing.setInterpolator((TimeInterpolator)this.mView.mPromptOptions.getAnimationInterpolator());
        this.mAnimationFocalBreathing.setDuration(1000L);
        this.mAnimationFocalBreathing.setStartDelay(225L);
        this.mAnimationFocalBreathing.setRepeatCount(-1);
        this.mAnimationFocalBreathing.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){
            boolean direction = true;

            public void onAnimationUpdate(@NonNull ValueAnimator animation) {
                float newFocalFraction = ((Float)animation.getAnimatedValue()).floatValue();
                boolean newDirection = this.direction;
                if (newFocalFraction < MaterialTapTargetPrompt.this.mFocalRippleProgress && this.direction) {
                    newDirection = false;
                } else if (newFocalFraction > MaterialTapTargetPrompt.this.mFocalRippleProgress && !this.direction) {
                    newDirection = true;
                }
                if (newDirection != this.direction && !newDirection) {
                    MaterialTapTargetPrompt.this.mAnimationFocalRipple.start();
                }
                this.direction = newDirection;
                MaterialTapTargetPrompt.this.mFocalRippleProgress = newFocalFraction;
                MaterialTapTargetPrompt.this.mView.mPromptOptions.getPromptFocal().update(MaterialTapTargetPrompt.this.mView.mPromptOptions, newFocalFraction, 1.0f);
                MaterialTapTargetPrompt.this.mView.invalidate();
            }
        });
        this.mAnimationFocalBreathing.start();
        this.mAnimationFocalRipple = ValueAnimator.ofFloat((float[])new float[]{1.1f, 1.6f});
        this.mAnimationFocalRipple.setInterpolator((TimeInterpolator)this.mView.mPromptOptions.getAnimationInterpolator());
        this.mAnimationFocalRipple.setDuration(500L);
        this.mAnimationFocalRipple.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(@NonNull ValueAnimator animation) {
                float value = ((Float)animation.getAnimatedValue()).floatValue();
                MaterialTapTargetPrompt.this.mView.mPromptOptions.getPromptFocal().updateRipple(value, (1.6f - value) * 2.0f);
            }
        });
    }

    void updateAnimation(float revealModifier, float alphaModifier) {
        if (this.mView.getParent() == null) {
            return;
        }
        this.mView.mPromptOptions.getPromptText().update(this.mView.mPromptOptions, revealModifier, alphaModifier);
        if (this.mView.mIconDrawable != null) {
            this.mView.mIconDrawable.setAlpha((int)(255.0f * alphaModifier));
        }
        this.mView.mPromptOptions.getPromptFocal().update(this.mView.mPromptOptions, revealModifier, alphaModifier);
        this.mView.mPromptOptions.getPromptBackground().update(this.mView.mPromptOptions, revealModifier, alphaModifier);
        this.mView.invalidate();
    }

    void prepare() {
        View targetRenderView = this.mView.mPromptOptions.getTargetRenderView();
        this.mView.mTargetRenderView = targetRenderView == null ? this.mView.mPromptOptions.getTargetView() : targetRenderView;
        this.updateClipBounds();
        View targetView = this.mView.mPromptOptions.getTargetView();
        if (targetView != null) {
            int[] viewPosition = new int[2];
            this.mView.getLocationInWindow(viewPosition);
            this.mView.mPromptOptions.getPromptFocal().prepare(this.mView.mPromptOptions, targetView, viewPosition);
        } else {
            PointF targetPosition = this.mView.mPromptOptions.getTargetPosition();
            this.mView.mPromptOptions.getPromptFocal().prepare(this.mView.mPromptOptions, targetPosition.x, targetPosition.y);
        }
        this.mView.mPromptOptions.getPromptText().prepare(this.mView.mPromptOptions, this.mView.mClipToBounds, this.mView.mClipBounds);
        this.mView.mPromptOptions.getPromptBackground().prepare(this.mView.mPromptOptions, this.mView.mClipToBounds, this.mView.mClipBounds);
        this.updateIconPosition();
    }

    void updateIconPosition() {
        this.mView.mIconDrawable = this.mView.mPromptOptions.getIconDrawable();
        if (this.mView.mIconDrawable != null) {
            RectF mFocalBounds = this.mView.mPromptOptions.getPromptFocal().getBounds();
            this.mView.mIconDrawableLeft = mFocalBounds.centerX() - (float)(this.mView.mIconDrawable.getIntrinsicWidth() / 2);
            this.mView.mIconDrawableTop = mFocalBounds.centerY() - (float)(this.mView.mIconDrawable.getIntrinsicHeight() / 2);
        } else if (this.mView.mTargetRenderView != null) {
            int[] viewPosition = new int[2];
            this.mView.getLocationInWindow(viewPosition);
            int[] targetPosition = new int[2];
            this.mView.mTargetRenderView.getLocationInWindow(targetPosition);
            this.mView.mIconDrawableLeft = targetPosition[0] - viewPosition[0] - this.mView.mTargetRenderView.getScrollX();
            this.mView.mIconDrawableTop = targetPosition[1] - viewPosition[1] - this.mView.mTargetRenderView.getScrollY();
        }
    }

    void updateClipBounds() {
        View clipToView = this.mView.mPromptOptions.getClipToView();
        if (clipToView != null) {
            this.mView.mClipToBounds = true;
            this.mView.mClipBounds.set(0, 0, 0, 0);
            Point offset = new Point();
            clipToView.getGlobalVisibleRect(this.mView.mClipBounds, offset);
            if (offset.y == 0) {
                this.mView.mClipBounds.top = (int)((float)this.mView.mClipBounds.top + this.mStatusBarHeight);
            }
        } else {
            this.mView.mPromptOptions.getResourceFinder().getPromptParentView().getGlobalVisibleRect(this.mView.mClipBounds, new Point());
            this.mView.mClipToBounds = false;
        }
    }

    protected void onPromptStateChanged(int state) {
        this.mState = state;
        this.mView.mPromptOptions.onPromptStateChanged(this, state);
        this.mView.mPromptOptions.onExtraPromptStateChanged(this, state);
    }

    @NonNull
    public static MaterialTapTargetPrompt createDefault(@NonNull PromptOptions promptOptions) {
        return new MaterialTapTargetPrompt(promptOptions);
    }

    static class AnimatorListener
    implements Animator.AnimatorListener {
        AnimatorListener() {
        }

        public void onAnimationStart(Animator animation) {
        }

        public void onAnimationEnd(Animator animation) {
        }

        public void onAnimationCancel(Animator animation) {
        }

        public void onAnimationRepeat(Animator animation) {
        }
    }

    public static interface PromptStateChangeListener {
        public void onPromptStateChanged(@NonNull MaterialTapTargetPrompt var1, int var2);
    }

    public static class Builder
    extends PromptOptions<Builder> {
        @Deprecated
        public Builder(@NonNull Fragment fragment) {
            this(fragment.getActivity(), 0);
        }

        @Deprecated
        public Builder(@NonNull Fragment fragment, int themeResId) {
            this(fragment.getActivity(), themeResId);
        }

        @Deprecated
        public Builder(@NonNull android.app.DialogFragment dialogFragment) {
            this(dialogFragment, 0);
        }

        @Deprecated
        public Builder(@NonNull android.app.DialogFragment dialogFragment, int themeResId) {
            this(dialogFragment.getDialog(), themeResId);
        }

        public Builder(@NonNull android.support.v4.app.Fragment fragment) {
            this(fragment, 0);
        }

        public Builder(@NonNull android.support.v4.app.Fragment fragment, int themeResId) {
            this(new SupportFragmentResourceFinder(fragment), themeResId);
        }

        public Builder(@NonNull DialogFragment dialogFragment) {
            this(dialogFragment, 0);
        }

        public Builder(@NonNull DialogFragment dialogFragment, int themeResId) {
            this(new SupportFragmentResourceFinder((android.support.v4.app.Fragment)dialogFragment), themeResId);
        }

        public Builder(@NonNull Dialog dialog) {
            this(dialog, 0);
        }

        public Builder(@NonNull Dialog dialog, int themeResId) {
            this(new DialogResourceFinder(dialog), themeResId);
        }

        public Builder(@NonNull Activity activity) {
            this(activity, 0);
        }

        public Builder(@NonNull Activity activity, int themeResId) {
            this(new ActivityResourceFinder(activity), themeResId);
        }

        public Builder(@NonNull ResourceFinder resourceFinder, int themeResId) {
            super(resourceFinder);
            this.load(themeResId);
        }
    }

    static class PromptView
    extends View {
        Drawable mIconDrawable;
        float mIconDrawableLeft;
        float mIconDrawableTop;
        PromptTouchedListener mPromptTouchedListener;
        Rect mClipBounds = new Rect();
        View mTargetRenderView;
        MaterialTapTargetPrompt mPrompt;
        PromptOptions mPromptOptions;
        boolean mClipToBounds;
        AccessibilityManager mAccessibilityManager;

        public PromptView(Context context) {
            super(context);
            this.setId(R.id.material_target_prompt_view);
            this.setFocusableInTouchMode(true);
            this.requestFocus();
            if (Build.VERSION.SDK_INT < 18) {
                this.setLayerType(1, null);
            }
            this.setAccessibilityDelegate(new AccessibilityDelegate());
            this.mAccessibilityManager = (AccessibilityManager)context.getSystemService("accessibility");
            if (this.mAccessibilityManager.isEnabled()) {
                this.setupAccessibilityClickListener();
            }
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            View parent = (View)this.getParent();
            this.setMeasuredDimension(parent.getMeasuredWidth(), parent.getMeasuredHeight());
        }

        public void onDraw(Canvas canvas) {
            Path focalPath;
            if (this.mClipToBounds) {
                canvas.clipRect(this.mClipBounds);
            }
            if ((focalPath = this.mPromptOptions.getPromptFocal().getPath()) != null) {
                canvas.save();
                canvas.clipPath(focalPath, Region.Op.DIFFERENCE);
            }
            this.mPromptOptions.getPromptBackground().draw(canvas);
            if (focalPath != null) {
                canvas.restore();
            }
            this.mPromptOptions.getPromptFocal().draw(canvas);
            if (this.mIconDrawable != null) {
                canvas.translate(this.mIconDrawableLeft, this.mIconDrawableTop);
                this.mIconDrawable.draw(canvas);
                canvas.translate(-this.mIconDrawableLeft, -this.mIconDrawableTop);
            } else if (this.mTargetRenderView != null) {
                canvas.translate(this.mIconDrawableLeft, this.mIconDrawableTop);
                this.mTargetRenderView.draw(canvas);
                canvas.translate(-this.mIconDrawableLeft, -this.mIconDrawableTop);
            }
            this.mPromptOptions.getPromptText().draw(canvas);
        }

        public boolean onHoverEvent(MotionEvent event) {
            if (this.mAccessibilityManager.isTouchExplorationEnabled() && event.getPointerCount() == 1) {
                int action = event.getAction();
                switch (action) {
                    case 9: {
                        event.setAction(0);
                        break;
                    }
                    case 7: {
                        event.setAction(2);
                        break;
                    }
                    case 10: {
                        event.setAction(1);
                    }
                }
                return this.onTouchEvent(event);
            }
            return super.onHoverEvent(event);
        }

        public boolean onTouchEvent(MotionEvent event) {
            boolean captureEvent;
            float x = event.getX();
            float y = event.getY();
            boolean bl = captureEvent = (!this.mClipToBounds || this.mClipBounds.contains((int)x, (int)y)) && this.mPromptOptions.getPromptBackground().contains(x, y);
            if (captureEvent && this.mPromptOptions.getPromptFocal().contains(x, y)) {
                captureEvent = this.mPromptOptions.getCaptureTouchEventOnFocal();
                if (this.mPromptTouchedListener != null) {
                    this.mPromptTouchedListener.onFocalPressed();
                }
            } else {
                if (!captureEvent) {
                    captureEvent = this.mPromptOptions.getCaptureTouchEventOutsidePrompt();
                }
                if (this.mPromptTouchedListener != null) {
                    this.mPromptTouchedListener.onNonFocalPressed();
                }
            }
            return captureEvent;
        }

        public boolean dispatchKeyEventPreIme(KeyEvent event) {
            KeyEvent.DispatcherState state;
            if (this.mPromptOptions.getBackButtonDismissEnabled() && event.getKeyCode() == 4 && (state = this.getKeyDispatcherState()) != null) {
                if (event.getAction() == 0 && event.getRepeatCount() == 0) {
                    state.startTracking(event, (Object)this);
                    return true;
                }
                if (event.getAction() == 1 && !event.isCanceled() && state.isTracking(event)) {
                    if (this.mPromptTouchedListener != null) {
                        this.mPromptTouchedListener.onBackButtonPressed();
                    }
                    return this.mPromptOptions.getAutoDismiss() || super.dispatchKeyEventPreIme(event);
                }
            }
            return super.dispatchKeyEventPreIme(event);
        }

        protected void onDetachedFromWindow() {
            super.onDetachedFromWindow();
            this.mPrompt.cleanUpAnimation();
        }

        public CharSequence getAccessibilityClassName() {
            return PromptView.class.getName();
        }

        private void setupAccessibilityClickListener() {
            this.setClickable(true);
            this.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    View targetView;
                    if (Build.VERSION.SDK_INT >= 15 && (targetView = PromptView.this.mPromptOptions.getTargetView()) != null) {
                        targetView.callOnClick();
                    }
                    PromptView.this.mPrompt.finish();
                }
            });
        }

        class AccessibilityDelegate
        extends View.AccessibilityDelegate {
            AccessibilityDelegate() {
            }

            public void onInitializeAccessibilityNodeInfo(View host, AccessibilityNodeInfo info) {
                super.onInitializeAccessibilityNodeInfo(host, info);
                Package viewPackage = ((Object)((Object)PromptView.this)).getClass().getPackage();
                if (viewPackage != null) {
                    info.setPackageName((CharSequence)viewPackage.getName());
                }
                info.setSource(host);
                info.setClickable(true);
                info.setEnabled(true);
                info.setChecked(false);
                info.setFocusable(true);
                info.setFocused(true);
                if (Build.VERSION.SDK_INT >= 17) {
                    info.setLabelFor(PromptView.this.mPromptOptions.getTargetView());
                }
                if (Build.VERSION.SDK_INT >= 19) {
                    info.setDismissable(true);
                }
                info.setContentDescription((CharSequence)PromptView.this.mPromptOptions.getContentDescription());
                info.setText((CharSequence)PromptView.this.mPromptOptions.getContentDescription());
            }

            public void onPopulateAccessibilityEvent(View host, AccessibilityEvent event) {
                super.onPopulateAccessibilityEvent(host, event);
                String contentDescription = PromptView.this.mPromptOptions.getContentDescription();
                if (!TextUtils.isEmpty((CharSequence)contentDescription)) {
                    event.getText().add(contentDescription);
                }
            }
        }

        public static interface PromptTouchedListener {
            public void onFocalPressed();

            public void onNonFocalPressed();

            public void onBackButtonPressed();
        }
    }
}

