/*
 * Decompiled with CFR 0.152.
 */
package uk.co.samuelwall.materialtaptargetprompt;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DimenRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.IdRes;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.util.TypedValue;
import android.view.Gravity;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Interpolator;
import java.text.Bidi;
import uk.co.samuelwall.materialtaptargetprompt.R;

public class MaterialTapTargetPrompt {
    Activity mActivity;
    PromptView mView;
    View mTargetView;
    PointF mTargetPosition;
    float mBaseFocalRadius;
    float mBaseBackgroundRadius;
    PointF mBaseBackgroundPosition = new PointF();
    float mFocalRadius10Percent;
    float mRevealedAmount;
    String mPrimaryText;
    String mSecondaryText;
    float mMaxTextWidth;
    float mTextPadding;
    boolean mVerticalTextPositionAbove;
    boolean mHorizontalTextPositionLeft;
    boolean mInside88dpBounds;
    float mFocalToTextPadding;
    int mPrimaryTextColourAlpha;
    int mSecondaryTextColourAlpha;
    ValueAnimator mAnimationCurrent;
    ValueAnimator mAnimationFocalRipple;
    Interpolator mAnimationInterpolator;
    float mFocalRippleProgress;
    int mBaseFocalRippleAlpha;
    TextPaint mPaintPrimaryText;
    TextPaint mPaintSecondaryText;
    OnHidePromptListener mOnHidePromptListener;
    boolean mDismissing;
    ViewGroup mParentView;
    View mClipToView;
    final float mStatusBarHeight;
    final ViewTreeObserver.OnGlobalLayoutListener mGlobalLayoutListener;
    boolean mAutoDismiss;
    boolean mAutoFinish;
    boolean mIdleAnimationEnabled = true;
    Layout.Alignment mPrimaryTextAlignment;
    Layout.Alignment mSecondaryTextAlignment;
    RectF mClipViewBoundsInset88dp;
    float m88dp;
    int mBaseBackgroundColourAlpha;
    int mBaseFocalColourAlpha;

    MaterialTapTargetPrompt(Activity activity) {
        this.mActivity = activity;
        this.mView = new PromptView((Context)activity);
        this.mView.mOnPromptTouchedListener = new PromptView.OnPromptTouchedListener(){

            @Override
            public void onPromptTouched(MotionEvent event, boolean tappedTarget) {
                if (!MaterialTapTargetPrompt.this.mDismissing) {
                    MaterialTapTargetPrompt.this.onHidePrompt(event, tappedTarget);
                    if (tappedTarget) {
                        if (MaterialTapTargetPrompt.this.mAutoFinish) {
                            MaterialTapTargetPrompt.this.finish();
                        }
                    } else if (MaterialTapTargetPrompt.this.mAutoDismiss) {
                        MaterialTapTargetPrompt.this.dismiss();
                    }
                }
            }
        };
        Rect rect = new Rect();
        this.mActivity.getWindow().getDecorView().getWindowVisibleDisplayFrame(rect);
        this.mStatusBarHeight = rect.top;
        this.mGlobalLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                MaterialTapTargetPrompt.this.updateFocalCentrePosition();
            }
        };
    }

    public void show() {
        this.mParentView.addView((View)this.mView);
        this.addGlobalLayoutListener();
        if (Build.VERSION.SDK_INT >= 11) {
            this.startRevealAnimation();
        } else {
            this.mRevealedAmount = 1.0f;
            this.mView.mBackgroundRadius = this.mBaseBackgroundRadius;
            this.mView.mFocalRadius = this.mBaseFocalRadius;
            this.mView.mPaintFocal.setAlpha(this.mBaseFocalColourAlpha);
            this.mView.mPaintBackground.setAlpha(this.mBaseBackgroundColourAlpha);
            this.mPaintSecondaryText.setAlpha(this.mSecondaryTextColourAlpha);
            this.mPaintPrimaryText.setAlpha(this.mPrimaryTextColourAlpha);
        }
    }

    void addGlobalLayoutListener() {
        ViewTreeObserver viewTreeObserver = this.mParentView.getViewTreeObserver();
        if (viewTreeObserver.isAlive()) {
            viewTreeObserver.addOnGlobalLayoutListener(this.mGlobalLayoutListener);
        }
    }

    void removeGlobalLayoutListener() {
        ViewTreeObserver viewTreeObserver = this.mParentView.getViewTreeObserver();
        if (viewTreeObserver.isAlive()) {
            if (Build.VERSION.SDK_INT >= 16) {
                viewTreeObserver.removeOnGlobalLayoutListener(this.mGlobalLayoutListener);
            } else {
                viewTreeObserver.removeGlobalOnLayoutListener(this.mGlobalLayoutListener);
            }
        }
    }

    public void finish() {
        if (Build.VERSION.SDK_INT >= 11) {
            if (this.mDismissing) {
                return;
            }
            this.mDismissing = true;
            if (this.mAnimationCurrent != null) {
                this.mAnimationCurrent.removeAllListeners();
                this.mAnimationCurrent.cancel();
                this.mAnimationCurrent = null;
            }
            this.mAnimationCurrent = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.0f});
            this.mAnimationCurrent.setDuration(225L);
            this.mAnimationCurrent.setInterpolator((TimeInterpolator)this.mAnimationInterpolator);
            this.mAnimationCurrent.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                @TargetApi(value=11)
                public void onAnimationUpdate(ValueAnimator animation) {
                    float value = ((Float)animation.getAnimatedValue()).floatValue();
                    MaterialTapTargetPrompt.this.mRevealedAmount = 1.0f + (1.0f - value) / 4.0f;
                    MaterialTapTargetPrompt.this.mView.mBackgroundRadius = MaterialTapTargetPrompt.this.mBaseBackgroundRadius * MaterialTapTargetPrompt.this.mRevealedAmount;
                    MaterialTapTargetPrompt.this.mView.mFocalRadius = MaterialTapTargetPrompt.this.mBaseFocalRadius * MaterialTapTargetPrompt.this.mRevealedAmount;
                    MaterialTapTargetPrompt.this.mView.mPaintFocal.setAlpha((int)((float)MaterialTapTargetPrompt.this.mBaseFocalColourAlpha * value));
                    MaterialTapTargetPrompt.this.mView.mPaintBackground.setAlpha((int)((float)MaterialTapTargetPrompt.this.mBaseBackgroundColourAlpha * value));
                    MaterialTapTargetPrompt.this.mPaintSecondaryText.setAlpha((int)((float)MaterialTapTargetPrompt.this.mSecondaryTextColourAlpha * value));
                    MaterialTapTargetPrompt.this.mPaintPrimaryText.setAlpha((int)((float)MaterialTapTargetPrompt.this.mPrimaryTextColourAlpha * value));
                    if (MaterialTapTargetPrompt.this.mView.mIconDrawable != null) {
                        MaterialTapTargetPrompt.this.mView.mIconDrawable.setAlpha(MaterialTapTargetPrompt.this.mView.mPaintBackground.getAlpha());
                    }
                    MaterialTapTargetPrompt.this.mView.invalidate();
                }
            });
            this.mAnimationCurrent.addListener((Animator.AnimatorListener)new AnimatorListener(){

                @Override
                @TargetApi(value=11)
                public void onAnimationEnd(Animator animation) {
                    MaterialTapTargetPrompt.this.mAnimationCurrent.removeAllListeners();
                    MaterialTapTargetPrompt.this.mAnimationCurrent = null;
                    MaterialTapTargetPrompt.this.cleanUpPrompt();
                    MaterialTapTargetPrompt.this.mDismissing = false;
                }

                @Override
                @TargetApi(value=11)
                public void onAnimationCancel(Animator animation) {
                    MaterialTapTargetPrompt.this.mAnimationCurrent.removeAllListeners();
                    MaterialTapTargetPrompt.this.mAnimationCurrent = null;
                    MaterialTapTargetPrompt.this.cleanUpPrompt();
                    MaterialTapTargetPrompt.this.mDismissing = false;
                }
            });
            this.mAnimationCurrent.start();
        } else {
            this.cleanUpPrompt();
        }
    }

    public void dismiss() {
        if (Build.VERSION.SDK_INT >= 11) {
            if (this.mDismissing) {
                return;
            }
            this.mDismissing = true;
            if (this.mAnimationCurrent != null) {
                this.mAnimationCurrent.removeAllListeners();
                this.mAnimationCurrent.cancel();
                this.mAnimationCurrent = null;
            }
            this.mAnimationCurrent = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.0f});
            this.mAnimationCurrent.setDuration(225L);
            this.mAnimationCurrent.setInterpolator((TimeInterpolator)this.mAnimationInterpolator);
            this.mAnimationCurrent.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                @TargetApi(value=11)
                public void onAnimationUpdate(ValueAnimator animation) {
                    MaterialTapTargetPrompt.this.mRevealedAmount = ((Float)animation.getAnimatedValue()).floatValue();
                    MaterialTapTargetPrompt.this.mView.mBackgroundRadius = MaterialTapTargetPrompt.this.mBaseBackgroundRadius * MaterialTapTargetPrompt.this.mRevealedAmount;
                    MaterialTapTargetPrompt.this.mView.mFocalRadius = MaterialTapTargetPrompt.this.mBaseFocalRadius * MaterialTapTargetPrompt.this.mRevealedAmount;
                    MaterialTapTargetPrompt.this.mView.mPaintBackground.setAlpha((int)((float)MaterialTapTargetPrompt.this.mBaseBackgroundColourAlpha * MaterialTapTargetPrompt.this.mRevealedAmount));
                    MaterialTapTargetPrompt.this.mView.mPaintFocal.setAlpha((int)((float)MaterialTapTargetPrompt.this.mBaseFocalColourAlpha * MaterialTapTargetPrompt.this.mRevealedAmount));
                    MaterialTapTargetPrompt.this.mPaintSecondaryText.setAlpha((int)((float)MaterialTapTargetPrompt.this.mSecondaryTextColourAlpha * MaterialTapTargetPrompt.this.mRevealedAmount));
                    MaterialTapTargetPrompt.this.mPaintPrimaryText.setAlpha((int)((float)MaterialTapTargetPrompt.this.mPrimaryTextColourAlpha * MaterialTapTargetPrompt.this.mRevealedAmount));
                    if (MaterialTapTargetPrompt.this.mView.mIconDrawable != null) {
                        MaterialTapTargetPrompt.this.mView.mIconDrawable.setAlpha(MaterialTapTargetPrompt.this.mView.mPaintBackground.getAlpha());
                    }
                    MaterialTapTargetPrompt.this.mView.mBackgroundPosition.set(MaterialTapTargetPrompt.this.mView.mFocalCentre.x + (MaterialTapTargetPrompt.this.mBaseBackgroundPosition.x - MaterialTapTargetPrompt.this.mView.mFocalCentre.x) * MaterialTapTargetPrompt.this.mRevealedAmount, MaterialTapTargetPrompt.this.mView.mFocalCentre.y + (MaterialTapTargetPrompt.this.mBaseBackgroundPosition.y - MaterialTapTargetPrompt.this.mView.mFocalCentre.y) * MaterialTapTargetPrompt.this.mRevealedAmount);
                    MaterialTapTargetPrompt.this.mView.invalidate();
                }
            });
            this.mAnimationCurrent.addListener((Animator.AnimatorListener)new AnimatorListener(){

                @Override
                @TargetApi(value=11)
                public void onAnimationEnd(Animator animation) {
                    MaterialTapTargetPrompt.this.mAnimationCurrent.removeAllListeners();
                    MaterialTapTargetPrompt.this.mAnimationCurrent = null;
                    MaterialTapTargetPrompt.this.cleanUpPrompt();
                    MaterialTapTargetPrompt.this.mDismissing = false;
                }

                @Override
                @TargetApi(value=11)
                public void onAnimationCancel(Animator animation) {
                    MaterialTapTargetPrompt.this.mAnimationCurrent.removeAllListeners();
                    MaterialTapTargetPrompt.this.mAnimationCurrent = null;
                    MaterialTapTargetPrompt.this.cleanUpPrompt();
                    MaterialTapTargetPrompt.this.mDismissing = false;
                }
            });
            this.mAnimationCurrent.start();
        } else {
            this.cleanUpPrompt();
        }
    }

    void cleanUpPrompt() {
        this.removeGlobalLayoutListener();
        this.mParentView.removeView((View)this.mView);
        if (this.mDismissing) {
            this.onHidePromptComplete();
        }
    }

    @TargetApi(value=11)
    void startRevealAnimation() {
        this.mPaintSecondaryText.setAlpha(0);
        this.mPaintPrimaryText.setAlpha(0);
        this.mView.mPaintBackground.setAlpha(0);
        this.mView.mPaintFocal.setAlpha(0);
        this.mView.mFocalRadius = 0.0f;
        this.mView.mBackgroundRadius = 0.0f;
        this.mView.mBackgroundPosition.set(this.mView.mFocalCentre);
        if (this.mView.mIconDrawable != null) {
            this.mView.mIconDrawable.setAlpha(0);
        }
        this.mRevealedAmount = 0.0f;
        this.mAnimationCurrent = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        this.mAnimationCurrent.setInterpolator((TimeInterpolator)this.mAnimationInterpolator);
        this.mAnimationCurrent.setDuration(225L);
        this.mAnimationCurrent.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            @TargetApi(value=11)
            public void onAnimationUpdate(ValueAnimator animation) {
                MaterialTapTargetPrompt.this.mRevealedAmount = ((Float)animation.getAnimatedValue()).floatValue();
                MaterialTapTargetPrompt.this.mView.mBackgroundRadius = MaterialTapTargetPrompt.this.mBaseBackgroundRadius * MaterialTapTargetPrompt.this.mRevealedAmount;
                MaterialTapTargetPrompt.this.mView.mFocalRadius = MaterialTapTargetPrompt.this.mBaseFocalRadius * MaterialTapTargetPrompt.this.mRevealedAmount;
                MaterialTapTargetPrompt.this.mView.mPaintFocal.setAlpha((int)((float)MaterialTapTargetPrompt.this.mBaseFocalColourAlpha * MaterialTapTargetPrompt.this.mRevealedAmount));
                MaterialTapTargetPrompt.this.mView.mPaintBackground.setAlpha((int)((float)MaterialTapTargetPrompt.this.mBaseBackgroundColourAlpha * MaterialTapTargetPrompt.this.mRevealedAmount));
                MaterialTapTargetPrompt.this.mPaintSecondaryText.setAlpha((int)((float)MaterialTapTargetPrompt.this.mSecondaryTextColourAlpha * MaterialTapTargetPrompt.this.mRevealedAmount));
                MaterialTapTargetPrompt.this.mPaintPrimaryText.setAlpha((int)((float)MaterialTapTargetPrompt.this.mPrimaryTextColourAlpha * MaterialTapTargetPrompt.this.mRevealedAmount));
                if (MaterialTapTargetPrompt.this.mView.mIconDrawable != null) {
                    MaterialTapTargetPrompt.this.mView.mIconDrawable.setAlpha(MaterialTapTargetPrompt.this.mView.mPaintBackground.getAlpha());
                }
                MaterialTapTargetPrompt.this.mView.mBackgroundPosition.set(MaterialTapTargetPrompt.this.mView.mFocalCentre.x + (MaterialTapTargetPrompt.this.mBaseBackgroundPosition.x - MaterialTapTargetPrompt.this.mView.mFocalCentre.x) * MaterialTapTargetPrompt.this.mRevealedAmount, MaterialTapTargetPrompt.this.mView.mFocalCentre.y + (MaterialTapTargetPrompt.this.mBaseBackgroundPosition.y - MaterialTapTargetPrompt.this.mView.mFocalCentre.y) * MaterialTapTargetPrompt.this.mRevealedAmount);
                MaterialTapTargetPrompt.this.mView.invalidate();
            }
        });
        this.mAnimationCurrent.addListener((Animator.AnimatorListener)new AnimatorListener(){

            @Override
            @TargetApi(value=11)
            public void onAnimationEnd(Animator animation) {
                animation.removeAllListeners();
                MaterialTapTargetPrompt.this.mAnimationCurrent = null;
                MaterialTapTargetPrompt.this.mRevealedAmount = 1.0f;
                MaterialTapTargetPrompt.this.mView.mBackgroundPosition.set(MaterialTapTargetPrompt.this.mBaseBackgroundPosition);
                if (MaterialTapTargetPrompt.this.mIdleAnimationEnabled) {
                    MaterialTapTargetPrompt.this.startIdleAnimations();
                }
            }

            @Override
            @TargetApi(value=11)
            public void onAnimationCancel(Animator animation) {
                animation.removeAllListeners();
                MaterialTapTargetPrompt.this.mRevealedAmount = 1.0f;
                MaterialTapTargetPrompt.this.mView.mBackgroundPosition.set(MaterialTapTargetPrompt.this.mBaseBackgroundPosition);
                MaterialTapTargetPrompt.this.mAnimationCurrent = null;
            }
        });
        this.mAnimationCurrent.start();
    }

    @TargetApi(value=11)
    void startIdleAnimations() {
        if (this.mAnimationCurrent != null) {
            this.mAnimationCurrent.removeAllUpdateListeners();
            this.mAnimationCurrent.cancel();
            this.mAnimationCurrent = null;
        }
        this.mAnimationCurrent = ValueAnimator.ofFloat((float[])new float[]{0.0f, this.mFocalRadius10Percent, 0.0f});
        this.mAnimationCurrent.setInterpolator((TimeInterpolator)this.mAnimationInterpolator);
        this.mAnimationCurrent.setDuration(1000L);
        this.mAnimationCurrent.setStartDelay(225L);
        this.mAnimationCurrent.setRepeatCount(-1);
        this.mAnimationCurrent.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){
            boolean direction = true;

            @TargetApi(value=11)
            public void onAnimationUpdate(ValueAnimator animation) {
                float newFocalFraction = ((Float)animation.getAnimatedValue()).floatValue();
                boolean newDirection = this.direction;
                if (newFocalFraction < MaterialTapTargetPrompt.this.mFocalRippleProgress && this.direction) {
                    newDirection = false;
                } else if (newFocalFraction > MaterialTapTargetPrompt.this.mFocalRippleProgress && !this.direction) {
                    newDirection = true;
                }
                if (newDirection != this.direction && !newDirection) {
                    MaterialTapTargetPrompt.this.mAnimationFocalRipple.start();
                }
                this.direction = newDirection;
                MaterialTapTargetPrompt.this.mFocalRippleProgress = newFocalFraction;
                MaterialTapTargetPrompt.this.mView.mFocalRadius = MaterialTapTargetPrompt.this.mBaseFocalRadius + MaterialTapTargetPrompt.this.mFocalRippleProgress;
                MaterialTapTargetPrompt.this.mView.invalidate();
            }
        });
        this.mAnimationCurrent.start();
        if (this.mAnimationFocalRipple != null) {
            this.mAnimationFocalRipple.removeAllUpdateListeners();
            this.mAnimationFocalRipple.cancel();
            this.mAnimationFocalRipple = null;
        }
        float baseRadius = this.mBaseFocalRadius + this.mFocalRadius10Percent;
        this.mAnimationFocalRipple = ValueAnimator.ofFloat((float[])new float[]{baseRadius, baseRadius + this.mFocalRadius10Percent * 6.0f});
        this.mAnimationFocalRipple.setInterpolator((TimeInterpolator)this.mAnimationInterpolator);
        this.mAnimationFocalRipple.setDuration(500L);
        this.mAnimationFocalRipple.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            @TargetApi(value=11)
            public void onAnimationUpdate(ValueAnimator animation) {
                MaterialTapTargetPrompt.this.mView.mFocalRippleSize = ((Float)animation.getAnimatedValue()).floatValue();
                float fraction = Build.VERSION.SDK_INT >= 12 ? animation.getAnimatedFraction() : MaterialTapTargetPrompt.this.mFocalRadius10Percent * 6.0f / (MaterialTapTargetPrompt.this.mView.mFocalRippleSize - MaterialTapTargetPrompt.this.mBaseFocalRadius - MaterialTapTargetPrompt.this.mFocalRadius10Percent);
                MaterialTapTargetPrompt.this.mView.mFocalRippleAlpha = (int)((float)MaterialTapTargetPrompt.this.mBaseFocalRippleAlpha * (1.0f - fraction));
            }
        });
    }

    void updateFocalCentrePosition() {
        this.updateClipBounds();
        if (this.mTargetView != null) {
            int[] viewPosition = new int[2];
            this.mView.getLocationInWindow(viewPosition);
            int[] targetPosition = new int[2];
            this.mTargetView.getLocationInWindow(targetPosition);
            this.mView.mFocalCentre.x = targetPosition[0] - viewPosition[0] + this.mTargetView.getWidth() / 2;
            this.mView.mFocalCentre.y = targetPosition[1] - viewPosition[1] + this.mTargetView.getHeight() / 2;
        } else {
            this.mView.mFocalCentre.x = this.mTargetPosition.x;
            this.mView.mFocalCentre.y = this.mTargetPosition.y;
        }
        this.mVerticalTextPositionAbove = this.mView.mFocalCentre.y > (float)this.mView.mClipBounds.centerY();
        this.mHorizontalTextPositionLeft = this.mView.mFocalCentre.x > (float)this.mView.mClipBounds.centerX();
        this.mInside88dpBounds = this.mView.mFocalCentre.x > this.mClipViewBoundsInset88dp.left && this.mView.mFocalCentre.x < this.mClipViewBoundsInset88dp.right || this.mView.mFocalCentre.y > this.mClipViewBoundsInset88dp.top && this.mView.mFocalCentre.y < this.mClipViewBoundsInset88dp.bottom;
        this.updateTextPositioning();
        this.updateIconPosition();
    }

    void updateTextPositioning() {
        float maxWidth = Math.max(80.0f, Math.min(this.mMaxTextWidth, (float)(this.mView.mClipToBounds ? this.mView.mClipBounds.right - this.mView.mClipBounds.left : this.mParentView.getWidth()) - this.mTextPadding * 2.0f));
        this.mView.mPrimaryTextLayout = this.createStaticTextLayout(this.mPrimaryText, this.mPaintPrimaryText, (int)maxWidth, this.mPrimaryTextAlignment);
        this.mView.mSecondaryTextLayout = this.mSecondaryText != null ? this.createStaticTextLayout(this.mSecondaryText, this.mPaintSecondaryText, (int)maxWidth, this.mSecondaryTextAlignment) : null;
        float primaryTextWidth = this.calculateMaxTextWidth(this.mView.mPrimaryTextLayout);
        float secondaryTextWidth = this.calculateMaxTextWidth(this.mView.mSecondaryTextLayout);
        float textWidth = Math.max(primaryTextWidth, secondaryTextWidth);
        if (this.mInside88dpBounds) {
            this.mView.mPrimaryTextLeft = this.mView.mClipBounds.left;
            float width = Math.min(textWidth, maxWidth);
            this.mView.mPrimaryTextLeft = this.mHorizontalTextPositionLeft ? this.mView.mFocalCentre.x - width + this.mFocalToTextPadding : this.mView.mFocalCentre.x - width - this.mFocalToTextPadding;
            if (this.mView.mPrimaryTextLeft < (float)this.mView.mClipBounds.left + this.mTextPadding) {
                this.mView.mPrimaryTextLeft = (float)this.mView.mClipBounds.left + this.mTextPadding;
            }
            if (this.mView.mPrimaryTextLeft + width > (float)this.mView.mClipBounds.right - this.mTextPadding) {
                this.mView.mPrimaryTextLeft = (float)this.mView.mClipBounds.right - this.mTextPadding - width;
            }
        } else {
            this.mView.mPrimaryTextLeft = this.mHorizontalTextPositionLeft ? (float)(this.mView.mClipToBounds ? this.mView.mClipBounds.right : this.mParentView.getRight()) - this.mTextPadding - textWidth : (float)(this.mView.mClipToBounds ? this.mView.mClipBounds.left : this.mParentView.getLeft()) + this.mTextPadding;
        }
        this.mView.mPrimaryTextTop = this.mView.mFocalCentre.y;
        this.mView.mPrimaryTextTop = this.mVerticalTextPositionAbove ? this.mView.mPrimaryTextTop - this.mBaseFocalRadius - this.mFocalToTextPadding - (float)this.mView.mPrimaryTextLayout.getHeight() : (this.mView.mPrimaryTextTop += this.mBaseFocalRadius + this.mFocalToTextPadding);
        if (this.mSecondaryText != null) {
            if (this.mVerticalTextPositionAbove) {
                this.mView.mPrimaryTextTop = this.mView.mPrimaryTextTop - this.mView.mTextSeparation - (float)this.mView.mSecondaryTextLayout.getHeight();
            }
            this.mView.mSecondaryTextOffsetTop = (float)this.mView.mPrimaryTextLayout.getHeight() + this.mView.mTextSeparation;
        }
        this.updateBackgroundRadius(textWidth);
        this.mView.mSecondaryTextLeft = this.mView.mPrimaryTextLeft;
        this.mView.mPrimaryTextLeftChange = 0.0f;
        this.mView.mSecondaryTextLeftChange = 0.0f;
        float change = maxWidth - textWidth;
        if (this.isRtlText(this.mView.mPrimaryTextLayout)) {
            this.mView.mPrimaryTextLeftChange = change;
        }
        if (this.isRtlText(this.mView.mSecondaryTextLayout)) {
            this.mView.mSecondaryTextLeftChange = change;
        }
    }

    private boolean isRtlText(Layout layout) {
        boolean result = false;
        if (layout != null) {
            boolean bl = result = layout.getAlignment() == Layout.Alignment.ALIGN_OPPOSITE;
            if (Build.VERSION.SDK_INT >= 14) {
                boolean textIsRtl = layout.isRtlCharAt(0);
                boolean bl2 = result = (!result || !textIsRtl) && (result || textIsRtl) || textIsRtl;
                if (!result && layout.getAlignment() == Layout.Alignment.ALIGN_NORMAL && Build.VERSION.SDK_INT >= 17) {
                    result = textIsRtl && this.mActivity.getResources().getConfiguration().getLayoutDirection() == 1;
                } else if (layout.getAlignment() == Layout.Alignment.ALIGN_OPPOSITE && textIsRtl) {
                    result = false;
                }
            }
        }
        return result;
    }

    private StaticLayout createStaticTextLayout(String text, TextPaint paint, int maxTextWidth, Layout.Alignment textAlignment) {
        StaticLayout layout;
        if (Build.VERSION.SDK_INT >= 23) {
            StaticLayout.Builder builder = StaticLayout.Builder.obtain((CharSequence)text, (int)0, (int)text.length(), (TextPaint)paint, (int)maxTextWidth);
            builder.setAlignment(textAlignment);
            layout = builder.build();
        } else {
            layout = new StaticLayout((CharSequence)text, paint, maxTextWidth, textAlignment, 1.0f, 0.0f, false);
        }
        return layout;
    }

    float calculateMaxTextWidth(Layout textLayout) {
        float maxTextWidth = 0.0f;
        if (textLayout != null) {
            int count = textLayout.getLineCount();
            for (int i = 0; i < count; ++i) {
                maxTextWidth = Math.max(maxTextWidth, textLayout.getLineWidth(i));
            }
        }
        return maxTextWidth;
    }

    void updateBackgroundRadius(float maxTextWidth) {
        if (this.mInside88dpBounds) {
            float y2;
            float y1;
            float x1 = this.mView.mFocalCentre.x;
            float x2 = this.mView.mPrimaryTextLeft - this.mTextPadding;
            if (this.mVerticalTextPositionAbove) {
                y1 = this.mView.mFocalCentre.y + this.mBaseFocalRadius + this.mTextPadding;
                y2 = this.mView.mPrimaryTextTop;
            } else {
                y1 = this.mView.mFocalCentre.y - (this.mBaseFocalRadius + this.mFocalToTextPadding + this.mTextPadding);
                float baseY2 = this.mView.mPrimaryTextTop + (float)this.mView.mPrimaryTextLayout.getHeight();
                if (this.mView.mSecondaryTextLayout != null) {
                    baseY2 += (float)this.mView.mSecondaryTextLayout.getHeight() + this.mView.mTextSeparation;
                }
                y2 = baseY2;
            }
            float y3 = y2;
            float x3 = x2 + maxTextWidth + this.mTextPadding + this.mTextPadding;
            float focalLeft = this.mView.mFocalCentre.x - this.mBaseFocalRadius - this.mFocalToTextPadding;
            float focalRight = this.mView.mFocalCentre.x + this.mBaseFocalRadius + this.mFocalToTextPadding;
            if (x2 > focalLeft && x2 < focalRight) {
                if (this.mVerticalTextPositionAbove) {
                    x1 -= this.mBaseFocalRadius - this.mFocalToTextPadding;
                } else {
                    x2 -= this.mBaseFocalRadius - this.mFocalToTextPadding;
                }
            } else if (x3 > focalLeft && x3 < focalRight) {
                if (this.mVerticalTextPositionAbove) {
                    x1 += this.mBaseFocalRadius + this.mFocalToTextPadding;
                } else {
                    x3 += this.mBaseFocalRadius + this.mFocalToTextPadding;
                }
            }
            double offset = Math.pow(x2, 2.0) + Math.pow(y2, 2.0);
            double bc = (Math.pow(x1, 2.0) + Math.pow(y1, 2.0) - offset) / 2.0;
            double cd = (offset - Math.pow(x3, 2.0) - Math.pow(y3, 2.0)) / 2.0;
            double det = (x1 - x2) * (y2 - y3) - (x2 - x3) * (y1 - y2);
            double idet = 1.0 / det;
            this.mBaseBackgroundPosition.set((float)((bc * (double)(y2 - y3) - cd * (double)(y1 - y2)) * idet), (float)((cd * (double)(x1 - x2) - bc * (double)(x2 - x3)) * idet));
            this.mBaseBackgroundRadius = (float)Math.sqrt(Math.pow(x2 - this.mBaseBackgroundPosition.x, 2.0) + Math.pow(y2 - this.mBaseBackgroundPosition.y, 2.0));
        } else {
            this.mBaseBackgroundPosition.set(this.mView.mFocalCentre.x, this.mView.mFocalCentre.y);
            float length = Math.abs(this.mView.mPrimaryTextLeft + (this.mHorizontalTextPositionLeft ? 0.0f : maxTextWidth) - this.mView.mFocalCentre.x) + this.mTextPadding;
            float height = this.mBaseFocalRadius + this.mFocalToTextPadding + (float)this.mView.mPrimaryTextLayout.getHeight();
            if (this.mView.mSecondaryTextLayout != null) {
                height += (float)this.mView.mSecondaryTextLayout.getHeight() + this.mView.mTextSeparation;
            }
            this.mBaseBackgroundRadius = (float)Math.sqrt(Math.pow(length, 2.0) + Math.pow(height, 2.0));
        }
        this.mView.mBackgroundPosition.set(this.mBaseBackgroundPosition);
        this.mView.mBackgroundRadius = this.mBaseBackgroundRadius * this.mRevealedAmount;
    }

    void updateIconPosition() {
        if (this.mView.mIconDrawable != null) {
            this.mView.mIconDrawableLeft = this.mView.mFocalCentre.x - (float)(this.mView.mIconDrawable.getIntrinsicWidth() / 2);
            this.mView.mIconDrawableTop = this.mView.mFocalCentre.y - (float)(this.mView.mIconDrawable.getIntrinsicHeight() / 2);
        } else if (this.mView.mTargetRenderView != null) {
            int[] viewPosition = new int[2];
            this.mView.getLocationInWindow(viewPosition);
            int[] targetPosition = new int[2];
            this.mView.mTargetRenderView.getLocationInWindow(targetPosition);
            this.mView.mIconDrawableLeft = targetPosition[0] - viewPosition[0];
            this.mView.mIconDrawableTop = targetPosition[1] - viewPosition[1];
        }
    }

    void updateClipBounds() {
        if (this.mClipToView != null) {
            this.mView.mClipToBounds = true;
            this.mView.mClipBounds.set(0, 0, 0, 0);
            Point offset = new Point();
            this.mClipToView.getGlobalVisibleRect(this.mView.mClipBounds, offset);
            if (offset.y == 0) {
                this.mView.mClipBounds.top = (int)((float)this.mView.mClipBounds.top + this.mStatusBarHeight);
            }
            this.mClipViewBoundsInset88dp = new RectF(this.mView.mClipBounds);
            this.mClipViewBoundsInset88dp.inset(this.m88dp, this.m88dp);
        } else {
            View contentView = this.mActivity.findViewById(0x1020002);
            if (contentView != null) {
                contentView.getGlobalVisibleRect(this.mView.mClipBounds, new Point());
                this.mClipViewBoundsInset88dp = new RectF(this.mView.mClipBounds);
                this.mClipViewBoundsInset88dp.inset(this.m88dp, this.m88dp);
            }
            this.mView.mClipToBounds = false;
        }
    }

    protected void onHidePrompt(MotionEvent event, boolean targetTapped) {
        if (this.mOnHidePromptListener != null) {
            this.mOnHidePromptListener.onHidePrompt(event, targetTapped);
        }
    }

    protected void onHidePromptComplete() {
        if (this.mOnHidePromptListener != null) {
            this.mOnHidePromptListener.onHidePromptComplete();
        }
    }

    @TargetApi(value=11)
    static class AnimatorListener
    implements Animator.AnimatorListener {
        AnimatorListener() {
        }

        public void onAnimationStart(Animator animation) {
        }

        public void onAnimationEnd(Animator animation) {
        }

        public void onAnimationCancel(Animator animation) {
        }

        public void onAnimationRepeat(Animator animation) {
        }
    }

    public static interface OnHidePromptListener {
        public void onHidePrompt(MotionEvent var1, boolean var2);

        public void onHidePromptComplete();
    }

    public static class Builder {
        Activity mActivity;
        private boolean mTargetSet;
        private View mTargetView;
        private PointF mTargetPosition;
        private String mPrimaryText;
        private String mSecondaryText;
        private int mPrimaryTextColour;
        private int mSecondaryTextColour;
        private int mBackgroundColour;
        private int mFocalColour;
        private int mBackgroundColourAlpha;
        private int mFocalColourAlpha;
        private float mFocalRadius;
        private float mPrimaryTextSize;
        private float mSecondaryTextSize;
        private float mMaxTextWidth;
        private float mTextPadding;
        private float mFocalToTextPadding;
        private Interpolator mAnimationInterpolator;
        private Drawable mIconDrawable;
        private OnHidePromptListener mOnHidePromptListener;
        private boolean mCaptureTouchEventOnFocal;
        private float mTextSeparation;
        private boolean mAutoDismiss;
        private boolean mAutoFinish;
        private boolean mCaptureTouchEventOutsidePrompt;
        private Typeface mPrimaryTextTypeface;
        private Typeface mSecondaryTextTypeface;
        private int mPrimaryTextTypefaceStyle;
        private int mSecondaryTextTypefaceStyle;
        private ColorStateList mIconDrawableTintList = null;
        private PorterDuff.Mode mIconDrawableTintMode = null;
        private boolean mHasIconDrawableTint;
        private int mIconDrawableColourFilter;
        private View mTargetRenderView;
        private boolean mIdleAnimationEnabled = true;
        private int mPrimaryTextGravity = 0x800003;
        private int mSecondaryTextGravity = 0x800003;
        private View mClipToView;
        private final float m88dp;

        public Builder(Activity activity) {
            this(activity, 0);
        }

        public Builder(Activity activity, int themeResId) {
            this.mActivity = activity;
            if (themeResId == 0) {
                TypedValue outValue = new TypedValue();
                activity.getTheme().resolveAttribute(R.attr.MaterialTapTargetPromptTheme, outValue, true);
                themeResId = outValue.resourceId;
            }
            float density = activity.getResources().getDisplayMetrics().density;
            this.m88dp = 88.0f * density;
            TypedArray a = this.mActivity.obtainStyledAttributes(themeResId, R.styleable.PromptView);
            this.mPrimaryTextColour = a.getColor(R.styleable.PromptView_primaryTextColour, -1);
            this.mSecondaryTextColour = a.getColor(R.styleable.PromptView_secondaryTextColour, Color.argb((int)179, (int)255, (int)255, (int)255));
            this.mPrimaryText = a.getString(R.styleable.PromptView_primaryText);
            this.mSecondaryText = a.getString(R.styleable.PromptView_secondaryText);
            this.mBackgroundColour = a.getColor(R.styleable.PromptView_backgroundColour, Color.argb((int)244, (int)63, (int)81, (int)181));
            this.mFocalColour = a.getColor(R.styleable.PromptView_focalColour, -1);
            this.mFocalRadius = a.getDimension(R.styleable.PromptView_focalRadius, density * 44.0f);
            this.mPrimaryTextSize = a.getDimension(R.styleable.PromptView_primaryTextSize, 22.0f * density);
            this.mSecondaryTextSize = a.getDimension(R.styleable.PromptView_secondaryTextSize, 18.0f * density);
            this.mMaxTextWidth = a.getDimension(R.styleable.PromptView_maxTextWidth, 400.0f * density);
            this.mTextPadding = a.getDimension(R.styleable.PromptView_textPadding, 40.0f * density);
            this.mFocalToTextPadding = a.getDimension(R.styleable.PromptView_focalToTextPadding, 20.0f * density);
            this.mTextSeparation = a.getDimension(R.styleable.PromptView_textSeparation, 16.0f * density);
            this.mAutoDismiss = a.getBoolean(R.styleable.PromptView_autoDismiss, true);
            this.mAutoFinish = a.getBoolean(R.styleable.PromptView_autoFinish, true);
            this.mCaptureTouchEventOutsidePrompt = a.getBoolean(R.styleable.PromptView_captureTouchEventOutsidePrompt, false);
            this.mCaptureTouchEventOnFocal = a.getBoolean(R.styleable.PromptView_captureTouchEventOnFocal, false);
            this.mPrimaryTextTypefaceStyle = a.getInt(R.styleable.PromptView_primaryTextStyle, 0);
            this.mSecondaryTextTypefaceStyle = a.getInt(R.styleable.PromptView_secondaryTextStyle, 0);
            this.mPrimaryTextTypeface = this.setTypefaceFromAttrs(a.getString(R.styleable.PromptView_primaryTextFontFamily), a.getInt(R.styleable.PromptView_primaryTextTypeface, 0), this.mPrimaryTextTypefaceStyle);
            this.mSecondaryTextTypeface = this.setTypefaceFromAttrs(a.getString(R.styleable.PromptView_secondaryTextFontFamily), a.getInt(R.styleable.PromptView_secondaryTextTypeface, 0), this.mSecondaryTextTypefaceStyle);
            this.mBackgroundColourAlpha = a.getInt(R.styleable.PromptView_backgroundColourAlpha, 244);
            this.mFocalColourAlpha = a.getInt(R.styleable.PromptView_focalColourAlpha, 255);
            this.mIconDrawableColourFilter = a.getColor(R.styleable.PromptView_iconColourFilter, this.mBackgroundColour);
            this.mIconDrawableTintList = a.getColorStateList(R.styleable.PromptView_iconTint);
            this.mIconDrawableTintMode = this.parseTintMode(a.getInt(R.styleable.PromptView_iconTintMode, -1), PorterDuff.Mode.MULTIPLY);
            this.mHasIconDrawableTint = true;
            int targetId = a.getResourceId(R.styleable.PromptView_target, 0);
            a.recycle();
            if (targetId != 0) {
                this.mTargetView = this.mActivity.findViewById(targetId);
                if (this.mTargetView != null) {
                    this.mTargetSet = true;
                }
            }
            this.mClipToView = this.mActivity.findViewById(0x1020002);
        }

        public Builder setTarget(View target) {
            this.mTargetView = target;
            this.mTargetSet = this.mTargetView != null;
            return this;
        }

        public Builder setTarget(@IdRes int target) {
            this.mTargetView = this.mActivity.findViewById(target);
            this.mTargetPosition = null;
            this.mTargetSet = this.mTargetView != null;
            return this;
        }

        public Builder setTarget(float left, float top) {
            this.mTargetView = null;
            this.mTargetPosition = new PointF(left, top);
            this.mTargetSet = true;
            return this;
        }

        public Builder setTargetRenderView(View view) {
            this.mTargetRenderView = view;
            return this;
        }

        public boolean isTargetSet() {
            return this.mTargetSet;
        }

        public Builder setPrimaryText(@StringRes int resId) {
            this.mPrimaryText = this.mActivity.getString(resId);
            return this;
        }

        public Builder setPrimaryText(String text) {
            this.mPrimaryText = text;
            return this;
        }

        public Builder setPrimaryTextSize(@DimenRes int resId) {
            this.mPrimaryTextSize = this.mActivity.getResources().getDimension(resId);
            return this;
        }

        public Builder setPrimaryTextSize(float size) {
            this.mPrimaryTextSize = size;
            return this;
        }

        public Builder setPrimaryTextColour(@ColorInt int colour) {
            this.mPrimaryTextColour = colour;
            return this;
        }

        public Builder setPrimaryTextColourFromRes(@ColorRes int resId) {
            this.mPrimaryTextColour = this.getColour(resId);
            return this;
        }

        public Builder setPrimaryTextTypeface(Typeface typeface) {
            return this.setPrimaryTextTypeface(typeface, 0);
        }

        public Builder setPrimaryTextTypeface(Typeface typeface, int style) {
            this.mPrimaryTextTypeface = typeface;
            this.mPrimaryTextTypefaceStyle = style;
            return this;
        }

        public Builder setSecondaryText(@StringRes int resId) {
            this.mSecondaryText = this.mActivity.getString(resId);
            return this;
        }

        public Builder setSecondaryText(String text) {
            this.mSecondaryText = text;
            return this;
        }

        public Builder setSecondaryTextSize(@DimenRes int resId) {
            this.mSecondaryTextSize = this.mActivity.getResources().getDimension(resId);
            return this;
        }

        public Builder setSecondaryTextSize(float size) {
            this.mSecondaryTextSize = size;
            return this;
        }

        public Builder setSecondaryTextColour(@ColorInt int colour) {
            this.mSecondaryTextColour = colour;
            return this;
        }

        public Builder setSecondaryTextColourFromRes(@ColorRes int resId) {
            this.mSecondaryTextColour = this.getColour(resId);
            return this;
        }

        public Builder setSecondaryTextTypeface(Typeface typeface) {
            return this.setSecondaryTextTypeface(typeface, 0);
        }

        public Builder setSecondaryTextTypeface(Typeface typeface, int style) {
            this.mSecondaryTextTypeface = typeface;
            this.mSecondaryTextTypefaceStyle = style;
            return this;
        }

        public Builder setTextPadding(float padding) {
            this.mTextPadding = padding;
            return this;
        }

        public Builder setTextPadding(@DimenRes int resId) {
            this.mTextPadding = this.mActivity.getResources().getDimension(resId);
            return this;
        }

        public Builder setTextSeparation(float separation) {
            this.mTextSeparation = separation;
            return this;
        }

        public Builder setTextSeparation(@DimenRes int resId) {
            this.mTextSeparation = this.mActivity.getResources().getDimension(resId);
            return this;
        }

        public Builder setFocalToTextPadding(float padding) {
            this.mFocalToTextPadding = padding;
            return this;
        }

        public Builder setFocalToTextPadding(@DimenRes int resId) {
            this.mFocalToTextPadding = this.mActivity.getResources().getDimension(resId);
            return this;
        }

        public Builder setAnimationInterpolator(Interpolator interpolator) {
            this.mAnimationInterpolator = interpolator;
            return this;
        }

        public Builder setIdleAnimationEnabled(boolean enabled) {
            this.mIdleAnimationEnabled = enabled;
            return this;
        }

        public Builder setIcon(@DrawableRes int resId) {
            this.mIconDrawable = Build.VERSION.SDK_INT >= 21 ? this.mActivity.getDrawable(resId) : this.mActivity.getResources().getDrawable(resId);
            return this;
        }

        public Builder setIconDrawable(Drawable drawable) {
            this.mIconDrawable = drawable;
            return this;
        }

        public Builder setIconDrawableTintList(@Nullable ColorStateList tint) {
            this.mIconDrawableTintList = tint;
            this.mHasIconDrawableTint = tint != null;
            return this;
        }

        public Builder setIconDrawableTintMode(@Nullable PorterDuff.Mode tintMode) {
            this.mIconDrawableTintMode = tintMode;
            if (tintMode == null) {
                this.mIconDrawableTintList = null;
                this.mHasIconDrawableTint = false;
            }
            return this;
        }

        public Builder setIconDrawableColourFilter(@ColorInt int colour) {
            this.mIconDrawableColourFilter = colour;
            this.mIconDrawableTintList = null;
            this.mHasIconDrawableTint = true;
            return this;
        }

        public Builder setIconDrawableColourFilterFromRes(@ColorRes int id2) {
            int colour = Build.VERSION.SDK_INT >= 23 ? this.mActivity.getColor(id2) : this.mActivity.getResources().getColor(id2);
            return this.setIconDrawableColourFilter(colour);
        }

        public Builder setOnHidePromptListener(OnHidePromptListener listener) {
            this.mOnHidePromptListener = listener;
            return this;
        }

        public Builder setCaptureTouchEventOnFocal(boolean captureTouchEvent) {
            this.mCaptureTouchEventOnFocal = captureTouchEvent;
            return this;
        }

        public Builder setMaxTextWidth(float width) {
            this.mMaxTextWidth = width;
            return this;
        }

        public Builder setMaxTextWidth(@DimenRes int resId) {
            this.mMaxTextWidth = this.mActivity.getResources().getDimension(resId);
            return this;
        }

        public Builder setBackgroundColour(@ColorInt int colour) {
            this.mBackgroundColour = colour;
            return this;
        }

        public Builder setBackgroundColourFromRes(@ColorRes int resId) {
            this.mBackgroundColour = this.getColour(resId);
            return this;
        }

        public Builder setBackgroundColourAlpha(int alpha) {
            this.mBackgroundColourAlpha = alpha;
            return this;
        }

        public Builder setFocalColour(@ColorInt int colour) {
            this.mFocalColour = colour;
            return this;
        }

        public Builder setFocalColourFromRes(@ColorRes int resId) {
            this.mFocalColour = this.getColour(resId);
            return this;
        }

        public Builder setFocalColourAlpha(int alpha) {
            this.mFocalColourAlpha = alpha;
            return this;
        }

        public Builder setFocalRadius(float radius) {
            this.mFocalRadius = radius;
            return this;
        }

        public Builder setFocalRadius(@DimenRes int resId) {
            this.mFocalRadius = this.mActivity.getResources().getDimension(resId);
            return this;
        }

        public Builder setAutoDismiss(boolean autoDismiss) {
            this.mAutoDismiss = autoDismiss;
            return this;
        }

        public Builder setAutoFinish(boolean autoFinish) {
            this.mAutoFinish = autoFinish;
            return this;
        }

        public Builder setCaptureTouchEventOutsidePrompt(boolean captureTouchEventOutsidePrompt) {
            this.mCaptureTouchEventOutsidePrompt = captureTouchEventOutsidePrompt;
            return this;
        }

        public Builder setTextGravity(int gravity) {
            this.mPrimaryTextGravity = gravity;
            this.mSecondaryTextGravity = gravity;
            return this;
        }

        public Builder setPrimaryTextGravity(int gravity) {
            this.mPrimaryTextGravity = gravity;
            return this;
        }

        public Builder setSecondaryTextGravity(int gravity) {
            this.mSecondaryTextGravity = gravity;
            return this;
        }

        public Builder setClipToView(View view) {
            this.mClipToView = view;
            return this;
        }

        public MaterialTapTargetPrompt create() {
            if (!this.mTargetSet || this.mPrimaryText == null) {
                return null;
            }
            MaterialTapTargetPrompt mPrompt = new MaterialTapTargetPrompt(this.mActivity);
            if (this.mTargetView != null) {
                mPrompt.mTargetView = this.mTargetView;
                mPrompt.mView.mTargetView = this.mTargetView;
            } else {
                mPrompt.mTargetPosition = this.mTargetPosition;
            }
            mPrompt.mParentView = (ViewGroup)this.mActivity.getWindow().getDecorView();
            mPrompt.mView.mDrawRipple = Build.VERSION.SDK_INT >= 11 && this.mIdleAnimationEnabled;
            mPrompt.mIdleAnimationEnabled = this.mIdleAnimationEnabled;
            mPrompt.mClipToView = this.mClipToView;
            mPrompt.mPrimaryText = this.mPrimaryText;
            mPrompt.mPrimaryTextColourAlpha = Color.alpha((int)this.mPrimaryTextColour);
            mPrompt.mSecondaryText = this.mSecondaryText;
            mPrompt.mSecondaryTextColourAlpha = Color.alpha((int)this.mSecondaryTextColour);
            mPrompt.mMaxTextWidth = this.mMaxTextWidth;
            mPrompt.mTextPadding = this.mTextPadding;
            mPrompt.mFocalToTextPadding = this.mFocalToTextPadding;
            mPrompt.mBaseFocalRippleAlpha = 150;
            mPrompt.m88dp = this.m88dp;
            mPrompt.mBaseBackgroundColourAlpha = this.mBackgroundColourAlpha;
            mPrompt.mBaseFocalColourAlpha = this.mFocalColourAlpha;
            mPrompt.mView.mTextSeparation = this.mTextSeparation;
            mPrompt.mOnHidePromptListener = this.mOnHidePromptListener;
            mPrompt.mView.mCaptureTouchEventOnFocal = this.mCaptureTouchEventOnFocal;
            mPrompt.mAnimationInterpolator = this.mAnimationInterpolator != null ? this.mAnimationInterpolator : new AccelerateDecelerateInterpolator();
            mPrompt.mBaseFocalRadius = this.mFocalRadius;
            mPrompt.mFocalRadius10Percent = this.mFocalRadius / 100.0f * 10.0f;
            if (this.mIconDrawable != null) {
                this.mIconDrawable.mutate();
                this.mIconDrawable.setBounds(0, 0, this.mIconDrawable.getIntrinsicWidth(), this.mIconDrawable.getIntrinsicHeight());
                if (this.mHasIconDrawableTint) {
                    if (this.mIconDrawableTintList != null) {
                        if (Build.VERSION.SDK_INT >= 21) {
                            this.mIconDrawable.setTintList(this.mIconDrawableTintList);
                        }
                    } else {
                        this.mIconDrawable.setColorFilter(this.mIconDrawableColourFilter, this.mIconDrawableTintMode);
                        this.mIconDrawable.setAlpha(Color.alpha((int)this.mIconDrawableColourFilter));
                    }
                }
            }
            mPrompt.mView.mIconDrawable = this.mIconDrawable;
            mPrompt.mView.mPaintFocal = new Paint();
            mPrompt.mView.mPaintFocal.setColor(this.mFocalColour);
            mPrompt.mView.mPaintFocal.setAlpha(this.mFocalColourAlpha);
            mPrompt.mView.mPaintFocal.setAntiAlias(true);
            mPrompt.mView.mPaintBackground = new Paint();
            mPrompt.mView.mPaintBackground.setColor(this.mBackgroundColour);
            mPrompt.mView.mPaintBackground.setAlpha(this.mBackgroundColourAlpha);
            mPrompt.mView.mPaintBackground.setAntiAlias(true);
            mPrompt.mPaintPrimaryText = new TextPaint();
            mPrompt.mPaintPrimaryText.setColor(this.mPrimaryTextColour);
            mPrompt.mPaintPrimaryText.setAlpha(Color.alpha((int)this.mPrimaryTextColour));
            mPrompt.mPaintPrimaryText.setAntiAlias(true);
            mPrompt.mPaintPrimaryText.setTextSize(this.mPrimaryTextSize);
            this.setTypeface(mPrompt.mPaintPrimaryText, this.mPrimaryTextTypeface, this.mPrimaryTextTypefaceStyle);
            mPrompt.mPrimaryTextAlignment = this.getTextAlignment(this.mPrimaryTextGravity, this.mPrimaryText);
            mPrompt.mPaintSecondaryText = new TextPaint();
            mPrompt.mPaintSecondaryText.setColor(this.mSecondaryTextColour);
            mPrompt.mPaintSecondaryText.setAlpha(Color.alpha((int)this.mSecondaryTextColour));
            mPrompt.mPaintSecondaryText.setAntiAlias(true);
            mPrompt.mPaintSecondaryText.setTextSize(this.mSecondaryTextSize);
            this.setTypeface(mPrompt.mPaintSecondaryText, this.mSecondaryTextTypeface, this.mSecondaryTextTypefaceStyle);
            mPrompt.mSecondaryTextAlignment = this.getTextAlignment(this.mSecondaryTextGravity, this.mSecondaryText);
            mPrompt.mAutoDismiss = this.mAutoDismiss;
            mPrompt.mAutoFinish = this.mAutoFinish;
            mPrompt.mView.mCaptureTouchEventOutsidePrompt = this.mCaptureTouchEventOutsidePrompt;
            mPrompt.mView.mTargetRenderView = this.mTargetRenderView == null ? mPrompt.mView.mTargetView : this.mTargetRenderView;
            return mPrompt;
        }

        public MaterialTapTargetPrompt show() {
            MaterialTapTargetPrompt mPrompt = this.create();
            if (mPrompt != null) {
                mPrompt.show();
            }
            return mPrompt;
        }

        private int getColour(int resId) {
            int colour = Build.VERSION.SDK_INT >= 23 ? this.mActivity.getColor(resId) : this.mActivity.getResources().getColor(resId);
            return colour;
        }

        private void setTypeface(TextPaint textPaint, Typeface typeface, int style) {
            if (style > 0) {
                typeface = typeface == null ? Typeface.defaultFromStyle((int)style) : Typeface.create((Typeface)typeface, (int)style);
                textPaint.setTypeface(typeface);
                int typefaceStyle = typeface != null ? typeface.getStyle() : 0;
                int need = style & ~typefaceStyle;
                textPaint.setFakeBoldText((need & 1) != 0);
                textPaint.setTextSkewX((need & 2) != 0 ? -0.25f : 0.0f);
            } else {
                textPaint.setTypeface(typeface);
            }
        }

        private Typeface setTypefaceFromAttrs(String familyName, int typefaceIndex, int styleIndex) {
            Typeface tf = null;
            if (familyName != null && (tf = Typeface.create((String)familyName, (int)styleIndex)) != null) {
                return tf;
            }
            switch (typefaceIndex) {
                case 1: {
                    tf = Typeface.SANS_SERIF;
                    break;
                }
                case 2: {
                    tf = Typeface.SERIF;
                    break;
                }
                case 3: {
                    tf = Typeface.MONOSPACE;
                }
            }
            return tf;
        }

        PorterDuff.Mode parseTintMode(int value, PorterDuff.Mode defaultMode) {
            switch (value) {
                case 3: {
                    return PorterDuff.Mode.SRC_OVER;
                }
                case 5: {
                    return PorterDuff.Mode.SRC_IN;
                }
                case 9: {
                    return PorterDuff.Mode.SRC_ATOP;
                }
                case 14: {
                    return PorterDuff.Mode.MULTIPLY;
                }
                case 15: {
                    return PorterDuff.Mode.SCREEN;
                }
                case 16: {
                    return Build.VERSION.SDK_INT >= 11 ? PorterDuff.Mode.valueOf((String)"ADD") : defaultMode;
                }
            }
            return defaultMode;
        }

        Layout.Alignment getTextAlignment(int gravity, String text) {
            Layout.Alignment alignment;
            int absoluteGravity;
            if (this.isVersionAfterJellyBeanMR1()) {
                int realGravity = gravity;
                int layoutDirection = this.mActivity.getResources().getConfiguration().getLayoutDirection();
                if (layoutDirection == 1 && new Bidi(text, -2).isRightToLeft()) {
                    if (gravity == 0x800003) {
                        realGravity = 0x800005;
                    } else if (gravity == 0x800005) {
                        realGravity = 0x800003;
                    }
                }
                absoluteGravity = Gravity.getAbsoluteGravity((int)realGravity, (int)layoutDirection);
            } else {
                absoluteGravity = (gravity & 0x800003) == 0x800003 ? 3 : ((gravity & 0x800005) == 0x800005 ? 5 : gravity & 7);
            }
            switch (absoluteGravity) {
                case 5: {
                    alignment = Layout.Alignment.ALIGN_OPPOSITE;
                    break;
                }
                case 1: {
                    alignment = Layout.Alignment.ALIGN_CENTER;
                    break;
                }
                default: {
                    alignment = Layout.Alignment.ALIGN_NORMAL;
                }
            }
            return alignment;
        }

        boolean isVersionAfterJellyBeanMR1() {
            return Build.VERSION.SDK_INT >= 17;
        }
    }

    static class PromptView
    extends View {
        PointF mFocalCentre = new PointF();
        PointF mBackgroundPosition = new PointF();
        Paint mPaintBackground;
        Paint mPaintFocal;
        float mFocalRadius;
        float mBackgroundRadius;
        float mFocalRippleSize;
        int mFocalRippleAlpha;
        Drawable mIconDrawable;
        float mIconDrawableLeft;
        float mIconDrawableTop;
        float mPrimaryTextLeft;
        float mPrimaryTextLeftChange;
        float mPrimaryTextTop;
        float mSecondaryTextLeft;
        float mSecondaryTextLeftChange;
        float mSecondaryTextOffsetTop;
        Layout mPrimaryTextLayout;
        Layout mSecondaryTextLayout;
        boolean mDrawRipple = Build.VERSION.SDK_INT >= 11;
        OnPromptTouchedListener mOnPromptTouchedListener;
        boolean mCaptureTouchEventOnFocal;
        Rect mClipBounds = new Rect();
        View mTargetView;
        View mTargetRenderView;
        float mTextSeparation;
        boolean mClipToBounds;
        boolean mCaptureTouchEventOutsidePrompt;

        public PromptView(Context context) {
            super(context);
        }

        public void onDraw(Canvas canvas) {
            if (this.mBackgroundRadius > 0.0f) {
                if (this.mClipToBounds) {
                    canvas.clipRect(this.mClipBounds);
                }
                canvas.drawCircle(this.mBackgroundPosition.x, this.mBackgroundPosition.y, this.mBackgroundRadius, this.mPaintBackground);
                if (this.mDrawRipple) {
                    int oldAlpha = this.mPaintFocal.getAlpha();
                    this.mPaintFocal.setAlpha(this.mFocalRippleAlpha);
                    canvas.drawCircle(this.mFocalCentre.x, this.mFocalCentre.y, this.mFocalRippleSize, this.mPaintFocal);
                    this.mPaintFocal.setAlpha(oldAlpha);
                }
                canvas.drawCircle(this.mFocalCentre.x, this.mFocalCentre.y, this.mFocalRadius, this.mPaintFocal);
                if (this.mIconDrawable != null) {
                    canvas.translate(this.mIconDrawableLeft, this.mIconDrawableTop);
                    this.mIconDrawable.draw(canvas);
                    canvas.translate(-this.mIconDrawableLeft, -this.mIconDrawableTop);
                } else if (this.mTargetRenderView != null) {
                    canvas.translate(this.mIconDrawableLeft, this.mIconDrawableTop);
                    this.mTargetRenderView.draw(canvas);
                    canvas.translate(-this.mIconDrawableLeft, -this.mIconDrawableTop);
                }
                canvas.translate(this.mPrimaryTextLeft - this.mPrimaryTextLeftChange, this.mPrimaryTextTop);
                if (this.mPrimaryTextLayout != null) {
                    this.mPrimaryTextLayout.draw(canvas);
                }
                if (this.mSecondaryTextLayout != null) {
                    canvas.translate(-(this.mPrimaryTextLeft - this.mPrimaryTextLeftChange) + this.mSecondaryTextLeft - this.mSecondaryTextLeftChange, this.mSecondaryTextOffsetTop);
                    this.mSecondaryTextLayout.draw(canvas);
                }
            }
        }

        public boolean onTouchEvent(MotionEvent event) {
            boolean captureEvent;
            float x = event.getX();
            float y = event.getY();
            boolean bl = captureEvent = (!this.mClipToBounds || this.mClipBounds.contains((int)x, (int)y)) && this.pointInCircle(x, y, this.mBackgroundPosition, this.mBackgroundRadius);
            if (captureEvent && this.pointInCircle(x, y, this.mFocalCentre, this.mFocalRadius)) {
                captureEvent = this.mCaptureTouchEventOnFocal;
                this.onPromptTouched(event, true);
            } else {
                if (!captureEvent) {
                    captureEvent = this.mCaptureTouchEventOutsidePrompt;
                }
                this.onPromptTouched(event, false);
            }
            return captureEvent;
        }

        boolean pointInCircle(float x, float y, PointF circleCentre, float radius) {
            return Math.pow(x - circleCentre.x, 2.0) + Math.pow(y - circleCentre.y, 2.0) < Math.pow(radius, 2.0);
        }

        protected void onPromptTouched(MotionEvent event, boolean targetTapped) {
            if (this.mOnPromptTouchedListener != null) {
                this.mOnPromptTouchedListener.onPromptTouched(event, targetTapped);
            }
        }

        public static interface OnPromptTouchedListener {
            public void onPromptTouched(MotionEvent var1, boolean var2);
        }
    }
}

