/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.generation.rust;

import java.util.ArrayList;
import java.util.List;
import uk.co.real_logic.sbe.generation.NamedToken;
import uk.co.real_logic.sbe.ir.Token;

final class SplitCompositeTokens {
    private final List<Token> constantEncodingTokens;
    private final List<NamedToken> nonConstantEncodingTokens;

    private SplitCompositeTokens(List<Token> constantEncodingTokens, List<NamedToken> nonConstantEncodingTokens) {
        this.constantEncodingTokens = constantEncodingTokens;
        this.nonConstantEncodingTokens = nonConstantEncodingTokens;
    }

    public List<Token> constantEncodingTokens() {
        return this.constantEncodingTokens;
    }

    public List<NamedToken> nonConstantEncodingTokens() {
        return this.nonConstantEncodingTokens;
    }

    public static SplitCompositeTokens splitInnerTokens(List<Token> tokens) {
        Token encodingToken;
        ArrayList<Token> constantTokens = new ArrayList<Token>();
        ArrayList<NamedToken> namedNonConstantTokens = new ArrayList<NamedToken>();
        int end = tokens.size() - 1;
        for (int i = 1; i < end; i += encodingToken.componentTokenCount()) {
            encodingToken = tokens.get(i);
            if (encodingToken.isConstantEncoding()) {
                constantTokens.add(encodingToken);
                continue;
            }
            namedNonConstantTokens.add(new NamedToken(encodingToken.name(), encodingToken));
        }
        return new SplitCompositeTokens(constantTokens, namedNonConstantTokens);
    }
}

