/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.otf;

import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import uk.co.real_logic.sbe.PrimitiveType;
import uk.co.real_logic.sbe.ir.Encoding;

public class Types {
    public static int getInt(DirectBuffer buffer, int index, PrimitiveType type, ByteOrder byteOrder) {
        switch (type) {
            case INT8: {
                return buffer.getByte(index);
            }
            case UINT8: {
                return (short)(buffer.getByte(index) & 0xFF);
            }
            case INT16: {
                return buffer.getShort(index, byteOrder);
            }
            case UINT16: {
                return buffer.getShort(index, byteOrder) & 0xFFFF;
            }
            case INT32: {
                return buffer.getInt(index, byteOrder);
            }
            case UINT32: {
                int value = buffer.getInt(index, byteOrder);
                if (value < 0) {
                    throw new IllegalStateException("UINT32 type should not be greater than Integer.MAX_VALUE: value=" + value);
                }
                return value;
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + (Object)((Object)type));
    }

    public static long getLong(DirectBuffer buffer, int index, Encoding encoding) {
        switch (encoding.primitiveType()) {
            case CHAR: {
                return buffer.getByte(index);
            }
            case INT8: {
                return buffer.getByte(index);
            }
            case INT16: {
                return buffer.getShort(index, encoding.byteOrder());
            }
            case INT32: {
                return buffer.getInt(index, encoding.byteOrder());
            }
            case INT64: {
                return buffer.getLong(index, encoding.byteOrder());
            }
            case UINT8: {
                return (short)(buffer.getByte(index) & 0xFF);
            }
            case UINT16: {
                return buffer.getShort(index, encoding.byteOrder()) & 0xFFFF;
            }
            case UINT32: {
                return (long)buffer.getInt(index, encoding.byteOrder()) & 0xFFFFFFFFL;
            }
            case UINT64: {
                return buffer.getLong(index, encoding.byteOrder());
            }
        }
        throw new IllegalArgumentException("Unsupported type for long: " + (Object)((Object)encoding.primitiveType()));
    }

    public static void appendAsString(StringBuilder sb, DirectBuffer buffer, int index, Encoding encoding) {
        switch (encoding.primitiveType()) {
            case CHAR: {
                sb.append('\'').append((char)buffer.getByte(index)).append('\'');
                break;
            }
            case INT8: {
                sb.append(buffer.getByte(index));
                break;
            }
            case INT16: {
                sb.append(buffer.getShort(index, encoding.byteOrder()));
                break;
            }
            case INT32: {
                sb.append(buffer.getInt(index, encoding.byteOrder()));
                break;
            }
            case INT64: {
                sb.append(buffer.getLong(index, encoding.byteOrder()));
                break;
            }
            case UINT8: {
                sb.append((short)(buffer.getByte(index) & 0xFF));
                break;
            }
            case UINT16: {
                sb.append(buffer.getShort(index, encoding.byteOrder()) & 0xFFFF);
                break;
            }
            case UINT32: {
                sb.append((long)buffer.getInt(index, encoding.byteOrder()) & 0xFFFFFFFFL);
                break;
            }
            case UINT64: {
                sb.append(buffer.getLong(index, encoding.byteOrder()));
                break;
            }
            case FLOAT: {
                sb.append(buffer.getFloat(index, encoding.byteOrder()));
                break;
            }
            case DOUBLE: {
                sb.append(buffer.getDouble(index, encoding.byteOrder()));
            }
        }
    }
}

