/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.generation.java;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.Verify;
import org.agrona.generation.OutputManager;
import uk.co.real_logic.sbe.PrimitiveType;
import uk.co.real_logic.sbe.generation.CodeGenerator;
import uk.co.real_logic.sbe.generation.java.JavaUtil;
import uk.co.real_logic.sbe.ir.Encoding;
import uk.co.real_logic.sbe.ir.GenerationUtil;
import uk.co.real_logic.sbe.ir.HeaderStructure;
import uk.co.real_logic.sbe.ir.Ir;
import uk.co.real_logic.sbe.ir.Signal;
import uk.co.real_logic.sbe.ir.Token;

public class JavaGenerator
implements CodeGenerator {
    private static final String META_ATTRIBUTE_ENUM = "MetaAttribute";
    private static final String BASE_INDENT = "";
    private static final String INDENT = "    ";
    private static final String GEN_COMPOSITE_DECODER_FLYWEIGHT = "CompositeDecoderFlyweight";
    private static final String GEN_COMPOSITE_ENCODER_FLYWEIGHT = "CompositeEncoderFlyweight";
    private static final String GEN_MESSAGE_DECODER_FLYWEIGHT = "MessageDecoderFlyweight";
    private static final String GEN_MESSAGE_ENCODER_FLYWEIGHT = "MessageEncoderFlyweight";
    private final Ir ir;
    private final OutputManager outputManager;
    private final String fqMutableBuffer;
    private final String mutableBuffer;
    private final String fqReadOnlyBuffer;
    private final String readOnlyBuffer;
    private final boolean shouldGenerateGroupOrderAnnotation;
    private final boolean shouldGenerateInterfaces;

    public JavaGenerator(Ir ir, String mutableBuffer, String readOnlyBuffer, boolean shouldGenerateGroupOrderAnnotation, boolean shouldGenerateInterfaces, OutputManager outputManager) throws IOException {
        Verify.notNull((Object)ir, (String)"ir");
        Verify.notNull((Object)outputManager, (String)"outputManager");
        this.ir = ir;
        this.outputManager = outputManager;
        this.mutableBuffer = JavaGenerator.validateBufferImplementation(mutableBuffer, MutableDirectBuffer.class);
        this.fqMutableBuffer = mutableBuffer;
        this.readOnlyBuffer = JavaGenerator.validateBufferImplementation(readOnlyBuffer, DirectBuffer.class);
        this.fqReadOnlyBuffer = readOnlyBuffer;
        this.shouldGenerateGroupOrderAnnotation = shouldGenerateGroupOrderAnnotation;
        this.shouldGenerateInterfaces = shouldGenerateInterfaces;
    }

    private static String validateBufferImplementation(String fullyQualifiedBufferImplementation, Class<?> bufferClass) {
        Verify.notNull((Object)fullyQualifiedBufferImplementation, (String)"fullyQualifiedBufferImplementation");
        try {
            Class<?> clazz = Class.forName(fullyQualifiedBufferImplementation);
            if (!bufferClass.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException(fullyQualifiedBufferImplementation + " doesn't implement " + bufferClass.getName());
            }
            return clazz.getSimpleName();
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("Unable to validate " + fullyQualifiedBufferImplementation + " because it can't be found", ex);
        }
    }

    private String encoderName(String className) {
        return className + "Encoder";
    }

    private String decoderName(String className) {
        return className + "Decoder";
    }

    private String implementsInterface(String interfaceName) {
        if (!this.shouldGenerateInterfaces) {
            return BASE_INDENT;
        }
        return String.format(" implements %s", interfaceName);
    }

    public void generateMessageHeaderStub() throws IOException {
        List<Token> tokens = this.ir.headerStructure().tokens();
        Token firstToken = tokens.get(0);
        try (Writer out = this.outputManager.createOutput("MessageHeaderEncoder");){
            this.generateFixedFlyweightHeader(firstToken, "MessageHeaderEncoder", out, this.mutableBuffer, this.fqMutableBuffer, BASE_INDENT);
            out.append(GenerationUtil.concatEncodingTokens(tokens, token -> this.generatePrimitiveEncoder("MessageHeaderEncoder", token.name(), (Token)token, BASE_INDENT)));
            out.append("}\n");
        }
        out = this.outputManager.createOutput("MessageHeaderDecoder");
        var4_4 = null;
        try {
            this.generateFixedFlyweightHeader(firstToken, "MessageHeaderDecoder", out, this.readOnlyBuffer, this.fqReadOnlyBuffer, BASE_INDENT);
            out.append(GenerationUtil.concatEncodingTokens(tokens, token -> this.generatePrimitiveDecoder(token.name(), (Token)token, BASE_INDENT)));
            out.append("}\n");
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (out != null) {
                if (var4_4 != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    out.close();
                }
            }
        }
    }

    public void generateTypeStubs() throws IOException {
        this.generateMetaAttributeEnum();
        for (List<Token> tokens : this.ir.types()) {
            switch (tokens.get(0).signal()) {
                case BEGIN_ENUM: {
                    this.generateEnum(tokens);
                    break;
                }
                case BEGIN_SET: {
                    this.generateBitSet(tokens);
                    break;
                }
                case BEGIN_COMPOSITE: {
                    this.generateComposite(tokens);
                }
            }
        }
    }

    @Override
    public void generate() throws IOException {
        this.generateMessageHeaderStub();
        this.generateTypeStubs();
        for (List<Token> tokens : this.ir.messages()) {
            Token msgToken = tokens.get(0);
            List<Token> messageBody = GenerationUtil.getMessageBody(tokens);
            int i = 0;
            ArrayList<Token> fields = new ArrayList<Token>();
            i = GenerationUtil.collectFields(messageBody, i, fields);
            ArrayList<Token> groups = new ArrayList<Token>();
            i = GenerationUtil.collectGroups(messageBody, i, groups);
            ArrayList<Token> varData = new ArrayList<Token>();
            GenerationUtil.collectVarData(messageBody, i, varData);
            this.generateDecoder(BASE_INDENT, fields, groups, varData, msgToken);
            this.generateEncoder(BASE_INDENT, fields, groups, varData, msgToken);
        }
    }

    private void generateEncoder(String indent, List<Token> fields, List<Token> groups, List<Token> varData, Token msgToken) throws IOException {
        String className = JavaUtil.formatClassName(this.encoderName(msgToken.name()));
        String implementsString = this.implementsInterface(GEN_MESSAGE_ENCODER_FLYWEIGHT);
        try (Writer out = this.outputManager.createOutput(className);){
            out.append(this.generateMainHeader(className, this.ir.applicableNamespace()));
            this.generateAnnotations(indent, className, groups, out, 0, this::encoderName);
            out.append(JavaGenerator.generateDeclaration("class", className, implementsString));
            out.append(this.generateEncoderFlyweightCode(className, msgToken));
            out.append(this.generateEncoderFields(className, fields, indent));
            StringBuilder sb = new StringBuilder();
            this.generateEncoderGroups(sb, className, groups, indent);
            out.append(sb);
            out.append(this.generateEncoderVarData(className, varData, indent));
            out.append(this.generateEncoderDisplay(JavaUtil.formatClassName(this.decoderName(msgToken.name())), indent));
            out.append("}\n");
        }
    }

    private void generateDecoder(String indent, List<Token> fields, List<Token> groups, List<Token> varData, Token msgToken) throws IOException {
        String className = JavaUtil.formatClassName(this.decoderName(msgToken.name()));
        String implementsString = this.implementsInterface(GEN_MESSAGE_DECODER_FLYWEIGHT);
        try (Writer out = this.outputManager.createOutput(className);){
            out.append(this.generateMainHeader(className, this.ir.applicableNamespace()));
            this.generateAnnotations(indent, className, groups, out, 0, this::decoderName);
            out.append(JavaGenerator.generateDeclaration("class", className, implementsString));
            out.append(this.generateDecoderFlyweightCode(className, msgToken));
            out.append(this.generateDecoderFields(fields, indent));
            StringBuilder sb = new StringBuilder();
            this.generateDecoderGroups(sb, className, groups, indent);
            out.append(sb);
            out.append(this.generateDecoderVarData(varData, indent));
            out.append(this.generateDecoderDisplay(msgToken.name(), fields, groups, varData, indent));
            out.append("}\n");
        }
    }

    private void generateDecoderGroups(StringBuilder sb, String outerClassName, List<Token> tokens, String indent) throws IOException {
        int size = tokens.size();
        for (int i = 0; i < size; ++i) {
            Token groupToken = tokens.get(i);
            if (groupToken.signal() != Signal.BEGIN_GROUP) {
                throw new IllegalStateException("tokens must begin with BEGIN_GROUP: token=" + groupToken);
            }
            String groupName = this.decoderName(JavaUtil.formatClassName(groupToken.name()));
            sb.append(JavaGenerator.generateGroupDecoderProperty(groupName, groupToken, indent));
            this.generateAnnotations(indent + INDENT, groupName, tokens, sb, i + 1, this::decoderName);
            this.generateGroupDecoderClassHeader(sb, groupName, outerClassName, tokens, i, indent + INDENT);
            int groupHeaderTokenCount = tokens.get(++i).componentTokenCount();
            i += groupHeaderTokenCount;
            ArrayList<Token> fields = new ArrayList<Token>();
            i = GenerationUtil.collectFields(tokens, i, fields);
            sb.append(this.generateDecoderFields(fields, indent + INDENT));
            ArrayList<Token> groups = new ArrayList<Token>();
            i = GenerationUtil.collectGroups(tokens, i, groups);
            this.generateDecoderGroups(sb, outerClassName, groups, indent + INDENT);
            ArrayList<Token> varData = new ArrayList<Token>();
            i = GenerationUtil.collectVarData(tokens, i, varData);
            sb.append(this.generateDecoderVarData(varData, indent + INDENT));
            this.appendGroupInstanceDecoderDisplay(sb, fields, groups, varData, indent + INDENT);
            sb.append(indent).append("    }\n");
        }
    }

    private void generateEncoderGroups(StringBuilder sb, String outerClassName, List<Token> tokens, String indent) throws IOException {
        int size = tokens.size();
        for (int i = 0; i < size; ++i) {
            Token groupToken = tokens.get(i);
            if (groupToken.signal() != Signal.BEGIN_GROUP) {
                throw new IllegalStateException("tokens must begin with BEGIN_GROUP: token=" + groupToken);
            }
            String groupName = groupToken.name();
            String groupClassName = JavaUtil.formatClassName(this.encoderName(groupName));
            sb.append(this.generateGroupEncoderProperty(groupName, groupToken, indent));
            this.generateAnnotations(indent + INDENT, groupClassName, tokens, sb, i + 1, this::encoderName);
            this.generateGroupEncoderClassHeader(sb, groupName, outerClassName, tokens, i, indent + INDENT);
            int groupHeaderTokenCount = tokens.get(++i).componentTokenCount();
            i += groupHeaderTokenCount;
            ArrayList<Token> fields = new ArrayList<Token>();
            i = GenerationUtil.collectFields(tokens, i, fields);
            sb.append(this.generateEncoderFields(groupClassName, fields, indent + INDENT));
            ArrayList<Token> groups = new ArrayList<Token>();
            i = GenerationUtil.collectGroups(tokens, i, groups);
            this.generateEncoderGroups(sb, outerClassName, groups, indent + INDENT);
            ArrayList<Token> varData = new ArrayList<Token>();
            i = GenerationUtil.collectVarData(tokens, i, varData);
            sb.append(this.generateEncoderVarData(groupClassName, varData, indent + INDENT));
            sb.append(indent).append("    }\n");
        }
    }

    private void generateGroupDecoderClassHeader(StringBuilder sb, String groupName, String parentMessageClassName, List<Token> tokens, int index, String indent) {
        String dimensionsClassName = JavaUtil.formatClassName(tokens.get(index + 1).name());
        int dimensionHeaderLen = tokens.get(index + 1).encodedLength();
        this.generateGroupDecoderClassDeclaration(sb, groupName, parentMessageClassName, indent, dimensionsClassName, dimensionHeaderLen);
        sb.append(String.format(indent + "    public void wrap(\n" + indent + "        final %s parentMessage, final %s buffer)\n" + indent + "    {\n" + indent + "        this.parentMessage = parentMessage;\n" + indent + "        this.buffer = buffer;\n" + indent + "        dimensions.wrap(buffer, parentMessage.limit());\n" + indent + "        blockLength = dimensions.blockLength();\n" + indent + "        count = dimensions.numInGroup();\n" + indent + "        index = -1;\n" + indent + "        parentMessage.limit(parentMessage.limit() + HEADER_SIZE);\n" + indent + "    }\n\n", parentMessageClassName, this.readOnlyBuffer));
        int blockLength = tokens.get(index).encodedLength();
        sb.append(indent).append("    public static int sbeHeaderSize()\n").append(indent).append("    {\n").append(indent).append("        return HEADER_SIZE;\n").append(indent).append("    }\n\n");
        sb.append(String.format(indent + "    public static int sbeBlockLength()\n" + indent + "    {\n" + indent + "        return %d;\n" + indent + "    }\n\n", blockLength));
        sb.append(String.format(indent + "    public int actingBlockLength()\n" + indent + "    {\n" + indent + "        return blockLength;\n" + indent + "    }\n\n" + indent + "    public int count()\n" + indent + "    {\n" + indent + "        return count;\n" + indent + "    }\n\n" + indent + "    public java.util.Iterator<%s> iterator()\n" + indent + "    {\n" + indent + "        return this;\n" + indent + "    }\n\n" + indent + "    public void remove()\n" + indent + "    {\n" + indent + "        throw new UnsupportedOperationException();\n" + indent + "    }\n\n" + indent + "    public boolean hasNext()\n" + indent + "    {\n" + indent + "        return (index + 1) < count;\n" + indent + "    }\n\n", JavaUtil.formatClassName(groupName)));
        sb.append(String.format(indent + "    public %s next()\n" + indent + "    {\n" + indent + "        if (index + 1 >= count)\n" + indent + "        {\n" + indent + "            throw new java.util.NoSuchElementException();\n" + indent + "        }\n\n" + indent + "        offset = parentMessage.limit();\n" + indent + "        parentMessage.limit(offset + blockLength);\n" + indent + "        ++index;\n\n" + indent + "        return this;\n" + indent + "    }\n", JavaUtil.formatClassName(groupName)));
    }

    private void generateGroupEncoderClassHeader(StringBuilder sb, String groupName, String parentMessageClassName, List<Token> tokens, int index, String indent) {
        String dimensionsClassName = JavaUtil.formatClassName(this.encoderName(tokens.get(index + 1).name()));
        int dimensionHeaderSize = tokens.get(index + 1).encodedLength();
        this.generateGroupEncoderClassDeclaration(sb, groupName, parentMessageClassName, indent, dimensionsClassName, dimensionHeaderSize);
        int blockLength = tokens.get(index).encodedLength();
        String javaTypeForBlockLength = JavaGenerator.primitiveTypeName(tokens.get(index + 2));
        Token numInGroupToken = tokens.get(index + 3);
        String javaTypeForNumInGroup = JavaGenerator.primitiveTypeName(numInGroupToken);
        sb.append(String.format(indent + "    public void wrap(\n" + indent + "        final %1$s parentMessage, final %2$s buffer, final int count)\n" + indent + "    {\n" + indent + "        if (count < %3$d || count > %4$d)\n" + indent + "        {\n" + indent + "            throw new IllegalArgumentException(\"count outside allowed range: count=\" + count);\n" + indent + "        }\n\n" + indent + "        this.parentMessage = parentMessage;\n" + indent + "        this.buffer = buffer;\n" + indent + "        actingVersion = SCHEMA_VERSION;\n" + indent + "        dimensions.wrap(buffer, parentMessage.limit());\n" + indent + "        dimensions.blockLength((%5$s)%6$d);\n" + indent + "        dimensions.numInGroup((%7$s)count);\n" + indent + "        index = -1;\n" + indent + "        this.count = count;\n" + indent + "        blockLength = %6$d;\n" + indent + "        parentMessage.limit(parentMessage.limit() + HEADER_SIZE);\n" + indent + "    }\n\n", parentMessageClassName, this.mutableBuffer, numInGroupToken.encoding().applicableMinValue().longValue(), numInGroupToken.encoding().applicableMaxValue().longValue(), javaTypeForBlockLength, blockLength, javaTypeForNumInGroup));
        sb.append(indent).append("    public static int sbeHeaderSize()\n").append(indent).append("    {\n").append(indent).append("        return HEADER_SIZE;\n").append(indent).append("    }\n\n");
        sb.append(String.format(indent + "    public static int sbeBlockLength()\n" + indent + "    {\n" + indent + "        return %d;\n" + indent + "    }\n\n", blockLength));
        sb.append(String.format(indent + "    public %s next()\n" + indent + "    {\n" + indent + "        if (index + 1 >= count)\n" + indent + "        {\n" + indent + "            throw new java.util.NoSuchElementException();\n" + indent + "        }\n\n" + indent + "        offset = parentMessage.limit();\n" + indent + "        parentMessage.limit(offset + blockLength);\n" + indent + "        ++index;\n\n" + indent + "        return this;\n" + indent + "    }\n", JavaUtil.formatClassName(this.encoderName(groupName))));
    }

    private static String primitiveTypeName(Token token) {
        return JavaUtil.javaTypeName(token.encoding().primitiveType());
    }

    private void generateGroupDecoderClassDeclaration(StringBuilder sb, String groupName, String parentMessageClassName, String indent, String dimensionsClassName, int dimensionHeaderSize) {
        sb.append(String.format("\n" + indent + "public static class %1$s\n" + indent + "    implements Iterable<%1$s>, java.util.Iterator<%1$s>\n" + indent + "{\n" + indent + "    private static final int HEADER_SIZE = %2$d;\n" + indent + "    private final %3$s dimensions = new %3$s();\n" + indent + "    private %4$s parentMessage;\n" + indent + "    private %5$s buffer;\n" + indent + "    private int blockLength;\n" + indent + "    private int actingVersion;\n" + indent + "    private int count;\n" + indent + "    private int index;\n" + indent + "    private int offset;\n\n", JavaUtil.formatClassName(groupName), dimensionHeaderSize, this.decoderName(dimensionsClassName), parentMessageClassName, this.readOnlyBuffer));
    }

    private void generateGroupEncoderClassDeclaration(StringBuilder sb, String groupName, String parentMessageClassName, String indent, String dimensionsClassName, int dimensionHeaderSize) {
        sb.append(String.format("\n" + indent + "public static class %1$s\n" + indent + "{\n" + indent + "    private static final int HEADER_SIZE = %2$d;\n" + indent + "    private final %3$s dimensions = new %3$s();\n" + indent + "    private %4$s parentMessage;\n" + indent + "    private %5$s buffer;\n" + indent + "    private int blockLength;\n" + indent + "    private int actingVersion;\n" + indent + "    private int count;\n" + indent + "    private int index;\n" + indent + "    private int offset;\n\n", JavaUtil.formatClassName(this.encoderName(groupName)), dimensionHeaderSize, dimensionsClassName, parentMessageClassName, this.mutableBuffer));
    }

    private static CharSequence generateGroupDecoderProperty(String groupName, Token token, String indent) {
        StringBuilder sb = new StringBuilder();
        String className = JavaUtil.formatClassName(groupName);
        String propertyName = JavaUtil.formatPropertyName(token.name());
        sb.append(String.format("\n" + indent + "    private final %s %s = new %s();\n", className, propertyName, className));
        sb.append(String.format("\n" + indent + "    public static long %sId()\n" + indent + "    {\n" + indent + "        return %d;\n" + indent + "    }\n", JavaUtil.formatPropertyName(groupName), token.id()));
        sb.append(String.format("\n" + indent + "    public %1$s %2$s()\n" + indent + "    {\n" + indent + "        %2$s.wrap(parentMessage, buffer);\n" + indent + "        return %2$s;\n" + indent + "    }\n", className, propertyName));
        return sb;
    }

    private CharSequence generateGroupEncoderProperty(String groupName, Token token, String indent) {
        StringBuilder sb = new StringBuilder();
        String className = JavaUtil.formatClassName(this.encoderName(groupName));
        String propertyName = JavaUtil.formatPropertyName(groupName);
        sb.append(String.format("\n" + indent + "    private final %s %s = new %s();\n", className, propertyName, className));
        sb.append(String.format("\n" + indent + "    public static long %sId()\n" + indent + "    {\n" + indent + "        return %d;\n" + indent + "    }\n", JavaUtil.formatPropertyName(groupName), token.id()));
        sb.append(String.format("\n" + indent + "    public %1$s %2$sCount(final int count)\n" + indent + "    {\n" + indent + "        %2$s.wrap(parentMessage, buffer, count);\n" + indent + "        return %2$s;\n" + indent + "    }\n", className, propertyName));
        return sb;
    }

    private CharSequence generateDecoderVarData(List<Token> tokens, String indent) {
        Token token;
        StringBuilder sb = new StringBuilder();
        int size = tokens.size();
        for (int i = 0; i < size; i += token.componentTokenCount()) {
            token = tokens.get(i);
            if (token.signal() != Signal.BEGIN_VAR_DATA) {
                throw new IllegalStateException("tokens must begin with BEGIN_VAR_DATA: token=" + token);
            }
            JavaGenerator.generateFieldIdMethod(sb, token, indent);
            String characterEncoding = tokens.get(i + 3).encoding().characterEncoding();
            JavaGenerator.generateCharacterEncodingMethod(sb, token.name(), characterEncoding, indent);
            JavaGenerator.generateFieldMetaAttributeMethod(sb, token, indent);
            String propertyName = JavaUtil.toUpperFirstChar(token.name());
            Token lengthToken = tokens.get(i + 2);
            int sizeOfLengthField = lengthToken.encodedLength();
            Encoding lengthEncoding = lengthToken.encoding();
            PrimitiveType lengthType = lengthEncoding.primitiveType();
            String byteOrderStr = this.byteOrderString(lengthEncoding);
            sb.append(String.format("\n" + indent + "    public static int %sHeaderLength()\n" + indent + "    {\n" + indent + "        return %d;\n" + indent + "    }\n", JavaUtil.toLowerFirstChar(propertyName), sizeOfLengthField));
            sb.append(String.format("\n" + indent + "    public int %sLength()\n" + indent + "    {\n%s" + indent + "        final int limit = parentMessage.limit();\n" + indent + "        return (int)%s;\n" + indent + "    }\n", JavaUtil.toLowerFirstChar(propertyName), JavaGenerator.generateArrayFieldNotPresentCondition(token.version(), indent), this.generateGet(lengthType, "limit", byteOrderStr)));
            this.generateDataDecodeMethods(sb, token, propertyName, sizeOfLengthField, lengthType, byteOrderStr, characterEncoding, indent);
        }
        return sb;
    }

    private CharSequence generateEncoderVarData(String className, List<Token> tokens, String indent) {
        Token token;
        StringBuilder sb = new StringBuilder();
        int size = tokens.size();
        for (int i = 0; i < size; i += token.componentTokenCount()) {
            token = tokens.get(i);
            if (token.signal() != Signal.BEGIN_VAR_DATA) {
                throw new IllegalStateException("tokens must begin with BEGIN_VAR_DATA: token=" + token);
            }
            JavaGenerator.generateFieldIdMethod(sb, token, indent);
            String characterEncoding = tokens.get(i + 3).encoding().characterEncoding();
            JavaGenerator.generateCharacterEncodingMethod(sb, token.name(), characterEncoding, indent);
            JavaGenerator.generateFieldMetaAttributeMethod(sb, token, indent);
            String propertyName = JavaUtil.toUpperFirstChar(token.name());
            Token lengthToken = tokens.get(i + 2);
            int sizeOfLengthField = lengthToken.encodedLength();
            Encoding lengthEncoding = lengthToken.encoding();
            int maxLengthValue = (int)lengthEncoding.applicableMaxValue().longValue();
            String byteOrderStr = this.byteOrderString(lengthEncoding);
            sb.append(String.format("\n" + indent + "    public static int %sHeaderLength()\n" + indent + "    {\n" + indent + "        return %d;\n" + indent + "    }\n", JavaUtil.toLowerFirstChar(propertyName), sizeOfLengthField));
            this.generateDataEncodeMethods(sb, propertyName, sizeOfLengthField, maxLengthValue, lengthEncoding.primitiveType(), byteOrderStr, characterEncoding, className, indent);
        }
        return sb;
    }

    private void generateDataDecodeMethods(StringBuilder sb, Token token, String propertyName, int sizeOfLengthField, PrimitiveType lengthType, String byteOrderStr, String characterEncoding, String indent) {
        this.generateDataTypedDecoder(sb, token, propertyName, sizeOfLengthField, this.mutableBuffer, lengthType, byteOrderStr, indent);
        this.generateDataTypedDecoder(sb, token, propertyName, sizeOfLengthField, "byte[]", lengthType, byteOrderStr, indent);
        sb.append(String.format("\n" + indent + "    public String %1$s()\n" + indent + "    {\n%2$s" + indent + "        final int headerLength = %3$d;\n" + indent + "        final int limit = parentMessage.limit();\n" + indent + "        final int dataLength = (int)%4$s;\n" + indent + "        parentMessage.limit(limit + headerLength + dataLength);\n" + indent + "        final byte[] tmp = new byte[dataLength];\n" + indent + "        buffer.getBytes(limit + headerLength, tmp, 0, dataLength);\n\n" + indent + "        final String value;\n" + indent + "        try\n" + indent + "        {\n" + indent + "            value = new String(tmp, \"%5$s\");\n" + indent + "        }\n" + indent + "        catch (final java.io.UnsupportedEncodingException ex)\n" + indent + "        {\n" + indent + "            throw new RuntimeException(ex);\n" + indent + "        }\n\n" + indent + "        return value;\n" + indent + "    }\n", JavaUtil.formatPropertyName(propertyName), JavaGenerator.generateStringNotPresentCondition(token.version(), indent), sizeOfLengthField, this.generateGet(lengthType, "limit", byteOrderStr), characterEncoding));
    }

    private void generateDataEncodeMethods(StringBuilder sb, String propertyName, int sizeOfLengthField, int maxLengthValue, PrimitiveType lengthType, String byteOrderStr, String characterEncoding, String className, String indent) {
        this.generateDataTypedEncoder(sb, className, propertyName, sizeOfLengthField, maxLengthValue, this.readOnlyBuffer, lengthType, byteOrderStr, indent);
        this.generateDataTypedEncoder(sb, className, propertyName, sizeOfLengthField, maxLengthValue, "byte[]", lengthType, byteOrderStr, indent);
        sb.append(String.format("\n" + indent + "    public %1$s %2$s(final String value)\n" + indent + "    {\n" + indent + "        final byte[] bytes;\n" + indent + "        try\n" + indent + "        {\n" + indent + "            bytes = value.getBytes(\"%3$s\");\n" + indent + "        }\n" + indent + "        catch (final java.io.UnsupportedEncodingException ex)\n" + indent + "        {\n" + indent + "            throw new RuntimeException(ex);\n" + indent + "        }\n\n" + indent + "        final int length = bytes.length;\n" + indent + "        if (length > %4$d)\n" + indent + "        {\n" + indent + "            throw new IllegalArgumentException(\"length > max value for type: \" + length);\n" + indent + "        }\n\n" + indent + "        final int headerLength = %5$d;\n" + indent + "        final int limit = parentMessage.limit();\n" + indent + "        parentMessage.limit(limit + headerLength + length);\n" + indent + "        %6$s;\n" + indent + "        buffer.putBytes(limit + headerLength, bytes, 0, length);\n\n" + indent + "        return this;\n" + indent + "    }\n", className, JavaUtil.formatPropertyName(propertyName), characterEncoding, maxLengthValue, sizeOfLengthField, this.generatePut(lengthType, "limit", "length", byteOrderStr)));
    }

    private void generateDataTypedDecoder(StringBuilder sb, Token token, String propertyName, int sizeOfLengthField, String exchangeType, PrimitiveType lengthType, String byteOrderStr, String indent) {
        sb.append(String.format("\n" + indent + "    public int get%s(final %s dst, final int dstOffset, final int length)\n" + indent + "    {\n%s" + indent + "        final int headerLength = %d;\n" + indent + "        final int limit = parentMessage.limit();\n" + indent + "        final int dataLength = (int)%s;\n" + indent + "        final int bytesCopied = Math.min(length, dataLength);\n" + indent + "        parentMessage.limit(limit + headerLength + dataLength);\n" + indent + "        buffer.getBytes(limit + headerLength, dst, dstOffset, bytesCopied);\n\n" + indent + "        return bytesCopied;\n" + indent + "    }\n", propertyName, exchangeType, JavaGenerator.generateArrayFieldNotPresentCondition(token.version(), indent), sizeOfLengthField, this.generateGet(lengthType, "limit", byteOrderStr)));
    }

    private void generateDataTypedEncoder(StringBuilder sb, String className, String propertyName, int sizeOfLengthField, int maxLengthValue, String exchangeType, PrimitiveType lengthType, String byteOrderStr, String indent) {
        sb.append(String.format("\n" + indent + "    public %1$s put%2$s(final %3$s src, final int srcOffset, final int length)\n" + indent + "    {\n" + indent + "        if (length > %4$d)\n" + indent + "        {\n" + indent + "            throw new IllegalArgumentException(\"length > max value for type: \" + length);\n" + indent + "        }\n\n" + indent + "        final int headerLength = %5$d;\n" + indent + "        final int limit = parentMessage.limit();\n" + indent + "        parentMessage.limit(limit + headerLength + length);\n" + indent + "        %6$s;\n" + indent + "        buffer.putBytes(limit + headerLength, src, srcOffset, length);\n\n" + indent + "        return this;\n" + indent + "    }\n", className, propertyName, exchangeType, maxLengthValue, sizeOfLengthField, this.generatePut(lengthType, "limit", "length", byteOrderStr)));
    }

    private void generateBitSet(List<Token> tokens) throws IOException {
        Token token = tokens.get(0);
        String bitSetName = JavaUtil.formatClassName(token.name());
        String decoderName = this.decoderName(bitSetName);
        String encoderName = this.encoderName(bitSetName);
        List<Token> messageBody = GenerationUtil.getMessageBody(tokens);
        try (Writer out = this.outputManager.createOutput(decoderName);){
            this.generateFixedFlyweightHeader(token, decoderName, out, this.readOnlyBuffer, this.fqReadOnlyBuffer, BASE_INDENT);
            out.append(this.generateChoiceDecoders(messageBody));
            out.append(this.generateChoiceDisplay(messageBody));
            out.append("}\n");
        }
        out = this.outputManager.createOutput(encoderName);
        var8_8 = null;
        try {
            this.generateFixedFlyweightHeader(token, encoderName, out, this.mutableBuffer, this.fqMutableBuffer, BASE_INDENT);
            out.append(this.generateChoiceClear(encoderName, token));
            out.append(this.generateChoiceEncoders(encoderName, messageBody));
            out.append("}\n");
        }
        catch (Throwable throwable) {
            var8_8 = throwable;
            throw throwable;
        }
        finally {
            if (out != null) {
                if (var8_8 != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable) {
                        var8_8.addSuppressed(throwable);
                    }
                } else {
                    out.close();
                }
            }
        }
    }

    private void generateFixedFlyweightHeader(Token token, String encoderName, Writer out, String buffer, String fqBuffer, String implementsString) throws IOException {
        out.append(this.generateFileHeader(encoderName, this.ir.applicableNamespace(), fqBuffer));
        out.append(JavaGenerator.generateDeclaration("class", encoderName, implementsString));
        out.append(JavaGenerator.generateFixedFlyweightCode(encoderName, token.encodedLength(), false, buffer));
    }

    private void generateEnum(List<Token> tokens) throws IOException {
        String enumName = JavaUtil.formatClassName(tokens.get(0).name());
        try (Writer out = this.outputManager.createOutput(enumName);){
            out.append(JavaGenerator.generateEnumFileHeader(enumName, this.ir.applicableNamespace()));
            out.append(JavaGenerator.generateEnumDeclaration(enumName));
            out.append(this.generateEnumValues(GenerationUtil.getMessageBody(tokens)));
            out.append(this.generateEnumBody(tokens.get(0), enumName));
            out.append(this.generateEnumLookupMethod(GenerationUtil.getMessageBody(tokens), enumName));
            out.append("}\n");
        }
    }

    private void generateComposite(List<Token> tokens) throws IOException {
        String typeName;
        String propertyName;
        Token encodingToken;
        int i;
        int end;
        String implementsString;
        Token token = tokens.get(0);
        String compositeName = JavaUtil.formatClassName(token.name());
        String decoderName = this.decoderName(compositeName);
        String encoderName = this.encoderName(compositeName);
        try (Writer out = this.outputManager.createOutput(decoderName);){
            implementsString = this.implementsInterface(GEN_COMPOSITE_DECODER_FLYWEIGHT);
            this.generateFixedFlyweightHeader(token, decoderName, out, this.readOnlyBuffer, this.fqReadOnlyBuffer, implementsString);
            end = tokens.size() - 1;
            block30: for (i = 1; i < end; ++i) {
                encodingToken = tokens.get(i);
                propertyName = JavaUtil.formatPropertyName(encodingToken.name());
                typeName = JavaUtil.formatClassName(this.decoderName(encodingToken.name()));
                switch (encodingToken.signal()) {
                    case ENCODING: {
                        out.append(this.generatePrimitiveDecoder(encodingToken.name(), encodingToken, BASE_INDENT));
                        continue block30;
                    }
                    case BEGIN_ENUM: {
                        out.append(this.generateEnumDecoder(encodingToken, propertyName, encodingToken, BASE_INDENT));
                        continue block30;
                    }
                    case BEGIN_SET: {
                        out.append(this.generateBitSetProperty(propertyName, encodingToken, BASE_INDENT, typeName));
                        continue block30;
                    }
                    case BEGIN_COMPOSITE: {
                        out.append(this.generateCompositeProperty(propertyName, encodingToken, BASE_INDENT, typeName));
                        i += encodingToken.componentTokenCount();
                    }
                }
            }
            out.append(this.generateCompositeDecoderDisplay(tokens, BASE_INDENT));
            out.append("}\n");
        }
        out = this.outputManager.createOutput(encoderName);
        var7_7 = null;
        try {
            implementsString = this.implementsInterface(GEN_COMPOSITE_ENCODER_FLYWEIGHT);
            this.generateFixedFlyweightHeader(token, encoderName, out, this.mutableBuffer, this.fqMutableBuffer, implementsString);
            end = tokens.size() - 1;
            block31: for (i = 1; i < end; ++i) {
                encodingToken = tokens.get(i);
                propertyName = JavaUtil.formatPropertyName(encodingToken.name());
                typeName = JavaUtil.formatClassName(this.encoderName(encodingToken.name()));
                switch (encodingToken.signal()) {
                    case ENCODING: {
                        out.append(this.generatePrimitiveEncoder(encoderName, encodingToken.name(), encodingToken, BASE_INDENT));
                        continue block31;
                    }
                    case BEGIN_ENUM: {
                        out.append(this.generateEnumEncoder(encoderName, propertyName, encodingToken, BASE_INDENT));
                        continue block31;
                    }
                    case BEGIN_SET: {
                        out.append(this.generateBitSetProperty(propertyName, encodingToken, BASE_INDENT, typeName));
                        continue block31;
                    }
                    case BEGIN_COMPOSITE: {
                        out.append(this.generateCompositeProperty(propertyName, encodingToken, BASE_INDENT, typeName));
                        i += encodingToken.componentTokenCount();
                    }
                }
            }
            out.append(this.generateCompositeEncoderDisplay(decoderName, BASE_INDENT));
            out.append("}\n");
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
        finally {
            if (out != null) {
                if (var7_7 != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable) {
                        var7_7.addSuppressed(throwable);
                    }
                } else {
                    out.close();
                }
            }
        }
    }

    private CharSequence generateChoiceClear(String bitSetClassName, Token token) {
        StringBuilder sb = new StringBuilder();
        Encoding encoding = token.encoding();
        String literalValue = this.generateLiteral(encoding.primitiveType(), "0");
        String byteOrderStr = this.byteOrderString(encoding);
        sb.append(String.format("\n    public %s clear()\n    {\n        %s;\n        return this;\n    }\n", bitSetClassName, this.generatePut(encoding.primitiveType(), "offset", literalValue, byteOrderStr)));
        return sb;
    }

    private CharSequence generateChoiceDecoders(List<Token> tokens) {
        return GenerationUtil.concatTokens(tokens, Signal.CHOICE, token -> {
            String choiceName = JavaUtil.formatPropertyName(token.name());
            Encoding encoding = token.encoding();
            String choiceBitIndex = encoding.constValue().toString();
            String byteOrderStr = this.byteOrderString(encoding);
            return String.format("\n    public boolean %s()\n    {\n        return %s;\n    }\n", choiceName, this.generateChoiceGet(encoding.primitiveType(), "offset", choiceBitIndex, byteOrderStr));
        });
    }

    private CharSequence generateChoiceEncoders(String bitSetClassName, List<Token> tokens) {
        return GenerationUtil.concatTokens(tokens, Signal.CHOICE, token -> {
            String choiceName = JavaUtil.formatPropertyName(token.name());
            Encoding encoding = token.encoding();
            String choiceBitIndex = encoding.constValue().toString();
            String byteOrderStr = this.byteOrderString(encoding);
            return String.format("\n    public %s %s(final boolean value)\n    {\n%s\n        return this;\n    }\n", bitSetClassName, choiceName, this.generateChoicePut(encoding.primitiveType(), "offset", choiceBitIndex, byteOrderStr));
        });
    }

    private CharSequence generateEnumValues(List<Token> tokens) {
        StringBuilder sb = new StringBuilder();
        for (Token token : tokens) {
            Encoding encoding = token.encoding();
            String constVal = this.generateLiteral(encoding.primitiveType(), encoding.constValue().toString());
            sb.append(INDENT).append(token.name()).append('(').append((CharSequence)constVal).append("),\n");
        }
        Token token = tokens.get(0);
        Encoding encoding = token.encoding();
        String nullVal = this.generateLiteral(encoding.primitiveType(), encoding.applicableNullValue().toString());
        sb.append(INDENT).append("NULL_VAL").append('(').append((CharSequence)nullVal).append(')');
        sb.append(";\n\n");
        return sb;
    }

    private CharSequence generateEnumBody(Token token, String enumName) {
        String javaEncodingType = JavaGenerator.primitiveTypeName(token);
        return String.format("    private final %1$s value;\n\n    %2$s(final %1$s value)\n    {\n        this.value = value;\n    }\n\n    public %1$s value()\n    {\n        return value;\n    }\n\n", javaEncodingType, enumName);
    }

    private CharSequence generateEnumLookupMethod(List<Token> tokens, String enumName) {
        StringBuilder sb = new StringBuilder();
        PrimitiveType primitiveType = tokens.get(0).encoding().primitiveType();
        sb.append(String.format("    public static %s get(final %s value)\n    {\n        switch (value)\n        {\n", enumName, JavaUtil.javaTypeName(primitiveType)));
        for (Token token : tokens) {
            sb.append(String.format("            case %s: return %s;\n", token.encoding().constValue().toString(), token.name()));
        }
        sb.append(String.format("        }\n\n        if (%s == value)\n        {\n            return NULL_VAL;\n        }\n\n        throw new IllegalArgumentException(\"Unknown value: \" + value);\n    }\n", this.generateLiteral(primitiveType, tokens.get(0).encoding().applicableNullValue().toString())));
        return sb;
    }

    private CharSequence interfaceImportLine() {
        if (!this.shouldGenerateInterfaces) {
            return "\n";
        }
        return String.format("import %s.*;\n\n", "org.agrona.sbe");
    }

    private CharSequence generateFileHeader(String className, String packageName, String fqBuffer) {
        return String.format("/* Generated SBE (Simple Binary Encoding) message codec */\npackage %s;\n\nimport %s;\n%s@javax.annotation.Generated(value = {\"%s.%s\"})\n", packageName, fqBuffer, this.interfaceImportLine(), packageName, className);
    }

    private CharSequence generateMainHeader(String className, String packageName) {
        if (this.fqMutableBuffer.equals(this.fqReadOnlyBuffer)) {
            return String.format("/* Generated SBE (Simple Binary Encoding) message codec */\npackage %s;\n\nimport %s;\n%s@javax.annotation.Generated(value = {\"%s.%s\"})\n", packageName, this.fqMutableBuffer, this.interfaceImportLine(), packageName, className);
        }
        return String.format("/* Generated SBE (Simple Binary Encoding) message codec */\npackage %s;\n\nimport %s;\nimport %s;\n%s@javax.annotation.Generated(value = {\"%s.%s\"})\n", packageName, this.fqMutableBuffer, this.fqReadOnlyBuffer, this.interfaceImportLine(), packageName, className);
    }

    private static CharSequence generateEnumFileHeader(String className, String packageName) {
        return String.format("/* Generated SBE (Simple Binary Encoding) message codec */\npackage %s;\n\n@javax.annotation.Generated(value = {\"%s.%s\"})\n", packageName, packageName, className);
    }

    private void generateAnnotations(String indent, String className, List<Token> tokens, Appendable out, int index, Function<String, String> nameMapping) throws IOException {
        if (this.shouldGenerateGroupOrderAnnotation) {
            ArrayList<String> groupClassNames = new ArrayList<String>();
            int level = 0;
            int size = tokens.size();
            while (index < size) {
                if (tokens.get(index).signal() == Signal.BEGIN_GROUP) {
                    if (++level == 1) {
                        Token groupToken = tokens.get(index);
                        String groupName = groupToken.name();
                        groupClassNames.add(JavaUtil.formatClassName(nameMapping.apply(groupName)));
                    }
                } else if (tokens.get(index).signal() == Signal.END_GROUP && --level < 0) break;
                ++index;
            }
            if (!groupClassNames.isEmpty()) {
                out.append(indent).append("@uk.co.real_logic.sbe.codec.java.GroupOrder({");
                index = 0;
                for (String name : groupClassNames) {
                    out.append(className).append('.').append(name).append(".class");
                    if (++index >= groupClassNames.size()) continue;
                    out.append(", ");
                }
                out.append("})\n");
            }
        }
    }

    private static CharSequence generateDeclaration(String classType, String className, String implementsString) {
        return String.format("@SuppressWarnings(\"all\")\npublic %s %s%s\n{\n", classType, className, implementsString);
    }

    private void generateMetaAttributeEnum() throws IOException {
        try (Writer out = this.outputManager.createOutput(META_ATTRIBUTE_ENUM);){
            out.append(String.format("/* Generated SBE (Simple Binary Encoding) message codec */\npackage %s;\n\n@javax.annotation.Generated(value = {\"%s.MetaAttribute\"})\npublic enum MetaAttribute\n{\n    EPOCH,\n    TIME_UNIT,\n    SEMANTIC_TYPE\n}\n", this.ir.applicableNamespace(), this.ir.applicableNamespace()));
        }
    }

    private static CharSequence generateEnumDeclaration(String name) {
        return "public enum " + name + "\n{\n";
    }

    private CharSequence generatePrimitiveDecoder(String propertyName, Token token, String indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.generatePrimitiveFieldMetaData(propertyName, token, indent));
        if (token.isConstantEncoding()) {
            sb.append(this.generateConstPropertyMethods(propertyName, token, indent));
        } else {
            sb.append(this.generatePrimitivePropertyDecodeMethods(propertyName, token, indent));
        }
        return sb;
    }

    private CharSequence generatePrimitiveEncoder(String containingClassName, String propertyName, Token token, String indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.generatePrimitiveFieldMetaData(propertyName, token, indent));
        if (token.isConstantEncoding()) {
            sb.append(this.generateConstPropertyMethods(propertyName, token, indent));
        } else {
            sb.append(this.generatePrimitivePropertyEncodeMethods(containingClassName, propertyName, token, indent));
        }
        return sb;
    }

    private CharSequence generatePrimitivePropertyDecodeMethods(String propertyName, Token token, String indent) {
        return token.matchOnLength(() -> this.generatePrimitivePropertyDecode(propertyName, token, indent), () -> this.generatePrimitiveArrayPropertyDecode(propertyName, token, indent));
    }

    private CharSequence generatePrimitivePropertyEncodeMethods(String containingClassName, String propertyName, Token token, String indent) {
        return token.matchOnLength(() -> this.generatePrimitivePropertyEncode(containingClassName, propertyName, token, indent), () -> this.generatePrimitiveArrayPropertyEncode(containingClassName, propertyName, token, indent));
    }

    private CharSequence generatePrimitiveFieldMetaData(String propertyName, Token token, String indent) {
        StringBuilder sb = new StringBuilder();
        PrimitiveType primitiveType = token.encoding().primitiveType();
        String javaTypeName = JavaUtil.javaTypeName(primitiveType);
        sb.append(String.format("\n" + indent + "    public static %s %sNullValue()\n" + indent + "    {\n" + indent + "        return %s;\n" + indent + "    }\n", javaTypeName, propertyName, this.generateLiteral(primitiveType, token.encoding().applicableNullValue().toString())));
        sb.append(String.format("\n" + indent + "    public static %s %sMinValue()\n" + indent + "    {\n" + indent + "        return %s;\n" + indent + "    }\n", javaTypeName, propertyName, this.generateLiteral(primitiveType, token.encoding().applicableMinValue().toString())));
        sb.append(String.format("\n" + indent + "    public static %s %sMaxValue()\n" + indent + "    {\n" + indent + "        return %s;\n" + indent + "    }\n", javaTypeName, propertyName, this.generateLiteral(primitiveType, token.encoding().applicableMaxValue().toString())));
        return sb;
    }

    private CharSequence generatePrimitivePropertyDecode(String propertyName, Token token, String indent) {
        Encoding encoding = token.encoding();
        String javaTypeName = JavaUtil.javaTypeName(encoding.primitiveType());
        int offset = token.offset();
        String byteOrderStr = this.byteOrderString(encoding);
        return String.format("\n" + indent + "    public %s %s()\n" + indent + "    {\n%s" + indent + "        return %s;\n" + indent + "    }\n\n", javaTypeName, propertyName, this.generateFieldNotPresentCondition(token.version(), encoding, indent), this.generateGet(encoding.primitiveType(), "offset + " + offset, byteOrderStr));
    }

    private CharSequence generatePrimitivePropertyEncode(String containingClassName, String propertyName, Token token, String indent) {
        Encoding encoding = token.encoding();
        String javaTypeName = JavaUtil.javaTypeName(encoding.primitiveType());
        int offset = token.offset();
        String byteOrderStr = this.byteOrderString(encoding);
        return String.format("\n" + indent + "    public %s %s(final %s value)\n" + indent + "    {\n" + indent + "        %s;\n" + indent + "        return this;\n" + indent + "    }\n\n", JavaUtil.formatClassName(containingClassName), propertyName, javaTypeName, this.generatePut(encoding.primitiveType(), "offset + " + offset, "value", byteOrderStr));
    }

    private CharSequence generateFieldNotPresentCondition(int sinceVersion, Encoding encoding, String indent) {
        if (0 == sinceVersion) {
            return BASE_INDENT;
        }
        return String.format(indent + "        if (actingVersion < %d)\n" + indent + "        {\n" + indent + "            return %s;\n" + indent + "        }\n\n", sinceVersion, this.generateLiteral(encoding.primitiveType(), encoding.applicableNullValue().toString()));
    }

    private static CharSequence generateArrayFieldNotPresentCondition(int sinceVersion, String indent) {
        if (0 == sinceVersion) {
            return BASE_INDENT;
        }
        return String.format(indent + "        if (actingVersion < %d)\n" + indent + "        {\n" + indent + "            return 0;\n" + indent + "        }\n\n", sinceVersion);
    }

    private static CharSequence generateStringNotPresentCondition(int sinceVersion, String indent) {
        if (0 == sinceVersion) {
            return BASE_INDENT;
        }
        return String.format(indent + "        if (actingVersion < %d)\n" + indent + "        {\n" + indent + "            return \"\";\n" + indent + "        }\n\n", sinceVersion);
    }

    private static CharSequence generateTypeFieldNotPresentCondition(int sinceVersion, String indent) {
        if (0 == sinceVersion) {
            return BASE_INDENT;
        }
        return String.format(indent + "        if (actingVersion < %d)\n" + indent + "        {\n" + indent + "            return null;\n" + indent + "        }\n\n", sinceVersion);
    }

    private CharSequence generatePrimitiveArrayPropertyDecode(String propertyName, Token token, String indent) {
        Encoding encoding = token.encoding();
        String javaTypeName = JavaUtil.javaTypeName(encoding.primitiveType());
        int offset = token.offset();
        String byteOrderStr = this.byteOrderString(encoding);
        int fieldLength = token.arrayLength();
        int typeSize = JavaGenerator.sizeOfPrimitive(encoding);
        StringBuilder sb = new StringBuilder();
        JavaGenerator.generateArrayLengthMethod(propertyName, indent, fieldLength, sb);
        sb.append(String.format(indent + "    public %s %s(final int index)\n" + indent + "    {\n" + indent + "        if (index < 0 || index >= %d)\n" + indent + "        {\n" + indent + "            throw new IndexOutOfBoundsException(\"index out of range: index=\" + index);\n" + indent + "        }\n\n%s" + indent + "        final int pos = this.offset + %d + (index * %d);\n\n" + indent + "        return %s;\n" + indent + "    }\n\n", javaTypeName, propertyName, fieldLength, this.generateFieldNotPresentCondition(token.version(), encoding, indent), offset, typeSize, this.generateGet(encoding.primitiveType(), "pos", byteOrderStr)));
        if (encoding.primitiveType() == PrimitiveType.CHAR) {
            JavaGenerator.generateCharacterEncodingMethod(sb, propertyName, encoding.characterEncoding(), indent);
            sb.append(String.format("\n" + indent + "    public int get%s(final byte[] dst, final int dstOffset)\n" + indent + "    {\n" + indent + "        final int length = %d;\n" + indent + "        if (dstOffset < 0 || dstOffset > (dst.length - length))\n" + indent + "        {\n" + indent + "            throw new IndexOutOfBoundsException(\"dstOffset out of range for copy: offset=\" + dstOffset);\n" + indent + "        }\n\n%s" + indent + "        buffer.getBytes(this.offset + %d, dst, dstOffset, length);\n\n" + indent + "        return length;\n" + indent + "    }\n\n", JavaUtil.toUpperFirstChar(propertyName), fieldLength, JavaGenerator.generateArrayFieldNotPresentCondition(token.version(), indent), offset));
        }
        return sb;
    }

    private static void generateArrayLengthMethod(String propertyName, String indent, int fieldLength, StringBuilder sb) {
        sb.append(String.format("\n" + indent + "    public static int %sLength()\n" + indent + "    {\n" + indent + "        return %d;\n" + indent + "    }\n\n", propertyName, fieldLength));
    }

    private String byteOrderString(Encoding encoding) {
        return JavaGenerator.sizeOfPrimitive(encoding) == 1 ? BASE_INDENT : ", java.nio.ByteOrder." + encoding.byteOrder();
    }

    private CharSequence generatePrimitiveArrayPropertyEncode(String containingClassName, String propertyName, Token token, String indent) {
        Encoding encoding = token.encoding();
        String javaTypeName = JavaUtil.javaTypeName(encoding.primitiveType());
        int offset = token.offset();
        String byteOrderStr = this.byteOrderString(encoding);
        int fieldLength = token.arrayLength();
        int typeSize = JavaGenerator.sizeOfPrimitive(encoding);
        StringBuilder sb = new StringBuilder();
        JavaGenerator.generateArrayLengthMethod(propertyName, indent, fieldLength, sb);
        sb.append(String.format(indent + "    public void %s(final int index, final %s value)\n" + indent + "    {\n" + indent + "        if (index < 0 || index >= %d)\n" + indent + "        {\n" + indent + "            throw new IndexOutOfBoundsException(\"index out of range: index=\" + index);\n" + indent + "        }\n\n" + indent + "        final int pos = this.offset + %d + (index * %d);\n" + indent + "        %s;\n" + indent + "    }\n", propertyName, javaTypeName, fieldLength, offset, typeSize, this.generatePut(encoding.primitiveType(), "pos", "value", byteOrderStr)));
        if (encoding.primitiveType() == PrimitiveType.CHAR) {
            JavaGenerator.generateCharacterEncodingMethod(sb, propertyName, encoding.characterEncoding(), indent);
            sb.append(String.format(indent + "    public %s put%s(final byte[] src, final int srcOffset)\n" + indent + "    {\n" + indent + "        final int length = %d;\n" + indent + "        if (srcOffset < 0 || srcOffset > (src.length - length))\n" + indent + "        {\n" + indent + "            throw new IndexOutOfBoundsException(\"srcOffset out of range for copy: offset=\" + srcOffset);\n" + indent + "        }\n\n" + indent + "        buffer.putBytes(this.offset + %d, src, srcOffset, length);\n\n" + indent + "        return this;\n" + indent + "    }\n", JavaUtil.formatClassName(containingClassName), JavaUtil.toUpperFirstChar(propertyName), fieldLength, offset));
        }
        return sb;
    }

    private static int sizeOfPrimitive(Encoding encoding) {
        return encoding.primitiveType().size();
    }

    private static void generateCharacterEncodingMethod(StringBuilder sb, String propertyName, String encoding, String indent) {
        sb.append(String.format("\n" + indent + "    public static String %sCharacterEncoding()\n" + indent + "    {\n" + indent + "        return \"%s\";\n" + indent + "    }\n", JavaUtil.formatPropertyName(propertyName), encoding));
    }

    private CharSequence generateConstPropertyMethods(String propertyName, Token token, String indent) {
        Encoding encoding = token.encoding();
        if (encoding.primitiveType() != PrimitiveType.CHAR) {
            return String.format("\n" + indent + "    public %s %s()\n" + indent + "    {\n" + indent + "        return %s;\n" + indent + "    }\n", JavaUtil.javaTypeName(encoding.primitiveType()), propertyName, this.generateLiteral(encoding.primitiveType(), encoding.constValue().toString()));
        }
        StringBuilder sb = new StringBuilder();
        String javaTypeName = JavaUtil.javaTypeName(encoding.primitiveType());
        byte[] constantValue = encoding.constValue().byteArrayValue(encoding.primitiveType());
        CharSequence values = JavaGenerator.generateByteLiteralList(encoding.constValue().byteArrayValue(encoding.primitiveType()));
        sb.append(String.format("\n" + indent + "    private static final byte[] %s_VALUE = {%s};\n", propertyName.toUpperCase(), values));
        JavaGenerator.generateArrayLengthMethod(propertyName, indent, constantValue.length, sb);
        sb.append(String.format(indent + "    public %s %s(final int index)\n" + indent + "    {\n" + indent + "        return %s_VALUE[index];\n" + indent + "    }\n\n", javaTypeName, propertyName, propertyName.toUpperCase()));
        sb.append(String.format(indent + "    public int get%s(final byte[] dst, final int offset, final int length)\n" + indent + "    {\n" + indent + "        final int bytesCopied = Math.min(length, %d);\n" + indent + "        System.arraycopy(%s_VALUE, 0, dst, offset, bytesCopied);\n\n" + indent + "        return bytesCopied;\n" + indent + "    }\n", JavaUtil.toUpperFirstChar(propertyName), constantValue.length, propertyName.toUpperCase()));
        return sb;
    }

    private static CharSequence generateByteLiteralList(byte[] bytes) {
        StringBuilder values = new StringBuilder();
        for (byte b : bytes) {
            values.append(b).append(", ");
        }
        if (values.length() > 0) {
            values.setLength(values.length() - 2);
        }
        return values;
    }

    private static CharSequence generateFixedFlyweightCode(String className, int size, boolean callsSuper, String bufferImplementation) {
        String body = callsSuper ? "        super.wrap(buffer, offset);\n" : BASE_INDENT;
        return String.format("    public static final int ENCODED_LENGTH = %2$d;\n    private %3$s buffer;\n    private int offset;\n\n    public %1$s wrap(final %3$s buffer, final int offset)\n    {\n        this.buffer = buffer;\n%4$s        this.offset = offset;\n\n        return this;\n    }\n\n    public int encodedLength()\n    {\n        return ENCODED_LENGTH;\n    }\n", className, size, bufferImplementation, body);
    }

    private CharSequence generateDecoderFlyweightCode(String className, Token token) {
        String wrapMethod = String.format("    public %1$s wrap(\n        final %2$s buffer, final int offset, final int actingBlockLength, final int actingVersion)\n    {\n        this.buffer = buffer;\n        this.offset = offset;\n        this.actingBlockLength = actingBlockLength;\n        this.actingVersion = actingVersion;\n        limit(offset + actingBlockLength);\n\n        return this;\n    }\n\n", className, this.readOnlyBuffer);
        return this.generateFlyweightCode(className, token, wrapMethod, this.readOnlyBuffer);
    }

    private CharSequence generateFlyweightCode(String className, Token token, String wrapMethod, String bufferImplementation) {
        HeaderStructure headerStructure = this.ir.headerStructure();
        String blockLengthType = JavaUtil.javaTypeName(headerStructure.blockLengthType());
        String templateIdType = JavaUtil.javaTypeName(headerStructure.templateIdType());
        String schemaIdType = JavaUtil.javaTypeName(headerStructure.schemaIdType());
        String schemaVersionType = JavaUtil.javaTypeName(headerStructure.schemaVersionType());
        String semanticType = token.encoding().semanticType() == null ? BASE_INDENT : token.encoding().semanticType();
        return String.format("    public static final %1$s BLOCK_LENGTH = %2$s;\n    public static final %3$s TEMPLATE_ID = %4$s;\n    public static final %5$s SCHEMA_ID = %6$s;\n    public static final %7$s SCHEMA_VERSION = %8$s;\n\n    private final %9$s parentMessage = this;\n    private %11$s buffer;\n    protected int offset;\n    protected int limit;\n    protected int actingBlockLength;\n    protected int actingVersion;\n\n    public %1$s sbeBlockLength()\n    {\n        return BLOCK_LENGTH;\n    }\n\n    public %3$s sbeTemplateId()\n    {\n        return TEMPLATE_ID;\n    }\n\n    public %5$s sbeSchemaId()\n    {\n        return SCHEMA_ID;\n    }\n\n    public %7$s sbeSchemaVersion()\n    {\n        return SCHEMA_VERSION;\n    }\n\n    public String sbeSemanticType()\n    {\n        return \"%10$s\";\n    }\n\n    public int offset()\n    {\n        return offset;\n    }\n\n%12$s    public int encodedLength()\n    {\n        return limit - offset;\n    }\n\n    public int limit()\n    {\n        return limit;\n    }\n\n    public void limit(final int limit)\n    {\n        this.limit = limit;\n    }\n", blockLengthType, this.generateLiteral(headerStructure.blockLengthType(), Integer.toString(token.encodedLength())), templateIdType, this.generateLiteral(headerStructure.templateIdType(), Integer.toString(token.id())), schemaIdType, this.generateLiteral(headerStructure.schemaIdType(), Integer.toString(this.ir.id())), schemaVersionType, this.generateLiteral(headerStructure.schemaVersionType(), Integer.toString(token.version())), className, semanticType, bufferImplementation, wrapMethod);
    }

    private CharSequence generateEncoderFlyweightCode(String className, Token token) {
        String wrapMethod = String.format("    public %1$s wrap(final %2$s buffer, final int offset)\n    {\n        this.buffer = buffer;\n        this.offset = offset;\n        limit(offset + BLOCK_LENGTH);\n\n        return this;\n    }\n\n", className, this.mutableBuffer);
        return this.generateFlyweightCode(className, token, wrapMethod, this.mutableBuffer);
    }

    private CharSequence generateEncoderFields(String containingClassName, List<Token> tokens, String indent) {
        StringBuilder sb = new StringBuilder();
        JavaGenerator.eachField(tokens, (fieldToken, typeToken) -> {
            String propertyName = JavaUtil.formatPropertyName(fieldToken.name());
            String typeName = JavaUtil.formatClassName(this.encoderName(typeToken.name()));
            switch (typeToken.signal()) {
                case ENCODING: {
                    sb.append(this.generatePrimitiveEncoder(containingClassName, propertyName, (Token)typeToken, indent));
                    break;
                }
                case BEGIN_ENUM: {
                    sb.append(this.generateEnumEncoder(containingClassName, propertyName, (Token)typeToken, indent));
                    break;
                }
                case BEGIN_SET: {
                    sb.append(this.generateBitSetProperty(propertyName, (Token)typeToken, indent, typeName));
                    break;
                }
                case BEGIN_COMPOSITE: {
                    sb.append(this.generateCompositeProperty(propertyName, (Token)typeToken, indent, typeName));
                }
            }
        });
        return sb;
    }

    private CharSequence generateDecoderFields(List<Token> tokens, String indent) {
        StringBuilder sb = new StringBuilder();
        JavaGenerator.eachField(tokens, (fieldToken, typeToken) -> {
            String propertyName = JavaUtil.formatPropertyName(fieldToken.name());
            String typeName = this.decoderName(JavaUtil.formatClassName(typeToken.name()));
            JavaGenerator.generateFieldIdMethod(sb, fieldToken, indent);
            JavaGenerator.generateFieldMetaAttributeMethod(sb, fieldToken, indent);
            switch (typeToken.signal()) {
                case ENCODING: {
                    sb.append(this.generatePrimitiveDecoder(propertyName, (Token)typeToken, indent));
                    break;
                }
                case BEGIN_ENUM: {
                    sb.append(this.generateEnumDecoder((Token)fieldToken, propertyName, (Token)typeToken, indent));
                    break;
                }
                case BEGIN_SET: {
                    sb.append(this.generateBitSetProperty(propertyName, (Token)typeToken, indent, typeName));
                    break;
                }
                case BEGIN_COMPOSITE: {
                    sb.append(this.generateCompositeProperty(propertyName, (Token)typeToken, indent, typeName));
                }
            }
        });
        return sb;
    }

    private static void eachField(List<Token> tokens, BiConsumer<Token, Token> consumer) {
        int i = 0;
        int size = tokens.size();
        while (i < size) {
            Token fieldToken = tokens.get(i);
            if (fieldToken.signal() == Signal.BEGIN_FIELD) {
                Token encodingToken = tokens.get(i + 1);
                consumer.accept(fieldToken, encodingToken);
                i += fieldToken.componentTokenCount();
                continue;
            }
            ++i;
        }
    }

    private static void generateFieldIdMethod(StringBuilder sb, Token token, String indent) {
        sb.append(String.format("\n" + indent + "    public static int %sId()\n" + indent + "    {\n" + indent + "        return %d;\n" + indent + "    }\n", JavaUtil.formatPropertyName(token.name()), token.id()));
    }

    private static void generateFieldMetaAttributeMethod(StringBuilder sb, Token token, String indent) {
        Encoding encoding = token.encoding();
        String epoch = encoding.epoch() == null ? BASE_INDENT : encoding.epoch();
        String timeUnit = encoding.timeUnit() == null ? BASE_INDENT : encoding.timeUnit();
        String semanticType = encoding.semanticType() == null ? BASE_INDENT : encoding.semanticType();
        sb.append(String.format("\n" + indent + "    public static String %sMetaAttribute(final MetaAttribute metaAttribute)\n" + indent + "    {\n" + indent + "        switch (metaAttribute)\n" + indent + "        {\n" + indent + "            case EPOCH: return \"%s\";\n" + indent + "            case TIME_UNIT: return \"%s\";\n" + indent + "            case SEMANTIC_TYPE: return \"%s\";\n" + indent + "        }\n\n" + indent + "        return \"\";\n" + indent + "    }\n", JavaUtil.formatPropertyName(token.name()), epoch, timeUnit, semanticType));
    }

    private CharSequence generateEnumDecoder(Token signalToken, String propertyName, Token token, String indent) {
        String enumName = JavaUtil.formatClassName(token.name());
        Encoding encoding = token.encoding();
        if (token.isConstantEncoding()) {
            return String.format("\n" + indent + "    public %s %s()\n" + indent + "    {\n" + indent + "        return %s;\n" + indent + "    }\n\n", enumName, propertyName, signalToken.encoding().constValue().toString());
        }
        return String.format("\n" + indent + "    public %s %s()\n" + indent + "    {\n%s" + indent + "        return %s.get(%s);\n" + indent + "    }\n\n", enumName, propertyName, JavaGenerator.generateTypeFieldNotPresentCondition(token.version(), indent), enumName, this.generateGet(encoding.primitiveType(), "offset + " + token.offset(), this.byteOrderString(encoding)));
    }

    private CharSequence generateEnumEncoder(String containingClassName, String propertyName, Token token, String indent) {
        if (token.isConstantEncoding()) {
            return BASE_INDENT;
        }
        String enumName = JavaUtil.formatClassName(token.name());
        Encoding encoding = token.encoding();
        int offset = token.offset();
        return String.format(indent + "    public %s %s(final %s value)\n" + indent + "    {\n" + indent + "        %s;\n" + indent + "        return this;\n" + indent + "    }\n", JavaUtil.formatClassName(containingClassName), propertyName, enumName, this.generatePut(encoding.primitiveType(), "offset + " + offset, "value.value()", this.byteOrderString(encoding)));
    }

    private CharSequence generateBitSetProperty(String propertyName, Token token, String indent, String bitSetName) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("\n" + indent + "    private final %s %s = new %s();\n", bitSetName, propertyName, bitSetName));
        sb.append(String.format("\n" + indent + "    public %s %s()\n" + indent + "    {\n%s" + indent + "        %s.wrap(buffer, offset + %d);\n" + indent + "        return %s;\n" + indent + "    }\n", bitSetName, propertyName, JavaGenerator.generateTypeFieldNotPresentCondition(token.version(), indent), propertyName, token.offset(), propertyName));
        return sb;
    }

    private CharSequence generateCompositeProperty(String propertyName, Token token, String indent, String compositeName) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("\n" + indent + "    private final %s %s = new %s();\n", compositeName, propertyName, compositeName));
        sb.append(String.format("\n" + indent + "    public %s %s()\n" + indent + "    {\n%s" + indent + "        %s.wrap(buffer, offset + %d);\n" + indent + "        return %s;\n" + indent + "    }\n", compositeName, propertyName, JavaGenerator.generateTypeFieldNotPresentCondition(token.version(), indent), propertyName, token.offset(), propertyName));
        return sb;
    }

    private String generateLiteral(PrimitiveType type, String value) {
        String literal = BASE_INDENT;
        String castType = JavaUtil.javaTypeName(type);
        switch (type) {
            case CHAR: 
            case UINT8: 
            case INT8: 
            case INT16: {
                literal = "(" + castType + ")" + value;
                break;
            }
            case UINT16: 
            case INT32: {
                literal = value;
                break;
            }
            case UINT32: {
                literal = value + "L";
                break;
            }
            case FLOAT: {
                literal = value.endsWith("NaN") ? "Float.NaN" : value + "f";
                break;
            }
            case INT64: {
                literal = value + "L";
                break;
            }
            case UINT64: {
                literal = "0x" + Long.toHexString(Long.parseLong(value)) + "L";
                break;
            }
            case DOUBLE: {
                literal = value.endsWith("NaN") ? "Double.NaN" : value + "d";
            }
        }
        return literal;
    }

    private String generateGet(PrimitiveType type, String index, String byteOrder) {
        switch (type) {
            case CHAR: 
            case INT8: {
                return "buffer.getByte(" + index + ")";
            }
            case UINT8: {
                return "((short)(buffer.getByte(" + index + ") & 0xFF))";
            }
            case INT16: {
                return "buffer.getShort(" + index + byteOrder + ")";
            }
            case UINT16: {
                return "(buffer.getShort(" + index + byteOrder + ") & 0xFFFF)";
            }
            case INT32: {
                return "buffer.getInt(" + index + byteOrder + ")";
            }
            case UINT32: {
                return "(buffer.getInt(" + index + byteOrder + ") & 0xFFFF_FFFFL)";
            }
            case FLOAT: {
                return "buffer.getFloat(" + index + byteOrder + ")";
            }
            case INT64: 
            case UINT64: {
                return "buffer.getLong(" + index + byteOrder + ")";
            }
            case DOUBLE: {
                return "buffer.getDouble(" + index + byteOrder + ")";
            }
        }
        throw new IllegalArgumentException("primitive type not supported: " + (Object)((Object)type));
    }

    private String generatePut(PrimitiveType type, String index, String value, String byteOrder) {
        switch (type) {
            case CHAR: 
            case INT8: {
                return "buffer.putByte(" + index + ", " + value + ")";
            }
            case UINT8: {
                return "buffer.putByte(" + index + ", (byte)" + value + ")";
            }
            case INT16: {
                return "buffer.putShort(" + index + ", " + value + byteOrder + ")";
            }
            case UINT16: {
                return "buffer.putShort(" + index + ", (short)" + value + byteOrder + ")";
            }
            case INT32: {
                return "buffer.putInt(" + index + ", " + value + byteOrder + ")";
            }
            case UINT32: {
                return "buffer.putInt(" + index + ", (int)" + value + byteOrder + ")";
            }
            case FLOAT: {
                return "buffer.putFloat(" + index + ", " + value + byteOrder + ")";
            }
            case INT64: 
            case UINT64: {
                return "buffer.putLong(" + index + ", " + value + byteOrder + ")";
            }
            case DOUBLE: {
                return "buffer.putDouble(" + index + ", " + value + byteOrder + ")";
            }
        }
        throw new IllegalArgumentException("primitive type not supported: " + (Object)((Object)type));
    }

    private String generateChoiceGet(PrimitiveType type, String index, String bitIndex, String byteOrder) {
        switch (type) {
            case UINT8: {
                return "0 != (buffer.getByte(" + index + ") & (1 << " + bitIndex + "))";
            }
            case UINT16: {
                return "0 != (buffer.getShort(" + index + byteOrder + ") & (1 << " + bitIndex + "))";
            }
            case UINT32: {
                return "0 != (buffer.getInt(" + index + byteOrder + ") & (1 << " + bitIndex + "))";
            }
            case UINT64: {
                return "0 != (buffer.getLong(" + index + byteOrder + ") & (1L << " + bitIndex + "))";
            }
        }
        throw new IllegalArgumentException("primitive type not supported: " + (Object)((Object)type));
    }

    private String generateChoicePut(PrimitiveType type, String index, String bitIndex, String byteOrder) {
        switch (type) {
            case UINT8: {
                return "        byte bits = buffer.getByte(" + index + ");\n        bits = (byte)(value ? bits | (1 << " + bitIndex + ") : bits & ~(1 << " + bitIndex + "));\n        buffer.putByte(" + index + ", bits);";
            }
            case UINT16: {
                return "        short bits = buffer.getShort(" + index + byteOrder + ");\n        bits = (short)(value ? bits | (1 << " + bitIndex + ") : bits & ~(1 << " + bitIndex + "));\n        buffer.putShort(" + index + ", bits" + byteOrder + ");";
            }
            case UINT32: {
                return "        int bits = buffer.getInt(" + index + byteOrder + ");\n        bits = value ? bits | (1 << " + bitIndex + ") : bits & ~(1 << " + bitIndex + ");\n        buffer.putInt(" + index + ", bits" + byteOrder + ");";
            }
            case UINT64: {
                return "        long bits = buffer.getLong(" + index + byteOrder + ");\n        bits = value ? bits | (1L << " + bitIndex + ") : bits & ~(1L << " + bitIndex + ");\n        buffer.putLong(" + index + ", bits" + byteOrder + ");";
            }
        }
        throw new IllegalArgumentException("primitive type not supported: " + (Object)((Object)type));
    }

    private CharSequence generateEncoderDisplay(String decoderName, String baseIndent) {
        String indent = baseIndent + INDENT;
        StringBuilder sb = new StringBuilder();
        this.appendToString(sb, indent);
        sb.append("\n");
        JavaUtil.append(sb, indent, "public StringBuilder appendTo(final StringBuilder builder)");
        JavaUtil.append(sb, indent, "{");
        JavaUtil.append(sb, indent, INDENT + decoderName + " writer = new " + decoderName + "();");
        JavaUtil.append(sb, indent, "    writer.wrap(buffer, offset, BLOCK_LENGTH, SCHEMA_VERSION);");
        sb.append('\n');
        JavaUtil.append(sb, indent, "    return writer.appendTo(builder);");
        JavaUtil.append(sb, indent, "}");
        return sb.toString();
    }

    private CharSequence generateCompositeEncoderDisplay(String decoderName, String baseIndent) {
        String indent = baseIndent + INDENT;
        StringBuilder sb = new StringBuilder();
        this.appendToString(sb, indent);
        sb.append('\n');
        JavaUtil.append(sb, indent, "public StringBuilder appendTo(final StringBuilder builder)");
        JavaUtil.append(sb, indent, "{");
        JavaUtil.append(sb, indent, INDENT + decoderName + " writer = new " + decoderName + "();");
        JavaUtil.append(sb, indent, "    writer.wrap(buffer, offset);");
        sb.append('\n');
        JavaUtil.append(sb, indent, "    return writer.appendTo(builder);");
        JavaUtil.append(sb, indent, "}");
        return sb.toString();
    }

    private CharSequence generateCompositeDecoderDisplay(List<Token> tokens, String baseIndent) {
        Token encodingToken;
        String indent = baseIndent + INDENT;
        StringBuilder sb = new StringBuilder();
        this.appendToString(sb, indent);
        sb.append('\n');
        JavaUtil.append(sb, indent, "public StringBuilder appendTo(final StringBuilder builder)");
        JavaUtil.append(sb, indent, "{");
        JavaUtil.Separators.BEGIN_COMPOSITE.appendToGeneratedBuilder(sb, indent + INDENT, "builder");
        int lengthBeforeLastGeneratedSeparator = -1;
        int end = tokens.size() - 1;
        for (int i = 1; i < end; i += encodingToken.componentTokenCount()) {
            encodingToken = tokens.get(i);
            String propertyName = JavaUtil.formatPropertyName(encodingToken.name());
            lengthBeforeLastGeneratedSeparator = this.writeTokenDisplay(propertyName, encodingToken, sb, indent + INDENT);
        }
        if (-1 != lengthBeforeLastGeneratedSeparator) {
            sb.setLength(lengthBeforeLastGeneratedSeparator);
        }
        JavaUtil.Separators.END_COMPOSITE.appendToGeneratedBuilder(sb, indent + INDENT, "builder");
        sb.append('\n');
        JavaUtil.append(sb, indent, "    return builder;");
        JavaUtil.append(sb, indent, "}");
        return sb.toString();
    }

    private CharSequence generateChoiceDisplay(List<Token> tokens) {
        String indent = INDENT;
        StringBuilder sb = new StringBuilder();
        this.appendToString(sb, INDENT);
        sb.append('\n');
        JavaUtil.append(sb, INDENT, "public StringBuilder appendTo(final StringBuilder builder)");
        JavaUtil.append(sb, INDENT, "{");
        JavaUtil.Separators.BEGIN_SET.appendToGeneratedBuilder(sb, "        ", "builder");
        JavaUtil.append(sb, INDENT, "    boolean atLeastOne = false;");
        tokens.stream().filter(token -> token.signal() == Signal.CHOICE).forEach(token -> {
            String choiceName = JavaUtil.formatPropertyName(token.name());
            JavaUtil.append(sb, INDENT, "    if (" + choiceName + "())");
            JavaUtil.append(sb, INDENT, "    {");
            JavaUtil.append(sb, INDENT, "        if (atLeastOne)");
            JavaUtil.append(sb, INDENT, "        {");
            JavaUtil.Separators.ENTRY.appendToGeneratedBuilder(sb, "                ", "builder");
            JavaUtil.append(sb, INDENT, "        }");
            JavaUtil.append(sb, INDENT, "        builder.append(\"" + choiceName + "\");");
            JavaUtil.append(sb, INDENT, "        atLeastOne = true;");
            JavaUtil.append(sb, INDENT, "    }");
        });
        JavaUtil.Separators.END_SET.appendToGeneratedBuilder(sb, "        ", "builder");
        sb.append('\n');
        JavaUtil.append(sb, INDENT, "    return builder;");
        JavaUtil.append(sb, INDENT, "}");
        return sb.toString();
    }

    private CharSequence generateDecoderDisplay(String name, List<Token> tokens, List<Token> groups, List<Token> varData, String baseIndent) throws IOException {
        String indent = baseIndent + INDENT;
        StringBuilder sb = new StringBuilder();
        sb.append('\n');
        this.appendToString(sb, indent);
        sb.append('\n');
        JavaUtil.append(sb, indent, "public StringBuilder appendTo(final StringBuilder builder)");
        JavaUtil.append(sb, indent, "{");
        JavaUtil.append(sb, indent, "    final int originalLimit = limit();");
        JavaUtil.append(sb, indent, "    limit(offset + actingBlockLength);");
        JavaUtil.append(sb, indent, "    builder.append(\"[" + name + "](sbeTemplateId=\");");
        JavaUtil.append(sb, indent, "    builder.append(TEMPLATE_ID);");
        JavaUtil.append(sb, indent, "    builder.append(\"|sbeSchemaId=\");");
        JavaUtil.append(sb, indent, "    builder.append(SCHEMA_ID);");
        JavaUtil.append(sb, indent, "    builder.append(\"|sbeSchemaVersion=\");");
        JavaUtil.append(sb, indent, "    if (actingVersion != SCHEMA_VERSION)");
        JavaUtil.append(sb, indent, "    {");
        JavaUtil.append(sb, indent, "        builder.append(actingVersion);");
        JavaUtil.append(sb, indent, "        builder.append('/');");
        JavaUtil.append(sb, indent, "    }");
        JavaUtil.append(sb, indent, "    builder.append(SCHEMA_VERSION);");
        JavaUtil.append(sb, indent, "    builder.append(\"|sbeBlockLength=\");");
        JavaUtil.append(sb, indent, "    if (actingBlockLength != BLOCK_LENGTH)");
        JavaUtil.append(sb, indent, "    {");
        JavaUtil.append(sb, indent, "        builder.append(actingBlockLength);");
        JavaUtil.append(sb, indent, "        builder.append('/');");
        JavaUtil.append(sb, indent, "    }");
        JavaUtil.append(sb, indent, "    builder.append(BLOCK_LENGTH);");
        JavaUtil.append(sb, indent, "    builder.append(\"):\");");
        this.appendDecoderDisplay(sb, tokens, groups, varData, indent + INDENT);
        sb.append('\n');
        JavaUtil.append(sb, indent, "    limit(originalLimit);");
        sb.append('\n');
        JavaUtil.append(sb, indent, "    return builder;");
        JavaUtil.append(sb, indent, "}");
        return sb.toString();
    }

    private StringBuilder appendGroupInstanceDecoderDisplay(StringBuilder sb, List<Token> fields, List<Token> groups, List<Token> varData, String baseIndent) {
        String indent = baseIndent + INDENT;
        sb.append('\n');
        this.appendToString(sb, indent);
        sb.append('\n');
        JavaUtil.append(sb, indent, "public StringBuilder appendTo(final StringBuilder builder)");
        JavaUtil.append(sb, indent, "{");
        JavaUtil.Separators.BEGIN_COMPOSITE.appendToGeneratedBuilder(sb, indent + INDENT, "builder");
        this.appendDecoderDisplay(sb, fields, groups, varData, indent + INDENT);
        JavaUtil.Separators.END_COMPOSITE.appendToGeneratedBuilder(sb, indent + INDENT, "builder");
        JavaUtil.append(sb, indent, "    return builder;");
        JavaUtil.append(sb, indent, "}");
        return sb;
    }

    private StringBuilder appendDecoderDisplay(StringBuilder sb, List<Token> fields, List<Token> groups, List<Token> varData, String indent) {
        Token varDataToken;
        int lengthBeforeLastGeneratedSeparator = -1;
        int i = 0;
        int size = fields.size();
        while (i < size) {
            Token fieldToken = fields.get(i);
            if (fieldToken.signal() == Signal.BEGIN_FIELD) {
                Token encodingToken = fields.get(i + 1);
                String fieldName = JavaUtil.formatPropertyName(fieldToken.name());
                JavaUtil.append(sb, indent, "//" + fieldToken);
                lengthBeforeLastGeneratedSeparator = this.writeTokenDisplay(fieldName, encodingToken, sb, indent);
                i += fieldToken.componentTokenCount();
                continue;
            }
            ++i;
        }
        size = groups.size();
        for (i = 0; i < size; ++i) {
            Token groupToken = groups.get(i);
            if (groupToken.signal() != Signal.BEGIN_GROUP) {
                throw new IllegalStateException("tokens must begin with BEGIN_GROUP: token=" + groupToken);
            }
            JavaUtil.append(sb, indent, "//" + groupToken);
            String groupName = JavaUtil.formatPropertyName(groupToken.name());
            String groupDecoderName = this.decoderName(JavaUtil.formatClassName(groupToken.name()));
            JavaUtil.append(sb, indent, "builder.append(\"" + groupName + (Object)((Object)JavaUtil.Separators.KEY_VALUE) + (Object)((Object)JavaUtil.Separators.BEGIN_GROUP) + "\");");
            JavaUtil.append(sb, indent, groupDecoderName + " " + groupName + " = " + groupName + "();");
            JavaUtil.append(sb, indent, "if (" + groupName + ".count() > 0)");
            JavaUtil.append(sb, indent, "{");
            JavaUtil.append(sb, indent, "    while (" + groupName + ".hasNext())");
            JavaUtil.append(sb, indent, "    {");
            JavaUtil.append(sb, indent, "        " + groupName + ".next().appendTo(builder);");
            JavaUtil.Separators.ENTRY.appendToGeneratedBuilder(sb, indent + INDENT + INDENT, "builder");
            JavaUtil.append(sb, indent, "    }");
            JavaUtil.append(sb, indent, "    builder.setLength(builder.length() - 1);");
            JavaUtil.append(sb, indent, "}");
            JavaUtil.Separators.END_GROUP.appendToGeneratedBuilder(sb, indent, "builder");
            lengthBeforeLastGeneratedSeparator = sb.length();
            JavaUtil.Separators.FIELD.appendToGeneratedBuilder(sb, indent, "builder");
            i = GenerationUtil.findEndSignal(groups, i, Signal.END_GROUP, groupToken.name());
        }
        size = varData.size();
        for (i = 0; i < size; i += varDataToken.componentTokenCount()) {
            varDataToken = varData.get(i);
            if (varDataToken.signal() != Signal.BEGIN_VAR_DATA) {
                throw new IllegalStateException("tokens must begin with BEGIN_VAR_DATA: token=" + varDataToken);
            }
            JavaUtil.append(sb, indent, "//" + varDataToken);
            String varDataName = JavaUtil.formatPropertyName(varDataToken.name());
            JavaUtil.append(sb, indent, "builder.append(\"" + varDataName + (Object)((Object)JavaUtil.Separators.KEY_VALUE) + "\");");
            JavaUtil.append(sb, indent, "builder.append(" + varDataName + "());");
            lengthBeforeLastGeneratedSeparator = sb.length();
            JavaUtil.Separators.FIELD.appendToGeneratedBuilder(sb, indent, "builder");
        }
        if (-1 != lengthBeforeLastGeneratedSeparator) {
            sb.setLength(lengthBeforeLastGeneratedSeparator);
        }
        return sb;
    }

    private int writeTokenDisplay(String fieldName, Token typeToken, StringBuilder sb, String indent) {
        JavaUtil.append(sb, indent, "//" + typeToken);
        if (typeToken.encodedLength() <= 0 || typeToken.isConstantEncoding()) {
            return -1;
        }
        JavaUtil.append(sb, indent, "builder.append(\"" + fieldName + (Object)((Object)JavaUtil.Separators.KEY_VALUE) + "\");");
        switch (typeToken.signal()) {
            case ENCODING: {
                if (typeToken.arrayLength() > 1) {
                    if (typeToken.encoding().primitiveType() == PrimitiveType.CHAR) {
                        JavaUtil.append(sb, indent, "for (int i = 0; i < " + fieldName + "Length() && " + fieldName + "(i) > 0; i++)");
                        JavaUtil.append(sb, indent, "{");
                        JavaUtil.append(sb, indent, "    builder.append((char)" + fieldName + "(i));");
                        JavaUtil.append(sb, indent, "}");
                        break;
                    }
                    JavaUtil.Separators.BEGIN_ARRAY.appendToGeneratedBuilder(sb, indent, "builder");
                    JavaUtil.append(sb, indent, "if (" + fieldName + "Length() > 0)");
                    JavaUtil.append(sb, indent, "{");
                    JavaUtil.append(sb, indent, "    for (int i = 0; i < " + fieldName + "Length(); i++)");
                    JavaUtil.append(sb, indent, "    {");
                    JavaUtil.append(sb, indent, "        builder.append(" + fieldName + "(i));");
                    JavaUtil.Separators.ENTRY.appendToGeneratedBuilder(sb, indent + INDENT + INDENT, "builder");
                    JavaUtil.append(sb, indent, "    }");
                    JavaUtil.append(sb, indent, "    builder.setLength(builder.length() - 1);");
                    JavaUtil.append(sb, indent, "}");
                    JavaUtil.Separators.END_ARRAY.appendToGeneratedBuilder(sb, indent, "builder");
                    break;
                }
                JavaUtil.append(sb, indent, "builder.append(" + fieldName + "());");
                break;
            }
            case BEGIN_ENUM: 
            case BEGIN_SET: {
                JavaUtil.append(sb, indent, "builder.append(" + fieldName + "());");
                break;
            }
            case BEGIN_COMPOSITE: {
                JavaUtil.append(sb, indent, fieldName + "().appendTo(builder);");
            }
        }
        int lengthBeforeFieldSeparator = sb.length();
        JavaUtil.Separators.FIELD.appendToGeneratedBuilder(sb, indent, "builder");
        return lengthBeforeFieldSeparator;
    }

    private void appendToString(StringBuilder sb, String indent) {
        JavaUtil.append(sb, indent, "public String toString()");
        JavaUtil.append(sb, indent, "{");
        JavaUtil.append(sb, indent, "    return appendTo(new StringBuilder(100)).toString();");
        JavaUtil.append(sb, indent, "}");
    }
}

