/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.xml;

import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import uk.co.real_logic.sbe.PrimitiveType;
import uk.co.real_logic.sbe.PrimitiveValue;
import uk.co.real_logic.sbe.ir.Encoding;
import uk.co.real_logic.sbe.ir.Ir;
import uk.co.real_logic.sbe.ir.Signal;
import uk.co.real_logic.sbe.ir.Token;
import uk.co.real_logic.sbe.xml.CompositeType;
import uk.co.real_logic.sbe.xml.EncodedDataType;
import uk.co.real_logic.sbe.xml.EnumType;
import uk.co.real_logic.sbe.xml.Field;
import uk.co.real_logic.sbe.xml.Message;
import uk.co.real_logic.sbe.xml.MessageSchema;
import uk.co.real_logic.sbe.xml.Presence;
import uk.co.real_logic.sbe.xml.SetType;
import uk.co.real_logic.sbe.xml.Type;

public class IrGenerator {
    private final List<Token> tokenList = new ArrayList<Token>();
    private ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
    private int version = 0;

    public Ir generate(MessageSchema schema, String namespace) {
        List<Token> headerTokens = this.generateForHeader(schema);
        Ir ir = new Ir(schema.packageName(), namespace, schema.id(), schema.version(), schema.semanticVersion(), headerTokens);
        for (Message message : schema.messages()) {
            long msgId = message.id();
            ir.addMessage(msgId, this.generateForMessage(schema, msgId));
        }
        return ir;
    }

    public Ir generate(MessageSchema schema) {
        return this.generate(schema, null);
    }

    private List<Token> generateForMessage(MessageSchema schema, long messageId) {
        this.tokenList.clear();
        this.byteOrder = schema.byteOrder();
        this.version = schema.version();
        Message msg = schema.getMessage(messageId);
        this.addMessageSignal(msg, Signal.BEGIN_MESSAGE);
        this.addAllFields(msg.fields());
        this.addMessageSignal(msg, Signal.END_MESSAGE);
        return this.tokenList;
    }

    private List<Token> generateForHeader(MessageSchema schema) {
        this.tokenList.clear();
        this.byteOrder = schema.byteOrder();
        this.add(schema.messageHeader(), 0, null);
        return this.tokenList;
    }

    private void addMessageSignal(Message msg, Signal signal) {
        Token token = new Token.Builder().signal(signal).name(msg.name()).description(msg.description()).size(msg.blockLength()).id(msg.id()).version(this.version).encoding(new Encoding.Builder().semanticType(msg.semanticType()).build()).build();
        this.tokenList.add(token);
    }

    private void addFieldSignal(Field field, Signal signal) {
        Encoding.Builder encodingBuilder = new Encoding.Builder().epoch(field.epoch()).timeUnit(field.timeUnit()).presence(this.mapPresence(field.presence())).semanticType(IrGenerator.semanticTypeOf(null, field));
        if (field.presence() == Presence.CONSTANT && null != field.valueRef()) {
            byte[] bytes;
            String valueRef = field.valueRef();
            try {
                bytes = valueRef.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
            encodingBuilder.constValue(new PrimitiveValue(bytes, "UTF-8", valueRef.length()));
            encodingBuilder.primitiveType(PrimitiveType.CHAR);
        }
        Token token = new Token.Builder().signal(signal).size(field.computedBlockLength()).name(field.name()).description(field.description()).id(field.id()).offset(field.computedOffset()).version(field.sinceVersion()).encoding(encodingBuilder.build()).build();
        this.tokenList.add(token);
    }

    private void addAllFields(List<Field> fieldList) {
        for (Field field : fieldList) {
            Type type = field.type();
            if (type == null) {
                this.addFieldSignal(field, Signal.BEGIN_GROUP);
                this.add(field.dimensionType(), 0, field);
                this.addAllFields(field.groupFields());
                this.addFieldSignal(field, Signal.END_GROUP);
                continue;
            }
            if (type instanceof CompositeType && field.isVariableLength()) {
                this.addFieldSignal(field, Signal.BEGIN_VAR_DATA);
                this.add((CompositeType)type, field.computedOffset(), field);
                this.addFieldSignal(field, Signal.END_VAR_DATA);
                continue;
            }
            this.addFieldSignal(field, Signal.BEGIN_FIELD);
            if (type instanceof EncodedDataType) {
                this.add((EncodedDataType)type, field.computedOffset(), field);
            } else if (type instanceof CompositeType) {
                this.add((CompositeType)type, field.computedOffset(), field);
            } else if (type instanceof EnumType) {
                this.add((EnumType)type, field.computedOffset(), field);
            } else if (type instanceof SetType) {
                this.add((SetType)type, field.computedOffset(), field);
            } else {
                throw new IllegalStateException("Unknown type: " + type);
            }
            this.addFieldSignal(field, Signal.END_FIELD);
        }
    }

    private void add(CompositeType type, int currOffset, Field field) {
        Token.Builder builder = new Token.Builder().signal(Signal.BEGIN_COMPOSITE).name(type.name()).offset(currOffset).size(type.encodedLength()).encoding(new Encoding.Builder().semanticType(IrGenerator.semanticTypeOf(type, field)).build());
        if (field != null) {
            builder.version(field.sinceVersion());
            builder.description(field.description());
        }
        this.tokenList.add(builder.build());
        int offset = 0;
        for (Type elementType : type.getTypeList()) {
            if (elementType.offsetAttribute() != -1) {
                offset = elementType.offsetAttribute();
            }
            if (elementType instanceof EncodedDataType) {
                this.add((EncodedDataType)elementType, offset, field);
            } else if (elementType instanceof EnumType) {
                this.add((EnumType)elementType, offset, field);
            } else if (elementType instanceof SetType) {
                this.add((SetType)elementType, offset, field);
            } else if (elementType instanceof CompositeType) {
                this.add((CompositeType)elementType, offset, field);
            }
            offset += elementType.encodedLength();
        }
        this.tokenList.add(builder.signal(Signal.END_COMPOSITE).build());
    }

    private void add(EnumType type, int offset, Field field) {
        PrimitiveType encodingType = type.encodingType();
        Encoding.Builder encodingBuilder = new Encoding.Builder().primitiveType(encodingType).semanticType(IrGenerator.semanticTypeOf(type, field)).byteOrder(this.byteOrder);
        if (type.presence() == Presence.OPTIONAL) {
            encodingBuilder.nullValue(encodingType.nullValue());
        }
        Token.Builder builder = new Token.Builder().signal(Signal.BEGIN_ENUM).name(type.name()).size(encodingType.size()).offset(offset).encoding(encodingBuilder.build());
        if (field != null) {
            builder.version(field.sinceVersion());
            builder.description(field.description());
        }
        this.tokenList.add(builder.build());
        for (EnumType.ValidValue validValue : type.validValues()) {
            this.add(validValue, encodingType, field);
        }
        builder.signal(Signal.END_ENUM);
        this.tokenList.add(builder.build());
    }

    private void add(EnumType.ValidValue value, PrimitiveType encodingType, Field field) {
        Token.Builder builder = new Token.Builder().signal(Signal.VALID_VALUE).name(value.name()).encoding(new Encoding.Builder().byteOrder(this.byteOrder).primitiveType(encodingType).constValue(value.primitiveValue()).build());
        if (field != null) {
            builder.version(field.sinceVersion());
            builder.description(field.description());
        }
        this.tokenList.add(builder.build());
    }

    private void add(SetType type, int offset, Field field) {
        PrimitiveType encodingType = type.encodingType();
        Token.Builder builder = new Token.Builder().signal(Signal.BEGIN_SET).name(type.name()).size(encodingType.size()).offset(offset).encoding(new Encoding.Builder().semanticType(IrGenerator.semanticTypeOf(type, field)).primitiveType(encodingType).build());
        if (field != null) {
            builder.version(field.sinceVersion());
            builder.description(field.description());
        }
        this.tokenList.add(builder.build());
        for (SetType.Choice choice : type.choices()) {
            this.add(choice, encodingType, field);
        }
        builder.signal(Signal.END_SET);
        this.tokenList.add(builder.build());
    }

    private void add(SetType.Choice value, PrimitiveType encodingType, Field field) {
        Token.Builder builder = new Token.Builder().signal(Signal.CHOICE).name(value.name()).encoding(new Encoding.Builder().constValue(value.primitiveValue()).byteOrder(this.byteOrder).primitiveType(encodingType).build());
        if (field != null) {
            builder.version(field.sinceVersion());
        }
        this.tokenList.add(builder.build());
    }

    private void add(EncodedDataType type, int offset, Field field) {
        Encoding.Builder encodingBuilder = new Encoding.Builder().primitiveType(type.primitiveType()).byteOrder(this.byteOrder).semanticType(IrGenerator.semanticTypeOf(type, field)).characterEncoding(type.characterEncoding());
        if (null != field) {
            encodingBuilder.epoch(field.epoch());
            encodingBuilder.timeUnit(field.timeUnit());
        }
        Token.Builder tokenBuilder = new Token.Builder().signal(Signal.ENCODING).name(type.name()).size(type.encodedLength()).offset(offset);
        if (field != null) {
            tokenBuilder.version(field.sinceVersion());
            tokenBuilder.description(field.description());
        }
        switch (type.presence()) {
            case REQUIRED: {
                encodingBuilder.presence(Encoding.Presence.REQUIRED).minValue(type.minValue()).maxValue(type.maxValue());
                break;
            }
            case OPTIONAL: {
                encodingBuilder.presence(Encoding.Presence.OPTIONAL).minValue(type.minValue()).maxValue(type.maxValue()).nullValue(type.nullValue());
                break;
            }
            case CONSTANT: {
                encodingBuilder.presence(Encoding.Presence.CONSTANT).constValue(type.constVal());
            }
        }
        Token token = tokenBuilder.encoding(encodingBuilder.build()).build();
        this.tokenList.add(token);
    }

    private static String semanticTypeOf(Type type, Field field) {
        String typeSemanticType;
        String string = typeSemanticType = null != type ? type.semanticType() : null;
        if (typeSemanticType != null) {
            return typeSemanticType;
        }
        return null != field ? field.semanticType() : null;
    }

    private Encoding.Presence mapPresence(Presence presence) {
        Encoding.Presence encodingPresence = Encoding.Presence.REQUIRED;
        if (null != presence) {
            switch (presence) {
                case OPTIONAL: {
                    encodingPresence = Encoding.Presence.OPTIONAL;
                    break;
                }
                case CONSTANT: {
                    encodingPresence = Encoding.Presence.CONSTANT;
                }
            }
        }
        return encodingPresence;
    }
}

