/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.generation.java;

import java.util.EnumMap;
import java.util.Map;
import uk.co.real_logic.sbe.PrimitiveType;
import uk.co.real_logic.sbe.util.ValidationUtil;

public class JavaUtil {
    private static final Map<PrimitiveType, String> TYPE_NAME_BY_PRIMITIVE_TYPE_MAP = new EnumMap<PrimitiveType, String>(PrimitiveType.class);

    public static String javaTypeName(PrimitiveType primitiveType) {
        return TYPE_NAME_BY_PRIMITIVE_TYPE_MAP.get((Object)primitiveType);
    }

    public static String toUpperFirstChar(String s) {
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    public static String toLowerFirstChar(String s) {
        return Character.toLowerCase(s.charAt(0)) + s.substring(1);
    }

    public static String formatPropertyName(String value) {
        String formattedValue = JavaUtil.toLowerFirstChar(value);
        if (ValidationUtil.isJavaKeyword(formattedValue)) {
            String keywordAppendToken = System.getProperty("sbe.keyword.append.token");
            if (null == keywordAppendToken) {
                throw new IllegalStateException("Invalid property name='" + formattedValue + "' please correct the schema or consider setting system property: " + "sbe.keyword.append.token");
            }
            formattedValue = formattedValue + keywordAppendToken;
        }
        return formattedValue;
    }

    public static String formatClassName(String value) {
        return JavaUtil.toUpperFirstChar(value);
    }

    static {
        TYPE_NAME_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.CHAR, "byte");
        TYPE_NAME_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.INT8, "byte");
        TYPE_NAME_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.INT16, "short");
        TYPE_NAME_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.INT32, "int");
        TYPE_NAME_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.INT64, "long");
        TYPE_NAME_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.UINT8, "short");
        TYPE_NAME_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.UINT16, "int");
        TYPE_NAME_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.UINT32, "long");
        TYPE_NAME_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.UINT64, "long");
        TYPE_NAME_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.FLOAT, "float");
        TYPE_NAME_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.DOUBLE, "double");
    }
}

