/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.json;

import java.nio.ByteBuffer;
import java.util.List;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import uk.co.real_logic.sbe.ir.Ir;
import uk.co.real_logic.sbe.ir.Token;
import uk.co.real_logic.sbe.json.JsonTokenListener;
import uk.co.real_logic.sbe.otf.OtfHeaderDecoder;
import uk.co.real_logic.sbe.otf.OtfMessageDecoder;

public class JsonPrinter {
    private final OtfHeaderDecoder headerDecoder;
    private final Ir ir;

    public JsonPrinter(Ir ir) {
        this.ir = ir;
        this.headerDecoder = new OtfHeaderDecoder(ir.headerStructure());
    }

    public void print(ByteBuffer encodedMessage, StringBuilder output) {
        UnsafeBuffer buffer = new UnsafeBuffer(encodedMessage);
        this.print(output, (DirectBuffer)buffer, 0);
    }

    public void print(StringBuilder output, DirectBuffer buffer, int offset) {
        int blockLength = this.headerDecoder.getBlockLength(buffer, offset);
        int templateId = this.headerDecoder.getTemplateId(buffer, offset);
        int schemaId = this.headerDecoder.getSchemaId(buffer, offset);
        int actingVersion = this.headerDecoder.getSchemaVersion(buffer, offset);
        this.validateId(schemaId);
        int messageOffset = offset + this.headerDecoder.encodedLength();
        List<Token> msgTokens = this.ir.getMessage(templateId);
        OtfMessageDecoder.decode(buffer, messageOffset, actingVersion, blockLength, msgTokens, new JsonTokenListener(output));
    }

    public String print(ByteBuffer encodedMessage) {
        StringBuilder sb = new StringBuilder();
        this.print(encodedMessage, sb);
        return sb.toString();
    }

    private void validateId(int schemaId) {
        if (schemaId != this.ir.id()) {
            throw new IllegalArgumentException("Required schema id " + this.ir.id() + " but was " + schemaId);
        }
    }
}

