/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.xml;

import java.nio.ByteOrder;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.agrona.Verify;
import org.w3c.dom.Node;
import uk.co.real_logic.sbe.xml.CompositeType;
import uk.co.real_logic.sbe.xml.EncodedDataType;
import uk.co.real_logic.sbe.xml.EnumType;
import uk.co.real_logic.sbe.xml.ErrorHandler;
import uk.co.real_logic.sbe.xml.Field;
import uk.co.real_logic.sbe.xml.Message;
import uk.co.real_logic.sbe.xml.SetType;
import uk.co.real_logic.sbe.xml.Type;
import uk.co.real_logic.sbe.xml.XmlSchemaParser;

public class MessageSchema {
    public static final String HEADER_TYPE_DEFAULT = "messageHeader";
    private final String packageName;
    private final String description;
    private final int id;
    private final int version;
    private final String semanticVersion;
    private final ByteOrder byteOrder;
    private final String headerType;
    private final Map<String, Type> typeByNameMap;
    private final Map<Long, Message> messageByIdMap;

    MessageSchema(Node schemaNode, Map<String, Type> typeByNameMap, Map<Long, Message> messageByIdMap) {
        this.packageName = XmlSchemaParser.getAttributeValue(schemaNode, "package");
        this.description = XmlSchemaParser.getAttributeValueOrNull(schemaNode, "description");
        this.id = Integer.parseInt(XmlSchemaParser.getAttributeValue(schemaNode, "id"));
        this.version = Integer.parseInt(XmlSchemaParser.getAttributeValue(schemaNode, "version", "0"));
        this.semanticVersion = XmlSchemaParser.getAttributeValueOrNull(schemaNode, "semanticVersion");
        this.byteOrder = XmlSchemaParser.getByteOrder(XmlSchemaParser.getAttributeValue(schemaNode, "byteOrder", "littleEndian"));
        this.typeByNameMap = typeByNameMap;
        this.messageByIdMap = messageByIdMap;
        String configuredHeaderType = XmlSchemaParser.getAttributeValueOrNull(schemaNode, "headerType");
        this.headerType = null == configuredHeaderType ? HEADER_TYPE_DEFAULT : configuredHeaderType;
        Verify.present(typeByNameMap, (Object)this.headerType, (String)"Message header");
        Node messageHeaderNode = MessageSchema.findNode(schemaNode, "types/composite[@name='" + this.headerType + "']");
        ((CompositeType)typeByNameMap.get(this.headerType)).checkForWellFormedMessageHeader(messageHeaderNode);
    }

    MessageSchema(String packageName, String description, int id, int version, String semanticVersion, ByteOrder byteOrder, String headerType, Map<String, Type> typeByNameMap, Map<Long, Message> messageByIdMap) {
        this.packageName = packageName;
        this.description = description;
        this.id = id;
        this.version = version;
        this.semanticVersion = semanticVersion;
        this.byteOrder = byteOrder;
        this.headerType = headerType;
        this.typeByNameMap = typeByNameMap;
        this.messageByIdMap = messageByIdMap;
    }

    public CompositeType messageHeader() {
        return (CompositeType)this.typeByNameMap.get(this.headerType);
    }

    public String packageName() {
        return this.packageName;
    }

    public String description() {
        return this.description;
    }

    public int id() {
        return this.id;
    }

    public int version() {
        return this.version;
    }

    public String semanticVersion() {
        return this.semanticVersion;
    }

    public Message getMessage(long messageId) {
        return this.messageByIdMap.get(messageId);
    }

    public Type getType(String typeName) {
        return this.typeByNameMap.get(typeName);
    }

    public Collection<Message> messages() {
        return this.messageByIdMap.values();
    }

    public Collection<Type> types() {
        return this.typeByNameMap.values();
    }

    public ByteOrder byteOrder() {
        return this.byteOrder;
    }

    public void validate(ErrorHandler errorHandler) {
        ArrayDeque<String> path = new ArrayDeque<String>();
        for (Type type : this.typeByNameMap.values()) {
            this.validateType(errorHandler, path, type);
        }
        for (Message message : this.messageByIdMap.values()) {
            if (message.sinceVersion() > this.version) {
                errorHandler.error(message.name() + ".sinceVersion=" + message.sinceVersion() + " > messageSchema.version=" + this.version);
            }
            path.addLast(message.name());
            for (Field field : message.fields()) {
                this.validateField(errorHandler, path, field);
            }
            path.removeLast();
        }
    }

    private void validateType(ErrorHandler errorHandler, Deque<String> path, Type type) {
        if (type instanceof EncodedDataType) {
            this.validateEncodedType(errorHandler, path, (EncodedDataType)type);
        } else if (type instanceof EnumType) {
            this.validateEnumType(errorHandler, path, (EnumType)type);
        } else if (type instanceof SetType) {
            this.validateSetType(errorHandler, path, (SetType)type);
        } else if (type instanceof CompositeType) {
            this.validateCompositeType(errorHandler, path, (CompositeType)type);
        }
    }

    private void validateEncodedType(ErrorHandler errorHandler, Deque<String> path, EncodedDataType type) {
        if (type.sinceVersion() > this.version) {
            this.reportError(errorHandler, path, type.name(), type.sinceVersion());
        }
    }

    private void validateEnumType(ErrorHandler errorHandler, Deque<String> path, EnumType type) {
        if (type.sinceVersion() > this.version) {
            this.reportError(errorHandler, path, type.name(), type.sinceVersion());
        }
        path.addLast(type.name());
        for (EnumType.ValidValue validValue : type.validValues()) {
            if (validValue.sinceVersion() <= this.version) continue;
            this.reportError(errorHandler, path, validValue.name(), validValue.sinceVersion());
        }
        path.removeLast();
    }

    private void validateSetType(ErrorHandler errorHandler, Deque<String> path, SetType type) {
        if (type.sinceVersion() > this.version) {
            this.reportError(errorHandler, path, type.name(), type.sinceVersion());
        }
        path.addLast(type.name());
        for (SetType.Choice choice : type.choices()) {
            if (choice.sinceVersion() <= this.version) continue;
            this.reportError(errorHandler, path, choice.name(), choice.sinceVersion());
        }
        path.removeLast();
    }

    private void validateCompositeType(ErrorHandler errorHandler, Deque<String> path, CompositeType type) {
        if (type.sinceVersion() > this.version) {
            this.reportError(errorHandler, path, type.name(), type.sinceVersion());
        }
        path.addLast(type.name());
        for (Type subType : type.getTypeList()) {
            this.validateType(errorHandler, path, subType);
        }
        path.removeLast();
    }

    private void validateField(ErrorHandler errorHandler, Deque<String> path, Field field) {
        List<Field> groupFields;
        if (field.sinceVersion() > this.version) {
            this.reportError(errorHandler, path, field.name(), field.sinceVersion());
        }
        if (null != (groupFields = field.groupFields())) {
            path.addLast(field.name());
            for (Field groupField : groupFields) {
                this.validateField(errorHandler, path, groupField);
            }
            path.removeLast();
        }
    }

    private void reportError(ErrorHandler errorHandler, Deque<String> path, String name, int sinceVersion) {
        StringBuilder sb = new StringBuilder();
        for (String step : path) {
            sb.append(step).append('.');
        }
        sb.append(name).append(".sinceVersion=").append(sinceVersion).append(" > messageSchema.version=").append(this.version);
        errorHandler.error(sb.toString());
    }

    private static Node findNode(Node contextNode, String path) {
        try {
            return (Node)XPathFactory.newInstance().newXPath().evaluate(path, contextNode, XPathConstants.NODE);
        }
        catch (XPathExpressionException ex) {
            throw new IllegalArgumentException("Unable to locate node with path=" + path, ex);
        }
    }
}

