/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.generation.rust;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.agrona.Verify;
import org.agrona.generation.OutputManager;
import uk.co.real_logic.sbe.generation.rust.RustUtil;

public class RustOutputManager
implements OutputManager {
    private final File rootDir;
    private final File srcDir;

    static File createDir(String dirName) {
        File dir = new File(dirName);
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IllegalStateException("Unable to create directory: " + dirName);
        }
        return dir;
    }

    public RustOutputManager(String baseDirName, String packageName) {
        Verify.notNull((Object)baseDirName, (String)"baseDirName");
        Verify.notNull((Object)packageName, (String)"packageName");
        String dirName = baseDirName.endsWith("" + File.separatorChar) ? baseDirName : baseDirName + File.separatorChar;
        String libDirName = dirName = dirName + packageName.replaceAll("\\.", "_").toLowerCase() + File.separatorChar;
        this.rootDir = new File(libDirName);
        String srcDirName = libDirName + File.separatorChar + "src";
        this.srcDir = RustOutputManager.createDir(srcDirName);
    }

    public Writer createOutput(String name) throws IOException {
        String fileName = RustUtil.toLowerSnakeCase(name) + ".rs";
        File targetFile = new File(this.srcDir, fileName);
        return Files.newBufferedWriter(targetFile.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);
    }

    public Writer createCargoToml() throws IOException {
        String fileName = "Cargo.toml";
        File targetFile = new File(this.rootDir, "Cargo.toml");
        return Files.newBufferedWriter(targetFile.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);
    }

    Path getSrcDirPath() {
        return this.srcDir.toPath();
    }
}

