/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.generation.rust;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import uk.co.real_logic.sbe.PrimitiveType;
import uk.co.real_logic.sbe.generation.Generators;
import uk.co.real_logic.sbe.generation.rust.RustGenerator;
import uk.co.real_logic.sbe.generation.rust.RustUtil;
import uk.co.real_logic.sbe.ir.Token;

class SubGroup
implements RustGenerator.ParentDef {
    private final StringBuilder sb = new StringBuilder();
    private final ArrayList<SubGroup> subGroups = new ArrayList();
    private final String name;
    private final int level;
    private final Token groupToken;

    SubGroup(String name, int level, Token groupToken) {
        this.name = name;
        this.level = level;
        this.groupToken = groupToken;
    }

    @Override
    public SubGroup addSubGroup(String name, int level, Token groupToken) {
        SubGroup subGroup = new SubGroup(name, level, groupToken);
        this.subGroups.add(subGroup);
        return subGroup;
    }

    void generateEncoder(List<Token> tokens, List<Token> fields, List<Token> groups, List<Token> varData, int index) throws IOException {
        Token blockLengthToken = Generators.findFirst("blockLength", tokens, index);
        PrimitiveType blockLengthPrimitiveType = blockLengthToken.encoding().primitiveType();
        Token numInGroupToken = Generators.findFirst("numInGroup", tokens, index);
        PrimitiveType numInGroupPrimitiveType = numInGroupToken.encoding().primitiveType();
        RustUtil.indent(this.sb, this.level - 1, "#[derive(Debug, Default)]\n", new Object[0]);
        RustUtil.indent(this.sb, this.level - 1, "pub struct %s<P> {\n", this.name);
        RustUtil.indent(this.sb, this.level, "parent: Option<P>,\n", new Object[0]);
        RustUtil.indent(this.sb, this.level, "count: %s,\n", RustUtil.rustTypeName(numInGroupPrimitiveType));
        RustUtil.indent(this.sb, this.level, "index: usize,\n", new Object[0]);
        RustUtil.indent(this.sb, this.level, "offset: usize,\n", new Object[0]);
        RustUtil.indent(this.sb, this.level, "initial_limit: usize,\n", new Object[0]);
        RustUtil.indent(this.sb, this.level - 1, "}\n\n", new Object[0]);
        RustGenerator.appendImplEncoderForComposite(this.sb, this.level - 1, this.name);
        RustUtil.indent(this.sb, this.level - 1, "impl<'a, P> %s<P> where P: Encoder<'a> + Default {\n", this.name);
        int dimensionHeaderSize = tokens.get(index).encodedLength();
        RustUtil.indent(this.sb, this.level, "#[inline]\n", new Object[0]);
        RustUtil.indent(this.sb, this.level, "pub fn wrap(\n", new Object[0]);
        RustUtil.indent(this.sb, this.level + 1, "mut self,\n", new Object[0]);
        RustUtil.indent(this.sb, this.level + 1, "mut parent: P,\n", new Object[0]);
        RustUtil.indent(this.sb, this.level + 1, "count: %s,\n", RustUtil.rustTypeName(numInGroupPrimitiveType));
        RustUtil.indent(this.sb, this.level, ") -> Self {\n", new Object[0]);
        RustUtil.indent(this.sb, this.level + 1, "let initial_limit = parent.get_limit();\n", new Object[0]);
        RustUtil.indent(this.sb, this.level + 1, "parent.set_limit(initial_limit + %d);\n", dimensionHeaderSize);
        RustUtil.indent(this.sb, this.level + 1, "parent.get_buf_mut().put_%s_at(initial_limit, Self::block_length());\n", RustUtil.rustTypeName(blockLengthPrimitiveType));
        RustUtil.indent(this.sb, this.level + 1, "parent.get_buf_mut().put_%s_at(initial_limit + %d, count);\n", RustUtil.rustTypeName(numInGroupPrimitiveType), numInGroupToken.offset());
        RustUtil.indent(this.sb, this.level + 1, "self.parent = Some(parent);\n", new Object[0]);
        RustUtil.indent(this.sb, this.level + 1, "self.count = count;\n", new Object[0]);
        RustUtil.indent(this.sb, this.level + 1, "self.index = usize::MAX;\n", new Object[0]);
        RustUtil.indent(this.sb, this.level + 1, "self.offset = usize::MAX;\n", new Object[0]);
        RustUtil.indent(this.sb, this.level + 1, "self.initial_limit = initial_limit;\n", new Object[0]);
        RustUtil.indent(this.sb, this.level + 1, "self\n", new Object[0]);
        RustUtil.indent(this.sb, this.level, "}\n\n", new Object[0]);
        RustUtil.indent(this.sb, this.level, "#[inline]\n", new Object[0]);
        RustUtil.indent(this.sb, this.level, "pub fn block_length() -> %s {\n", RustUtil.rustTypeName(blockLengthPrimitiveType));
        RustUtil.indent(this.sb, this.level + 1, "%d\n", this.groupToken.encodedLength());
        RustUtil.indent(this.sb, this.level, "}\n\n", new Object[0]);
        RustUtil.indent(this.sb, this.level, "#[inline]\n", new Object[0]);
        RustUtil.indent(this.sb, this.level, "pub fn parent(&mut self) -> SbeResult<P> {\n", new Object[0]);
        RustUtil.indent(this.sb, this.level + 1, "self.parent.take().ok_or(SbeErr::ParentNotSet)\n", new Object[0]);
        RustUtil.indent(this.sb, this.level, "}\n\n", new Object[0]);
        RustUtil.indent(this.sb, this.level, "/// will return Some(current index) when successful otherwise None\n", new Object[0]);
        RustUtil.indent(this.sb, this.level, "#[inline]\n", new Object[0]);
        RustUtil.indent(this.sb, this.level, "pub fn advance(&mut self) -> SbeResult<Option<usize>> {\n", new Object[0]);
        RustUtil.indent(this.sb, this.level + 1, "let index = self.index.wrapping_add(1);\n", new Object[0]);
        RustUtil.indent(this.sb, this.level + 1, "if index >= self.count as usize {\n", new Object[0]);
        RustUtil.indent(this.sb, this.level + 2, "return Ok(None);\n", new Object[0]);
        RustUtil.indent(this.sb, this.level + 1, "}\n", new Object[0]);
        RustUtil.indent(this.sb, this.level + 1, "if let Some(parent) = self.parent.as_mut() {\n", new Object[0]);
        RustUtil.indent(this.sb, this.level + 2, "self.offset = parent.get_limit();\n", new Object[0]);
        RustUtil.indent(this.sb, this.level + 2, "parent.set_limit(self.offset + Self::block_length() as usize);\n", new Object[0]);
        RustUtil.indent(this.sb, this.level + 2, "self.index = index;\n", new Object[0]);
        RustUtil.indent(this.sb, this.level + 2, "Ok(Some(index))\n", new Object[0]);
        RustUtil.indent(this.sb, this.level + 1, "} else {\n", new Object[0]);
        RustUtil.indent(this.sb, this.level + 2, "Err(SbeErr::ParentNotSet)\n", new Object[0]);
        RustUtil.indent(this.sb, this.level + 1, "}\n", new Object[0]);
        RustUtil.indent(this.sb, this.level, "}\n\n", new Object[0]);
        RustGenerator.generateEncoderFields(this.sb, fields, this.level);
        RustGenerator.generateEncoderGroups(this.sb, groups, this.level, this);
        RustGenerator.generateEncoderVarData(this.sb, varData, this.level);
        RustUtil.indent(this.sb, this.level - 1, "}\n\n", new Object[0]);
    }

    void generateDecoder(List<Token> tokens, List<Token> fields, List<Token> groups, List<Token> varData, int index) throws IOException {
        Token blockLengthToken = Generators.findFirst("blockLength", tokens, index);
        PrimitiveType blockLengthPrimitiveType = blockLengthToken.encoding().primitiveType();
        Token numInGroupToken = Generators.findFirst("numInGroup", tokens, index);
        PrimitiveType numInGroupPrimitiveType = numInGroupToken.encoding().primitiveType();
        RustUtil.indent(this.sb, this.level - 1, "#[derive(Debug, Default)]\n", new Object[0]);
        RustUtil.indent(this.sb, this.level - 1, "pub struct %s<P> {\n", this.name);
        RustUtil.indent(this.sb, this.level, "parent: Option<P>,\n", new Object[0]);
        RustUtil.indent(this.sb, this.level, "block_length: usize,\n", new Object[0]);
        RustUtil.indent(this.sb, this.level, "count: %s,\n", RustUtil.rustTypeName(numInGroupPrimitiveType));
        RustUtil.indent(this.sb, this.level, "index: usize,\n", new Object[0]);
        RustUtil.indent(this.sb, this.level, "offset: usize,\n", new Object[0]);
        RustUtil.indent(this.sb, this.level - 1, "}\n\n", new Object[0]);
        RustGenerator.appendImplDecoderForComposite(this.sb, this.level - 1, this.name);
        RustUtil.indent(this.sb, this.level - 1, "impl<'a, P> %s<P> where P: Decoder<'a> + Default {\n", this.name);
        int dimensionHeaderSize = tokens.get(index).encodedLength();
        RustUtil.indent(this.sb, this.level, "pub fn wrap(\n", new Object[0]);
        RustUtil.indent(this.sb, this.level + 1, "mut self,\n", new Object[0]);
        RustUtil.indent(this.sb, this.level + 1, "mut parent: P,\n", new Object[0]);
        RustUtil.indent(this.sb, this.level, ") -> Self {\n", new Object[0]);
        RustUtil.indent(this.sb, this.level + 1, "let initial_offset = parent.get_limit();\n", new Object[0]);
        RustUtil.indent(this.sb, this.level + 1, "let block_length = parent.get_buf().get_%s_at(initial_offset) as usize;\n", RustUtil.rustTypeName(blockLengthPrimitiveType));
        RustUtil.indent(this.sb, this.level + 1, "let count = parent.get_buf().get_%s_at(initial_offset + %d);\n", RustUtil.rustTypeName(numInGroupPrimitiveType), numInGroupToken.offset());
        RustUtil.indent(this.sb, this.level + 1, "parent.set_limit(initial_offset + %d);\n", dimensionHeaderSize);
        RustUtil.indent(this.sb, this.level + 1, "self.parent = Some(parent);\n", new Object[0]);
        RustUtil.indent(this.sb, this.level + 1, "self.block_length = block_length;\n", new Object[0]);
        RustUtil.indent(this.sb, this.level + 1, "self.count = count;\n", new Object[0]);
        RustUtil.indent(this.sb, this.level + 1, "self.index = usize::MAX;\n", new Object[0]);
        RustUtil.indent(this.sb, this.level + 1, "self.offset = 0;\n", new Object[0]);
        RustUtil.indent(this.sb, this.level + 1, "self\n", new Object[0]);
        RustUtil.indent(this.sb, this.level, "}\n\n", new Object[0]);
        RustUtil.indent(this.sb, this.level, "/// group token - %s\n", this.groupToken);
        RustUtil.indent(this.sb, this.level, "#[inline]\n", new Object[0]);
        RustUtil.indent(this.sb, this.level, "pub fn parent(&mut self) -> SbeResult<P> {\n", new Object[0]);
        RustUtil.indent(this.sb, this.level + 1, "self.parent.take().ok_or(SbeErr::ParentNotSet)\n", new Object[0]);
        RustUtil.indent(this.sb, this.level, "}\n\n", new Object[0]);
        RustUtil.indent(this.sb, this.level, "#[inline]\n", new Object[0]);
        RustUtil.indent(this.sb, this.level, "pub fn count(&self) -> %s {\n", RustUtil.rustTypeName(numInGroupPrimitiveType));
        RustUtil.indent(this.sb, this.level + 1, "self.count\n", new Object[0]);
        RustUtil.indent(this.sb, this.level, "}\n\n", new Object[0]);
        RustUtil.indent(this.sb, this.level, "/// will return Some(current index) when successful otherwise None\n", new Object[0]);
        RustUtil.indent(this.sb, this.level, "pub fn advance(&mut self) -> SbeResult<Option<usize>> {\n", new Object[0]);
        RustUtil.indent(this.sb, this.level + 1, "let index = self.index.wrapping_add(1);\n", new Object[0]);
        RustUtil.indent(this.sb, this.level + 1, "if index >= self.count as usize {\n", new Object[0]);
        RustUtil.indent(this.sb, this.level + 2, " return Ok(None);\n", new Object[0]);
        RustUtil.indent(this.sb, this.level + 1, "}\n", new Object[0]);
        RustUtil.indent(this.sb, this.level + 1, "if let Some(parent) = self.parent.as_mut() {\n", new Object[0]);
        RustUtil.indent(this.sb, this.level + 2, "self.offset = parent.get_limit();\n", new Object[0]);
        RustUtil.indent(this.sb, this.level + 2, "parent.set_limit(self.offset + self.block_length as usize);\n", new Object[0]);
        RustUtil.indent(this.sb, this.level + 2, "self.index = index;\n", new Object[0]);
        RustUtil.indent(this.sb, this.level + 2, "Ok(Some(index))\n", new Object[0]);
        RustUtil.indent(this.sb, this.level + 1, "} else {\n", new Object[0]);
        RustUtil.indent(this.sb, this.level + 2, "Err(SbeErr::ParentNotSet)\n", new Object[0]);
        RustUtil.indent(this.sb, this.level + 1, "}\n", new Object[0]);
        RustUtil.indent(this.sb, this.level, "}\n\n", new Object[0]);
        RustGenerator.generateDecoderFields(this.sb, fields, this.level);
        RustGenerator.generateDecoderGroups(this.sb, groups, this.level, this);
        RustGenerator.generateDecoderVarData(this.sb, varData, this.level, true);
        RustUtil.indent(this.sb, this.level - 1, "}\n\n", new Object[0]);
    }

    void appendTo(Appendable dest) throws IOException {
        dest.append(this.sb);
        for (SubGroup subGroup : this.subGroups) {
            subGroup.appendTo(dest);
        }
    }
}

