/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.ir;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.List;
import org.agrona.CloseHelper;
import org.agrona.LangUtil;
import org.agrona.MutableDirectBuffer;
import org.agrona.Verify;
import org.agrona.concurrent.UnsafeBuffer;
import uk.co.real_logic.sbe.PrimitiveType;
import uk.co.real_logic.sbe.ir.Encoding;
import uk.co.real_logic.sbe.ir.Ir;
import uk.co.real_logic.sbe.ir.IrUtil;
import uk.co.real_logic.sbe.ir.Token;
import uk.co.real_logic.sbe.ir.generated.FrameCodecEncoder;
import uk.co.real_logic.sbe.ir.generated.TokenCodecEncoder;

public class IrEncoder
implements AutoCloseable {
    private static final int CAPACITY = 4096;
    private final FileChannel channel;
    private final ByteBuffer resultBuffer;
    private final ByteBuffer buffer;
    private final MutableDirectBuffer directBuffer;
    private final Ir ir;
    private final FrameCodecEncoder frameEncoder = new FrameCodecEncoder();
    private final TokenCodecEncoder tokenEncoder = new TokenCodecEncoder();
    private final byte[] valArray = new byte[4096];
    private final UnsafeBuffer valBuffer = new UnsafeBuffer(this.valArray);
    private int totalLength = 0;

    public IrEncoder(String fileName, Ir ir) {
        try {
            this.channel = new FileOutputStream(fileName).getChannel();
            this.resultBuffer = null;
            this.buffer = ByteBuffer.allocateDirect(4096);
            this.directBuffer = new UnsafeBuffer(this.buffer);
            this.ir = ir;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public IrEncoder(ByteBuffer buffer, Ir ir) {
        this.channel = null;
        this.resultBuffer = buffer;
        this.buffer = ByteBuffer.allocateDirect(4096);
        this.directBuffer = new UnsafeBuffer(this.buffer);
        this.ir = ir;
    }

    @Override
    public void close() {
        CloseHelper.quietClose((AutoCloseable)this.channel);
    }

    public int encode() {
        Verify.notNull((Object)this.ir, (String)"ir");
        this.write(this.buffer, this.encodeFrame());
        this.encodeTokenList(this.ir.headerStructure().tokens());
        this.ir.messages().forEach(this::encodeTokenList);
        return this.totalLength;
    }

    private void encodeTokenList(List<Token> tokenList) {
        for (Token token : tokenList) {
            this.write(this.buffer, this.encodeToken(token));
        }
    }

    private void write(ByteBuffer buffer, int length) {
        buffer.position(0);
        buffer.limit(length);
        if (this.channel != null) {
            try {
                this.channel.write(buffer);
            }
            catch (IOException ex) {
                LangUtil.rethrowUnchecked((Exception)ex);
            }
        } else if (this.resultBuffer != null) {
            this.resultBuffer.put(buffer);
        }
        this.totalLength += length;
    }

    private int encodeFrame() {
        this.frameEncoder.wrap(this.directBuffer, 0).irId(this.ir.id()).irVersion(0).schemaVersion(this.ir.version());
        try {
            byte[] packageBytes = this.ir.packageName().getBytes(FrameCodecEncoder.packageNameCharacterEncoding());
            this.frameEncoder.putPackageName(packageBytes, 0, packageBytes.length);
            byte[] namespaceBytes = IrUtil.getBytes(this.ir.namespaceName(), FrameCodecEncoder.namespaceNameCharacterEncoding());
            this.frameEncoder.putNamespaceName(namespaceBytes, 0, namespaceBytes.length);
            byte[] semanticVersionBytes = IrUtil.getBytes(this.ir.semanticVersion(), FrameCodecEncoder.semanticVersionCharacterEncoding());
            this.frameEncoder.putSemanticVersion(semanticVersionBytes, 0, semanticVersionBytes.length);
        }
        catch (UnsupportedEncodingException ex) {
            LangUtil.rethrowUnchecked((Exception)ex);
        }
        return this.frameEncoder.encodedLength();
    }

    private int encodeToken(Token token) {
        Encoding encoding = token.encoding();
        PrimitiveType type = encoding.primitiveType();
        this.tokenEncoder.wrap(this.directBuffer, 0).tokenOffset(token.offset()).tokenSize(token.encodedLength()).fieldId(token.id()).tokenVersion(token.version()).componentTokenCount(token.componentTokenCount()).signal(IrUtil.mapSignal(token.signal())).primitiveType(IrUtil.mapPrimitiveType(type)).byteOrder(IrUtil.mapByteOrder(encoding.byteOrder())).presence(IrUtil.mapPresence(encoding.presence()));
        try {
            byte[] nameBytes = token.name().getBytes(TokenCodecEncoder.nameCharacterEncoding());
            this.tokenEncoder.putName(nameBytes, 0, nameBytes.length);
            this.tokenEncoder.putConstValue(this.valArray, 0, IrUtil.put((MutableDirectBuffer)this.valBuffer, encoding.constValue(), type));
            this.tokenEncoder.putMinValue(this.valArray, 0, IrUtil.put((MutableDirectBuffer)this.valBuffer, encoding.minValue(), type));
            this.tokenEncoder.putMaxValue(this.valArray, 0, IrUtil.put((MutableDirectBuffer)this.valBuffer, encoding.maxValue(), type));
            this.tokenEncoder.putNullValue(this.valArray, 0, IrUtil.put((MutableDirectBuffer)this.valBuffer, encoding.nullValue(), type));
            byte[] charEncodingBytes = IrUtil.getBytes(encoding.characterEncoding(), TokenCodecEncoder.characterEncodingCharacterEncoding());
            this.tokenEncoder.putCharacterEncoding(charEncodingBytes, 0, charEncodingBytes.length);
            byte[] epochBytes = IrUtil.getBytes(encoding.epoch(), TokenCodecEncoder.epochCharacterEncoding());
            this.tokenEncoder.putEpoch(epochBytes, 0, epochBytes.length);
            byte[] timeUnitBytes = IrUtil.getBytes(encoding.timeUnit(), TokenCodecEncoder.timeUnitCharacterEncoding());
            this.tokenEncoder.putTimeUnit(timeUnitBytes, 0, timeUnitBytes.length);
            byte[] semanticTypeBytes = IrUtil.getBytes(encoding.semanticType(), TokenCodecEncoder.semanticTypeCharacterEncoding());
            this.tokenEncoder.putSemanticType(semanticTypeBytes, 0, semanticTypeBytes.length);
            byte[] descriptionBytes = IrUtil.getBytes(token.description(), TokenCodecEncoder.descriptionCharacterEncoding());
            this.tokenEncoder.putDescription(descriptionBytes, 0, descriptionBytes.length);
        }
        catch (UnsupportedEncodingException ex) {
            LangUtil.rethrowUnchecked((Exception)ex);
        }
        return this.tokenEncoder.encodedLength();
    }
}

