/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.xml;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import uk.co.real_logic.sbe.PrimitiveType;
import uk.co.real_logic.sbe.xml.EncodedDataType;
import uk.co.real_logic.sbe.xml.EnumType;
import uk.co.real_logic.sbe.xml.SetType;
import uk.co.real_logic.sbe.xml.Type;
import uk.co.real_logic.sbe.xml.XmlSchemaParser;

public class CompositeType
extends Type {
    public static final String COMPOSITE_TYPE = "composite";
    public static final String SUB_TYPES_EXP = "type|enum|set|composite|ref";
    private final Map<String, Type> containedTypeByNameMap = new LinkedHashMap<String, Type>();
    private final int sinceVersion;

    public CompositeType(Node node) throws XPathExpressionException {
        super(node);
        this.sinceVersion = Integer.parseInt(XmlSchemaParser.getAttributeValue(node, "sinceVersion", "0"));
        XPath xPath = XPathFactory.newInstance().newXPath();
        NodeList list = (NodeList)xPath.compile(SUB_TYPES_EXP).evaluate(node, XPathConstants.NODESET);
        int size = list.getLength();
        for (int i = 0; i < size; ++i) {
            Node subTypeNode = list.item(i);
            String subTypeName = XmlSchemaParser.getAttributeValue(subTypeNode, "name");
            this.addType(subTypeNode, subTypeName);
        }
        this.checkForValidOffsets(node);
    }

    public Type getType(String name) {
        return this.containedTypeByNameMap.get(name);
    }

    @Override
    public int encodedLength() {
        int offset = 0;
        for (Type t : this.containedTypeByNameMap.values()) {
            if (t.isVariableLength()) {
                return -1;
            }
            if (t.offsetAttribute() != -1) {
                offset = t.offsetAttribute();
            }
            offset += t.encodedLength();
        }
        return offset;
    }

    public int sinceVersion() {
        return this.sinceVersion;
    }

    public List<Type> getTypeList() {
        return new ArrayList<Type>(this.containedTypeByNameMap.values());
    }

    public void makeDataFieldCompositeType() {
        EncodedDataType edt = (EncodedDataType)this.containedTypeByNameMap.get("varData");
        if (edt != null) {
            edt.variableLength(true);
        }
    }

    public void checkForWellFormedGroupSizeEncoding(Node node) {
        EncodedDataType blockLengthType = (EncodedDataType)this.containedTypeByNameMap.get("blockLength");
        EncodedDataType numInGroupType = (EncodedDataType)this.containedTypeByNameMap.get("numInGroup");
        if (blockLengthType == null) {
            XmlSchemaParser.handleError(node, "composite for group encodedLength encoding must have \"blockLength\"");
        } else if (!PrimitiveType.isUnsigned(blockLengthType.primitiveType())) {
            XmlSchemaParser.handleError(node, "\"blockLength\" must be unsigned type");
        }
        if (numInGroupType == null) {
            XmlSchemaParser.handleError(node, "composite for group encodedLength encoding must have \"numInGroup\"");
        } else if (!PrimitiveType.isUnsigned(numInGroupType.primitiveType())) {
            XmlSchemaParser.handleError(node, "\"numInGroup\" must be unsigned type");
        } else if (numInGroupType.primitiveType() != PrimitiveType.UINT8 && numInGroupType.primitiveType() != PrimitiveType.UINT16) {
            XmlSchemaParser.handleWarning(node, "\"numInGroup\" should be UINT8 or UINT16");
        }
    }

    public void checkForWellFormedVariableLengthDataEncoding(Node node) {
        EncodedDataType lengthType = (EncodedDataType)this.containedTypeByNameMap.get("length");
        if (lengthType == null) {
            XmlSchemaParser.handleError(node, "composite for variable length data encoding must have \"length\"");
        } else if (!PrimitiveType.isUnsigned(lengthType.primitiveType())) {
            XmlSchemaParser.handleError(node, "\"length\" must be unsigned type");
        } else if (lengthType.primitiveType() != PrimitiveType.UINT8 && lengthType.primitiveType() != PrimitiveType.UINT16) {
            XmlSchemaParser.handleWarning(node, "\"length\" should be UINT8 or UINT16");
        }
        if ("optional".equals(XmlSchemaParser.getAttributeValueOrNull(node, "presence"))) {
            XmlSchemaParser.handleError(node, "composite for variable length data encoding cannot have presence=\"optional\"");
        }
        if (this.containedTypeByNameMap.get("varData") == null) {
            XmlSchemaParser.handleError(node, "composite for variable length data encoding must have \"varData\"");
        }
    }

    public void checkForWellFormedMessageHeader(Node node) {
        EncodedDataType blockLengthType = (EncodedDataType)this.containedTypeByNameMap.get("blockLength");
        EncodedDataType templateIdType = (EncodedDataType)this.containedTypeByNameMap.get("templateId");
        EncodedDataType schemaIdType = (EncodedDataType)this.containedTypeByNameMap.get("schemaId");
        EncodedDataType versionType = (EncodedDataType)this.containedTypeByNameMap.get("version");
        if (blockLengthType == null) {
            XmlSchemaParser.handleError(node, "composite for message header must have \"blockLength\"");
        } else if (!PrimitiveType.isUnsigned(blockLengthType.primitiveType())) {
            XmlSchemaParser.handleError(node, "\"blockLength\" must be unsigned");
        } else if (blockLengthType.primitiveType() != PrimitiveType.UINT16) {
            XmlSchemaParser.handleWarning(node, "\"blockLength\" should be UINT16");
        }
        if (templateIdType == null) {
            XmlSchemaParser.handleError(node, "composite for message header must have \"templateId\"");
        } else if (templateIdType.primitiveType() != PrimitiveType.UINT16) {
            XmlSchemaParser.handleError(node, "\"templateId\" must be UINT16");
        }
        if (schemaIdType == null) {
            XmlSchemaParser.handleError(node, "composite for message header must have \"schemaId\"");
        } else if (schemaIdType.primitiveType() != PrimitiveType.UINT16) {
            XmlSchemaParser.handleError(node, "\"schemaId\" must be UINT16");
        }
        if (versionType == null) {
            XmlSchemaParser.handleError(node, "composite for message header must have \"version\"");
        } else if (versionType.primitiveType() != PrimitiveType.UINT16) {
            XmlSchemaParser.handleError(node, "\"version\" must be UINT16");
        }
    }

    public void checkForValidOffsets(Node node) {
        int offset = 0;
        for (Type edt : this.containedTypeByNameMap.values()) {
            int offsetAttribute = edt.offsetAttribute();
            if (-1 != offsetAttribute) {
                if (offsetAttribute < offset) {
                    XmlSchemaParser.handleError(node, String.format("composite element \"%s\" has incorrect offset specified", edt.name()));
                }
                offset = offsetAttribute;
            }
            offset += edt.encodedLength();
        }
    }

    @Override
    public boolean isVariableLength() {
        return false;
    }

    private Type addType(Node subTypeNode, String subTypeName) throws XPathExpressionException {
        String nodeName = subTypeNode.getNodeName();
        Type type = null;
        switch (nodeName) {
            case "type": {
                type = this.addType(subTypeNode, subTypeName, new EncodedDataType(subTypeNode));
                break;
            }
            case "enum": {
                type = this.addType(subTypeNode, subTypeName, new EnumType(subTypeNode));
                break;
            }
            case "set": {
                type = this.addType(subTypeNode, subTypeName, new SetType(subTypeNode));
                break;
            }
            case "composite": {
                type = this.addType(subTypeNode, subTypeName, new CompositeType(subTypeNode));
                break;
            }
            case "ref": {
                XPath xPath = XPathFactory.newInstance().newXPath();
                String refName = XmlSchemaParser.getAttributeValue(subTypeNode, "name");
                String refType = XmlSchemaParser.getAttributeValue(subTypeNode, "type");
                int refOffset = Integer.parseInt(XmlSchemaParser.getAttributeValue(subTypeNode, "offset", "-1"));
                Node refTypeNode = (Node)xPath.compile(String.format("/messageSchema/types/*[@name='%s']", refType)).evaluate(subTypeNode.getOwnerDocument(), XPathConstants.NODE);
                if (refTypeNode == null) {
                    XmlSchemaParser.handleError(subTypeNode, "ref type not found: " + refType);
                    break;
                }
                type = this.addType(refTypeNode, refName);
                if (-1 == refOffset) break;
                type.offsetAttribute(refOffset);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown node name: " + nodeName);
            }
        }
        return type;
    }

    private Type addType(Node subTypeNode, String name, Type type) {
        if (this.containedTypeByNameMap.put(name, type) != null) {
            XmlSchemaParser.handleError(subTypeNode, "composite already contains type named: " + name);
        }
        return type;
    }
}

