/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.generation.java;

import java.util.EnumMap;
import java.util.Map;
import uk.co.real_logic.sbe.PrimitiveType;

public class JavaUtil {
    private static Map<PrimitiveType, String> typeNameByPrimitiveTypeMap = new EnumMap<PrimitiveType, String>(PrimitiveType.class);

    public static String javaTypeName(PrimitiveType primitiveType) {
        return typeNameByPrimitiveTypeMap.get((Object)primitiveType);
    }

    public static String toUpperFirstChar(String s) {
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    public static String toLowerFirstChar(String s) {
        return Character.toLowerCase(s.charAt(0)) + s.substring(1);
    }

    public static String formatPropertyName(String s) {
        return JavaUtil.toLowerFirstChar(s);
    }

    public static String formatClassName(String s) {
        return JavaUtil.toUpperFirstChar(s);
    }

    static {
        typeNameByPrimitiveTypeMap.put(PrimitiveType.CHAR, "byte");
        typeNameByPrimitiveTypeMap.put(PrimitiveType.INT8, "byte");
        typeNameByPrimitiveTypeMap.put(PrimitiveType.INT16, "short");
        typeNameByPrimitiveTypeMap.put(PrimitiveType.INT32, "int");
        typeNameByPrimitiveTypeMap.put(PrimitiveType.INT64, "long");
        typeNameByPrimitiveTypeMap.put(PrimitiveType.UINT8, "short");
        typeNameByPrimitiveTypeMap.put(PrimitiveType.UINT16, "int");
        typeNameByPrimitiveTypeMap.put(PrimitiveType.UINT32, "long");
        typeNameByPrimitiveTypeMap.put(PrimitiveType.UINT64, "long");
        typeNameByPrimitiveTypeMap.put(PrimitiveType.FLOAT, "float");
        typeNameByPrimitiveTypeMap.put(PrimitiveType.DOUBLE, "double");
    }
}

