/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.xml;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import uk.co.real_logic.sbe.PrimitiveType;
import uk.co.real_logic.sbe.PrimitiveValue;
import uk.co.real_logic.sbe.xml.Type;
import uk.co.real_logic.sbe.xml.XmlSchemaParser;

public class SetType
extends Type {
    public static final String SET_TYPE = "set";
    private final PrimitiveType encodingType;
    private final Map<PrimitiveValue, Choice> choiceByPrimitiveValueMap = new LinkedHashMap<PrimitiveValue, Choice>();
    private final Map<String, Choice> choiceByNameMap = new LinkedHashMap<String, Choice>();

    public SetType(Node node) throws XPathExpressionException, IllegalArgumentException {
        this(node, null, null);
    }

    public SetType(Node node, String givenName, String referencedName) throws XPathExpressionException, IllegalArgumentException {
        super(node, givenName, referencedName);
        String encodingTypeStr;
        XPath xPath = XPathFactory.newInstance().newXPath();
        switch (encodingTypeStr = XmlSchemaParser.getAttributeValue(node, "encodingType")) {
            case "uint8": 
            case "uint16": 
            case "uint32": 
            case "uint64": {
                this.encodingType = PrimitiveType.get(encodingTypeStr);
                break;
            }
            default: {
                String expression = "/*[local-name() = 'messageSchema']/types/type[@name='" + encodingTypeStr + "']";
                Node encodingTypeNode = (Node)xPath.compile(expression).evaluate(node.getOwnerDocument(), XPathConstants.NODE);
                this.encodingType = null == encodingTypeNode ? null : (Integer.parseInt(XmlSchemaParser.getAttributeValue(encodingTypeNode, "length", "1")) != 1 ? null : PrimitiveType.get(XmlSchemaParser.getAttributeValue(encodingTypeNode, "primitiveType")));
            }
        }
        if (this.encodingType == null) {
            throw new IllegalArgumentException("Illegal encodingType " + encodingTypeStr);
        }
        NodeList list = (NodeList)xPath.compile("choice").evaluate(node, XPathConstants.NODESET);
        int size = list.getLength();
        for (int i = 0; i < size; ++i) {
            Choice c = new Choice(list.item(i), this.encodingType);
            if (this.choiceByPrimitiveValueMap.get(c.primitiveValue()) != null) {
                XmlSchemaParser.handleWarning(node, "Choice value already defined: " + c.primitiveValue());
            }
            if (this.choiceByNameMap.get(c.name()) != null) {
                XmlSchemaParser.handleWarning(node, "Choice already exists for name: " + c.name());
            }
            this.choiceByPrimitiveValueMap.put(c.primitiveValue(), c);
            this.choiceByNameMap.put(c.name(), c);
        }
    }

    public PrimitiveType encodingType() {
        return this.encodingType;
    }

    @Override
    public int encodedLength() {
        return this.encodingType.size();
    }

    public Choice getChoice(PrimitiveValue value) {
        return this.choiceByPrimitiveValueMap.get(value);
    }

    public Choice getChoice(String name) {
        return this.choiceByNameMap.get(name);
    }

    public Collection<Choice> choices() {
        return this.choiceByNameMap.values();
    }

    @Override
    public boolean isVariableLength() {
        return false;
    }

    public String toString() {
        return "SetType{encodingType=" + (Object)((Object)this.encodingType) + ", choiceByPrimitiveValueMap=" + this.choiceByPrimitiveValueMap + ", choiceByNameMap=" + this.choiceByNameMap + '}';
    }

    public static class Choice {
        private final String name;
        private final String description;
        private final PrimitiveValue value;
        private final int sinceVersion;
        private final int deprecated;

        public Choice(Node node, PrimitiveType encodingType) {
            this.name = XmlSchemaParser.getAttributeValue(node, "name");
            this.description = XmlSchemaParser.getAttributeValueOrNull(node, "description");
            this.value = PrimitiveValue.parse(node.getFirstChild().getNodeValue(), encodingType);
            this.sinceVersion = Integer.parseInt(XmlSchemaParser.getAttributeValue(node, "sinceVersion", "0"));
            this.deprecated = Integer.parseInt(XmlSchemaParser.getAttributeValue(node, "deprecated", "0"));
            if (this.value.longValue() >= (long)(encodingType.size() * 8)) {
                throw new IllegalArgumentException("Choice value out of bounds: " + this.value.longValue());
            }
            XmlSchemaParser.checkForValidName(node, this.name);
        }

        public PrimitiveValue primitiveValue() {
            return this.value;
        }

        public String name() {
            return this.name;
        }

        public String description() {
            return this.description;
        }

        public int sinceVersion() {
            return this.sinceVersion;
        }

        public int deprecated() {
            return this.deprecated;
        }

        public String toString() {
            return "Choice{name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", value=" + this.value + ", sinceVersion=" + this.sinceVersion + ", deprecated=" + this.deprecated + '}';
        }
    }
}

