/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.agrona.collections.IntHashSet;
import org.agrona.collections.ObjectHashSet;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import uk.co.real_logic.sbe.xml.CompositeType;
import uk.co.real_logic.sbe.xml.Field;
import uk.co.real_logic.sbe.xml.Presence;
import uk.co.real_logic.sbe.xml.Type;
import uk.co.real_logic.sbe.xml.XmlSchemaParser;

public class Message {
    private static final String FIELD_OR_GROUP_OR_DATA_EXPR = "field|group|data";
    private final int id;
    private final String name;
    private final String description;
    private final int sinceVersion;
    private final int deprecated;
    private final int blockLength;
    private final List<Field> fieldList;
    private final String semanticType;
    private final int computedBlockLength;
    private final Map<String, Type> typeByNameMap;

    public Message(Node messageNode, Map<String, Type> typeByNameMap) throws XPathExpressionException {
        this.id = Integer.parseInt(XmlSchemaParser.getAttributeValue(messageNode, "id"));
        this.name = XmlSchemaParser.getAttributeValue(messageNode, "name");
        this.description = XmlSchemaParser.getAttributeValueOrNull(messageNode, "description");
        this.blockLength = Integer.parseInt(XmlSchemaParser.getAttributeValue(messageNode, "blockLength", "0"));
        this.sinceVersion = Integer.parseInt(XmlSchemaParser.getAttributeValue(messageNode, "sinceVersion", "0"));
        this.deprecated = Integer.parseInt(XmlSchemaParser.getAttributeValue(messageNode, "deprecated", "0"));
        this.semanticType = XmlSchemaParser.getAttributeValueOrNull(messageNode, "semanticType");
        this.typeByNameMap = typeByNameMap;
        this.fieldList = this.parseMembers(messageNode);
        Message.computeAndValidateOffsets(messageNode, this.fieldList, this.blockLength);
        this.computedBlockLength = Message.computeMessageRootBlockLength(this.fieldList);
        Message.validateBlockLength(messageNode, this.blockLength, this.computedBlockLength);
    }

    public int id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String semanticType() {
        return this.semanticType;
    }

    public int sinceVersion() {
        return this.sinceVersion;
    }

    public int deprecated() {
        return this.deprecated;
    }

    public List<Field> fields() {
        return this.fieldList;
    }

    public int blockLength() {
        return this.blockLength > this.computedBlockLength ? this.blockLength : this.computedBlockLength;
    }

    private List<Field> parseMembers(Node node) throws XPathExpressionException {
        XPath xPath = XPathFactory.newInstance().newXPath();
        NodeList list = (NodeList)xPath.compile(FIELD_OR_GROUP_OR_DATA_EXPR).evaluate(node, XPathConstants.NODESET);
        boolean groupEncountered = false;
        boolean dataEncountered = false;
        ObjectHashSet distinctNames = new ObjectHashSet();
        IntHashSet distinctIds = new IntHashSet();
        ArrayList<Field> fieldList = new ArrayList<Field>();
        int size = list.getLength();
        for (int i = 0; i < size; ++i) {
            Field field;
            String nodeName;
            switch (nodeName = list.item(i).getNodeName()) {
                case "group": {
                    if (dataEncountered) {
                        XmlSchemaParser.handleError(node, "group node specified after data node");
                    }
                    field = this.parseGroupField(list, i);
                    groupEncountered = true;
                    break;
                }
                case "data": {
                    field = this.parseDataField(list, i);
                    dataEncountered = true;
                    break;
                }
                case "field": {
                    if (groupEncountered || dataEncountered) {
                        XmlSchemaParser.handleError(node, "field node specified after group or data node specified");
                    }
                    field = this.parseField(list, i);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown node name: " + nodeName);
                }
            }
            if (!distinctIds.add(field.id())) {
                XmlSchemaParser.handleError(node, "duplicate id found: " + field.id());
            }
            if (!distinctNames.add((Object)field.name())) {
                XmlSchemaParser.handleError(node, "duplicate name found: " + field.name());
            }
            fieldList.add(field);
        }
        return fieldList;
    }

    private Field parseGroupField(NodeList nodeList, int nodeIndex) throws XPathExpressionException {
        Node node = nodeList.item(nodeIndex);
        String dimensionTypeName = XmlSchemaParser.getAttributeValue(node, "dimensionType", "groupSizeEncoding");
        Type dimensionType = this.typeByNameMap.get(dimensionTypeName);
        if (dimensionType == null) {
            XmlSchemaParser.handleError(node, "could not find dimensionType: " + dimensionTypeName);
        } else if (!(dimensionType instanceof CompositeType)) {
            XmlSchemaParser.handleError(node, "dimensionType should be a composite type: " + dimensionTypeName);
            dimensionType = null;
        } else {
            ((CompositeType)dimensionType).checkForWellFormedGroupSizeEncoding(node);
        }
        Field field = new Field.Builder().name(XmlSchemaParser.getAttributeValue(node, "name")).description(XmlSchemaParser.getAttributeValueOrNull(node, "description")).id(Integer.parseInt(XmlSchemaParser.getAttributeValue(node, "id"))).blockLength(Integer.parseInt(XmlSchemaParser.getAttributeValue(node, "blockLength", "0"))).sinceVersion(Integer.parseInt(XmlSchemaParser.getAttributeValue(node, "sinceVersion", "0"))).deprecated(Integer.parseInt(XmlSchemaParser.getAttributeValue(node, "deprecated", "0"))).dimensionType((CompositeType)dimensionType).build();
        XmlSchemaParser.checkForValidName(node, field.name());
        field.groupFields(this.parseMembers(node));
        return field;
    }

    private Field parseField(NodeList nodeList, int nodeIndex) {
        Node node = nodeList.item(nodeIndex);
        String typeName = XmlSchemaParser.getAttributeValue(node, "type");
        Type fieldType = this.typeByNameMap.get(typeName);
        if (fieldType == null) {
            XmlSchemaParser.handleError(node, "could not find type: " + typeName);
        }
        Field field = new Field.Builder().name(XmlSchemaParser.getAttributeValue(node, "name")).description(XmlSchemaParser.getAttributeValueOrNull(node, "description")).id(Integer.parseInt(XmlSchemaParser.getAttributeValue(node, "id"))).offset(Integer.parseInt(XmlSchemaParser.getAttributeValue(node, "offset", "0"))).semanticType(XmlSchemaParser.getAttributeValueOrNull(node, "semanticType")).presence(Message.getPresence(node, fieldType)).valueRef(XmlSchemaParser.getAttributeValueOrNull(node, "valueRef")).sinceVersion(Integer.parseInt(XmlSchemaParser.getAttributeValue(node, "sinceVersion", "0"))).deprecated(Integer.parseInt(XmlSchemaParser.getAttributeValue(node, "deprecated", "0"))).epoch(XmlSchemaParser.getAttributeValueOrNull(node, "epoch")).timeUnit(XmlSchemaParser.getAttributeValueOrNull(node, "timeUnit")).type(fieldType).build();
        field.validate(node, this.typeByNameMap);
        return field;
    }

    private static Presence getPresence(Node node, Type fieldType) {
        String presenceStr = XmlSchemaParser.getAttributeValueOrNull(node, "presence");
        Presence presence = null != presenceStr ? Presence.get(presenceStr) : (null != fieldType ? fieldType.presence() : Presence.REQUIRED);
        return presence;
    }

    private Field parseDataField(NodeList nodeList, int nodeIndex) {
        Node node = nodeList.item(nodeIndex);
        String typeName = XmlSchemaParser.getAttributeValue(node, "type");
        Type fieldType = this.typeByNameMap.get(typeName);
        if (fieldType == null) {
            XmlSchemaParser.handleError(node, "could not find type: " + typeName);
        } else if (!(fieldType instanceof CompositeType)) {
            XmlSchemaParser.handleError(node, "data type is not composite type: " + typeName);
        } else {
            ((CompositeType)fieldType).checkForWellFormedVariableLengthDataEncoding(node);
            ((CompositeType)fieldType).makeDataFieldCompositeType();
        }
        Field field = new Field.Builder().name(XmlSchemaParser.getAttributeValue(node, "name")).description(XmlSchemaParser.getAttributeValueOrNull(node, "description")).id(Integer.parseInt(XmlSchemaParser.getAttributeValue(node, "id"))).offset(Integer.parseInt(XmlSchemaParser.getAttributeValue(node, "offset", "0"))).semanticType(XmlSchemaParser.getAttributeValueOrNull(node, "semanticType")).presence(Presence.get(XmlSchemaParser.getAttributeValue(node, "presence", "required"))).sinceVersion(Integer.parseInt(XmlSchemaParser.getAttributeValue(node, "sinceVersion", "0"))).deprecated(Integer.parseInt(XmlSchemaParser.getAttributeValue(node, "deprecated", "0"))).epoch(XmlSchemaParser.getAttributeValue(node, "epoch", "unix")).timeUnit(XmlSchemaParser.getAttributeValue(node, "timeUnit", "nanosecond")).type(fieldType).variableLength(true).build();
        field.validate(node, this.typeByNameMap);
        return field;
    }

    private static int computeAndValidateOffsets(Node node, List<Field> fields, int blockLength) {
        boolean variableLengthBlock = false;
        int offset = 0;
        for (Field field : fields) {
            if (0 != field.offset() && field.offset() < offset) {
                XmlSchemaParser.handleError(node, "Offset provides insufficient space at field: " + field.name());
            }
            if (-1 != offset) {
                if (0 != field.offset()) {
                    offset = field.offset();
                } else if (null != field.dimensionType() && 0 != blockLength) {
                    offset = blockLength;
                } else if (field.isVariableLength() && 0 != blockLength) {
                    offset = blockLength;
                }
            }
            field.computedOffset(variableLengthBlock ? -1 : offset);
            if (null != field.groupFields()) {
                int groupBlockLength = Message.computeAndValidateOffsets(node, field.groupFields(), 0);
                Message.validateBlockLength(node, field.blockLength(), groupBlockLength);
                field.computedBlockLength(Math.max(field.blockLength(), groupBlockLength));
                variableLengthBlock = true;
                continue;
            }
            if (null == field.type() || Presence.CONSTANT == field.presence()) continue;
            int size = field.type().encodedLength();
            if (-1 == size) {
                variableLengthBlock = true;
            } else {
                field.computedBlockLength(size);
            }
            if (variableLengthBlock) continue;
            offset += size;
        }
        return offset;
    }

    private static int computeMessageRootBlockLength(List<Field> fields) {
        int blockLength = 0;
        for (Field field : fields) {
            if (field.groupFields() != null) {
                return blockLength;
            }
            if (field.type() == null) continue;
            int fieldLength = field.type().encodedLength();
            if (-1 == fieldLength) {
                return blockLength;
            }
            if (field.presence() == Presence.CONSTANT) {
                blockLength = field.computedOffset();
                continue;
            }
            blockLength = field.computedOffset() + fieldLength;
        }
        return blockLength;
    }

    private static void validateBlockLength(Node node, long specifiedBlockLength, long computedBlockLength) {
        if (0L != specifiedBlockLength && computedBlockLength > specifiedBlockLength) {
            String msg = "specified blockLength provides insufficient space " + computedBlockLength + " > " + specifiedBlockLength;
            XmlSchemaParser.handleError(node, msg);
        }
    }

    public String toString() {
        return "Message{id=" + this.id + ", name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", sinceVersion=" + this.sinceVersion + ", deprecated=" + this.deprecated + ", blockLength=" + this.blockLength + ", fieldList=" + this.fieldList + ", semanticType='" + this.semanticType + '\'' + ", computedBlockLength=" + this.computedBlockLength + ", typeByNameMap=" + this.typeByNameMap + '}';
    }
}

