/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.generation.csharp;

import java.io.IOException;
import java.io.Writer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import org.agrona.Verify;
import org.agrona.generation.OutputManager;
import uk.co.real_logic.sbe.PrimitiveType;
import uk.co.real_logic.sbe.PrimitiveValue;
import uk.co.real_logic.sbe.generation.CodeGenerator;
import uk.co.real_logic.sbe.generation.Generators;
import uk.co.real_logic.sbe.generation.csharp.CSharpUtil;
import uk.co.real_logic.sbe.ir.Encoding;
import uk.co.real_logic.sbe.ir.GenerationUtil;
import uk.co.real_logic.sbe.ir.Ir;
import uk.co.real_logic.sbe.ir.Signal;
import uk.co.real_logic.sbe.ir.Token;

public class CSharpGenerator
implements CodeGenerator {
    private static final String META_ATTRIBUTE_ENUM = "MetaAttribute";
    private static final String INDENT = "    ";
    private static final String BASE_INDENT = "    ";
    private final Ir ir;
    private final OutputManager outputManager;

    public CSharpGenerator(Ir ir, OutputManager outputManager) {
        Verify.notNull((Object)ir, (String)"ir");
        Verify.notNull((Object)outputManager, (String)"outputManager");
        this.ir = ir;
        this.outputManager = outputManager;
    }

    public void generateMessageHeaderStub() throws IOException {
        this.generateComposite(this.ir.headerStructure().tokens());
    }

    public void generateTypeStubs() throws IOException {
        this.generateMetaAttributeEnum();
        for (List<Token> tokens : this.ir.types()) {
            switch (tokens.get(0).signal()) {
                case BEGIN_ENUM: {
                    this.generateEnum(tokens);
                    break;
                }
                case BEGIN_SET: {
                    this.generateBitSet(tokens);
                    break;
                }
                case BEGIN_COMPOSITE: {
                    this.generateComposite(tokens);
                }
            }
        }
    }

    @Override
    public void generate() throws IOException {
        this.generateMessageHeaderStub();
        this.generateTypeStubs();
        for (List<Token> tokens : this.ir.messages()) {
            Token msgToken = tokens.get(0);
            String className = CSharpUtil.formatClassName(msgToken.name());
            Writer out = this.outputManager.createOutput(className);
            Throwable throwable = null;
            try {
                out.append(this.generateFileHeader(this.ir.applicableNamespace()));
                out.append(this.generateClassDeclaration(className));
                out.append(this.generateMessageFlyweightCode(className, msgToken, "    "));
                List<Token> messageBody = tokens.subList(1, tokens.size() - 1);
                int offset = 0;
                ArrayList<Token> fields = new ArrayList<Token>();
                offset = GenerationUtil.collectFields(messageBody, offset, fields);
                out.append(this.generateFields(fields, "    "));
                ArrayList<Token> groups = new ArrayList<Token>();
                offset = GenerationUtil.collectGroups(messageBody, offset, groups);
                StringBuilder sb = new StringBuilder();
                this.generateGroups(sb, className, groups, "    ");
                out.append(sb);
                ArrayList<Token> varData = new ArrayList<Token>();
                GenerationUtil.collectVarData(messageBody, offset, varData);
                out.append(this.generateVarData(varData, "        "));
                out.append("    }\n");
                out.append("}\n");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out == null) continue;
                if (throwable != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                out.close();
            }
        }
    }

    private void generateGroups(StringBuilder sb, String parentMessageClassName, List<Token> tokens, String indent) {
        int size = tokens.size();
        for (int i = 0; i < size; ++i) {
            Token groupToken = tokens.get(i);
            if (groupToken.signal() != Signal.BEGIN_GROUP) {
                throw new IllegalStateException("tokens must begin with BEGIN_GROUP: token=" + groupToken);
            }
            String groupName = groupToken.name();
            sb.append(this.generateGroupProperty(groupName, groupToken, indent + "    "));
            this.generateGroupClassHeader(sb, groupName, parentMessageClassName, tokens, i, indent + "    ");
            ++i;
            i += tokens.get(i).componentTokenCount();
            ArrayList<Token> fields = new ArrayList<Token>();
            i = GenerationUtil.collectFields(tokens, i, fields);
            sb.append(this.generateFields(fields, indent + "    "));
            ArrayList<Token> groups = new ArrayList<Token>();
            i = GenerationUtil.collectGroups(tokens, i, groups);
            this.generateGroups(sb, parentMessageClassName, groups, indent + "    ");
            ArrayList<Token> varData = new ArrayList<Token>();
            i = GenerationUtil.collectVarData(tokens, i, varData);
            sb.append(this.generateVarData(varData, indent + "    " + "    "));
            sb.append(indent).append("    }\n");
        }
    }

    private void generateGroupClassHeader(StringBuilder sb, String groupName, String parentMessageClassName, List<Token> tokens, int index, String indent) {
        String dimensionsClassName = CSharpUtil.formatClassName(tokens.get(index + 1).name());
        int dimensionHeaderLength = tokens.get(index + 1).encodedLength();
        sb.append(String.format("\n" + indent + "public sealed partial class %1$sGroup\n" + indent + "{\n" + indent + "    " + "private readonly %2$s _dimensions = new %2$s();\n" + indent + "    " + "private %3$s _parentMessage;\n" + indent + "    " + "private DirectBuffer _buffer;\n" + indent + "    " + "private int _blockLength;\n" + indent + "    " + "private int _actingVersion;\n" + indent + "    " + "private int _count;\n" + indent + "    " + "private int _index;\n" + indent + "    " + "private int _offset;\n", CSharpUtil.formatClassName(groupName), dimensionsClassName, parentMessageClassName));
        Token numInGroupToken = Generators.findFirst("numInGroup", tokens, index);
        boolean isIntCastSafe = this.isRepresentableByInt32(numInGroupToken.encoding());
        if (!isIntCastSafe) {
            throw new IllegalArgumentException(String.format("%s.numInGroup - cannot be represented safely by an int. Please constrain the maxValue.", groupName));
        }
        sb.append(String.format("\n" + indent + "    " + "public void WrapForDecode(%s parentMessage, DirectBuffer buffer, int actingVersion)\n" + indent + "    " + "{\n" + indent + "    " + "    " + "_parentMessage = parentMessage;\n" + indent + "    " + "    " + "_buffer = buffer;\n" + indent + "    " + "    " + "_dimensions.Wrap(buffer, parentMessage.Limit, actingVersion);\n" + indent + "    " + "    " + "_blockLength = _dimensions.BlockLength;\n" + indent + "    " + "    " + "_count = (int) _dimensions.NumInGroup;\n" + indent + "    " + "    " + "_actingVersion = actingVersion;\n" + indent + "    " + "    " + "_index = -1;\n" + indent + "    " + "    " + "_parentMessage.Limit = parentMessage.Limit + SbeHeaderSize;\n" + indent + "    " + "}\n", parentMessageClassName));
        int blockLength = tokens.get(index).encodedLength();
        String typeForBlockLength = CSharpUtil.cSharpTypeName(tokens.get(index + 2).encoding().primitiveType());
        String typeForNumInGroup = CSharpUtil.cSharpTypeName(numInGroupToken.encoding().primitiveType());
        String throwCondition = numInGroupToken.encoding().applicableMinValue().longValue() == 0L ? "if ((uint) count > %3$d)\n" : "if (count < %2$d || count > %3$d)\n";
        sb.append(String.format("\n" + indent + "    " + "public void WrapForEncode(%1$s parentMessage, DirectBuffer buffer, int count)\n" + indent + "    " + "{\n" + indent + "    " + "    " + throwCondition + indent + "    " + "    " + "{\n" + indent + "    " + "    " + "    " + "ThrowHelper.ThrowCountOutOfRangeException(count);\n" + indent + "    " + "    " + "}\n\n" + indent + "    " + "    " + "_parentMessage = parentMessage;\n" + indent + "    " + "    " + "_buffer = buffer;\n" + indent + "    " + "    " + "_dimensions.Wrap(buffer, parentMessage.Limit, _actingVersion);\n" + indent + "    " + "    " + "_dimensions.BlockLength = (%4$s)%5$d;\n" + indent + "    " + "    " + "_dimensions.NumInGroup = (%6$s)count;\n" + indent + "    " + "    " + "_index = -1;\n" + indent + "    " + "    " + "_count = count;\n" + indent + "    " + "    " + "_blockLength = %5$d;\n" + indent + "    " + "    " + "_actingVersion = SchemaVersion;\n" + indent + "    " + "    " + "parentMessage.Limit = parentMessage.Limit + SbeHeaderSize;\n" + indent + "    " + "}\n", parentMessageClassName, numInGroupToken.encoding().applicableMinValue().longValue(), numInGroupToken.encoding().applicableMaxValue().longValue(), typeForBlockLength, blockLength, typeForNumInGroup));
        sb.append(String.format("\n" + indent + "    " + "public const int SbeBlockLength = %d;\n" + indent + "    " + "public const int SbeHeaderSize = %d;\n", blockLength, dimensionHeaderLength));
        this.generateGroupEnumerator(sb, groupName, indent);
    }

    private void generateGroupEnumerator(StringBuilder sb, String groupName, String indent) {
        sb.append(indent + "    " + "public int ActingBlockLength { get { return _blockLength; } }\n\n" + indent + "    " + "public int Count { get { return _count; } }\n\n" + indent + "    " + "public bool HasNext { get { return (_index + 1) < _count; } }\n");
        sb.append(String.format("\n" + indent + "    " + "public %sGroup Next()\n" + indent + "    " + "{\n" + indent + "    " + "    " + "if (_index + 1 >= _count)\n" + indent + "    " + "    " + "{\n" + indent + "    " + "    " + "    " + "ThrowHelper.ThrowInvalidOperationException();\n" + indent + "    " + "    " + "}\n\n" + indent + "    " + "    " + "_offset = _parentMessage.Limit;\n" + indent + "    " + "    " + "_parentMessage.Limit = _offset + _blockLength;\n" + indent + "    " + "    " + "++_index;\n\n" + indent + "    " + "    " + "return this;\n" + indent + "    " + "}\n", CSharpUtil.formatClassName(groupName)));
        sb.append("\n" + indent + "    " + "public System.Collections.IEnumerator GetEnumerator()\n" + indent + "    " + "{\n" + indent + "    " + "    " + "while (this.HasNext)\n" + indent + "    " + "    " + "{\n" + indent + "    " + "    " + "    " + "yield return this.Next();\n" + indent + "    " + "    " + "}\n" + indent + "    " + "}\n");
    }

    private boolean isRepresentableByInt32(Encoding encoding) {
        return encoding.applicableMinValue().longValue() >= Integer.MIN_VALUE && encoding.applicableMaxValue().longValue() <= Integer.MAX_VALUE;
    }

    private CharSequence generateGroupProperty(String groupName, Token token, String indent) {
        StringBuilder sb = new StringBuilder();
        String className = CSharpUtil.formatClassName(groupName);
        sb.append(String.format("\n" + indent + "private readonly %sGroup _%s = new %sGroup();\n", className, CSharpUtil.toLowerFirstChar(groupName), className));
        sb.append(String.format("\n" + indent + "public const long %sId = %d;\n", CSharpUtil.toUpperFirstChar(groupName), token.id()));
        this.generateSinceActingDeprecated(sb, indent, CSharpUtil.toUpperFirstChar(groupName), token);
        sb.append(String.format("\n" + indent + "public %1$sGroup %2$s\n" + indent + "{\n" + indent + "    " + "get\n" + indent + "    " + "{\n" + indent + "    " + "    " + "_%3$s.WrapForDecode(_parentMessage, _buffer, _actingVersion);\n" + indent + "    " + "    " + "return _%3$s;\n" + indent + "    " + "}\n" + indent + "}\n", className, CSharpUtil.toUpperFirstChar(groupName), CSharpUtil.toLowerFirstChar(groupName)));
        sb.append(String.format("\n" + indent + "public %1$sGroup %2$sCount(int count)\n" + indent + "{\n" + indent + "    " + "_%3$s.WrapForEncode(_parentMessage, _buffer, count);\n" + indent + "    " + "return _%3$s;\n" + indent + "}\n", className, CSharpUtil.toUpperFirstChar(groupName), CSharpUtil.toLowerFirstChar(groupName)));
        return sb;
    }

    private CharSequence generateVarData(List<Token> tokens, String indent) {
        StringBuilder sb = new StringBuilder();
        int size = tokens.size();
        for (int i = 0; i < size; ++i) {
            Token token = tokens.get(i);
            if (token.signal() != Signal.BEGIN_VAR_DATA) continue;
            this.generateFieldIdMethod(sb, token, indent);
            Token varDataToken = Generators.findFirst("varData", tokens, i);
            String characterEncoding = varDataToken.encoding().characterEncoding();
            this.generateCharacterEncodingMethod(sb, token.name(), characterEncoding, indent);
            this.generateFieldMetaAttributeMethod(sb, token, indent);
            String propertyName = CSharpUtil.toUpperFirstChar(token.name());
            Token lengthToken = Generators.findFirst("length", tokens, i);
            int sizeOfLengthField = lengthToken.encodedLength();
            Encoding lengthEncoding = lengthToken.encoding();
            String lengthCSharpType = CSharpUtil.cSharpTypeName(lengthEncoding.primitiveType());
            String lengthTypePrefix = CSharpUtil.toUpperFirstChar(lengthEncoding.primitiveType().primitiveName());
            ByteOrder byteOrder = lengthEncoding.byteOrder();
            String byteOrderStr = this.generateByteOrder(byteOrder, lengthEncoding.primitiveType().size());
            sb.append(String.format("\n" + indent + "public const int %sHeaderSize = %d;\n", propertyName, sizeOfLengthField));
            sb.append(String.format(indent + "\n" + indent + "public int %1$sLength()\n" + indent + "{\n" + indent + "    " + "_buffer.CheckLimit(_parentMessage.Limit + %2$d);\n" + indent + "    " + "return (int)_buffer.%3$sGet%4$s(_parentMessage.Limit);\n" + indent + "}\n", propertyName, sizeOfLengthField, lengthTypePrefix, byteOrderStr));
            sb.append(String.format("\n" + indent + "public int Get%1$s(byte[] dst, int dstOffset, int length) =>\n" + indent + "    " + "Get%1$s(new Span<byte>(dst, dstOffset, length));\n", propertyName));
            sb.append(String.format("\n" + indent + "public int Get%1$s(Span<byte> dst)\n" + indent + "{\n%2$s" + indent + "    " + "const int sizeOfLengthField = %3$d;\n" + indent + "    " + "int limit = _parentMessage.Limit;\n" + indent + "    " + "_buffer.CheckLimit(limit + sizeOfLengthField);\n" + indent + "    " + "int dataLength = (int)_buffer.%4$sGet%5$s(limit);\n" + indent + "    " + "int bytesCopied = Math.Min(dst.Length, dataLength);\n" + indent + "    " + "_parentMessage.Limit = limit + sizeOfLengthField + dataLength;\n" + indent + "    " + "_buffer.GetBytes(limit + sizeOfLengthField, dst.Slice(0, bytesCopied));\n\n" + indent + "    " + "return bytesCopied;\n" + indent + "}\n", propertyName, this.generateArrayFieldNotPresentCondition(token.version(), indent), sizeOfLengthField, lengthTypePrefix, byteOrderStr));
            sb.append(String.format(indent + "\n" + indent + "// Allocates and returns a new byte array\n" + indent + "public byte[] Get%1$sBytes()\n" + indent + "{\n" + indent + "    " + "const int sizeOfLengthField = %2$d;\n" + indent + "    " + "int limit = _parentMessage.Limit;\n" + indent + "    " + "_buffer.CheckLimit(limit + sizeOfLengthField);\n" + indent + "    " + "int dataLength = (int)_buffer.%3$sGet%4$s(limit);\n" + indent + "    " + "byte[] data = new byte[dataLength];\n" + indent + "    " + "_parentMessage.Limit = limit + sizeOfLengthField + dataLength;\n" + indent + "    " + "_buffer.GetBytes(limit + sizeOfLengthField, data);\n\n" + indent + "    " + "return data;\n" + indent + "}\n", propertyName, sizeOfLengthField, lengthTypePrefix, byteOrderStr));
            sb.append(String.format("\n" + indent + "public int Set%1$s(byte[] src, int srcOffset, int length) =>\n" + indent + "    " + "Set%1$s(new ReadOnlySpan<byte>(src, srcOffset, length));\n", propertyName));
            sb.append(String.format("\n" + indent + "public int Set%1$s(ReadOnlySpan<byte> src)\n" + indent + "{\n" + indent + "    " + "const int sizeOfLengthField = %2$d;\n" + indent + "    " + "int limit = _parentMessage.Limit;\n" + indent + "    " + "_parentMessage.Limit = limit + sizeOfLengthField + src.Length;\n" + indent + "    " + "_buffer.%3$sPut%5$s(limit, (%4$s)src.Length);\n" + indent + "    " + "_buffer.SetBytes(limit + sizeOfLengthField, src);\n\n" + indent + "    " + "return src.Length;\n" + indent + "}\n", propertyName, sizeOfLengthField, lengthTypePrefix, lengthCSharpType, byteOrderStr));
        }
        return sb;
    }

    private void generateBitSet(List<Token> tokens) throws IOException {
        Token enumToken = tokens.get(0);
        String enumName = CSharpUtil.formatClassName(enumToken.applicableTypeName());
        try (Writer out = this.outputManager.createOutput(enumName);){
            out.append(this.generateFileHeader(this.ir.applicableNamespace()));
            String enumPrimitiveType = CSharpUtil.cSharpTypeName(enumToken.encoding().primitiveType());
            out.append(this.generateEnumDeclaration(enumName, enumPrimitiveType, true));
            out.append(this.generateChoices(tokens.subList(1, tokens.size() - 1)));
            out.append("    }\n");
            out.append("}\n");
        }
    }

    private void generateEnum(List<Token> tokens) throws IOException {
        Token enumToken = tokens.get(0);
        String enumName = CSharpUtil.formatClassName(enumToken.applicableTypeName());
        try (Writer out = this.outputManager.createOutput(enumName);){
            out.append(this.generateFileHeader(this.ir.applicableNamespace()));
            String enumPrimitiveType = CSharpUtil.cSharpTypeName(enumToken.encoding().primitiveType());
            out.append(this.generateEnumDeclaration(enumName, enumPrimitiveType, false));
            out.append(this.generateEnumValues(tokens.subList(1, tokens.size() - 1), enumToken));
            out.append("    }\n");
            out.append("}\n");
        }
    }

    private void generateComposite(List<Token> tokens) throws IOException {
        String compositeName = CSharpUtil.formatClassName(tokens.get(0).applicableTypeName());
        try (Writer out = this.outputManager.createOutput(compositeName);){
            out.append(this.generateFileHeader(this.ir.applicableNamespace()));
            out.append(this.generateClassDeclaration(compositeName));
            out.append(this.generateFixedFlyweightCode(tokens.get(0).encodedLength()));
            out.append(this.generateCompositePropertyElements(tokens.subList(1, tokens.size() - 1), "    "));
            out.append("    }\n");
            out.append("}\n");
        }
    }

    private CharSequence generateCompositePropertyElements(List<Token> tokens, String indent) {
        StringBuilder sb = new StringBuilder();
        block6: for (int i = 0; i < tokens.size(); i += tokens.get(i).componentTokenCount()) {
            Token token = tokens.get(i);
            String propertyName = CSharpUtil.formatPropertyName(token.name());
            switch (token.signal()) {
                case ENCODING: {
                    sb.append(this.generatePrimitiveProperty(propertyName, token, indent));
                    continue block6;
                }
                case BEGIN_ENUM: {
                    sb.append(this.generateEnumProperty(propertyName, token, null, indent));
                    continue block6;
                }
                case BEGIN_SET: {
                    sb.append(this.generateBitSetProperty(propertyName, token, indent));
                    continue block6;
                }
                case BEGIN_COMPOSITE: {
                    sb.append(this.generateCompositeProperty(propertyName, token, indent));
                }
            }
        }
        return sb;
    }

    private CharSequence generateChoices(List<Token> tokens) {
        StringBuilder sb = new StringBuilder();
        for (Token token : tokens) {
            if (token.signal() != Signal.CHOICE) continue;
            String choiceName = CSharpUtil.toUpperFirstChar(token.applicableTypeName());
            String choiceBitPosition = token.encoding().constValue().toString();
            int choiceValue = (int)Math.pow(2.0, Integer.parseInt(choiceBitPosition));
            sb.append(String.format("        %s = %s,\n", choiceName, choiceValue));
        }
        return sb;
    }

    private CharSequence generateEnumValues(List<Token> tokens, Token encodingToken) {
        StringBuilder sb = new StringBuilder();
        Encoding encoding = encodingToken.encoding();
        for (Token token : tokens) {
            sb.append("    ").append("    ").append(token.name()).append(" = ").append(token.encoding().constValue()).append(",\n");
        }
        PrimitiveValue nullVal = encoding.applicableNullValue();
        sb.append("    ").append("    ").append("NULL_VALUE = ").append(nullVal).append("\n");
        return sb;
    }

    private CharSequence generateFileHeader(String packageName) {
        String[] tokens = packageName.split("\\.");
        StringBuilder sb = new StringBuilder();
        for (String t : tokens) {
            sb.append(CSharpUtil.toUpperFirstChar(t)).append(".");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        tokens = sb.toString().split("-");
        sb.setLength(0);
        for (String t : tokens) {
            sb.append(CSharpUtil.toUpperFirstChar(t));
        }
        return String.format("/* Generated SBE (Simple Binary Encoding) message codec */\n\n#pragma warning disable 1591 // disable warning on missing comments\nusing System;\nusing Org.SbeTool.Sbe.Dll;\n\nnamespace %s\n{\n", sb);
    }

    private CharSequence generateClassDeclaration(String className) {
        return String.format("    public sealed partial class %s\n    {\n", className);
    }

    private void generateMetaAttributeEnum() throws IOException {
        try (Writer out = this.outputManager.createOutput(META_ATTRIBUTE_ENUM);){
            out.append(this.generateFileHeader(this.ir.applicableNamespace()));
            out.append("    public enum MetaAttribute\n    {\n        Epoch,\n        TimeUnit,\n        SemanticType,\n        Presence\n    }\n}\n");
        }
    }

    private CharSequence generateEnumDeclaration(String name, String primitiveType, boolean addFlagsAttribute) {
        String result = "";
        if (addFlagsAttribute) {
            result = result + "    [Flags]\n";
        }
        result = result + "    public enum " + name + " : " + primitiveType + "\n" + "    " + "{\n";
        return result;
    }

    private CharSequence generatePrimitiveProperty(String propertyName, Token token, String indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.generatePrimitiveFieldMetaData(propertyName, token, indent + "    "));
        if (token.isConstantEncoding()) {
            sb.append(this.generateConstPropertyMethods(propertyName, token, indent));
        } else {
            sb.append(this.generatePrimitivePropertyMethods(propertyName, token, indent));
        }
        return sb;
    }

    private CharSequence generatePrimitivePropertyMethods(String propertyName, Token token, String indent) {
        int arrayLength = token.arrayLength();
        if (arrayLength == 1) {
            return this.generateSingleValueProperty(propertyName, token, indent + "    ");
        }
        if (arrayLength > 1) {
            return this.generateArrayProperty(propertyName, token, indent + "    ");
        }
        return "";
    }

    private CharSequence generatePrimitiveFieldMetaData(String propertyName, Token token, String indent) {
        PrimitiveType primitiveType = token.encoding().primitiveType();
        String typeName = CSharpUtil.cSharpTypeName(primitiveType);
        return String.format("\n" + indent + "public const %1$s %2$sNullValue = %3$s;\n" + indent + "public const %1$s %2$sMinValue = %4$s;\n" + indent + "public const %1$s %2$sMaxValue = %5$s;\n", typeName, CSharpUtil.toUpperFirstChar(propertyName), this.generateLiteral(primitiveType, token.encoding().applicableNullValue().toString()), this.generateLiteral(primitiveType, token.encoding().applicableMinValue().toString()), this.generateLiteral(primitiveType, token.encoding().applicableMaxValue().toString()));
    }

    private CharSequence generateSingleValueProperty(String propertyName, Token token, String indent) {
        String typeName = CSharpUtil.cSharpTypeName(token.encoding().primitiveType());
        String typePrefix = CSharpUtil.toUpperFirstChar(token.encoding().primitiveType().primitiveName());
        int offset = token.offset();
        ByteOrder byteOrder = token.encoding().byteOrder();
        String byteOrderStr = this.generateByteOrder(byteOrder, token.encoding().primitiveType().size());
        return String.format("\n" + indent + "public %1$s %2$s\n" + indent + "{\n" + indent + "    " + "get\n" + indent + "    " + "{\n%3$s" + indent + "    " + "    " + "return _buffer.%4$sGet%6$s(_offset + %5$d);\n" + indent + "    " + "}\n" + indent + "    " + "set\n" + indent + "    " + "{\n" + indent + "    " + "    " + "_buffer.%4$sPut%6$s(_offset + %5$d, value);\n" + indent + "    " + "}\n" + indent + "}\n\n", typeName, CSharpUtil.toUpperFirstChar(propertyName), this.generateFieldNotPresentCondition(token.version(), token.encoding(), indent), typePrefix, offset, byteOrderStr);
    }

    private CharSequence generateFieldNotPresentCondition(int sinceVersion, Encoding encoding, String indent) {
        if (0 == sinceVersion) {
            return "";
        }
        String literal = sinceVersion > 0 ? this.generateLiteral(encoding.primitiveType(), encoding.applicableNullValue().toString()) : "(byte)0";
        return String.format(indent + "    " + "    " + "if (_actingVersion < %1$d) return %2$s;\n\n", sinceVersion, literal);
    }

    private CharSequence generateArrayFieldNotPresentCondition(int sinceVersion, String indent) {
        if (0 == sinceVersion) {
            return "";
        }
        return String.format(indent + "    " + "    " + "if (_actingVersion < %d) return 0;\n\n", sinceVersion);
    }

    private CharSequence generateBitSetNotPresentCondition(int sinceVersion, String indent, String bitSetName) {
        if (0 == sinceVersion) {
            return "";
        }
        return String.format(indent + "    " + "    " + "    " + "if (_actingVersion < %1$d) return (%2$s)0;\n\n", sinceVersion, bitSetName);
    }

    private CharSequence generateTypeFieldNotPresentCondition(int sinceVersion, String indent) {
        if (0 == sinceVersion) {
            return "";
        }
        return String.format(indent + "    " + "    " + "if (_actingVersion < %d) return null;\n\n", sinceVersion);
    }

    private CharSequence generateArrayProperty(String propertyName, Token token, String indent) {
        String typeName = CSharpUtil.cSharpTypeName(token.encoding().primitiveType());
        String typePrefix = CSharpUtil.toUpperFirstChar(token.encoding().primitiveType().primitiveName());
        int offset = token.offset();
        ByteOrder byteOrder = token.encoding().byteOrder();
        String byteOrderStr = this.generateByteOrder(byteOrder, token.encoding().primitiveType().size());
        int fieldLength = token.arrayLength();
        int typeSize = token.encoding().primitiveType().size();
        String propName = CSharpUtil.toUpperFirstChar(propertyName);
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("\n" + indent + "public const int %sLength = %d;\n", propName, fieldLength));
        sb.append(String.format("\n" + indent + "public %1$s Get%2$s(int index)\n" + indent + "{\n" + indent + "    " + "if ((uint) index >= %3$d)\n" + indent + "    " + "{\n" + indent + "    " + "    " + "ThrowHelper.ThrowIndexOutOfRangeException(index);\n" + indent + "    " + "}\n\n%4$s" + indent + "    " + "return _buffer.%5$sGet%8$s(_offset + %6$d + (index * %7$d));\n" + indent + "}\n", typeName, propName, fieldLength, this.generateFieldNotPresentCondition(token.version(), token.encoding(), indent), typePrefix, offset, typeSize, byteOrderStr));
        sb.append(String.format("\n" + indent + "public void Set%1$s(int index, %2$s value)\n" + indent + "{\n" + indent + "    " + "if ((uint) index >= %3$d)\n" + indent + "    " + "{\n" + indent + "    " + "    " + "ThrowHelper.ThrowIndexOutOfRangeException(index);\n" + indent + "    " + "}\n\n" + indent + "    " + "_buffer.%4$sPut%7$s(_offset + %5$d + (index * %6$d), value);\n" + indent + "}\n", propName, typeName, fieldLength, typePrefix, offset, typeSize, byteOrderStr));
        if (token.encoding().primitiveType() == PrimitiveType.CHAR) {
            this.generateCharacterEncodingMethod(sb, propertyName, token.encoding().characterEncoding(), indent);
            sb.append(String.format("\n" + indent + "public int Get%1$s(byte[] dst, int dstOffset)\n" + indent + "{\n" + indent + "    " + "const int length = %2$d;\n%3$s" + indent + "    " + "return Get%1$s(new Span<byte>(dst, dstOffset, length));\n" + indent + "}\n", propName, fieldLength, this.generateArrayFieldNotPresentCondition(token.version(), indent), offset));
            sb.append(String.format("\n" + indent + "public int Get%1$s(Span<byte> dst)\n" + indent + "{\n" + indent + "    " + "const int length = %2$d;\n" + indent + "    " + "if (dst.Length < length)\n" + indent + "    " + "{\n" + indent + "    " + "    " + "ThrowHelper.ThrowWhenSpanLengthTooSmall(dst.Length);\n" + indent + "    " + "}\n\n%3$s" + indent + "    " + "_buffer.GetBytes(_offset + %4$d, dst);\n" + indent + "    " + "return length;\n" + indent + "}\n", propName, fieldLength, this.generateArrayFieldNotPresentCondition(token.version(), indent), offset));
            sb.append(String.format("\n" + indent + "public void Set%1$s(byte[] src, int srcOffset)\n" + indent + "{\n" + indent + "    " + "Set%1$s(new ReadOnlySpan<byte>(src, srcOffset, src.Length - srcOffset));\n" + indent + "}\n", propName, fieldLength, offset));
            sb.append(String.format("\n" + indent + "public void Set%1$s(ReadOnlySpan<byte> src)\n" + indent + "{\n" + indent + "    " + "const int length = %2$d;\n" + indent + "    " + "if (src.Length > length)\n" + indent + "    " + "{\n" + indent + "    " + "    " + "ThrowHelper.ThrowWhenSpanLengthTooLarge(src.Length);\n" + indent + "    " + "}\n\n" + indent + "    " + "_buffer.SetBytes(_offset + %3$d, src);\n" + indent + "}\n", propName, fieldLength, offset));
        }
        return sb;
    }

    private void generateCharacterEncodingMethod(StringBuilder sb, String propertyName, String encoding, String indent) {
        sb.append(String.format("\n" + indent + "public const string %sCharacterEncoding = \"%s\";\n\n", CSharpUtil.formatPropertyName(propertyName), encoding));
    }

    private CharSequence generateConstPropertyMethods(String propertyName, Token token, String indent) {
        if (token.encoding().primitiveType() != PrimitiveType.CHAR) {
            return String.format("\n" + indent + "    " + "public %1$s %2$s { get { return %3$s; } }\n", CSharpUtil.cSharpTypeName(token.encoding().primitiveType()), CSharpUtil.toUpperFirstChar(propertyName), this.generateLiteral(token.encoding().primitiveType(), token.encoding().constValue().toString()));
        }
        StringBuilder sb = new StringBuilder();
        String javaTypeName = CSharpUtil.cSharpTypeName(token.encoding().primitiveType());
        byte[] constantValue = token.encoding().constValue().byteArrayValue(token.encoding().primitiveType());
        CharSequence values = this.generateByteLiteralList(token.encoding().constValue().byteArrayValue(token.encoding().primitiveType()));
        sb.append(String.format("\n" + indent + "    " + "private static readonly byte[] _%1$sValue = { %2$s };\n", propertyName, values));
        sb.append(String.format("\n" + indent + "    " + "public const int %1$sLength = %2$d;\n", CSharpUtil.toUpperFirstChar(propertyName), constantValue.length));
        sb.append(String.format(indent + "    " + "public %1$s %2$s(int index)\n" + indent + "    " + "{\n" + indent + "    " + "    " + "return _%3$sValue[index];\n" + indent + "    " + "}\n\n", javaTypeName, CSharpUtil.toUpperFirstChar(propertyName), propertyName));
        sb.append(String.format(indent + "    " + "public int Get%1$s(byte[] dst, int offset, int length)\n" + indent + "    " + "{\n" + indent + "    " + "    " + "int bytesCopied = Math.Min(length, %2$d);\n" + indent + "    " + "    " + "Array.Copy(_%3$sValue, 0, dst, offset, bytesCopied);\n" + indent + "    " + "    " + "return bytesCopied;\n" + indent + "    " + "}\n", CSharpUtil.toUpperFirstChar(propertyName), constantValue.length, propertyName));
        return sb;
    }

    private CharSequence generateByteLiteralList(byte[] bytes) {
        StringBuilder values = new StringBuilder();
        for (byte b : bytes) {
            values.append(b).append(", ");
        }
        if (values.length() > 0) {
            values.setLength(values.length() - 2);
        }
        return values;
    }

    private CharSequence generateFixedFlyweightCode(int size) {
        return String.format("        private DirectBuffer _buffer;\n        private int _offset;\n        private int _actingVersion;\n\n        public void Wrap(DirectBuffer buffer, int offset, int actingVersion)\n        {\n            _offset = offset;\n            _actingVersion = actingVersion;\n            _buffer = buffer;\n        }\n\n        public const int Size = %d;\n", size);
    }

    private CharSequence generateMessageFlyweightCode(String className, Token token, String indent) {
        String blockLengthType = CSharpUtil.cSharpTypeName(this.ir.headerStructure().blockLengthType());
        String templateIdType = CSharpUtil.cSharpTypeName(this.ir.headerStructure().templateIdType());
        String schemaIdType = CSharpUtil.cSharpTypeName(this.ir.headerStructure().schemaIdType());
        String schemaVersionType = CSharpUtil.cSharpTypeName(this.ir.headerStructure().schemaVersionType());
        String semanticType = token.encoding().semanticType() == null ? "" : token.encoding().semanticType();
        return String.format(indent + "    " + "public const %1$s BlockLength = %2$s;\n" + indent + "    " + "public const %3$s TemplateId = %4$s;\n" + indent + "    " + "public const %5$s SchemaId = %6$s;\n" + indent + "    " + "public const %7$s SchemaVersion = %8$s;\n" + indent + "    " + "public const string SemanticType = \"%9$s\";\n\n" + indent + "    " + "private readonly %10$s _parentMessage;\n" + indent + "    " + "private DirectBuffer _buffer;\n" + indent + "    " + "private int _offset;\n" + indent + "    " + "private int _limit;\n" + indent + "    " + "private int _actingBlockLength;\n" + indent + "    " + "private int _actingVersion;\n\n" + indent + "    " + "public int Offset { get { return _offset; } }\n\n" + indent + "    " + "public %10$s()\n" + indent + "    " + "{\n" + indent + "    " + "    " + "_parentMessage = this;\n" + indent + "    " + "}\n\n" + indent + "    " + "public void WrapForEncode(DirectBuffer buffer, int offset)\n" + indent + "    " + "{\n" + indent + "    " + "    " + "_buffer = buffer;\n" + indent + "    " + "    " + "_offset = offset;\n" + indent + "    " + "    " + "_actingBlockLength = BlockLength;\n" + indent + "    " + "    " + "_actingVersion = SchemaVersion;\n" + indent + "    " + "    " + "Limit = offset + _actingBlockLength;\n" + indent + "    " + "}\n\n" + indent + "    " + "public void WrapForDecode(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion)\n" + indent + "    " + "{\n" + indent + "    " + "    " + "_buffer = buffer;\n" + indent + "    " + "    " + "_offset = offset;\n" + indent + "    " + "    " + "_actingBlockLength = actingBlockLength;\n" + indent + "    " + "    " + "_actingVersion = actingVersion;\n" + indent + "    " + "    " + "Limit = offset + _actingBlockLength;\n" + indent + "    " + "}\n\n" + indent + "    " + "public int Size\n" + indent + "    " + "{\n" + indent + "    " + "    " + "get\n" + indent + "    " + "    " + "{\n" + indent + "    " + "    " + "    " + "return _limit - _offset;\n" + indent + "    " + "    " + "}\n" + indent + "    " + "}\n\n" + indent + "    " + "public int Limit\n" + indent + "    " + "{\n" + indent + "    " + "    " + "get\n" + indent + "    " + "    " + "{\n" + indent + "    " + "    " + "    " + "return _limit;\n" + indent + "    " + "    " + "}\n" + indent + "    " + "    " + "set\n" + indent + "    " + "    " + "{\n" + indent + "    " + "    " + "    " + "_buffer.CheckLimit(value);\n" + indent + "    " + "    " + "    " + "_limit = value;\n" + indent + "    " + "    " + "}\n" + indent + "    " + "}\n\n", blockLengthType, this.generateLiteral(this.ir.headerStructure().blockLengthType(), Integer.toString(token.encodedLength())), templateIdType, this.generateLiteral(this.ir.headerStructure().templateIdType(), Integer.toString(token.id())), schemaIdType, this.generateLiteral(this.ir.headerStructure().schemaIdType(), Integer.toString(this.ir.id())), schemaVersionType, this.generateLiteral(this.ir.headerStructure().schemaVersionType(), Integer.toString(this.ir.version())), semanticType, className);
    }

    private CharSequence generateFields(List<Token> tokens, String indent) {
        StringBuilder sb = new StringBuilder();
        int size = tokens.size();
        block6: for (int i = 0; i < size; ++i) {
            Token signalToken = tokens.get(i);
            if (signalToken.signal() != Signal.BEGIN_FIELD) continue;
            Token encodingToken = tokens.get(i + 1);
            String propertyName = signalToken.name();
            this.generateFieldIdMethod(sb, signalToken, indent + "    ");
            this.generateFieldMetaAttributeMethod(sb, signalToken, indent + "    ");
            switch (encodingToken.signal()) {
                case ENCODING: {
                    sb.append(this.generatePrimitiveProperty(propertyName, encodingToken, indent));
                    continue block6;
                }
                case BEGIN_ENUM: {
                    sb.append(this.generateEnumProperty(propertyName, encodingToken, signalToken, indent));
                    continue block6;
                }
                case BEGIN_SET: {
                    sb.append(this.generateBitSetProperty(propertyName, encodingToken, indent));
                    continue block6;
                }
                case BEGIN_COMPOSITE: {
                    sb.append(this.generateCompositeProperty(propertyName, encodingToken, indent));
                }
            }
        }
        return sb;
    }

    private void generateFieldIdMethod(StringBuilder sb, Token token, String indent) {
        sb.append(String.format("\n" + indent + "public const int %sId = %d;\n", CSharpUtil.formatPropertyName(token.name()), token.id()));
        this.generateSinceActingDeprecated(sb, indent, CSharpUtil.formatPropertyName(token.name()), token);
    }

    private void generateFieldMetaAttributeMethod(StringBuilder sb, Token token, String indent) {
        Encoding encoding = token.encoding();
        String epoch = encoding.epoch() == null ? "" : encoding.epoch();
        String timeUnit = encoding.timeUnit() == null ? "" : encoding.timeUnit();
        String semanticType = encoding.semanticType() == null ? "" : encoding.semanticType();
        String presence = encoding.presence() == null ? "" : encoding.presence().toString().toLowerCase();
        sb.append(String.format("\n" + indent + "public static string %sMetaAttribute(MetaAttribute metaAttribute)\n" + indent + "{\n" + indent + "    " + "switch (metaAttribute)\n" + indent + "    " + "{\n" + indent + "    " + "    " + "case MetaAttribute.Epoch: return \"%s\";\n" + indent + "    " + "    " + "case MetaAttribute.TimeUnit: return \"%s\";\n" + indent + "    " + "    " + "case MetaAttribute.SemanticType: return \"%s\";\n" + indent + "    " + "    " + "case MetaAttribute.Presence: return \"%s\";\n" + indent + "    " + "}\n\n" + indent + "    " + "return \"\";\n" + indent + "}\n", CSharpUtil.toUpperFirstChar(token.name()), epoch, timeUnit, semanticType, presence));
    }

    private CharSequence generateEnumFieldNotPresentCondition(int sinceVersion, String enumName, String indent) {
        if (0 == sinceVersion) {
            return "";
        }
        return String.format(indent + "    " + "    " + "if (_actingVersion < %d) return %s.NULL_VALUE;\n\n", sinceVersion, enumName);
    }

    private CharSequence generateEnumProperty(String propertyName, Token token, Token signalToken, String indent) {
        String enumName = CSharpUtil.formatClassName(token.applicableTypeName());
        String typePrefix = CSharpUtil.toUpperFirstChar(token.encoding().primitiveType().primitiveName());
        String enumUnderlyingType = CSharpUtil.cSharpTypeName(token.encoding().primitiveType());
        int offset = token.offset();
        ByteOrder byteOrder = token.encoding().byteOrder();
        String byteOrderStr = this.generateByteOrder(byteOrder, token.encoding().primitiveType().size());
        if (signalToken != null && signalToken.isConstantEncoding()) {
            String constValue = signalToken.encoding().constValue().toString();
            return String.format("\n" + indent + "    " + "public %1$s %2$s\n" + indent + "    " + "{\n" + indent + "    " + "    " + "get\n" + indent + "    " + "    " + "{\n" + indent + "    " + "    " + "    " + "return %3$s;\n" + indent + "    " + "    " + "}\n" + indent + "    " + "}\n\n", enumName, CSharpUtil.toUpperFirstChar(propertyName), constValue);
        }
        return String.format("\n" + indent + "    " + "public %1$s %2$s\n" + indent + "    " + "{\n" + indent + "    " + "    " + "get\n" + indent + "    " + "    " + "{\n%3$s" + indent + "    " + "    " + "    " + "return (%4$s)_buffer.%5$sGet%7$s(_offset + %6$d);\n" + indent + "    " + "    " + "}\n" + indent + "    " + "    " + "set\n" + indent + "    " + "    " + "{\n" + indent + "    " + "    " + "    " + "_buffer.%5$sPut%7$s(_offset + %6$d, (%8$s)value);\n" + indent + "    " + "    " + "}\n" + indent + "    " + "}\n\n", enumName, CSharpUtil.toUpperFirstChar(propertyName), this.generateEnumFieldNotPresentCondition(token.version(), enumName, indent), enumName, typePrefix, offset, byteOrderStr, enumUnderlyingType);
    }

    private String generateBitSetProperty(String propertyName, Token token, String indent) {
        String bitSetName = CSharpUtil.formatClassName(token.applicableTypeName());
        int offset = token.offset();
        String typePrefix = CSharpUtil.toUpperFirstChar(token.encoding().primitiveType().primitiveName());
        ByteOrder byteOrder = token.encoding().byteOrder();
        String byteOrderStr = this.generateByteOrder(byteOrder, token.encoding().primitiveType().size());
        String typeName = CSharpUtil.cSharpTypeName(token.encoding().primitiveType());
        return String.format("\n" + indent + "    " + "public %1$s %2$s\n" + indent + "    " + "{\n" + indent + "    " + "    " + "get\n" + indent + "    " + "    " + "{\n%3$s" + indent + "    " + "    " + "    " + "return (%4$s)_buffer.%5$sGet%7$s(_offset + %6$d);\n" + indent + "    " + "    " + "}\n" + indent + "    " + "    " + "set\n" + indent + "    " + "    " + "{\n" + indent + "    " + "    " + "    " + "_buffer.%5$sPut%7$s(_offset + %6$d, (%8$s)value);\n" + indent + "    " + "    " + "}\n" + indent + "    " + "}\n", bitSetName, CSharpUtil.toUpperFirstChar(propertyName), this.generateBitSetNotPresentCondition(token.version(), indent, bitSetName), bitSetName, typePrefix, offset, byteOrderStr, typeName);
    }

    private Object generateCompositeProperty(String propertyName, Token token, String indent) {
        String compositeName = CSharpUtil.formatClassName(token.applicableTypeName());
        int offset = token.offset();
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("\n" + indent + "    " + "private readonly %1$s _%2$s = new %3$s();\n", compositeName, CSharpUtil.toLowerFirstChar(propertyName), compositeName));
        sb.append(String.format("\n" + indent + "    " + "public %1$s %2$s\n" + indent + "    " + "{\n" + indent + "    " + "    " + "get\n" + indent + "    " + "    " + "{\n%3$s" + indent + "    " + "    " + "    " + "_%4$s.Wrap(_buffer, _offset + %5$d, _actingVersion);\n" + indent + "    " + "    " + "    " + "return _%4$s;\n" + indent + "    " + "    " + "}\n" + indent + "    " + "}\n", compositeName, CSharpUtil.toUpperFirstChar(propertyName), this.generateTypeFieldNotPresentCondition(token.version(), indent), CSharpUtil.toLowerFirstChar(propertyName), offset));
        return sb;
    }

    private void generateSinceActingDeprecated(StringBuilder sb, String indent, String propertyName, Token token) {
        sb.append(String.format(indent + "public const int %1$sSinceVersion = %2$d;\n" + indent + "public const int %1$sDeprecated = %3$d;\n" + indent + "public bool %1$sInActingVersion()\n" + indent + "{\n" + indent + "    " + "return _actingVersion >= %1$sSinceVersion;\n" + indent + "}\n", propertyName, token.version(), token.deprecated()));
    }

    private String generateByteOrder(ByteOrder byteOrder, int primitiveTypeSize) {
        if (primitiveTypeSize == 1) {
            return "";
        }
        if ("BIG_ENDIAN".equals(byteOrder.toString())) {
            return "BigEndian";
        }
        return "LittleEndian";
    }

    private String generateLiteral(PrimitiveType type, String value) {
        String literal = "";
        String castType = CSharpUtil.cSharpTypeName(type);
        switch (type) {
            case CHAR: 
            case UINT8: 
            case INT8: 
            case INT16: 
            case UINT16: {
                literal = "(" + castType + ")" + value;
                break;
            }
            case INT32: {
                literal = value;
                break;
            }
            case UINT32: {
                literal = value + "U";
                break;
            }
            case FLOAT: {
                if (value.endsWith("NaN")) {
                    literal = "float.NaN";
                    break;
                }
                literal = value + "f";
                break;
            }
            case UINT64: {
                literal = "0x" + Long.toHexString(Long.parseLong(value)) + "UL";
                break;
            }
            case INT64: {
                literal = value + "L";
                break;
            }
            case DOUBLE: {
                literal = value.endsWith("NaN") ? "double.NaN" : value + "d";
            }
        }
        return literal;
    }
}

