/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.generation.csharp;

import java.util.EnumMap;
import java.util.Map;
import uk.co.real_logic.sbe.PrimitiveType;

public class CSharpUtil {
    private static final Map<PrimitiveType, String> PRIMITIVE_TYPE_STRING_ENUM_MAP = new EnumMap<PrimitiveType, String>(PrimitiveType.class);

    public static String cSharpTypeName(PrimitiveType primitiveType) {
        return PRIMITIVE_TYPE_STRING_ENUM_MAP.get((Object)primitiveType);
    }

    public static String toUpperFirstChar(String str) {
        return Character.toUpperCase(str.charAt(0)) + str.substring(1);
    }

    public static String toLowerFirstChar(String str) {
        return Character.toLowerCase(str.charAt(0)) + str.substring(1);
    }

    public static String formatPropertyName(String str) {
        return CSharpUtil.toUpperFirstChar(str);
    }

    public static String formatClassName(String str) {
        return CSharpUtil.toUpperFirstChar(str);
    }

    static {
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.CHAR, "byte");
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.INT8, "sbyte");
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.INT16, "short");
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.INT32, "int");
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.INT64, "long");
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.UINT8, "byte");
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.UINT16, "ushort");
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.UINT32, "uint");
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.UINT64, "ulong");
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.FLOAT, "float");
        PRIMITIVE_TYPE_STRING_ENUM_MAP.put(PrimitiveType.DOUBLE, "double");
    }
}

