/*
 * Decompiled with CFR 0.152.
 */
package extension;

import extension.BooleanType;
import extension.EngineDecoder;
import extension.MessageHeaderDecoder;
import extension.MetaAttribute;
import extension.Model;
import extension.OptionalExtrasDecoder;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.MessageDecoderFlyweight;

public final class CarDecoder
implements MessageDecoderFlyweight {
    public static final int BLOCK_LENGTH = 62;
    public static final int TEMPLATE_ID = 1;
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 1;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final CarDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;
    private final OptionalExtrasDecoder extras = new OptionalExtrasDecoder();
    private final EngineDecoder engine = new EngineDecoder();
    private final FuelFiguresDecoder fuelFigures = new FuelFiguresDecoder(this);
    private final PerformanceFiguresDecoder performanceFigures = new PerformanceFiguresDecoder(this);

    public int sbeBlockLength() {
        return 62;
    }

    public int sbeTemplateId() {
        return 1;
    }

    public int sbeSchemaId() {
        return 1;
    }

    public int sbeSchemaVersion() {
        return 1;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public CarDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public CarDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (1 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public CarDecoder sbeRewind() {
        return this.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int serialNumberId() {
        return 1;
    }

    public static int serialNumberSinceVersion() {
        return 0;
    }

    public static int serialNumberEncodingOffset() {
        return 0;
    }

    public static int serialNumberEncodingLength() {
        return 8;
    }

    public static String serialNumberMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long serialNumberNullValue() {
        return -1L;
    }

    public static long serialNumberMinValue() {
        return 0L;
    }

    public static long serialNumberMaxValue() {
        return -2L;
    }

    public long serialNumber() {
        return this.buffer.getLong(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
    }

    public static int modelYearId() {
        return 2;
    }

    public static int modelYearSinceVersion() {
        return 0;
    }

    public static int modelYearEncodingOffset() {
        return 8;
    }

    public static int modelYearEncodingLength() {
        return 2;
    }

    public static String modelYearMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int modelYearNullValue() {
        return 65535;
    }

    public static int modelYearMinValue() {
        return 0;
    }

    public static int modelYearMaxValue() {
        return 65534;
    }

    public int modelYear() {
        return this.buffer.getShort(this.offset + 8, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
    }

    public static int availableId() {
        return 3;
    }

    public static int availableSinceVersion() {
        return 0;
    }

    public static int availableEncodingOffset() {
        return 10;
    }

    public static int availableEncodingLength() {
        return 1;
    }

    public static String availableMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public short availableRaw() {
        return (short)(this.buffer.getByte(this.offset + 10) & 0xFF);
    }

    public BooleanType available() {
        return BooleanType.get((short)(this.buffer.getByte(this.offset + 10) & 0xFF));
    }

    public static int codeId() {
        return 4;
    }

    public static int codeSinceVersion() {
        return 0;
    }

    public static int codeEncodingOffset() {
        return 11;
    }

    public static int codeEncodingLength() {
        return 1;
    }

    public static String codeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public byte codeRaw() {
        return this.buffer.getByte(this.offset + 11);
    }

    public Model code() {
        return Model.get(this.buffer.getByte(this.offset + 11));
    }

    public static int someNumbersId() {
        return 5;
    }

    public static int someNumbersSinceVersion() {
        return 0;
    }

    public static int someNumbersEncodingOffset() {
        return 12;
    }

    public static int someNumbersEncodingLength() {
        return 16;
    }

    public static String someNumbersMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long someNumbersNullValue() {
        return 0xFFFFFFFFL;
    }

    public static long someNumbersMinValue() {
        return 0L;
    }

    public static long someNumbersMaxValue() {
        return 0xFFFFFFFEL;
    }

    public static int someNumbersLength() {
        return 4;
    }

    public long someNumbers(int index) {
        if (index < 0 || index >= 4) {
            throw new IndexOutOfBoundsException("index out of range: index=" + index);
        }
        int pos = this.offset + 12 + index * 4;
        return (long)this.buffer.getInt(pos, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL;
    }

    public static int vehicleCodeId() {
        return 6;
    }

    public static int vehicleCodeSinceVersion() {
        return 0;
    }

    public static int vehicleCodeEncodingOffset() {
        return 28;
    }

    public static int vehicleCodeEncodingLength() {
        return 6;
    }

    public static String vehicleCodeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static byte vehicleCodeNullValue() {
        return 0;
    }

    public static byte vehicleCodeMinValue() {
        return 32;
    }

    public static byte vehicleCodeMaxValue() {
        return 126;
    }

    public static int vehicleCodeLength() {
        return 6;
    }

    public byte vehicleCode(int index) {
        if (index < 0 || index >= 6) {
            throw new IndexOutOfBoundsException("index out of range: index=" + index);
        }
        int pos = this.offset + 28 + index * 1;
        return this.buffer.getByte(pos);
    }

    public static String vehicleCodeCharacterEncoding() {
        return "ASCII";
    }

    public int getVehicleCode(byte[] dst, int dstOffset) {
        int length = 6;
        if (dstOffset < 0 || dstOffset > dst.length - 6) {
            throw new IndexOutOfBoundsException("Copy will go out of range: offset=" + dstOffset);
        }
        this.buffer.getBytes(this.offset + 28, dst, dstOffset, 6);
        return 6;
    }

    public String vehicleCode() {
        int end;
        byte[] dst = new byte[6];
        this.buffer.getBytes(this.offset + 28, dst, 0, 6);
        for (end = 0; end < 6 && dst[end] != 0; ++end) {
        }
        return new String(dst, 0, end, StandardCharsets.US_ASCII);
    }

    public int getVehicleCode(Appendable value) {
        for (int i = 0; i < 6; ++i) {
            int c = this.buffer.getByte(this.offset + 28 + i) & 0xFF;
            if (c == 0) {
                return i;
            }
            try {
                value.append((char)(c > 127 ? 63 : (char)c));
                continue;
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
        return 6;
    }

    public static int extrasId() {
        return 7;
    }

    public static int extrasSinceVersion() {
        return 0;
    }

    public static int extrasEncodingOffset() {
        return 34;
    }

    public static int extrasEncodingLength() {
        return 1;
    }

    public static String extrasMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public OptionalExtrasDecoder extras() {
        this.extras.wrap(this.buffer, this.offset + 34);
        return this.extras;
    }

    public static int discountedModelId() {
        return 8;
    }

    public static int discountedModelSinceVersion() {
        return 0;
    }

    public static int discountedModelEncodingOffset() {
        return 35;
    }

    public static int discountedModelEncodingLength() {
        return 1;
    }

    public static String discountedModelMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "constant";
        }
        return "";
    }

    public byte discountedModelRaw() {
        return Model.C.value();
    }

    public Model discountedModel() {
        return Model.C;
    }

    public static int engineId() {
        return 9;
    }

    public static int engineSinceVersion() {
        return 0;
    }

    public static int engineEncodingOffset() {
        return 35;
    }

    public static int engineEncodingLength() {
        return 10;
    }

    public static String engineMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public EngineDecoder engine() {
        this.engine.wrap(this.buffer, this.offset + 35);
        return this.engine;
    }

    public static int uuidId() {
        return 100;
    }

    public static int uuidSinceVersion() {
        return 1;
    }

    public static int uuidEncodingOffset() {
        return 45;
    }

    public static int uuidEncodingLength() {
        return 16;
    }

    public static String uuidMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return "";
    }

    public static long uuidNullValue() {
        return Long.MIN_VALUE;
    }

    public static long uuidMinValue() {
        return -9223372036854775807L;
    }

    public static long uuidMaxValue() {
        return Long.MAX_VALUE;
    }

    public static int uuidLength() {
        return 2;
    }

    public long uuid(int index) {
        if (index < 0 || index >= 2) {
            throw new IndexOutOfBoundsException("index out of range: index=" + index);
        }
        if (this.parentMessage.actingVersion < 1) {
            return Long.MIN_VALUE;
        }
        int pos = this.offset + 45 + index * 8;
        return this.buffer.getLong(pos, ByteOrder.LITTLE_ENDIAN);
    }

    public static int cupHolderCountId() {
        return 101;
    }

    public static int cupHolderCountSinceVersion() {
        return 1;
    }

    public static int cupHolderCountEncodingOffset() {
        return 61;
    }

    public static int cupHolderCountEncodingLength() {
        return 1;
    }

    public static String cupHolderCountMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return "";
    }

    public static short cupHolderCountNullValue() {
        return 255;
    }

    public static short cupHolderCountMinValue() {
        return 0;
    }

    public static short cupHolderCountMaxValue() {
        return 254;
    }

    public short cupHolderCount() {
        if (this.parentMessage.actingVersion < 1) {
            return 255;
        }
        return (short)(this.buffer.getByte(this.offset + 61) & 0xFF);
    }

    public static long fuelFiguresDecoderId() {
        return 10L;
    }

    public static int fuelFiguresDecoderSinceVersion() {
        return 0;
    }

    public FuelFiguresDecoder fuelFigures() {
        this.fuelFigures.wrap(this.buffer);
        return this.fuelFigures;
    }

    public static long performanceFiguresDecoderId() {
        return 13L;
    }

    public static int performanceFiguresDecoderSinceVersion() {
        return 0;
    }

    public PerformanceFiguresDecoder performanceFigures() {
        this.performanceFigures.wrap(this.buffer);
        return this.performanceFigures;
    }

    public static int manufacturerId() {
        return 18;
    }

    public static int manufacturerSinceVersion() {
        return 0;
    }

    public static String manufacturerCharacterEncoding() {
        return "UTF-8";
    }

    public static String manufacturerMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int manufacturerHeaderLength() {
        return 4;
    }

    public int manufacturerLength() {
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
    }

    public int skipManufacturer() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getManufacturer(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getManufacturer(byte[] dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapManufacturer(DirectBuffer wrapBuffer) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
    }

    public String manufacturer() {
        String value;
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
        try {
            value = new String(tmp, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return value;
    }

    public static int modelId() {
        return 19;
    }

    public static int modelSinceVersion() {
        return 0;
    }

    public static String modelCharacterEncoding() {
        return "UTF-8";
    }

    public static String modelMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int modelHeaderLength() {
        return 4;
    }

    public int modelLength() {
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
    }

    public int skipModel() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getModel(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getModel(byte[] dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapModel(DirectBuffer wrapBuffer) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
    }

    public String model() {
        String value;
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
        try {
            value = new String(tmp, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return value;
    }

    public static int activationCodeId() {
        return 20;
    }

    public static int activationCodeSinceVersion() {
        return 0;
    }

    public static String activationCodeCharacterEncoding() {
        return "ASCII";
    }

    public static String activationCodeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int activationCodeHeaderLength() {
        return 4;
    }

    public int activationCodeLength() {
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
    }

    public int skipActivationCode() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getActivationCode(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getActivationCode(byte[] dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapActivationCode(DirectBuffer wrapBuffer) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
    }

    public String activationCode() {
        String value;
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
        try {
            value = new String(tmp, "ASCII");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return value;
    }

    public int getActivationCode(Appendable appendable) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        this.buffer.getStringWithoutLengthAscii(dataOffset, dataLength, appendable);
        return dataLength;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        CarDecoder decoder = new CarDecoder();
        decoder.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        int i;
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.initialOffset + this.actingBlockLength);
        builder.append("[Car](sbeTemplateId=");
        builder.append(1);
        builder.append("|sbeSchemaId=");
        builder.append(1);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 1) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(1);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 62) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(62);
        builder.append("):");
        builder.append("serialNumber=");
        builder.append(this.serialNumber());
        builder.append('|');
        builder.append("modelYear=");
        builder.append(this.modelYear());
        builder.append('|');
        builder.append("available=");
        builder.append((Object)this.available());
        builder.append('|');
        builder.append("code=");
        builder.append((Object)this.code());
        builder.append('|');
        builder.append("someNumbers=");
        builder.append('[');
        if (CarDecoder.someNumbersLength() > 0) {
            for (i = 0; i < CarDecoder.someNumbersLength(); ++i) {
                builder.append(this.someNumbers(i));
                builder.append(',');
            }
            builder.setLength(builder.length() - 1);
        }
        builder.append(']');
        builder.append('|');
        builder.append("vehicleCode=");
        for (i = 0; i < CarDecoder.vehicleCodeLength() && this.vehicleCode(i) > 0; ++i) {
            builder.append((char)this.vehicleCode(i));
        }
        builder.append('|');
        builder.append("extras=");
        this.extras().appendTo(builder);
        builder.append('|');
        builder.append("discountedModel=");
        builder.append((Object)this.discountedModel());
        builder.append('|');
        builder.append("engine=");
        EngineDecoder engine = this.engine();
        if (engine != null) {
            engine.appendTo(builder);
        } else {
            builder.append("null");
        }
        builder.append('|');
        builder.append("uuid=");
        builder.append('[');
        if (CarDecoder.uuidLength() > 0) {
            for (int i2 = 0; i2 < CarDecoder.uuidLength(); ++i2) {
                builder.append(this.uuid(i2));
                builder.append(',');
            }
            builder.setLength(builder.length() - 1);
        }
        builder.append(']');
        builder.append('|');
        builder.append("cupHolderCount=");
        builder.append(this.cupHolderCount());
        builder.append('|');
        builder.append("fuelFigures=[");
        FuelFiguresDecoder fuelFigures = this.fuelFigures();
        if (fuelFigures.count() > 0) {
            while (fuelFigures.hasNext()) {
                fuelFigures.next().appendTo(builder);
                builder.append(',');
            }
            builder.setLength(builder.length() - 1);
        }
        builder.append(']');
        builder.append('|');
        builder.append("performanceFigures=[");
        PerformanceFiguresDecoder performanceFigures = this.performanceFigures();
        if (performanceFigures.count() > 0) {
            while (performanceFigures.hasNext()) {
                performanceFigures.next().appendTo(builder);
                builder.append(',');
            }
            builder.setLength(builder.length() - 1);
        }
        builder.append(']');
        builder.append('|');
        builder.append("manufacturer=");
        builder.append('\'').append(this.manufacturer()).append('\'');
        builder.append('|');
        builder.append("model=");
        builder.append('\'').append(this.model()).append('\'');
        builder.append('|');
        builder.append("activationCode=");
        builder.append('\'');
        this.getActivationCode(builder);
        builder.append('\'');
        this.limit(originalLimit);
        return builder;
    }

    public static final class PerformanceFiguresDecoder
    implements Iterable<PerformanceFiguresDecoder>,
    Iterator<PerformanceFiguresDecoder> {
        public static final int HEADER_SIZE = 4;
        private final CarDecoder parentMessage;
        private DirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int blockLength;
        private final AccelerationDecoder acceleration;

        PerformanceFiguresDecoder(CarDecoder parentMessage) {
            this.parentMessage = parentMessage;
            this.acceleration = new AccelerationDecoder(parentMessage);
        }

        public void wrap(DirectBuffer buffer) {
            if (buffer != this.buffer) {
                this.buffer = buffer;
            }
            this.index = 0;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4);
            this.blockLength = buffer.getShort(limit + 0, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            this.count = buffer.getShort(limit + 2, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        }

        @Override
        public PerformanceFiguresDecoder next() {
            if (this.index >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + this.blockLength);
            ++this.index;
            return this;
        }

        public static int countMinValue() {
            return 0;
        }

        public static int countMaxValue() {
            return 65534;
        }

        public static int sbeHeaderSize() {
            return 4;
        }

        public static int sbeBlockLength() {
            return 1;
        }

        public int actingBlockLength() {
            return this.blockLength;
        }

        public int count() {
            return this.count;
        }

        @Override
        public Iterator<PerformanceFiguresDecoder> iterator() {
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.count;
        }

        public static int octaneRatingId() {
            return 14;
        }

        public static int octaneRatingSinceVersion() {
            return 0;
        }

        public static int octaneRatingEncodingOffset() {
            return 0;
        }

        public static int octaneRatingEncodingLength() {
            return 1;
        }

        public static String octaneRatingMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static short octaneRatingNullValue() {
            return 255;
        }

        public static short octaneRatingMinValue() {
            return 90;
        }

        public static short octaneRatingMaxValue() {
            return 110;
        }

        public short octaneRating() {
            return (short)(this.buffer.getByte(this.offset + 0) & 0xFF);
        }

        public static long accelerationDecoderId() {
            return 15L;
        }

        public static int accelerationDecoderSinceVersion() {
            return 0;
        }

        public AccelerationDecoder acceleration() {
            this.acceleration.wrap(this.buffer);
            return this.acceleration;
        }

        public StringBuilder appendTo(StringBuilder builder) {
            if (null == this.buffer) {
                return builder;
            }
            builder.append('(');
            builder.append("octaneRating=");
            builder.append(this.octaneRating());
            builder.append('|');
            builder.append("acceleration=[");
            AccelerationDecoder acceleration = this.acceleration();
            if (acceleration.count() > 0) {
                while (acceleration.hasNext()) {
                    acceleration.next().appendTo(builder);
                    builder.append(',');
                }
                builder.setLength(builder.length() - 1);
            }
            builder.append(']');
            builder.append(')');
            return builder;
        }

        public static final class AccelerationDecoder
        implements Iterable<AccelerationDecoder>,
        Iterator<AccelerationDecoder> {
            public static final int HEADER_SIZE = 4;
            private final CarDecoder parentMessage;
            private DirectBuffer buffer;
            private int count;
            private int index;
            private int offset;
            private int blockLength;

            AccelerationDecoder(CarDecoder parentMessage) {
                this.parentMessage = parentMessage;
            }

            public void wrap(DirectBuffer buffer) {
                if (buffer != this.buffer) {
                    this.buffer = buffer;
                }
                this.index = 0;
                int limit = this.parentMessage.limit();
                this.parentMessage.limit(limit + 4);
                this.blockLength = buffer.getShort(limit + 0, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
                this.count = buffer.getShort(limit + 2, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            }

            @Override
            public AccelerationDecoder next() {
                if (this.index >= this.count) {
                    throw new NoSuchElementException();
                }
                this.offset = this.parentMessage.limit();
                this.parentMessage.limit(this.offset + this.blockLength);
                ++this.index;
                return this;
            }

            public static int countMinValue() {
                return 0;
            }

            public static int countMaxValue() {
                return 65534;
            }

            public static int sbeHeaderSize() {
                return 4;
            }

            public static int sbeBlockLength() {
                return 6;
            }

            public int actingBlockLength() {
                return this.blockLength;
            }

            public int count() {
                return this.count;
            }

            @Override
            public Iterator<AccelerationDecoder> iterator() {
                return this;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasNext() {
                return this.index < this.count;
            }

            public static int mphId() {
                return 16;
            }

            public static int mphSinceVersion() {
                return 0;
            }

            public static int mphEncodingOffset() {
                return 0;
            }

            public static int mphEncodingLength() {
                return 2;
            }

            public static String mphMetaAttribute(MetaAttribute metaAttribute) {
                if (MetaAttribute.PRESENCE == metaAttribute) {
                    return "required";
                }
                return "";
            }

            public static int mphNullValue() {
                return 65535;
            }

            public static int mphMinValue() {
                return 0;
            }

            public static int mphMaxValue() {
                return 65534;
            }

            public int mph() {
                return this.buffer.getShort(this.offset + 0, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            }

            public static int secondsId() {
                return 17;
            }

            public static int secondsSinceVersion() {
                return 0;
            }

            public static int secondsEncodingOffset() {
                return 2;
            }

            public static int secondsEncodingLength() {
                return 4;
            }

            public static String secondsMetaAttribute(MetaAttribute metaAttribute) {
                if (MetaAttribute.PRESENCE == metaAttribute) {
                    return "required";
                }
                return "";
            }

            public static float secondsNullValue() {
                return Float.NaN;
            }

            public static float secondsMinValue() {
                return Float.MIN_VALUE;
            }

            public static float secondsMaxValue() {
                return Float.MAX_VALUE;
            }

            public float seconds() {
                return this.buffer.getFloat(this.offset + 2, ByteOrder.LITTLE_ENDIAN);
            }

            public StringBuilder appendTo(StringBuilder builder) {
                if (null == this.buffer) {
                    return builder;
                }
                builder.append('(');
                builder.append("mph=");
                builder.append(this.mph());
                builder.append('|');
                builder.append("seconds=");
                builder.append(this.seconds());
                builder.append(')');
                return builder;
            }
        }
    }

    public static final class FuelFiguresDecoder
    implements Iterable<FuelFiguresDecoder>,
    Iterator<FuelFiguresDecoder> {
        public static final int HEADER_SIZE = 4;
        private final CarDecoder parentMessage;
        private DirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int blockLength;

        FuelFiguresDecoder(CarDecoder parentMessage) {
            this.parentMessage = parentMessage;
        }

        public void wrap(DirectBuffer buffer) {
            if (buffer != this.buffer) {
                this.buffer = buffer;
            }
            this.index = 0;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4);
            this.blockLength = buffer.getShort(limit + 0, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            this.count = buffer.getShort(limit + 2, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        }

        @Override
        public FuelFiguresDecoder next() {
            if (this.index >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + this.blockLength);
            ++this.index;
            return this;
        }

        public static int countMinValue() {
            return 0;
        }

        public static int countMaxValue() {
            return 65534;
        }

        public static int sbeHeaderSize() {
            return 4;
        }

        public static int sbeBlockLength() {
            return 6;
        }

        public int actingBlockLength() {
            return this.blockLength;
        }

        public int count() {
            return this.count;
        }

        @Override
        public Iterator<FuelFiguresDecoder> iterator() {
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.count;
        }

        public static int speedId() {
            return 11;
        }

        public static int speedSinceVersion() {
            return 0;
        }

        public static int speedEncodingOffset() {
            return 0;
        }

        public static int speedEncodingLength() {
            return 2;
        }

        public static String speedMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int speedNullValue() {
            return 65535;
        }

        public static int speedMinValue() {
            return 0;
        }

        public static int speedMaxValue() {
            return 65534;
        }

        public int speed() {
            return this.buffer.getShort(this.offset + 0, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        }

        public static int mpgId() {
            return 12;
        }

        public static int mpgSinceVersion() {
            return 0;
        }

        public static int mpgEncodingOffset() {
            return 2;
        }

        public static int mpgEncodingLength() {
            return 4;
        }

        public static String mpgMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static float mpgNullValue() {
            return Float.NaN;
        }

        public static float mpgMinValue() {
            return Float.MIN_VALUE;
        }

        public static float mpgMaxValue() {
            return Float.MAX_VALUE;
        }

        public float mpg() {
            return this.buffer.getFloat(this.offset + 2, ByteOrder.LITTLE_ENDIAN);
        }

        public static int usageDescriptionId() {
            return 200;
        }

        public static int usageDescriptionSinceVersion() {
            return 0;
        }

        public static String usageDescriptionCharacterEncoding() {
            return "ASCII";
        }

        public static String usageDescriptionMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int usageDescriptionHeaderLength() {
            return 4;
        }

        public int usageDescriptionLength() {
            int limit = this.parentMessage.limit();
            return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        }

        public int skipUsageDescription() {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int dataOffset = limit + 4;
            this.parentMessage.limit(dataOffset + dataLength);
            return dataLength;
        }

        public int getUsageDescription(MutableDirectBuffer dst, int dstOffset, int length) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 4 + dataLength);
            this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public int getUsageDescription(byte[] dst, int dstOffset, int length) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 4 + dataLength);
            this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public void wrapUsageDescription(DirectBuffer wrapBuffer) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            this.parentMessage.limit(limit + 4 + dataLength);
            wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
        }

        public String usageDescription() {
            String value;
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            this.parentMessage.limit(limit + 4 + dataLength);
            if (0 == dataLength) {
                return "";
            }
            byte[] tmp = new byte[dataLength];
            this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
            try {
                value = new String(tmp, "ASCII");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
            return value;
        }

        public int getUsageDescription(Appendable appendable) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int dataOffset = limit + 4;
            this.parentMessage.limit(dataOffset + dataLength);
            this.buffer.getStringWithoutLengthAscii(dataOffset, dataLength, appendable);
            return dataLength;
        }

        public StringBuilder appendTo(StringBuilder builder) {
            if (null == this.buffer) {
                return builder;
            }
            builder.append('(');
            builder.append("speed=");
            builder.append(this.speed());
            builder.append('|');
            builder.append("mpg=");
            builder.append(this.mpg());
            builder.append('|');
            builder.append("usageDescription=");
            builder.append('\'');
            this.getUsageDescription(builder);
            builder.append('\'');
            builder.append(')');
            return builder;
        }
    }
}

