/*
 * Decompiled with CFR 0.152.
 */
package baseline;

import baseline.BooleanType;
import baseline.BoosterDecoder;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.sbe.CompositeDecoderFlyweight;

public class EngineDecoder
implements CompositeDecoderFlyweight {
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 0;
    public static final int ENCODED_LENGTH = 10;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private int offset;
    private DirectBuffer buffer;
    private static final byte[] FUEL_VALUE = new byte[]{80, 101, 116, 114, 111, 108};
    private final BoosterDecoder booster = new BoosterDecoder();

    public EngineDecoder wrap(DirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        return this;
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public int encodedLength() {
        return 10;
    }

    public int sbeSchemaId() {
        return 1;
    }

    public int sbeSchemaVersion() {
        return 0;
    }

    public static int capacityEncodingOffset() {
        return 0;
    }

    public static int capacityEncodingLength() {
        return 2;
    }

    public static int capacitySinceVersion() {
        return 0;
    }

    public static int capacityNullValue() {
        return 65535;
    }

    public static int capacityMinValue() {
        return 0;
    }

    public static int capacityMaxValue() {
        return 65534;
    }

    public int capacity() {
        return this.buffer.getShort(this.offset + 0, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
    }

    public static int numCylindersEncodingOffset() {
        return 2;
    }

    public static int numCylindersEncodingLength() {
        return 1;
    }

    public static int numCylindersSinceVersion() {
        return 0;
    }

    public static short numCylindersNullValue() {
        return 255;
    }

    public static short numCylindersMinValue() {
        return 0;
    }

    public static short numCylindersMaxValue() {
        return 254;
    }

    public short numCylinders() {
        return (short)(this.buffer.getByte(this.offset + 2) & 0xFF);
    }

    public static int maxRpmEncodingOffset() {
        return 3;
    }

    public static int maxRpmEncodingLength() {
        return 0;
    }

    public static int maxRpmSinceVersion() {
        return 0;
    }

    public static int maxRpmNullValue() {
        return 65535;
    }

    public static int maxRpmMinValue() {
        return 0;
    }

    public static int maxRpmMaxValue() {
        return 65534;
    }

    public int maxRpm() {
        return 9000;
    }

    public static int manufacturerCodeEncodingOffset() {
        return 3;
    }

    public static int manufacturerCodeEncodingLength() {
        return 3;
    }

    public static int manufacturerCodeSinceVersion() {
        return 0;
    }

    public static byte manufacturerCodeNullValue() {
        return 0;
    }

    public static byte manufacturerCodeMinValue() {
        return 32;
    }

    public static byte manufacturerCodeMaxValue() {
        return 126;
    }

    public static int manufacturerCodeLength() {
        return 3;
    }

    public byte manufacturerCode(int index) {
        if (index < 0 || index >= 3) {
            throw new IndexOutOfBoundsException("index out of range: index=" + index);
        }
        int pos = this.offset + 3 + index * 1;
        return this.buffer.getByte(pos);
    }

    public static String manufacturerCodeCharacterEncoding() {
        return "US-ASCII";
    }

    public int getManufacturerCode(byte[] dst, int dstOffset) {
        int length = 3;
        if (dstOffset < 0 || dstOffset > dst.length - 3) {
            throw new IndexOutOfBoundsException("Copy will go out of range: offset=" + dstOffset);
        }
        this.buffer.getBytes(this.offset + 3, dst, dstOffset, 3);
        return 3;
    }

    public String manufacturerCode() {
        int end;
        byte[] dst = new byte[3];
        this.buffer.getBytes(this.offset + 3, dst, 0, 3);
        for (end = 0; end < 3 && dst[end] != 0; ++end) {
        }
        return new String(dst, 0, end, StandardCharsets.US_ASCII);
    }

    public int getManufacturerCode(Appendable value) {
        for (int i = 0; i < 3; ++i) {
            int c = this.buffer.getByte(this.offset + 3 + i) & 0xFF;
            if (c == 0) {
                return i;
            }
            try {
                value.append((char)(c > 127 ? 63 : (char)c));
                continue;
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
        return 3;
    }

    public static int fuelEncodingOffset() {
        return 6;
    }

    public static int fuelEncodingLength() {
        return 0;
    }

    public static int fuelSinceVersion() {
        return 0;
    }

    public static byte fuelNullValue() {
        return 0;
    }

    public static byte fuelMinValue() {
        return 32;
    }

    public static byte fuelMaxValue() {
        return 126;
    }

    public static int fuelLength() {
        return 6;
    }

    public byte fuel(int index) {
        return FUEL_VALUE[index];
    }

    public int getFuel(byte[] dst, int offset, int length) {
        int bytesCopied = Math.min(length, 6);
        System.arraycopy(FUEL_VALUE, 0, dst, offset, bytesCopied);
        return bytesCopied;
    }

    public String fuel() {
        return "Petrol";
    }

    public static int efficiencyEncodingOffset() {
        return 6;
    }

    public static int efficiencyEncodingLength() {
        return 1;
    }

    public static int efficiencySinceVersion() {
        return 0;
    }

    public static byte efficiencyNullValue() {
        return -128;
    }

    public static byte efficiencyMinValue() {
        return 0;
    }

    public static byte efficiencyMaxValue() {
        return 100;
    }

    public byte efficiency() {
        return this.buffer.getByte(this.offset + 6);
    }

    public static int boosterEnabledEncodingOffset() {
        return 7;
    }

    public static int boosterEnabledEncodingLength() {
        return 1;
    }

    public static int boosterEnabledSinceVersion() {
        return 0;
    }

    public BooleanType boosterEnabled() {
        return BooleanType.get((short)(this.buffer.getByte(this.offset + 7) & 0xFF));
    }

    public static int boosterEncodingOffset() {
        return 8;
    }

    public static int boosterEncodingLength() {
        return 2;
    }

    public static int boosterSinceVersion() {
        return 0;
    }

    public BoosterDecoder booster() {
        this.booster.wrap(this.buffer, this.offset + 8);
        return this.booster;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        builder.append('(');
        builder.append("capacity=");
        builder.append(this.capacity());
        builder.append('|');
        builder.append("numCylinders=");
        builder.append(this.numCylinders());
        builder.append('|');
        builder.append("manufacturerCode=");
        for (int i = 0; i < EngineDecoder.manufacturerCodeLength() && this.manufacturerCode(i) > 0; ++i) {
            builder.append((char)this.manufacturerCode(i));
        }
        builder.append('|');
        builder.append("efficiency=");
        builder.append(this.efficiency());
        builder.append('|');
        builder.append("boosterEnabled=");
        builder.append((Object)this.boosterEnabled());
        builder.append('|');
        builder.append("booster=");
        BoosterDecoder booster = this.booster();
        if (booster != null) {
            booster.appendTo(builder);
        } else {
            builder.append("null");
        }
        builder.append(')');
        return builder;
    }
}

