/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.examples;

import baseline.BooleanType;
import baseline.BoostType;
import baseline.CarDecoder;
import baseline.CarEncoder;
import baseline.EngineDecoder;
import baseline.EngineEncoder;
import baseline.MessageHeaderDecoder;
import baseline.MessageHeaderEncoder;
import baseline.Model;
import baseline.OptionalExtrasDecoder;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class ExampleUsingGeneratedStub {
    private static final String ENCODING_FILENAME = "sbe.encoding.filename";
    private static final byte[] VEHICLE_CODE;
    private static final byte[] MANUFACTURER_CODE;
    private static final byte[] MANUFACTURER;
    private static final byte[] MODEL;
    private static final UnsafeBuffer ACTIVATION_CODE;
    private static final MessageHeaderDecoder MESSAGE_HEADER_DECODER;
    private static final MessageHeaderEncoder MESSAGE_HEADER_ENCODER;
    private static final CarDecoder CAR_DECODER;
    private static final CarEncoder CAR_ENCODER;

    public static void main(String[] args) throws Exception {
        System.out.println("\n*** Basic Stub Example ***");
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4096);
        UnsafeBuffer directBuffer = new UnsafeBuffer(byteBuffer);
        int encodingLengthPlusHeader = ExampleUsingGeneratedStub.encode(CAR_ENCODER, directBuffer, MESSAGE_HEADER_ENCODER);
        String encodingFilename = System.getProperty(ENCODING_FILENAME);
        if (encodingFilename != null) {
            try (FileChannel channel = FileChannel.open(Paths.get(encodingFilename, new String[0]), StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE);){
                byteBuffer.limit(encodingLengthPlusHeader);
                channel.write(byteBuffer);
            }
        }
        int bufferOffset = 0;
        MESSAGE_HEADER_DECODER.wrap((DirectBuffer)directBuffer, bufferOffset);
        int templateId = MESSAGE_HEADER_DECODER.templateId();
        if (templateId != 1) {
            throw new IllegalStateException("Template ids do not match");
        }
        int actingBlockLength = MESSAGE_HEADER_DECODER.blockLength();
        int actingVersion = MESSAGE_HEADER_DECODER.version();
        ExampleUsingGeneratedStub.decode(CAR_DECODER, directBuffer, bufferOffset += MESSAGE_HEADER_DECODER.encodedLength(), actingBlockLength, actingVersion);
    }

    public static int encode(CarEncoder car, UnsafeBuffer directBuffer, MessageHeaderEncoder messageHeaderEncoder) {
        car.wrapAndApplyHeader((MutableDirectBuffer)directBuffer, 0, messageHeaderEncoder).serialNumber(1234L).modelYear(2013).available(BooleanType.T).code(Model.A).putVehicleCode(VEHICLE_CODE, 0);
        car.putSomeNumbers(1L, 2L, 3L, 4L);
        car.extras().clear().cruiseControl(true).sportsPack(true).sunRoof(false);
        car.engine().capacity(2000).numCylinders((short)4).putManufacturerCode(MANUFACTURER_CODE, 0).efficiency((byte)35).boosterEnabled(BooleanType.T).booster().boostType(BoostType.NITROUS).horsePower((short)200);
        car.fuelFiguresCount(3).next().speed(30).mpg(35.9f).usageDescription("Urban Cycle").next().speed(55).mpg(49.0f).usageDescription("Combined Cycle").next().speed(75).mpg(40.0f).usageDescription("Highway Cycle");
        CarEncoder.PerformanceFiguresEncoder figures = car.performanceFiguresCount(2);
        figures.next().octaneRating((short)95).accelerationCount(3).next().mph(30).seconds(4.0f).next().mph(60).seconds(7.5f).next().mph(100).seconds(12.2f);
        figures.next().octaneRating((short)99).accelerationCount(3).next().mph(30).seconds(3.8f).next().mph(60).seconds(7.1f).next().mph(100).seconds(11.8f);
        car.manufacturer(new String(MANUFACTURER, StandardCharsets.UTF_8)).putModel(MODEL, 0, MODEL.length).putActivationCode((DirectBuffer)ACTIVATION_CODE, 0, ACTIVATION_CODE.capacity());
        return 8 + car.encodedLength();
    }

    public static void decode(CarDecoder car, UnsafeBuffer directBuffer, int bufferOffset, int actingBlockLength, int actingVersion) throws Exception {
        int i;
        byte[] buffer = new byte[128];
        StringBuilder sb = new StringBuilder();
        car.wrap((DirectBuffer)directBuffer, bufferOffset, actingBlockLength, actingVersion);
        sb.append("\ncar.serialNumber=").append(car.serialNumber());
        sb.append("\ncar.modelYear=").append(car.modelYear());
        sb.append("\ncar.available=").append(car.available());
        sb.append("\ncar.code=").append(car.code());
        sb.append("\ncar.someNumbers=");
        int size = CarEncoder.someNumbersLength();
        for (i = 0; i < size; ++i) {
            sb.append(car.someNumbers(i)).append(", ");
        }
        sb.append("\ncar.vehicleCode=");
        size = CarEncoder.vehicleCodeLength();
        for (i = 0; i < size; ++i) {
            sb.append((char)car.vehicleCode(i));
        }
        OptionalExtrasDecoder extras = car.extras();
        sb.append("\ncar.extras.cruiseControl=").append(extras.cruiseControl());
        sb.append("\ncar.extras.sportsPack=").append(extras.sportsPack());
        sb.append("\ncar.extras.sunRoof=").append(extras.sunRoof());
        sb.append("\ncar.discountedModel=").append(car.discountedModel());
        EngineDecoder engine = car.engine();
        sb.append("\ncar.engine.capacity=").append(engine.capacity());
        sb.append("\ncar.engine.numCylinders=").append(engine.numCylinders());
        sb.append("\ncar.engine.maxRpm=").append(engine.maxRpm());
        sb.append("\ncar.engine.manufacturerCode=");
        int size2 = EngineEncoder.manufacturerCodeLength();
        for (int i2 = 0; i2 < size2; ++i2) {
            sb.append((char)engine.manufacturerCode(i2));
        }
        sb.append("\ncar.engine.efficiency=").append(engine.efficiency());
        sb.append("\ncar.engine.boosterEnabled=").append(engine.boosterEnabled());
        sb.append("\ncar.engine.booster.boostType=").append(engine.booster().boostType());
        sb.append("\ncar.engine.booster.horsePower=").append(engine.booster().horsePower());
        sb.append("\ncar.engine.fuel=").append(new String(buffer, 0, engine.getFuel(buffer, 0, buffer.length), StandardCharsets.US_ASCII));
        for (CarDecoder.FuelFiguresDecoder fuelFigures : car.fuelFigures()) {
            sb.append("\ncar.fuelFigures.speed=").append(fuelFigures.speed());
            sb.append("\ncar.fuelFigures.mpg=").append(fuelFigures.mpg());
            sb.append("\ncar.fuelFigures.usageDescription=").append(fuelFigures.usageDescription());
        }
        for (CarDecoder.PerformanceFiguresDecoder performanceFigures : car.performanceFigures()) {
            sb.append("\ncar.performanceFigures.octaneRating=").append(performanceFigures.octaneRating());
            for (CarDecoder.PerformanceFiguresDecoder.AccelerationDecoder acceleration : performanceFigures.acceleration()) {
                sb.append("\ncar.performanceFigures.acceleration.mph=").append(acceleration.mph());
                sb.append("\ncar.performanceFigures.acceleration.seconds=").append(acceleration.seconds());
            }
        }
        sb.append("\ncar.manufacturer=").append(car.manufacturer());
        sb.append("\ncar.model=").append(new String(buffer, 0, car.getModel(buffer, 0, buffer.length), CarEncoder.modelCharacterEncoding()));
        UnsafeBuffer tempBuffer = new UnsafeBuffer(buffer);
        int tempBufferLength = car.getActivationCode((MutableDirectBuffer)tempBuffer, 0, tempBuffer.capacity());
        sb.append("\ncar.activationCode=").append(new String(buffer, 0, tempBufferLength, CarEncoder.activationCodeCharacterEncoding()));
        sb.append("\ncar.encodedLength=").append(car.encodedLength());
        System.out.println(sb);
    }

    static {
        MESSAGE_HEADER_DECODER = new MessageHeaderDecoder();
        MESSAGE_HEADER_ENCODER = new MessageHeaderEncoder();
        CAR_DECODER = new CarDecoder();
        CAR_ENCODER = new CarEncoder();
        try {
            VEHICLE_CODE = "abcdef".getBytes(CarEncoder.vehicleCodeCharacterEncoding());
            MANUFACTURER_CODE = "123".getBytes(EngineEncoder.manufacturerCodeCharacterEncoding());
            MANUFACTURER = "Honda".getBytes(CarEncoder.manufacturerCharacterEncoding());
            MODEL = "Civic VTi".getBytes(CarEncoder.modelCharacterEncoding());
            ACTIVATION_CODE = new UnsafeBuffer("abcdef".getBytes(CarEncoder.activationCodeCharacterEncoding()));
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }
}

