/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.examples;

import baseline.CarEncoder;
import baseline.MessageHeaderEncoder;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import uk.co.real_logic.sbe.examples.ExampleTokenListener;
import uk.co.real_logic.sbe.examples.ExampleUsingGeneratedStub;
import uk.co.real_logic.sbe.ir.Ir;
import uk.co.real_logic.sbe.ir.IrDecoder;
import uk.co.real_logic.sbe.ir.IrEncoder;
import uk.co.real_logic.sbe.otf.OtfHeaderDecoder;
import uk.co.real_logic.sbe.otf.OtfMessageDecoder;
import uk.co.real_logic.sbe.otf.TokenListener;
import uk.co.real_logic.sbe.xml.IrGenerator;
import uk.co.real_logic.sbe.xml.MessageSchema;
import uk.co.real_logic.sbe.xml.ParserOptions;
import uk.co.real_logic.sbe.xml.XmlSchemaParser;

public class OtfExample {
    private static final MessageHeaderEncoder HEADER_ENCODER = new MessageHeaderEncoder();
    private static final CarEncoder CAR_ENCODER = new CarEncoder();
    private static final int MSG_BUFFER_CAPACITY = 4096;
    private static final int SCHEMA_BUFFER_CAPACITY = 16384;

    public static void main(String[] args) throws Exception {
        System.out.println("\n*** OTF Example ***\n");
        ByteBuffer encodedSchemaBuffer = ByteBuffer.allocateDirect(16384);
        OtfExample.encodeSchema(encodedSchemaBuffer);
        ByteBuffer encodedMsgBuffer = ByteBuffer.allocateDirect(4096);
        OtfExample.encodeTestMessage(encodedMsgBuffer);
        encodedSchemaBuffer.flip();
        Ir ir = OtfExample.decodeIr(encodedSchemaBuffer);
        OtfHeaderDecoder headerDecoder = new OtfHeaderDecoder(ir.headerStructure());
        int bufferOffset = 0;
        UnsafeBuffer buffer = new UnsafeBuffer(encodedMsgBuffer);
        int templateId = headerDecoder.getTemplateId((DirectBuffer)buffer, bufferOffset);
        int schemaId = headerDecoder.getSchemaId((DirectBuffer)buffer, bufferOffset);
        int actingVersion = headerDecoder.getSchemaVersion((DirectBuffer)buffer, bufferOffset);
        int blockLength = headerDecoder.getBlockLength((DirectBuffer)buffer, bufferOffset);
        bufferOffset += headerDecoder.encodedLength();
        List msgTokens = ir.getMessage((long)templateId);
        bufferOffset = OtfMessageDecoder.decode((DirectBuffer)buffer, (int)bufferOffset, (int)actingVersion, (int)blockLength, (List)msgTokens, (TokenListener)new ExampleTokenListener(new PrintWriter(System.out, true)));
        if (bufferOffset != encodedMsgBuffer.position()) {
            throw new IllegalStateException("Message not fully decoded");
        }
    }

    private static void encodeSchema(ByteBuffer byteBuffer) throws Exception {
        Path path = Paths.get("src/main/resources/example-schema.xml", new String[0]);
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));){
            MessageSchema schema = XmlSchemaParser.parse((InputStream)in, (ParserOptions)ParserOptions.DEFAULT);
            Ir ir = new IrGenerator().generate(schema);
            try (IrEncoder irEncoder = new IrEncoder(byteBuffer, ir);){
                irEncoder.encode();
            }
        }
    }

    private static void encodeTestMessage(ByteBuffer byteBuffer) {
        UnsafeBuffer buffer = new UnsafeBuffer(byteBuffer);
        int encodedLength = ExampleUsingGeneratedStub.encode(CAR_ENCODER, buffer, HEADER_ENCODER);
        byteBuffer.position(encodedLength);
    }

    private static Ir decodeIr(ByteBuffer buffer) {
        try (IrDecoder irDecoder = new IrDecoder(buffer);){
            Ir ir = irDecoder.decode();
            return ir;
        }
    }
}

