/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.ir;

import java.util.List;
import org.agrona.Verify;
import uk.co.real_logic.sbe.PrimitiveType;
import uk.co.real_logic.sbe.ir.Token;

public class HeaderStructure {
    public static final String BLOCK_LENGTH = "blockLength";
    public static final String TEMPLATE_ID = "templateId";
    public static final String SCHEMA_ID = "schemaId";
    public static final String SCHEMA_VERSION = "version";
    private final List<Token> tokens;
    private PrimitiveType blockLengthType;
    private PrimitiveType templateIdType;
    private PrimitiveType schemaIdType;
    private PrimitiveType schemaVersionType;

    public HeaderStructure(List<Token> tokens) {
        Verify.notNull(tokens, "tokens");
        this.tokens = tokens;
        this.captureEncodings(tokens);
        Verify.notNull((Object)this.blockLengthType, "blockLengthType");
        Verify.notNull((Object)this.templateIdType, "templateIdType");
        Verify.notNull((Object)this.schemaIdType, "schemaIdType");
        Verify.notNull((Object)this.schemaVersionType, "schemaVersionType");
    }

    private void captureEncodings(List<Token> tokens) {
        for (Token token : tokens) {
            switch (token.name()) {
                case "blockLength": {
                    this.blockLengthType = token.encoding().primitiveType();
                    break;
                }
                case "templateId": {
                    this.templateIdType = token.encoding().primitiveType();
                    break;
                }
                case "schemaId": {
                    this.schemaIdType = token.encoding().primitiveType();
                    break;
                }
                case "version": {
                    this.schemaVersionType = token.encoding().primitiveType();
                }
            }
        }
    }

    public List<Token> tokens() {
        return this.tokens;
    }

    public PrimitiveType blockLengthType() {
        return this.blockLengthType;
    }

    public PrimitiveType templateIdType() {
        return this.templateIdType;
    }

    public PrimitiveType schemaIdType() {
        return this.schemaIdType;
    }

    public PrimitiveType schemaVersionType() {
        return this.schemaVersionType;
    }
}

