/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.ir;

import java.nio.ByteOrder;
import org.agrona.Verify;
import uk.co.real_logic.sbe.PrimitiveType;
import uk.co.real_logic.sbe.PrimitiveValue;

public class Encoding {
    private Presence presence;
    private final PrimitiveType primitiveType;
    private final ByteOrder byteOrder;
    private final PrimitiveValue minValue;
    private final PrimitiveValue maxValue;
    private final PrimitiveValue nullValue;
    private final PrimitiveValue constValue;
    private final String characterEncoding;
    private final String epoch;
    private final String timeUnit;
    private final String semanticType;

    public Encoding() {
        this.presence = Presence.REQUIRED;
        this.primitiveType = null;
        this.byteOrder = ByteOrder.LITTLE_ENDIAN;
        this.minValue = null;
        this.maxValue = null;
        this.nullValue = null;
        this.constValue = null;
        this.characterEncoding = null;
        this.epoch = null;
        this.timeUnit = null;
        this.semanticType = null;
    }

    public Encoding(Presence presence, PrimitiveType primitiveType, ByteOrder byteOrder, PrimitiveValue minValue, PrimitiveValue maxValue, PrimitiveValue nullValue, PrimitiveValue constValue, String characterEncoding, String epoch, String timeUnit, String semanticType) {
        Verify.notNull((Object)presence, "presence");
        Verify.notNull(byteOrder, "byteOrder");
        this.primitiveType = primitiveType;
        this.presence = presence;
        this.byteOrder = byteOrder;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.nullValue = nullValue;
        this.constValue = constValue;
        this.characterEncoding = characterEncoding;
        this.epoch = epoch;
        this.timeUnit = timeUnit;
        this.semanticType = semanticType;
    }

    public PrimitiveType primitiveType() {
        return this.primitiveType;
    }

    public ByteOrder byteOrder() {
        return this.byteOrder;
    }

    public PrimitiveValue minValue() {
        return this.minValue;
    }

    public PrimitiveValue maxValue() {
        return this.maxValue;
    }

    public PrimitiveValue nullValue() {
        return this.nullValue;
    }

    public PrimitiveValue constValue() {
        return this.constValue;
    }

    public Presence presence() {
        return this.presence;
    }

    public void presence(Presence presence) {
        this.presence = presence;
    }

    public PrimitiveValue applicableNullValue() {
        if (null != this.nullValue) {
            return this.nullValue;
        }
        return this.primitiveType.nullValue();
    }

    public PrimitiveValue applicableMinValue() {
        if (null != this.minValue) {
            return this.minValue;
        }
        return this.primitiveType.minValue();
    }

    public PrimitiveValue applicableMaxValue() {
        if (null != this.maxValue) {
            return this.maxValue;
        }
        return this.primitiveType.maxValue();
    }

    public String characterEncoding() {
        return this.characterEncoding;
    }

    public String epoch() {
        return this.epoch;
    }

    public String timeUnit() {
        return this.timeUnit;
    }

    public String semanticType() {
        return this.semanticType;
    }

    public String toString() {
        return "Encoding{presence=" + (Object)((Object)this.presence) + ", primitiveType=" + (Object)((Object)this.primitiveType) + ", byteOrder=" + this.byteOrder + ", minValue=" + this.minValue + ", maxValue=" + this.maxValue + ", nullValue=" + this.nullValue + ", constValue=" + this.constValue + ", characterEncoding='" + this.characterEncoding + '\'' + ", epoch='" + this.epoch + '\'' + ", timeUnit=" + this.timeUnit + ", semanticType='" + this.semanticType + '\'' + '}';
    }

    public static class Builder {
        private PrimitiveType primitiveType = null;
        private Presence presence = Presence.REQUIRED;
        private ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
        private PrimitiveValue minValue = null;
        private PrimitiveValue maxValue = null;
        private PrimitiveValue nullValue = null;
        private PrimitiveValue constValue = null;
        private String characterEncoding = null;
        private String epoch = null;
        private String timeUnit = null;
        private String semanticType = null;

        public Builder primitiveType(PrimitiveType primitiveType) {
            this.primitiveType = primitiveType;
            return this;
        }

        public Builder presence(Presence presence) {
            this.presence = presence;
            return this;
        }

        public Builder byteOrder(ByteOrder byteOrder) {
            this.byteOrder = byteOrder;
            return this;
        }

        public Builder minValue(PrimitiveValue minValue) {
            this.minValue = minValue;
            return this;
        }

        public Builder maxValue(PrimitiveValue maxValue) {
            this.maxValue = maxValue;
            return this;
        }

        public Builder nullValue(PrimitiveValue nullValue) {
            this.nullValue = nullValue;
            return this;
        }

        public Builder constValue(PrimitiveValue constValue) {
            this.constValue = constValue;
            return this;
        }

        public Builder characterEncoding(String characterEncoding) {
            this.characterEncoding = characterEncoding;
            return this;
        }

        public Builder epoch(String epoch) {
            this.epoch = epoch;
            return this;
        }

        public Builder timeUnit(String timeUnit) {
            this.timeUnit = timeUnit;
            return this;
        }

        public Builder semanticType(String semanticType) {
            this.semanticType = semanticType;
            return this;
        }

        public Encoding build() {
            return new Encoding(this.presence, this.primitiveType, this.byteOrder, this.minValue, this.maxValue, this.nullValue, this.constValue, this.characterEncoding, this.epoch, this.timeUnit, this.semanticType);
        }
    }

    public static enum Presence {
        REQUIRED,
        OPTIONAL,
        CONSTANT;

    }
}

