/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.generation.csharp;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.agrona.Verify;
import org.agrona.generation.OutputManager;

public class CSharpNamespaceOutputManager
implements OutputManager {
    private final File outputDir;

    public CSharpNamespaceOutputManager(String baseDirName, String packageName) {
        Verify.notNull(baseDirName, "baseDirName");
        Verify.notNull(packageName, "packageName");
        String dirName = baseDirName.endsWith("" + File.separatorChar) ? baseDirName : baseDirName + File.separatorChar;
        String packageDirName = dirName + packageName.replace('.', '_');
        this.outputDir = new File(packageDirName);
        if (!this.outputDir.exists() && !this.outputDir.mkdirs()) {
            throw new IllegalStateException("Unable to create directory: " + packageDirName);
        }
    }

    @Override
    public Writer createOutput(String name) throws IOException {
        File targetFile = new File(this.outputDir, name + ".cs");
        return Files.newBufferedWriter(targetFile.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);
    }
}

