/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.function.LongConsumer;
import java.util.stream.LongStream;
import org.agrona.collections.Hashing;

public class LongArrayList
extends AbstractList<Long>
implements List<Long>,
RandomAccess,
Serializable {
    public static final long DEFAULT_NULL_VALUE = Long.MIN_VALUE;
    public static final int INITIAL_CAPACITY = 10;
    public static final int MAX_CAPACITY = 0x7FFFFFF7;
    private final long nullValue;
    private int size = 0;
    private long[] elements;

    public LongArrayList() {
        this(10, Long.MIN_VALUE);
    }

    public LongArrayList(int initialCapacity, long nullValue) {
        this.nullValue = nullValue;
        this.elements = new long[Math.max(initialCapacity, 10)];
    }

    public LongArrayList(long[] initialElements, int initialSize, long nullValue) {
        this.wrap(initialElements, initialSize);
        this.nullValue = nullValue;
    }

    public void wrap(long[] initialElements, int initialSize) {
        if (initialSize < 0 || initialSize > initialElements.length) {
            throw new IllegalArgumentException("illegal initial size " + initialSize + " for array length of " + initialElements.length);
        }
        if (initialElements.length < 10) {
            throw new IllegalArgumentException("illegal initial array length " + initialElements.length + ", minimum required is " + 10);
        }
        this.elements = initialElements;
        this.size = initialSize;
    }

    public long nullValue() {
        return this.nullValue;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    public void trimToSize() {
        if (this.elements.length != this.size && this.elements.length > 10) {
            this.elements = Arrays.copyOf(this.elements, Math.max(10, this.size));
        }
    }

    @Override
    public Long get(int index) {
        long value = this.getLong(index);
        return value == this.nullValue ? null : Long.valueOf(value);
    }

    public long getLong(int index) {
        this.checkIndex(index);
        return this.elements[index];
    }

    @Override
    public boolean add(Long element) {
        return this.addLong(null == element ? this.nullValue : element);
    }

    public boolean addLong(long element) {
        this.ensureCapacityPrivate(this.size + 1);
        this.elements[this.size] = element;
        ++this.size;
        return true;
    }

    @Override
    public void add(int index, Long element) {
        this.addLong(index, null == element ? this.nullValue : element);
    }

    public void addLong(int index, long element) {
        this.checkIndexForAdd(index);
        int requiredSize = this.size + 1;
        this.ensureCapacityPrivate(requiredSize);
        if (index < this.size) {
            System.arraycopy(this.elements, index, this.elements, index + 1, this.size - index);
        }
        this.elements[index] = element;
        ++this.size;
    }

    @Override
    public Long set(int index, Long element) {
        long previous = this.setLong(index, null == element ? this.nullValue : element);
        return this.nullValue == previous ? null : Long.valueOf(previous);
    }

    public long setLong(int index, long element) {
        this.checkIndex(index);
        long previous = this.elements[index];
        this.elements[index] = element;
        return previous;
    }

    public boolean containsLong(long value) {
        return -1 != this.indexOf(value);
    }

    public int indexOf(long value) {
        for (int i = 0; i < this.size; ++i) {
            if (value != this.elements[i]) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(long value) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (value != this.elements[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Long remove(int index) {
        this.checkIndex(index);
        long value = this.elements[index];
        int moveCount = this.size - index - 1;
        if (moveCount > 0) {
            System.arraycopy(this.elements, index + 1, this.elements, index, moveCount);
        }
        --this.size;
        return value;
    }

    public long fastUnorderedRemove(int index) {
        this.checkIndex(index);
        long value = this.elements[index];
        this.elements[index] = this.elements[--this.size];
        return value;
    }

    public boolean removeLong(long value) {
        int index = this.indexOf(value);
        if (-1 != index) {
            this.remove(index);
            return true;
        }
        return false;
    }

    public boolean fastUnorderedRemoveLong(long value) {
        int index = this.indexOf(value);
        if (-1 != index) {
            this.elements[index] = this.elements[--this.size];
            return true;
        }
        return false;
    }

    public void pushLong(long element) {
        this.ensureCapacityPrivate(this.size + 1);
        this.elements[this.size] = element;
        ++this.size;
    }

    public long popLong() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.elements[--this.size];
    }

    public void forEachOrderedLong(LongConsumer consumer) {
        for (int i = 0; i < this.size; ++i) {
            consumer.accept(this.elements[i]);
        }
    }

    public LongStream longStream() {
        return Arrays.stream(this.elements, 0, this.size);
    }

    public long[] toLongArray() {
        return Arrays.copyOf(this.elements, this.size);
    }

    public long[] toLongArray(long[] dst) {
        if (dst.length == this.size) {
            System.arraycopy(this.elements, 0, dst, 0, dst.length);
            return dst;
        }
        return Arrays.copyOf(this.elements, this.size);
    }

    public void ensureCapacity(int requiredCapacity) {
        this.ensureCapacityPrivate(Math.max(requiredCapacity, 10));
    }

    public boolean equals(LongArrayList that) {
        if (that == this) {
            return true;
        }
        boolean isEqual = false;
        if (this.size == that.size) {
            isEqual = true;
            for (int i = 0; i < this.size; ++i) {
                long thisValue = this.elements[i];
                long thatValue = that.elements[i];
                if (thisValue == thatValue || thisValue == this.nullValue && thatValue == that.nullValue) continue;
                isEqual = false;
                break;
            }
        }
        return isEqual;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        boolean isEqual = false;
        if (other instanceof LongArrayList) {
            return this.equals((LongArrayList)other);
        }
        if (other instanceof List) {
            List that = (List)other;
            if (this.size == ((List)other).size()) {
                isEqual = true;
                int i = 0;
                for (Object o : that) {
                    Long thatValue;
                    Long thisValue;
                    if ((o == null || o instanceof Long) && Objects.equals(thisValue = this.get(i++), thatValue = (Long)o)) continue;
                    isEqual = false;
                    break;
                }
            }
        }
        return isEqual;
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        for (int i = 0; i < this.size; ++i) {
            long value = this.elements[i];
            hashCode = 31 * hashCode + (value == this.nullValue ? 0 : Hashing.hash(value));
        }
        return hashCode;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (int i = 0; i < this.size; ++i) {
            long value = this.elements[i];
            if (value == this.nullValue) continue;
            sb.append(value);
            sb.append(", ");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 2);
        }
        sb.append(']');
        return sb.toString();
    }

    private void ensureCapacityPrivate(int requiredCapacity) {
        int currentCapacity = this.elements.length;
        if (requiredCapacity > currentCapacity) {
            int newCapacity = currentCapacity + (currentCapacity >> 1);
            if (newCapacity < 0 || newCapacity > 0x7FFFFFF7) {
                if (currentCapacity == 0x7FFFFFF7) {
                    throw new IllegalStateException("max capacity reached: 2147483639");
                }
                newCapacity = 0x7FFFFFF7;
            }
            long[] newElements = new long[newCapacity];
            System.arraycopy(this.elements, 0, newElements, 0, currentCapacity);
            this.elements = newElements;
        }
    }

    private void checkIndex(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("index=" + index + " size=" + this.size);
        }
    }

    private void checkIndexForAdd(int index) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException("index=" + index + " size=" + this.size);
        }
    }
}

