/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.json;

import java.io.UnsupportedEncodingException;
import java.util.List;
import org.agrona.DirectBuffer;
import uk.co.real_logic.sbe.PrimitiveType;
import uk.co.real_logic.sbe.PrimitiveValue;
import uk.co.real_logic.sbe.ir.Encoding;
import uk.co.real_logic.sbe.ir.Token;
import uk.co.real_logic.sbe.otf.TokenListener;
import uk.co.real_logic.sbe.otf.Types;

public class JsonTokenListener
implements TokenListener {
    private final StringBuilder output;
    private int indentation = 0;
    private int compositeLevel = 0;

    public JsonTokenListener(StringBuilder output) {
        this.output = output;
    }

    @Override
    public void onBeginMessage(Token token) {
        this.startObject();
    }

    @Override
    public void onEndMessage(Token token) {
        this.endObject();
    }

    @Override
    public void onEncoding(Token fieldToken, DirectBuffer buffer, int bufferIndex, Token typeToken, int actingVersion) {
        this.property(this.compositeLevel > 0 ? typeToken.name() : fieldToken.name());
        this.appendEncodingAsString(buffer, bufferIndex, typeToken, actingVersion);
        this.next();
    }

    @Override
    public void onEnum(Token fieldToken, DirectBuffer buffer, int bufferIndex, List<Token> tokens, int fromIndex, int toIndex, int actingVersion) {
        Token typeToken = tokens.get(fromIndex + 1);
        long encodedValue = JsonTokenListener.readEncodingAsLong(buffer, bufferIndex, typeToken, actingVersion);
        String value = null;
        if (fieldToken.isConstantEncoding()) {
            String refValue = fieldToken.encoding().constValue().toString();
            int indexOfDot = refValue.indexOf(46);
            value = -1 == indexOfDot ? refValue : refValue.substring(indexOfDot + 1);
        } else {
            for (int i = fromIndex + 1; i < toIndex; ++i) {
                if (encodedValue != tokens.get(i).encoding().constValue().longValue()) continue;
                value = tokens.get(i).name();
                break;
            }
        }
        this.property(this.determineName(0, fieldToken, tokens, fromIndex));
        this.doubleQuote();
        this.output.append(value);
        this.doubleQuote();
        this.next();
    }

    @Override
    public void onBitSet(Token fieldToken, DirectBuffer buffer, int bufferIndex, List<Token> tokens, int fromIndex, int toIndex, int actingVersion) {
        Token typeToken = tokens.get(fromIndex + 1);
        long encodedValue = JsonTokenListener.readEncodingAsLong(buffer, bufferIndex, typeToken, actingVersion);
        this.property(this.determineName(0, fieldToken, tokens, fromIndex));
        this.output.append("{ ");
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            this.output.append('\"').append(tokens.get(i).name()).append("\": ");
            long bitPosition = tokens.get(i).encoding().constValue().longValue();
            boolean flag = (encodedValue & 1L << (int)bitPosition) != 0L;
            this.output.append(Boolean.toString(flag));
            if (i >= toIndex - 1) continue;
            this.output.append(", ");
        }
        this.output.append(" }");
        this.next();
    }

    @Override
    public void onBeginComposite(Token fieldToken, List<Token> tokens, int fromIndex, int toIndex) {
        ++this.compositeLevel;
        this.property(this.determineName(1, fieldToken, tokens, fromIndex));
        this.output.append('\n');
        this.startObject();
    }

    @Override
    public void onEndComposite(Token fieldToken, List<Token> tokens, int fromIndex, int toIndex) {
        --this.compositeLevel;
        this.endObject();
    }

    @Override
    public void onGroupHeader(Token token, int numInGroup) {
        this.property(token.name());
        this.output.append("[\n");
    }

    @Override
    public void onBeginGroup(Token token, int groupIndex, int numInGroup) {
        this.startObject();
    }

    @Override
    public void onEndGroup(Token token, int groupIndex, int numInGroup) {
        this.endObject();
        if (JsonTokenListener.isLastGroup(groupIndex, numInGroup)) {
            this.backup();
            this.output.append("],\n");
        }
    }

    @Override
    public void onVarData(Token fieldToken, DirectBuffer buffer, int bufferIndex, int length, Token typeToken) {
        try {
            this.property(fieldToken.name());
            this.doubleQuote();
            byte[] tempBuffer = new byte[length];
            buffer.getBytes(bufferIndex, tempBuffer, 0, length);
            this.output.append(new String(tempBuffer, 0, length, typeToken.encoding().characterEncoding()));
            this.doubleQuote();
            this.next();
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
        }
    }

    private static boolean isLastGroup(int groupIndex, int numInGroup) {
        return groupIndex == numInGroup - 1;
    }

    private void next() {
        this.output.append(",\n");
    }

    private void property(String name) {
        this.indent();
        this.doubleQuote();
        this.output.append(name);
        this.output.append("\": ");
    }

    private void appendEncodingAsString(DirectBuffer buffer, int index, Token typeToken, int actingVersion) {
        Encoding encoding = typeToken.encoding();
        PrimitiveValue constOrNotPresentValue = JsonTokenListener.constOrNotPresentValue(typeToken, actingVersion);
        if (null != constOrNotPresentValue) {
            if (encoding.primitiveType() == PrimitiveType.CHAR) {
                this.doubleQuote();
            }
            this.output.append(constOrNotPresentValue.toString());
            if (encoding.primitiveType() == PrimitiveType.CHAR) {
                this.doubleQuote();
            }
            return;
        }
        int elementSize = encoding.primitiveType().size();
        int size = typeToken.arrayLength();
        if (size > 1 && encoding.primitiveType() == PrimitiveType.CHAR) {
            this.doubleQuote();
            for (int i = 0; i < size; ++i) {
                this.output.append((char)buffer.getByte(index + i * elementSize));
            }
            this.doubleQuote();
        } else {
            if (size > 1) {
                this.output.append('[');
            }
            for (int i = 0; i < size; ++i) {
                Types.appendAsString(this.output, buffer, index + i * elementSize, encoding);
                this.output.append(", ");
            }
            this.backup();
            if (size > 1) {
                this.output.append(']');
            }
        }
    }

    private void backup() {
        this.output.setLength(this.output.length() - 2);
    }

    private void indent() {
        for (int i = 0; i < this.indentation; ++i) {
            this.output.append("    ");
        }
    }

    private void doubleQuote() {
        this.output.append('\"');
    }

    private void startObject() {
        this.indent();
        this.output.append("{\n");
        ++this.indentation;
    }

    private void endObject() {
        this.backup();
        this.output.append('\n');
        --this.indentation;
        this.indent();
        this.output.append('}');
        if (this.indentation > 0) {
            this.next();
        }
    }

    private String determineName(int thresholdLevel, Token fieldToken, List<Token> tokens, int fromIndex) {
        if (this.compositeLevel > thresholdLevel) {
            return tokens.get(fromIndex).name();
        }
        return fieldToken.name();
    }

    private static PrimitiveValue constOrNotPresentValue(Token token, int actingVersion) {
        Encoding encoding = token.encoding();
        if (token.isConstantEncoding()) {
            return encoding.constValue();
        }
        if (token.isOptionalEncoding() && actingVersion < token.version()) {
            return encoding.applicableNullValue();
        }
        return null;
    }

    private static long readEncodingAsLong(DirectBuffer buffer, int bufferIndex, Token typeToken, int actingVersion) {
        PrimitiveValue constOrNotPresentValue = JsonTokenListener.constOrNotPresentValue(typeToken, actingVersion);
        if (null != constOrNotPresentValue) {
            return constOrNotPresentValue.longValue();
        }
        return Types.getLong(buffer, bufferIndex, typeToken.encoding());
    }
}

