/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.ToIntFunction;
import org.agrona.BitUtil;
import org.agrona.collections.CollectionUtil;
import org.agrona.collections.Hashing;

public class Object2IntHashMap<K>
implements Map<K, Integer>,
Serializable {
    static final int MIN_CAPACITY = 8;
    private final float loadFactor;
    private final int missingValue;
    private int resizeThreshold;
    private int size;
    private final boolean shouldAvoidAllocation;
    private K[] keys;
    private int[] values;
    private ValueCollection valueCollection;
    private KeySet keySet;
    private EntrySet entrySet;

    public Object2IntHashMap(int missingValue) {
        this(8, 0.55f, missingValue);
    }

    public Object2IntHashMap(int initialCapacity, float loadFactor, int missingValue) {
        this(initialCapacity, loadFactor, missingValue, true);
    }

    public Object2IntHashMap(int initialCapacity, float loadFactor, int missingValue, boolean shouldAvoidAllocation) {
        CollectionUtil.validateLoadFactor(loadFactor);
        this.loadFactor = loadFactor;
        int capacity = BitUtil.findNextPositivePowerOfTwo(Math.max(8, initialCapacity));
        this.resizeThreshold = (int)((float)capacity * loadFactor);
        this.missingValue = missingValue;
        this.shouldAvoidAllocation = shouldAvoidAllocation;
        this.keys = new Object[capacity];
        this.values = new int[capacity];
        Arrays.fill(this.values, missingValue);
    }

    public Object2IntHashMap(Object2IntHashMap<K> mapToCopy) {
        this.loadFactor = mapToCopy.loadFactor;
        this.resizeThreshold = mapToCopy.resizeThreshold;
        this.size = mapToCopy.size;
        this.missingValue = mapToCopy.missingValue;
        this.shouldAvoidAllocation = mapToCopy.shouldAvoidAllocation;
        this.keys = (Object[])mapToCopy.keys.clone();
        this.values = (int[])mapToCopy.values.clone();
    }

    public int missingValue() {
        return this.missingValue;
    }

    public float loadFactor() {
        return this.loadFactor;
    }

    public int capacity() {
        return this.values.length;
    }

    public int resizeThreshold() {
        return this.resizeThreshold;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return 0 == this.size;
    }

    @Override
    public boolean containsKey(Object key) {
        int mask = this.values.length - 1;
        int index = Hashing.hash(key, mask);
        boolean found = false;
        while (this.missingValue != this.values[index]) {
            if (key.equals(this.keys[index])) {
                found = true;
                break;
            }
            ++index;
            index &= mask;
        }
        return found;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.containsValue((Integer)value);
    }

    public boolean containsValue(int value) {
        if (value == this.missingValue) {
            return false;
        }
        boolean found = false;
        for (int v : this.values) {
            if (value != v) continue;
            found = true;
            break;
        }
        return found;
    }

    @Override
    public Integer get(Object key) {
        return this.valOrNull(this.getValue(key));
    }

    public int getValue(K key) {
        int value;
        int mask = this.values.length - 1;
        int index = Hashing.hash(key, mask);
        while (this.missingValue != (value = this.values[index]) && !key.equals(this.keys[index])) {
            ++index;
            index &= mask;
        }
        return value;
    }

    public int computeIfAbsent(K key, ToIntFunction<? super K> mappingFunction) {
        int value = this.getValue(key);
        if (value == this.missingValue && (value = mappingFunction.applyAsInt(key)) != this.missingValue) {
            this.put(key, value);
        }
        return value;
    }

    @Override
    public Integer put(K key, Integer value) {
        return this.valOrNull(this.put(key, (int)value));
    }

    @Override
    public int put(K key, int value) {
        if (value == this.missingValue) {
            throw new IllegalArgumentException("Cannot accept missingValue");
        }
        int oldValue = this.missingValue;
        int mask = this.values.length - 1;
        int index = Hashing.hash(key, mask);
        while (this.missingValue != this.values[index]) {
            if (key.equals(this.keys[index])) {
                oldValue = this.values[index];
                break;
            }
            ++index;
            index &= mask;
        }
        if (this.missingValue == oldValue) {
            ++this.size;
            this.keys[index] = key;
        }
        this.values[index] = value;
        if (this.size > this.resizeThreshold) {
            this.increaseCapacity();
        }
        return oldValue;
    }

    @Override
    public Integer remove(Object key) {
        return this.valOrNull(this.removeKey(key));
    }

    public int removeKey(K key) {
        int value;
        int mask = this.values.length - 1;
        int index = Hashing.hash(key, mask);
        while (this.missingValue != (value = this.values[index])) {
            if (key.equals(this.keys[index])) {
                this.keys[index] = null;
                this.values[index] = this.missingValue;
                --this.size;
                this.compactChain(index);
                break;
            }
            ++index;
            index &= mask;
        }
        return value;
    }

    @Override
    public void clear() {
        if (this.size > 0) {
            Arrays.fill(this.keys, null);
            Arrays.fill(this.values, this.missingValue);
            this.size = 0;
        }
    }

    public void compact() {
        int idealCapacity = (int)Math.round((double)this.size() * (1.0 / (double)this.loadFactor));
        this.rehash(BitUtil.findNextPositivePowerOfTwo(Math.max(8, idealCapacity)));
    }

    @Override
    public void putAll(Map<? extends K, ? extends Integer> map) {
        for (Map.Entry<K, Integer> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Set<K> keySet() {
        if (null == this.keySet) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    public ValueCollection values() {
        if (null == this.valueCollection) {
            this.valueCollection = new ValueCollection();
        }
        return this.valueCollection;
    }

    @Override
    public Set<Map.Entry<K, Integer>> entrySet() {
        if (null == this.entrySet) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        EntryIterator entryIterator = new EntryIterator();
        entryIterator.reset();
        StringBuilder sb = new StringBuilder().append('{');
        while (true) {
            entryIterator.next();
            sb.append(entryIterator.getKey()).append('=').append(entryIterator.getIntValue());
            if (!entryIterator.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(',').append(' ');
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map that = (Map)o;
        if (this.size != that.size()) {
            return false;
        }
        int length = this.values.length;
        for (int i = 0; i < length; ++i) {
            int thisValue = this.values[i];
            if (this.missingValue == thisValue) continue;
            Object thatValueObject = that.get(this.keys[i]);
            if (!(thatValueObject instanceof Integer)) {
                return false;
            }
            int thatValue = (Integer)thatValueObject;
            if (this.missingValue != thatValue && thisValue == thatValue) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = 0;
        int length = this.values.length;
        for (int i = 0; i < length; ++i) {
            int value = this.values[i];
            if (this.missingValue == value) continue;
            result += this.keys[i].hashCode() ^ Integer.hashCode(value);
        }
        return result;
    }

    @Override
    public int replace(K key, int value) {
        int curValue = this.getValue(key);
        if (curValue != this.missingValue) {
            curValue = this.put(key, value);
        }
        return curValue;
    }

    @Override
    public boolean replace(K key, int oldValue, int newValue) {
        int curValue = this.getValue(key);
        if (curValue == this.missingValue || curValue != oldValue) {
            return false;
        }
        this.put(key, newValue);
        return true;
    }

    private void increaseCapacity() {
        int newCapacity = this.values.length << 1;
        if (newCapacity < 0) {
            throw new IllegalStateException("Max capacity reached at size=" + this.size);
        }
        this.rehash(newCapacity);
    }

    private void rehash(int newCapacity) {
        int mask = newCapacity - 1;
        this.resizeThreshold = (int)((float)newCapacity * this.loadFactor);
        Object[] tempKeys = new Object[newCapacity];
        int[] tempValues = new int[newCapacity];
        Arrays.fill(tempValues, this.missingValue);
        int size = this.values.length;
        for (int i = 0; i < size; ++i) {
            int value = this.values[i];
            if (this.missingValue == value) continue;
            K key = this.keys[i];
            int index = Hashing.hash(key, mask);
            while (this.missingValue != tempValues[index]) {
                ++index;
                index &= mask;
            }
            tempKeys[index] = key;
            tempValues[index] = value;
        }
        this.keys = tempKeys;
        this.values = tempValues;
    }

    private void compactChain(int deleteIndex) {
        int mask = this.values.length - 1;
        int index = deleteIndex;
        while (true) {
            ++index;
            if (this.missingValue == this.values[index &= mask]) break;
            int hash = Hashing.hash(this.keys[index], mask);
            if ((index >= hash || hash > deleteIndex && deleteIndex > index) && (hash > deleteIndex || deleteIndex > index)) continue;
            this.keys[deleteIndex] = this.keys[index];
            this.values[deleteIndex] = this.values[index];
            this.keys[index] = null;
            this.values[index] = this.missingValue;
            deleteIndex = index;
        }
    }

    private Integer valOrNull(int value) {
        return value == this.missingValue ? null : Integer.valueOf(value);
    }

    public final class EntryIterator
    extends AbstractIterator<Map.Entry<K, Integer>>
    implements Map.Entry<K, Integer> {
        @Override
        public Map.Entry<K, Integer> next() {
            this.findNext();
            if (Object2IntHashMap.this.shouldAvoidAllocation) {
                return this;
            }
            return this.allocateDuplicateEntry();
        }

        private Map.Entry<K, Integer> allocateDuplicateEntry() {
            final Object k = this.getKey();
            final int v = this.getIntValue();
            return new Map.Entry<K, Integer>(){

                @Override
                public K getKey() {
                    return k;
                }

                @Override
                public Integer getValue() {
                    return v;
                }

                @Override
                public Integer setValue(Integer value) {
                    return Object2IntHashMap.this.put(k, value);
                }

                @Override
                public int hashCode() {
                    return this.getKey().hashCode() ^ Integer.hashCode(EntryIterator.this.getIntValue());
                }

                @Override
                public boolean equals(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e = (Map.Entry)o;
                    return e.getKey() != null && e.getValue() != null && e.getKey().equals(k) && e.getValue().equals(v);
                }

                public String toString() {
                    return k + "=" + v;
                }
            };
        }

        @Override
        public K getKey() {
            return Object2IntHashMap.this.keys[this.position()];
        }

        public int getIntValue() {
            return Object2IntHashMap.this.values[this.position()];
        }

        @Override
        public Integer getValue() {
            return this.getIntValue();
        }

        @Override
        public Integer setValue(Integer value) {
            return this.setValue((int)value);
        }

        @Override
        public int setValue(int value) {
            if (value == Object2IntHashMap.this.missingValue) {
                throw new IllegalArgumentException("Cannot accept missingValue");
            }
            int pos = this.position();
            int oldValue = Object2IntHashMap.this.values[pos];
            ((Object2IntHashMap)Object2IntHashMap.this).values[pos] = value;
            return oldValue;
        }
    }

    public final class KeyIterator
    extends AbstractIterator<K> {
        @Override
        public K next() {
            this.findNext();
            return Object2IntHashMap.this.keys[this.position()];
        }
    }

    public final class ValueIterator
    extends AbstractIterator<Integer> {
        @Override
        public Integer next() {
            return this.nextInt();
        }

        public int nextInt() {
            this.findNext();
            return Object2IntHashMap.this.values[this.position()];
        }
    }

    abstract class AbstractIterator<T>
    implements Iterator<T>,
    Serializable {
        private int posCounter;
        private int stopCounter;
        private int remaining;
        private boolean isPositionValid = false;

        AbstractIterator() {
        }

        protected final int position() {
            return this.posCounter & Object2IntHashMap.this.values.length - 1;
        }

        @Override
        public boolean hasNext() {
            return this.remaining > 0;
        }

        protected final void findNext() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int[] values = Object2IntHashMap.this.values;
            int mask = values.length - 1;
            for (int i = this.posCounter - 1; i >= this.stopCounter; --i) {
                int index = i & mask;
                if (Object2IntHashMap.this.missingValue == values[index]) continue;
                this.posCounter = i;
                this.isPositionValid = true;
                --this.remaining;
                return;
            }
            this.isPositionValid = false;
            throw new IllegalStateException();
        }

        @Override
        public abstract T next();

        @Override
        public void remove() {
            if (!this.isPositionValid) {
                throw new IllegalStateException();
            }
            int position = this.position();
            ((Object2IntHashMap)Object2IntHashMap.this).values[position] = Object2IntHashMap.this.missingValue;
            --Object2IntHashMap.this.size;
            Object2IntHashMap.this.compactChain(position);
            this.isPositionValid = false;
        }

        final void reset() {
            int capacity;
            this.remaining = Object2IntHashMap.this.size;
            int[] values = Object2IntHashMap.this.values;
            int i = capacity = values.length;
            if (Object2IntHashMap.this.missingValue != values[capacity - 1]) {
                for (i = 0; i < capacity && Object2IntHashMap.this.missingValue != values[i]; ++i) {
                }
            }
            this.stopCounter = i;
            this.posCounter = i + capacity;
            this.isPositionValid = false;
        }
    }

    public final class EntrySet
    extends AbstractSet<Map.Entry<K, Integer>>
    implements Serializable {
        private final EntryIterator entryIterator;

        public EntrySet() {
            this.entryIterator = Object2IntHashMap.this.shouldAvoidAllocation ? new EntryIterator() : null;
        }

        public EntryIterator iterator() {
            EntryIterator entryIterator = this.entryIterator;
            if (null == entryIterator) {
                entryIterator = new EntryIterator();
            }
            entryIterator.reset();
            return entryIterator;
        }

        @Override
        public int size() {
            return Object2IntHashMap.this.size();
        }

        @Override
        public void clear() {
            Object2IntHashMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            Map.Entry entry = (Map.Entry)o;
            Integer value = Object2IntHashMap.this.get(entry.getKey());
            return value != null && value.equals(entry.getValue());
        }
    }

    public final class ValueCollection
    extends AbstractCollection<Integer>
    implements Serializable {
        private final ValueIterator valueIterator;

        public ValueCollection() {
            this.valueIterator = Object2IntHashMap.this.shouldAvoidAllocation ? new ValueIterator() : null;
        }

        public ValueIterator iterator() {
            ValueIterator valueIterator = this.valueIterator;
            if (null == valueIterator) {
                valueIterator = new ValueIterator();
            }
            valueIterator.reset();
            return valueIterator;
        }

        @Override
        public int size() {
            return Object2IntHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return Object2IntHashMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            Object2IntHashMap.this.clear();
        }
    }

    public final class KeySet
    extends AbstractSet<K>
    implements Serializable {
        private final KeyIterator keyIterator;

        public KeySet() {
            this.keyIterator = Object2IntHashMap.this.shouldAvoidAllocation ? new KeyIterator() : null;
        }

        public KeyIterator iterator() {
            KeyIterator keyIterator = this.keyIterator;
            if (null == keyIterator) {
                keyIterator = new KeyIterator();
            }
            keyIterator.reset();
            return keyIterator;
        }

        @Override
        public int size() {
            return Object2IntHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return Object2IntHashMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return Object2IntHashMap.this.missingValue != Object2IntHashMap.this.removeKey(o);
        }

        @Override
        public void clear() {
            Object2IntHashMap.this.clear();
        }
    }
}

