/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.xml;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import uk.co.real_logic.sbe.PrimitiveType;
import uk.co.real_logic.sbe.PrimitiveValue;
import uk.co.real_logic.sbe.ir.Encoding;
import uk.co.real_logic.sbe.ir.Ir;
import uk.co.real_logic.sbe.ir.Signal;
import uk.co.real_logic.sbe.ir.Token;
import uk.co.real_logic.sbe.xml.CompositeType;
import uk.co.real_logic.sbe.xml.EncodedDataType;
import uk.co.real_logic.sbe.xml.EnumType;
import uk.co.real_logic.sbe.xml.Field;
import uk.co.real_logic.sbe.xml.Message;
import uk.co.real_logic.sbe.xml.MessageSchema;
import uk.co.real_logic.sbe.xml.Presence;
import uk.co.real_logic.sbe.xml.SetType;
import uk.co.real_logic.sbe.xml.Type;

public class IrGenerator {
    private final List<Token> tokenList = new ArrayList<Token>();
    private MessageSchema schema;

    public Ir generate(MessageSchema schema, String namespace) {
        this.schema = schema;
        List<Token> headerTokens = this.generateForHeader(schema);
        Ir ir = new Ir(schema.packageName(), namespace, schema.id(), schema.version(), schema.semanticVersion(), schema.byteOrder(), headerTokens);
        for (Message message : schema.messages()) {
            long msgId = message.id();
            ir.addMessage(msgId, this.generateForMessage(schema, msgId));
        }
        return ir;
    }

    public Ir generate(MessageSchema schema) {
        return this.generate(schema, null);
    }

    private List<Token> generateForMessage(MessageSchema schema, long messageId) {
        this.tokenList.clear();
        Message msg = schema.getMessage(messageId);
        this.addMessageSignal(msg, Signal.BEGIN_MESSAGE);
        this.addAllFields(msg.fields());
        this.addMessageSignal(msg, Signal.END_MESSAGE);
        return this.tokenList;
    }

    private List<Token> generateForHeader(MessageSchema schema) {
        this.tokenList.clear();
        this.add(schema.messageHeader(), 0, null);
        return this.tokenList;
    }

    private void addMessageSignal(Message msg, Signal signal) {
        Token token = new Token.Builder().signal(signal).name(msg.name()).description(msg.description()).size(msg.blockLength()).id(msg.id()).version(msg.sinceVersion()).deprecated(msg.deprecated()).encoding(new Encoding.Builder().semanticType(msg.semanticType()).build()).build();
        this.tokenList.add(token);
    }

    private void addFieldSignal(Field field, Signal signal) {
        Encoding.Builder encodingBuilder = new Encoding.Builder().epoch(field.epoch()).timeUnit(field.timeUnit()).presence(this.mapPresence(field.presence())).semanticType(IrGenerator.semanticTypeOf(null, field));
        if (field.presence() == Presence.CONSTANT && null != field.valueRef()) {
            byte[] bytes;
            String valueRef = field.valueRef();
            try {
                bytes = valueRef.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
            encodingBuilder.constValue(new PrimitiveValue(bytes, "UTF-8", valueRef.length()));
            encodingBuilder.primitiveType(PrimitiveType.CHAR);
        }
        Token token = new Token.Builder().signal(signal).size(field.computedBlockLength()).name(field.name()).description(field.description()).id(field.id()).offset(field.computedOffset()).version(field.sinceVersion()).deprecated(field.deprecated()).encoding(encodingBuilder.build()).build();
        this.tokenList.add(token);
    }

    private void addAllFields(List<Field> fieldList) {
        for (Field field : fieldList) {
            Type type = field.type();
            if (null == type) {
                this.addFieldSignal(field, Signal.BEGIN_GROUP);
                this.add(field.dimensionType(), 0, field);
                this.addAllFields(field.groupFields());
                this.addFieldSignal(field, Signal.END_GROUP);
                continue;
            }
            if (type instanceof CompositeType && field.isVariableLength()) {
                this.addFieldSignal(field, Signal.BEGIN_VAR_DATA);
                this.add((CompositeType)type, field.computedOffset(), field);
                this.addFieldSignal(field, Signal.END_VAR_DATA);
                continue;
            }
            this.addFieldSignal(field, Signal.BEGIN_FIELD);
            if (type instanceof EncodedDataType) {
                this.add((EncodedDataType)type, field.computedOffset(), field);
            } else if (type instanceof CompositeType) {
                this.add((CompositeType)type, field.computedOffset(), field);
            } else if (type instanceof EnumType) {
                this.add((EnumType)type, field.computedOffset(), field);
            } else if (type instanceof SetType) {
                this.add((SetType)type, field.computedOffset(), field);
            } else {
                throw new IllegalStateException("Unknown type: " + type);
            }
            this.addFieldSignal(field, Signal.END_FIELD);
        }
    }

    private void add(CompositeType type, int currOffset, Field field) {
        Token.Builder builder = new Token.Builder().signal(Signal.BEGIN_COMPOSITE).name(type.name()).referencedName(type.referencedName()).offset(currOffset).size(type.encodedLength()).version(type.sinceVersion()).deprecated(type.deprecated()).description(type.description()).encoding(new Encoding.Builder().semanticType(IrGenerator.semanticTypeOf(type, field)).build());
        if (null != field) {
            builder.version(Math.max(field.sinceVersion(), type.sinceVersion()));
        }
        this.tokenList.add(builder.build());
        int offset = 0;
        for (Type elementType : type.getTypeList()) {
            if (elementType.offsetAttribute() != -1) {
                offset = elementType.offsetAttribute();
            }
            if (elementType instanceof EncodedDataType) {
                this.add((EncodedDataType)elementType, offset);
            } else if (elementType instanceof EnumType) {
                this.add((EnumType)elementType, offset, null);
            } else if (elementType instanceof SetType) {
                this.add((SetType)elementType, offset, null);
            } else if (elementType instanceof CompositeType) {
                this.add((CompositeType)elementType, offset, null);
            }
            offset += elementType.encodedLength();
        }
        this.tokenList.add(builder.signal(Signal.END_COMPOSITE).build());
    }

    private void add(EnumType type, int offset, Field field) {
        PrimitiveType encodingType = type.encodingType();
        Encoding.Builder encodingBuilder = new Encoding.Builder().primitiveType(encodingType).semanticType(IrGenerator.semanticTypeOf(type, field)).byteOrder(this.schema.byteOrder());
        if (type.presence() == Presence.OPTIONAL) {
            encodingBuilder.nullValue(encodingType.nullValue());
        }
        Token.Builder builder = new Token.Builder().signal(Signal.BEGIN_ENUM).name(type.name()).referencedName(type.referencedName()).size(encodingType.size()).offset(offset).version(type.sinceVersion()).deprecated(type.deprecated()).description(type.description()).encoding(encodingBuilder.build());
        if (null != field) {
            builder.version(Math.max(field.sinceVersion(), type.sinceVersion()));
        }
        this.tokenList.add(builder.build());
        for (EnumType.ValidValue validValue : type.validValues()) {
            this.add(validValue, encodingType);
        }
        builder.signal(Signal.END_ENUM);
        this.tokenList.add(builder.build());
    }

    private void add(EnumType.ValidValue value, PrimitiveType encodingType) {
        Token.Builder builder = new Token.Builder().signal(Signal.VALID_VALUE).name(value.name()).version(value.sinceVersion()).deprecated(value.deprecated()).description(value.description()).encoding(new Encoding.Builder().byteOrder(this.schema.byteOrder()).primitiveType(encodingType).constValue(value.primitiveValue()).build());
        this.tokenList.add(builder.build());
    }

    private void add(SetType type, int offset, Field field) {
        PrimitiveType encodingType = type.encodingType();
        Token.Builder builder = new Token.Builder().signal(Signal.BEGIN_SET).name(type.name()).referencedName(type.referencedName()).size(encodingType.size()).offset(offset).version(type.sinceVersion()).deprecated(type.deprecated()).description(type.description()).encoding(new Encoding.Builder().semanticType(IrGenerator.semanticTypeOf(type, field)).primitiveType(encodingType).build());
        if (null != field) {
            builder.version(Math.max(field.sinceVersion(), type.sinceVersion()));
        }
        this.tokenList.add(builder.build());
        for (SetType.Choice choice : type.choices()) {
            this.add(choice, encodingType);
        }
        builder.signal(Signal.END_SET);
        this.tokenList.add(builder.build());
    }

    private void add(SetType.Choice value, PrimitiveType encodingType) {
        Token.Builder builder = new Token.Builder().signal(Signal.CHOICE).name(value.name()).description(value.description()).version(value.sinceVersion()).deprecated(value.deprecated()).encoding(new Encoding.Builder().constValue(value.primitiveValue()).byteOrder(this.schema.byteOrder()).primitiveType(encodingType).build());
        this.tokenList.add(builder.build());
    }

    private void add(EncodedDataType type, int offset) {
        Encoding.Builder encodingBuilder = new Encoding.Builder().primitiveType(type.primitiveType()).byteOrder(this.schema.byteOrder()).characterEncoding(type.characterEncoding());
        Token.Builder tokenBuilder = new Token.Builder().signal(Signal.ENCODING).name(type.name()).referencedName(type.referencedName()).size(type.encodedLength()).description(type.description()).version(type.sinceVersion()).deprecated(type.deprecated()).offset(offset);
        switch (type.presence()) {
            case REQUIRED: {
                encodingBuilder.presence(Encoding.Presence.REQUIRED).minValue(type.minValue()).maxValue(type.maxValue());
                break;
            }
            case OPTIONAL: {
                encodingBuilder.presence(Encoding.Presence.OPTIONAL).minValue(type.minValue()).maxValue(type.maxValue()).nullValue(type.nullValue());
                break;
            }
            case CONSTANT: {
                encodingBuilder.presence(Encoding.Presence.CONSTANT).constValue(type.constVal());
            }
        }
        Token token = tokenBuilder.encoding(encodingBuilder.build()).build();
        this.tokenList.add(token);
    }

    private void add(EncodedDataType type, int offset, Field field) {
        Encoding.Builder encodingBuilder = new Encoding.Builder().primitiveType(type.primitiveType()).byteOrder(this.schema.byteOrder()).semanticType(IrGenerator.semanticTypeOf(type, field)).characterEncoding(type.characterEncoding()).timeUnit(field.timeUnit()).epoch(field.epoch());
        Token.Builder tokenBuilder = new Token.Builder().signal(Signal.ENCODING).name(type.name()).referencedName(type.referencedName()).size(type.encodedLength()).description(type.description()).version(type.sinceVersion()).deprecated(type.deprecated()).offset(offset);
        if (field.type() instanceof CompositeType) {
            tokenBuilder.version(Math.max(field.sinceVersion(), type.sinceVersion()));
        }
        switch (field.presence()) {
            case REQUIRED: {
                encodingBuilder.presence(Encoding.Presence.REQUIRED).minValue(type.minValue()).maxValue(type.maxValue());
                break;
            }
            case OPTIONAL: {
                encodingBuilder.presence(Encoding.Presence.OPTIONAL).minValue(type.minValue()).maxValue(type.maxValue()).nullValue(type.nullValue());
                break;
            }
            case CONSTANT: {
                String valueRef = field.valueRef();
                tokenBuilder.size(0);
                encodingBuilder.presence(Encoding.Presence.CONSTANT).constValue(valueRef != null ? this.lookupValueRef(valueRef) : type.constVal());
            }
        }
        Token token = tokenBuilder.encoding(encodingBuilder.build()).build();
        this.tokenList.add(token);
    }

    private PrimitiveValue lookupValueRef(String valueRef) {
        int periodIndex = valueRef.indexOf(46);
        String valueRefType = valueRef.substring(0, periodIndex);
        String validValueName = valueRef.substring(periodIndex + 1);
        EnumType enumType = (EnumType)this.schema.getType(valueRefType);
        EnumType.ValidValue validValue = enumType.getValidValue(validValueName);
        return validValue.primitiveValue();
    }

    private static String semanticTypeOf(Type type, Field field) {
        String typeSemanticType;
        String string = typeSemanticType = null != type ? type.semanticType() : null;
        if (typeSemanticType != null) {
            return typeSemanticType;
        }
        return null != field ? field.semanticType() : null;
    }

    private Encoding.Presence mapPresence(Presence presence) {
        Encoding.Presence encodingPresence = Encoding.Presence.REQUIRED;
        if (null != presence) {
            switch (presence) {
                case OPTIONAL: {
                    encodingPresence = Encoding.Presence.OPTIONAL;
                    break;
                }
                case CONSTANT: {
                    encodingPresence = Encoding.Presence.CONSTANT;
                }
            }
        }
        return encodingPresence;
    }
}

