/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent.status;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.LangUtil;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.IntArrayList;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.AtomicCounter;
import org.agrona.concurrent.status.CountersReader;

public class CountersManager
extends CountersReader {
    public static final int DEFAULT_TYPE_ID = 0;
    private int idHighWaterMark = -1;
    private final IntArrayList freeList = new IntArrayList();

    public CountersManager(AtomicBuffer metaDataBuffer, AtomicBuffer valuesBuffer) {
        super(metaDataBuffer, valuesBuffer);
        valuesBuffer.verifyAlignment();
        if (metaDataBuffer.capacity() < valuesBuffer.capacity() * 2) {
            throw new IllegalArgumentException("Meta data buffer not sufficiently large");
        }
    }

    public CountersManager(AtomicBuffer metaDataBuffer, AtomicBuffer valuesBuffer, Charset labelCharset) {
        super(metaDataBuffer, valuesBuffer, labelCharset);
        valuesBuffer.verifyAlignment();
        if (metaDataBuffer.capacity() < valuesBuffer.capacity() * 2) {
            throw new IllegalArgumentException("Meta data buffer not sufficiently large");
        }
    }

    public int allocate(String label) {
        return this.allocate(label, 0);
    }

    public int allocate(String label, int typeId) {
        int counterId = this.nextCounterId();
        this.checkCountersCapacity(counterId);
        int recordOffset = CountersManager.metaDataOffset(counterId);
        this.checkMetaDataCapacity(recordOffset);
        try {
            this.metaDataBuffer.putInt(recordOffset + 4, typeId);
            this.putLabel(recordOffset, label);
            this.metaDataBuffer.putIntOrdered(recordOffset, 1);
        }
        catch (Exception ex) {
            this.freeList.pushInt(counterId);
            LangUtil.rethrowUnchecked(ex);
        }
        return counterId;
    }

    public int allocate(String label, int typeId, Consumer<MutableDirectBuffer> keyFunc) {
        int counterId = this.nextCounterId();
        this.checkCountersCapacity(counterId);
        int recordOffset = CountersManager.metaDataOffset(counterId);
        this.checkMetaDataCapacity(recordOffset);
        try {
            this.metaDataBuffer.putInt(recordOffset + 4, typeId);
            keyFunc.accept(new UnsafeBuffer(this.metaDataBuffer, recordOffset + 8, 120));
            this.putLabel(recordOffset, label);
            this.metaDataBuffer.putIntOrdered(recordOffset, 1);
        }
        catch (Exception ex) {
            this.freeList.pushInt(counterId);
            LangUtil.rethrowUnchecked(ex);
        }
        return counterId;
    }

    public int allocate(int typeId, DirectBuffer keyBuffer, int keyOffset, int keyLength, DirectBuffer labelBuffer, int labelOffset, int labelLength) {
        int counterId = this.nextCounterId();
        this.checkCountersCapacity(counterId);
        int recordOffset = CountersManager.metaDataOffset(counterId);
        this.checkMetaDataCapacity(recordOffset);
        try {
            int length;
            this.metaDataBuffer.putInt(recordOffset + 4, typeId);
            if (null != keyBuffer) {
                length = Math.min(keyLength, 120);
                this.metaDataBuffer.putBytes(recordOffset + 8, keyBuffer, keyOffset, length);
            }
            length = Math.min(labelLength, 380);
            this.metaDataBuffer.putInt(recordOffset + 128, length);
            this.metaDataBuffer.putBytes(recordOffset + 128 + 4, labelBuffer, labelOffset, length);
            this.metaDataBuffer.putIntOrdered(recordOffset, 1);
        }
        catch (Exception ex) {
            this.freeList.pushInt(counterId);
            LangUtil.rethrowUnchecked(ex);
        }
        return counterId;
    }

    public AtomicCounter newCounter(String label) {
        return new AtomicCounter(this.valuesBuffer, this.allocate(label), this);
    }

    public AtomicCounter newCounter(String label, int typeId) {
        return new AtomicCounter(this.valuesBuffer, this.allocate(label, typeId), this);
    }

    public AtomicCounter newCounter(String label, int typeId, Consumer<MutableDirectBuffer> keyFunc) {
        return new AtomicCounter(this.valuesBuffer, this.allocate(label, typeId, keyFunc), this);
    }

    public AtomicCounter newCounter(int typeId, DirectBuffer keyBuffer, int keyOffset, int keyLength, DirectBuffer labelBuffer, int labelOffset, int labelLength) {
        return new AtomicCounter(this.valuesBuffer, this.allocate(typeId, keyBuffer, keyOffset, keyLength, labelBuffer, labelOffset, labelLength), this);
    }

    public void free(int counterId) {
        this.metaDataBuffer.putIntOrdered(CountersManager.metaDataOffset(counterId), -1);
        this.freeList.pushInt(counterId);
    }

    public void linger(int counterId) {
        this.metaDataBuffer.putIntOrdered(CountersManager.metaDataOffset(counterId), -2);
    }

    public void setCounterValue(int counterId, long value) {
        this.valuesBuffer.putLongOrdered(CountersManager.counterOffset(counterId), value);
    }

    private int nextCounterId() {
        if (this.freeList.isEmpty()) {
            return ++this.idHighWaterMark;
        }
        int counterId = this.freeList.popInt();
        this.valuesBuffer.putLongOrdered(CountersManager.counterOffset(counterId), 0L);
        return counterId;
    }

    private void putLabel(int recordOffset, String label) {
        if (StandardCharsets.US_ASCII == this.labelCharset) {
            this.metaDataBuffer.putInt(recordOffset + 128, this.metaDataBuffer.putStringWithoutLengthAscii(recordOffset + 128 + 4, label, 0, 380));
        } else {
            byte[] bytes = label.getBytes(this.labelCharset);
            if (bytes.length > 380) {
                this.metaDataBuffer.putInt(recordOffset + 128, 380);
                this.metaDataBuffer.putBytes(recordOffset + 128 + 4, bytes, 0, 380);
            } else {
                this.metaDataBuffer.putInt(recordOffset + 128, bytes.length);
                this.metaDataBuffer.putBytes(recordOffset + 128 + 4, bytes);
            }
        }
    }

    private void checkCountersCapacity(int counterId) {
        if (CountersManager.counterOffset(counterId) + 128 > this.valuesBuffer.capacity()) {
            throw new IllegalStateException("Unable to allocated counter, values buffer is full");
        }
    }

    private void checkMetaDataCapacity(int recordOffset) {
        if (recordOffset + 512 > this.metaDataBuffer.capacity()) {
            throw new IllegalStateException("Unable to allocate counter, labels buffer is full");
        }
    }
}

