/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent.status;

import org.agrona.UnsafeAccess;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.status.CountersManager;

public class AtomicCounter
implements AutoCloseable {
    private boolean isClosed = false;
    private final int id;
    private final long addressOffset;
    private final byte[] buffer;
    private final CountersManager countersManager;

    public AtomicCounter(AtomicBuffer buffer, int counterId) {
        this(buffer, counterId, null);
    }

    public AtomicCounter(AtomicBuffer buffer, int counterId, CountersManager countersManager) {
        this.id = counterId;
        this.countersManager = countersManager;
        this.buffer = buffer.byteArray();
        int counterOffset = CountersManager.counterOffset(counterId);
        buffer.boundsCheck(counterOffset, 8);
        this.addressOffset = buffer.addressOffset() + (long)counterOffset;
    }

    public int id() {
        return this.id;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public long increment() {
        return UnsafeAccess.UNSAFE.getAndAddLong(this.buffer, this.addressOffset, 1L);
    }

    public long incrementOrdered() {
        long currentValue = UnsafeAccess.UNSAFE.getLong(this.buffer, this.addressOffset);
        UnsafeAccess.UNSAFE.putOrderedLong(this.buffer, this.addressOffset, currentValue + 1L);
        return currentValue;
    }

    public void set(long value) {
        UnsafeAccess.UNSAFE.putLongVolatile(this.buffer, this.addressOffset, value);
    }

    public void setOrdered(long value) {
        UnsafeAccess.UNSAFE.putOrderedLong(this.buffer, this.addressOffset, value);
    }

    public void setWeak(long value) {
        UnsafeAccess.UNSAFE.putLong(this.buffer, this.addressOffset, value);
    }

    public long getAndAdd(long increment) {
        return UnsafeAccess.UNSAFE.getAndAddLong(this.buffer, this.addressOffset, increment);
    }

    public long getAndAddOrdered(long increment) {
        long currentValue = UnsafeAccess.UNSAFE.getLong(this.buffer, this.addressOffset);
        UnsafeAccess.UNSAFE.putOrderedLong(this.buffer, this.addressOffset, currentValue + increment);
        return currentValue;
    }

    public long getAndSet(long value) {
        return UnsafeAccess.UNSAFE.getAndSetLong(this.buffer, this.addressOffset, value);
    }

    public boolean compareAndSet(long expectedValue, long updateValue) {
        return UnsafeAccess.UNSAFE.compareAndSwapLong(this.buffer, this.addressOffset, expectedValue, updateValue);
    }

    public long get() {
        return UnsafeAccess.UNSAFE.getLongVolatile(this.buffer, this.addressOffset);
    }

    public long getWeak() {
        return UnsafeAccess.UNSAFE.getLong(this.buffer, this.addressOffset);
    }

    @Override
    public void close() {
        if (!this.isClosed) {
            this.isClosed = true;
            if (null != this.countersManager) {
                this.countersManager.free(this.id);
            }
        }
    }
}

