/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ObjectIterator<T>
implements Iterator<T>,
Serializable {
    private static final Object MISSING_VALUE = null;
    private int remaining;
    private int positionCounter;
    private int stopCounter;
    protected boolean isPositionValid = false;
    private T[] values;

    protected ObjectIterator() {
    }

    void reset(T[] values, int size) {
        int length;
        this.remaining = size;
        this.values = values;
        int i = length = values.length;
        if (values[length - 1] != MISSING_VALUE) {
            for (i = 0; i < length && values[i] != MISSING_VALUE; ++i) {
            }
        }
        this.stopCounter = i;
        this.positionCounter = i + length;
        this.isPositionValid = false;
    }

    @Override
    public boolean hasNext() {
        return this.remaining > 0;
    }

    @Override
    public T next() {
        return this.nextValue();
    }

    public T nextValue() {
        T[] values = this.values;
        int mask = values.length - 1;
        this.isPositionValid = false;
        for (int i = this.positionCounter - 1; i >= this.stopCounter; --i) {
            int index = i & mask;
            T value = values[index];
            if (value == MISSING_VALUE) continue;
            this.positionCounter = i;
            this.isPositionValid = true;
            --this.remaining;
            return value;
        }
        throw new NoSuchElementException();
    }

    protected int position() {
        return this.positionCounter & this.values.length - 1;
    }
}

