/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.LongUnaryOperator;
import org.agrona.BitUtil;
import org.agrona.collections.CollectionUtil;
import org.agrona.collections.Hashing;
import org.agrona.collections.LongLongConsumer;
import org.agrona.collections.MapDelegatingSet;

public class Long2LongHashMap
implements Map<Long, Long>,
Serializable {
    private static final int MIN_CAPACITY = 8;
    private final float loadFactor;
    private final long missingValue;
    private int resizeThreshold;
    private int size = 0;
    private long[] entries;
    private KeySet keySet;
    private Values values;
    private Set<Map.Entry<Long, Long>> entrySet;

    public Long2LongHashMap(long missingValue) {
        this(8, 0.55f, missingValue);
    }

    public Long2LongHashMap(int initialCapacity, float loadFactor, long missingValue) {
        CollectionUtil.validateLoadFactor(loadFactor);
        this.loadFactor = loadFactor;
        this.missingValue = missingValue;
        this.capacity(BitUtil.findNextPositivePowerOfTwo(Math.max(8, initialCapacity)));
    }

    public long missingValue() {
        return this.missingValue;
    }

    public float loadFactor() {
        return this.loadFactor;
    }

    public int resizeThreshold() {
        return this.resizeThreshold;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public long get(long key) {
        long[] entries = this.entries;
        long missingValue = this.missingValue;
        int mask = entries.length - 1;
        int index = Hashing.evenHash(key, mask);
        long value = missingValue;
        while (entries[index + 1] != missingValue) {
            if (entries[index] == key) {
                value = entries[index + 1];
                break;
            }
            index = Long2LongHashMap.next(index, mask);
        }
        return value;
    }

    @Override
    public long put(long key, long value) {
        if (value == this.missingValue) {
            throw new IllegalArgumentException("Cannot accept missingValue");
        }
        long[] entries = this.entries;
        long missingValue = this.missingValue;
        int mask = entries.length - 1;
        int index = Hashing.evenHash(key, mask);
        long oldValue = missingValue;
        while (entries[index + 1] != missingValue) {
            if (entries[index] == key) {
                oldValue = entries[index + 1];
                break;
            }
            index = Long2LongHashMap.next(index, mask);
        }
        if (oldValue == missingValue) {
            ++this.size;
            entries[index] = key;
        }
        entries[index + 1] = value;
        this.increaseCapacity();
        return oldValue;
    }

    private void increaseCapacity() {
        if (this.size > this.resizeThreshold) {
            int newCapacity = this.entries.length;
            this.rehash(newCapacity);
        }
    }

    private void rehash(int newCapacity) {
        long[] oldEntries = this.entries;
        long missingValue = this.missingValue;
        int length = this.entries.length;
        this.capacity(newCapacity);
        for (int keyIndex = 0; keyIndex < length; keyIndex += 2) {
            if (oldEntries[keyIndex + 1] == missingValue) continue;
            this.put(oldEntries[keyIndex], oldEntries[keyIndex + 1]);
        }
    }

    public void longForEach(LongLongConsumer consumer) {
        long[] entries = this.entries;
        long missingValue = this.missingValue;
        int length = entries.length;
        for (int keyIndex = 0; keyIndex < length; keyIndex += 2) {
            if (entries[keyIndex + 1] == missingValue) continue;
            consumer.accept(entries[keyIndex], entries[keyIndex + 1]);
        }
    }

    public boolean containsKey(long key) {
        return this.get(key) != this.missingValue;
    }

    public boolean containsValue(long value) {
        boolean found = false;
        if (value != this.missingValue) {
            long[] entries = this.entries;
            int length = entries.length;
            for (int valueIndex = 1; valueIndex < length; valueIndex += 2) {
                if (value != entries[valueIndex]) continue;
                found = true;
                break;
            }
        }
        return found;
    }

    @Override
    public void clear() {
        Arrays.fill(this.entries, this.missingValue);
        this.size = 0;
    }

    public void compact() {
        int idealCapacity = (int)Math.round((double)this.size() * (1.0 / (double)this.loadFactor));
        this.rehash(BitUtil.findNextPositivePowerOfTwo(Math.max(8, idealCapacity)));
    }

    public long computeIfAbsent(long key, LongUnaryOperator mappingFunction) {
        long value = this.get(key);
        if (value == this.missingValue && (value = mappingFunction.applyAsLong(key)) != this.missingValue) {
            this.put(key, value);
        }
        return value;
    }

    @Override
    public Long get(Object key) {
        long value = this.get((Long)key);
        return value == this.missingValue ? null : Long.valueOf(value);
    }

    @Override
    public Long put(Long key, Long value) {
        long existingValue = this.put((long)key, (long)value);
        return existingValue == this.missingValue ? null : Long.valueOf(existingValue);
    }

    @Override
    public void forEach(BiConsumer<? super Long, ? super Long> action) {
        this.longForEach(action::accept);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.containsKey((Long)key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.containsValue((Long)value);
    }

    @Override
    public void putAll(Map<? extends Long, ? extends Long> map) {
        for (Map.Entry<? extends Long, ? extends Long> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public KeySet keySet() {
        if (null == this.keySet) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    public Values values() {
        if (null == this.values) {
            this.values = new Values();
        }
        return this.values;
    }

    @Override
    public Set<Map.Entry<Long, Long>> entrySet() {
        if (null == this.entrySet) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    @Override
    public Long remove(Object key) {
        long value = this.remove((Long)key);
        return value == this.missingValue ? null : Long.valueOf(value);
    }

    public long remove(long key) {
        long[] entries = this.entries;
        long missingValue = this.missingValue;
        int mask = entries.length - 1;
        int keyIndex = Hashing.evenHash(key, mask);
        long oldValue = missingValue;
        while (entries[keyIndex + 1] != missingValue) {
            if (entries[keyIndex] == key) {
                oldValue = entries[keyIndex + 1];
                entries[keyIndex + 1] = missingValue;
                --this.size;
                this.compactChain(keyIndex);
                break;
            }
            keyIndex = Long2LongHashMap.next(keyIndex, mask);
        }
        return oldValue;
    }

    private void compactChain(int deleteKeyIndex) {
        long[] entries = this.entries;
        long missingValue = this.missingValue;
        int mask = entries.length - 1;
        int keyIndex = deleteKeyIndex;
        while (entries[(keyIndex = Long2LongHashMap.next(keyIndex, mask)) + 1] != missingValue) {
            int hash = Hashing.evenHash(entries[keyIndex], mask);
            if ((keyIndex >= hash || hash > deleteKeyIndex && deleteKeyIndex > keyIndex) && (hash > deleteKeyIndex || deleteKeyIndex > keyIndex)) continue;
            entries[deleteKeyIndex] = entries[keyIndex];
            entries[deleteKeyIndex + 1] = entries[keyIndex + 1];
            entries[keyIndex + 1] = missingValue;
            deleteKeyIndex = keyIndex;
        }
    }

    public long minValue() {
        long missingValue = this.missingValue;
        long min = this.size == 0 ? missingValue : Long.MAX_VALUE;
        long[] entries = this.entries;
        int length = entries.length;
        for (int valueIndex = 1; valueIndex < length; valueIndex += 2) {
            long value = entries[valueIndex];
            if (value == missingValue) continue;
            min = Math.min(min, value);
        }
        return min;
    }

    public long maxValue() {
        long missingValue = this.missingValue;
        long max = this.size == 0 ? missingValue : Long.MIN_VALUE;
        long[] entries = this.entries;
        int length = entries.length;
        for (int valueIndex = 1; valueIndex < length; valueIndex += 2) {
            long value = entries[valueIndex];
            if (value == missingValue) continue;
            max = Math.max(max, value);
        }
        return max;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        int length = this.entries.length;
        for (int i = 1; i < length; i += 2) {
            long value = this.entries[i];
            if (value == this.missingValue) continue;
            sb.append(this.entries[i - 1]);
            sb.append('=');
            sb.append(value);
            sb.append(", ");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 2);
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public long replace(long key, long value) {
        long curValue = this.get(key);
        if (curValue != this.missingValue) {
            curValue = this.put(key, value);
        }
        return curValue;
    }

    @Override
    public boolean replace(long key, long oldValue, long newValue) {
        long curValue = this.get(key);
        if (curValue != oldValue || curValue == this.missingValue) {
            return false;
        }
        this.put(key, newValue);
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Map)) {
            return false;
        }
        Map that = (Map)o;
        return this.size == that.size() && this.entrySet().equals(that.entrySet());
    }

    @Override
    public int hashCode() {
        return this.entrySet().hashCode();
    }

    private static int next(int index, int mask) {
        return index + 2 & mask;
    }

    private void capacity(int newCapacity) {
        int entriesLength = newCapacity * 2;
        if (entriesLength < 0) {
            throw new IllegalStateException("Max capacity reached at size=" + this.size);
        }
        this.resizeThreshold = (int)((float)newCapacity * this.loadFactor);
        this.entries = new long[entriesLength];
        this.size = 0;
        Arrays.fill(this.entries, this.missingValue);
    }

    private final class EntrySet
    extends MapDelegatingSet<Map.Entry<Long, Long>> {
        private final EntryIterator entryIterator;

        EntrySet() {
            super(Long2LongHashMap.this);
            this.entryIterator = new EntryIterator();
        }

        @Override
        public Iterator<Map.Entry<Long, Long>> iterator() {
            this.entryIterator.reset();
            return this.entryIterator;
        }

        @Override
        public boolean contains(Object o) {
            return Long2LongHashMap.this.containsKey(((Map.Entry)o).getKey());
        }
    }

    public final class Values
    extends AbstractCollection<Long> {
        private final LongIterator valueIterator;

        public Values() {
            this.valueIterator = new LongIterator(1);
        }

        public LongIterator iterator() {
            this.valueIterator.reset();
            return this.valueIterator;
        }

        @Override
        public int size() {
            return Long2LongHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return this.contains((Long)o);
        }

        public boolean contains(long key) {
            return Long2LongHashMap.this.containsValue(key);
        }
    }

    public final class KeySet
    extends MapDelegatingSet<Long> {
        private final LongIterator keyIterator;

        KeySet() {
            super(Long2LongHashMap.this);
            this.keyIterator = new LongIterator(0);
        }

        public LongIterator iterator() {
            this.keyIterator.reset();
            return this.keyIterator;
        }

        @Override
        public boolean contains(Object o) {
            return this.contains((Long)o);
        }

        public boolean contains(long key) {
            return Long2LongHashMap.this.containsKey(key);
        }
    }

    final class EntryIterator
    extends AbstractIterator
    implements Iterator<Map.Entry<Long, Long>>,
    Map.Entry<Long, Long> {
        private long key;
        private long value;

        EntryIterator() {
        }

        @Override
        public Long getKey() {
            return this.key;
        }

        @Override
        public Long getValue() {
            return this.value;
        }

        @Override
        public Long setValue(Long value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map.Entry<Long, Long> next() {
            this.findNext();
            int keyPosition = this.keyPosition();
            this.key = Long2LongHashMap.this.entries[keyPosition];
            this.value = Long2LongHashMap.this.entries[keyPosition + 1];
            return this;
        }

        @Override
        void reset() {
            super.reset();
            this.key = Long2LongHashMap.this.missingValue;
            this.value = Long2LongHashMap.this.missingValue;
        }

        @Override
        public int hashCode() {
            return Long.hashCode(this.key) ^ Long.hashCode(this.value);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry that = (Map.Entry)o;
            return Objects.equals(this.key, that.getKey()) && Objects.equals(this.value, that.getValue());
        }
    }

    public final class LongIterator
    extends AbstractIterator
    implements Iterator<Long> {
        private final int offset;

        LongIterator(int offset) {
            this.offset = offset;
        }

        @Override
        public Long next() {
            return this.nextValue();
        }

        public long nextValue() {
            this.findNext();
            return Long2LongHashMap.this.entries[this.keyPosition() + this.offset];
        }
    }

    abstract class AbstractIterator
    implements Serializable {
        private int remaining;
        private int positionCounter;
        private int stopCounter;

        AbstractIterator() {
        }

        void reset() {
            int capacity;
            this.remaining = Long2LongHashMap.this.size;
            long missingValue = Long2LongHashMap.this.missingValue;
            long[] entries = Long2LongHashMap.this.entries;
            int keyIndex = capacity = entries.length;
            if (entries[capacity - 1] != missingValue) {
                int size = capacity;
                for (keyIndex = 0; keyIndex < size && entries[keyIndex + 1] != missingValue; keyIndex += 2) {
                }
            }
            this.stopCounter = keyIndex;
            this.positionCounter = keyIndex + capacity;
        }

        protected int keyPosition() {
            return this.positionCounter & Long2LongHashMap.this.entries.length - 1;
        }

        public boolean hasNext() {
            return this.remaining > 0;
        }

        protected void findNext() {
            long[] entries = Long2LongHashMap.this.entries;
            long missingValue = Long2LongHashMap.this.missingValue;
            int mask = entries.length - 1;
            for (int keyIndex = this.positionCounter - 2; keyIndex >= this.stopCounter; keyIndex -= 2) {
                int index = keyIndex & mask;
                if (entries[index + 1] == missingValue) continue;
                this.positionCounter = keyIndex;
                --this.remaining;
                return;
            }
            throw new NoSuchElementException();
        }
    }
}

